/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.vidacount380;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.vidacount380.MessageAckR01;
import jalis.laboratorio.interfaceamento.interfaces.vidacount380.MessageOrrO02;
import jalis.laboratorio.interfaceamento.interfaces.vidacount380.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrmO01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.apache.commons.codec.binary.Base64;

public class InterfaceListener
extends InterfaceHl7Listener {
    private HashMap<String, String> parametros = new HashMap();
    private static final String IMAGE_BMP_BASE64 = "^Image^BMP^Base64^";
    public static final int SIT_NAO_ENVIADO = 0;
    public static final int SIT_PENDENTE = 1;
    public static final int SIT_PRONTO = 2;
    public static final int SIT_REPETINDO = 3;
    public static final int SIT_COM_REPETICAO = 4;
    public static final int SIT_A_REPETIR = 5;
    public static final int SIT_EXCECAO = 6;
    public static final int SIT_PRONTO_VALIDADO = 7;
    public static final int SIT_EXPORTADO = 8;
    private static final String ALTERNATIVO = "HEMOG";

    public InterfaceListener() {
        super("VIDACOUNT380");
        this.parametros.put("WBC", "leucocitos");
        this.parametros.put("NEU%", "neutrofilo_percentual");
        this.parametros.put("LYM%", "linfocitos_tipicos_percentual");
        this.parametros.put("MON%", "monocitos_percentual");
        this.parametros.put("EOS%", "eosinofilos_percentual");
        this.parametros.put("BAS%", "basofilos_percentual");
        this.parametros.put("NEU#", "neutrofilo_contagem");
        this.parametros.put("LYM#", "linfocitos_tipicos_contagem");
        this.parametros.put("MON#", "monocitos_contagem");
        this.parametros.put("EOS#", "eosinofilos_contagem");
        this.parametros.put("BAS#", "basofilos_contagem");
        this.parametros.put("RBC", "hemacias");
        this.parametros.put("HGB", "hgb");
        this.parametros.put("MCHC", "mchc");
        this.parametros.put("MCH", "hcm");
        this.parametros.put("MCV", "vcm");
        this.parametros.put("RDW-CV", "rdw_cv");
        this.parametros.put("RWD-SD", "rdw_sd");
        this.parametros.put("HCT", "hct");
        this.parametros.put("PLT", "plaquetas");
        this.parametros.put("MPV", "vpm");
        this.parametros.put("PDW", "pdw");
        this.parametros.put("PCT", "pct");
        this.parametros.put("PLCR", "plaquetas_lcr");
        this.parametros.put("PLCC", "plaquetas_lcc");
        this.parametros.put("LIC%", "bastonados_percentual");
        this.parametros.put("LIC#", "bastonados_contagem");
        this.parametros.put("WBC Histogram", "vc510_histograma_wbc");
        this.parametros.put("RBC Histogram", "vc510_histograma_rbc");
        this.parametros.put("PLT Histogram", "vc510_histograma_plt");
    }

    @Override
    protected void mensagemRecebida(Message message) {
        switch (message.getType()) {
            case ORU_R01: {
                this.messageOruR01Recebida((MessageOruR01)message);
                break;
            }
            case ORM_O01: {
                this.messageOrmO01Recebida((MessageOrmO01)message);
                break;
            }
            case ACK_Q03: {
                this.messageAckQ03Recebida((MessageAckQ03)message);
                break;
            }
            case ORR_O02: {
                this.messageOrro02Recebida((MessageOrrO02)message);
                break;
            }
            default: {
                this.fireExcecaoEncontrada("Mensagem de tipo desconhecido recebida");
            }
        }
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        try {
            int digitosCodigoTubo = this.getQtdeDigitosTubo();
            String tuboId = oruR01.getObr().getFilterOrderNumber();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String intCodigo = this.getIntCodigo(filCodigo, reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), recCodigo, ALTERNATIVO);
                if (Funcoes.textoVazio(intCodigo)) {
                    this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar a interface para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + ALTERNATIVO);
                    return;
                }
                ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, ALTERNATIVO);
                if (exame == null) {
                    this.fireExcecaoEncontrada("Nenhum exame foi encontrado para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + ALTERNATIVO);
                    return;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                ArrayList<String> flags = new ArrayList<String>();
                for (String p : this.parametros.keySet()) {
                    jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx obx = this.buscaObxPeloObservationID(oruR01.getObxList(), p);
                    if (Funcoes.objectIsNull(obx)) continue;
                    if (obx.getAbnormalFlag() != null && !obx.getAbnormalFlag().equals((Object)MessageSegmentObx.AbnormalFlag.NORMAL)) {
                        flags.add(this.tratarDescricao(p) + " - " + obx.getAbnormalFlag().toString());
                    }
                    String campo = this.parametros.get(p);
                    String resultado = obx.getObservationValue();
                    if (resultado.length() > IMAGE_BMP_BASE64.length() && resultado.substring(0, IMAGE_BMP_BASE64.length()).equalsIgnoreCase(IMAGE_BMP_BASE64)) {
                        resultado = resultado.substring(IMAGE_BMP_BASE64.length());
                        resultado = this.convertImg(reqCodigo, resultado, p);
                    } else {
                        resultado = resultado.replace('.', ',');
                    }
                    dados.put(campo, resultado);
                }
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                for (BDExame exa : exames) {
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exa.getExame(), exa.getMaterial(), intCodigo, dados, flags);
                }
            } else {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", tuboId));
                return;
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
            ackR01.getMsa().setTextMessage("Erro ao receber a mensagem");
            ackR01.getMsa().setErrorCondition(ErrorCondition.APPLICATION_INTERNAL_ERROR);
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    @Override
    protected void messageOrmO01Recebida(MessageOrmO01 ormO01) {
        block18: {
            String messageId = ormO01.getMsh().getMessageControlId();
            MessageOrrO02 orrO02 = new MessageOrrO02();
            try {
                String tuboId = ormO01.getOrc().getFilterOrderNumber();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (tuboId != null && !tuboId.trim().isEmpty() && tuboId != "null" && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                        aba = this.equipamento.getTab(1);
                    }
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                        aba = this.equipamento.getTab(2);
                    }
                    if (req == null) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        return;
                    }
                    String exames = (String)req[aba.getColIndice("Exame")];
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    String pacNasc = this.getPacienteDataNascimento(filCodigo, reqCodigo);
                    if ((pacNome = pacNome.trim()).split(" ").length > 1) {
                        String aux = pacNome;
                        pacNome = aux.substring(aux.lastIndexOf(" ") + 1, aux.length()).concat(" ").concat(aux.substring(0, aux.lastIndexOf(" ")));
                    }
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (n == 0 || n == 1) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<String> tests = new HashSet<String>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (test == null || test.trim().isEmpty()) continue;
                        tests.add(test);
                    }
                    if (tests.isEmpty()) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        this.examesEnviadosPorSid.put(tuboId, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(filCodigo).append(reqCodigo).append("^^^^");
                        Date dataHoraRequisicao = new Date();
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        orrO02.getPid().setId(1);
                        orrO02.getPid().setPatientName("^" + pacNome);
                        orrO02.getPid().setSex(pacSexo);
                        orrO02.getPid().setDataOfBirth(pacNasc);
                        orrO02.getPid().setPatientIdentifierList(stringBuilder.toString());
                        orrO02.getOrc().setOrderControl("AF");
                        orrO02.getOrc().setPlaceOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getObr().setPlacerOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getObr().setRequestDateTime(dataHoraRequisicao);
                        orrO02.getObr().setCollectorIdentifier("MA");
                        orrO02.getObr().setSpecimenReceiveDateTime(dataHoraRequisicao);
                        orrO02.getObr().setDiagnosticServSect("HM");
                        MessageSegmentObx obx = new MessageSegmentObx();
                        obx.setId(1);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("02001^Loading Mode^99MRC");
                        obx.setObservationValue("A");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        obx = new MessageSegmentObx();
                        obx.setId(2);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("02002^Blood Mode^99MRC");
                        obx.setObservationValue("W");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        for (String alternativo : tests) {
                            obx = new MessageSegmentObx();
                            obx.setId(3);
                            obx.setValueType(MessageSegmentObx.ValueType.IS);
                            obx.setObservationId("02003^Test Mode^99MRC");
                            obx.setObservationValue(alternativo);
                            obx.setObserveResultStatus("F");
                            orrO02.addObx(obx);
                        }
                        obx = new MessageSegmentObx();
                        obx.setId(4);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("03001^Ref Group^99MRC");
                        obx.setObservationValue("General");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        this.enviaMensagem(messageId, orrO02);
                        this.alteraSituacaoParaPendentes((InfoExameRequisicao)this.examesEnviadosPorSid.get(tuboId));
                        this.examesEnviadosPorSid.remove(tuboId);
                    }
                    break block18;
                }
                orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                this.enviaMensagem(messageId, orrO02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    private void messageOrro02Recebida(MessageOrrO02 orro02) {
        block16: {
            String messageId = orro02.getMsh().getMessageControlId();
            try {
                String idTubo = orro02.getObr().getPlacerOrderNumber();
                int digitosCodigoTubo = this.getQtdeDigitosTubo();
                if (!Funcoes.textoVazio(idTubo) && Funcoes.isNumeric(idTubo) && idTubo.length() == digitosCodigoTubo) {
                    String filCodigo = idTubo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = idTubo.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    if (Funcoes.objectIsNull(req)) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                        aba = this.equipamento.getTab(1);
                    }
                    if (Funcoes.objectIsNull(req)) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                        aba = this.equipamento.getTab(2);
                    }
                    if (Funcoes.objectIsNull(req)) {
                        orro02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orro02);
                        return;
                    }
                    String exames = (String)req[aba.getColIndice("Exame")];
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    String pacNasc = this.getPacienteDataNascimento(filCodigo, reqCodigo);
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String exame : exames.split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(exame, new Integer(mcoCodigo)));
                    }
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exame : examesDaRequisicao) {
                        int situacao = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exame.getString(), mcoCodigo)) {
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exame.getString(), mcoCodigo));
                            if (situacao == 0 || situacao == 1) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (!this.isSituacaoValida(situacao)) continue;
                        examesParaEnviar.add(exame);
                    }
                    HashSet<String> tests = new HashSet<String>();
                    for (ExameMaterial exameParaEnviar : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameParaEnviar.getNomeExame(), mcoCodigo, intCodigo);
                        if (test == null || test.trim().isEmpty()) continue;
                        tests.add(test);
                    }
                    if (tests.isEmpty()) {
                        orro02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orro02);
                        this.fireExcecaoEncontrada(idTubo + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao exame = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        this.examesEnviadosPorSid.put(idTubo, exame);
                        this.examesEnviadosPorMid.put(messageId, exame);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        StringBuilder pacIdentifier = new StringBuilder();
                        pacIdentifier.append(filCodigo).append(reqCodigo).append("^^^^");
                        Date dataHoraRequisicao = new Date();
                        orro02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        orro02.getPid().setId(1);
                        orro02.getPid().setPatientName("^" + pacNome);
                        orro02.getPid().setSex(pacSexo);
                        orro02.getPid().setDataOfBirth(pacNasc);
                        orro02.getPid().setPatientIdentifierList(pacIdentifier.toString());
                        orro02.getOrc().setOrderControl("AF");
                        orro02.getOrc().setPlaceOrderNumber(orro02.getObr().getPlacerOrderNumber());
                        orro02.getObr().setPlacerOrderNumber(orro02.getObr().getPlacerOrderNumber());
                        orro02.getObr().setRequestDateTime(dataHoraRequisicao);
                        orro02.getObr().setCollectorIdentifier("MA");
                        orro02.getObr().setSpecimenReceiveDateTime(dataHoraRequisicao);
                        orro02.getObr().setDiagnosticServSect("HM");
                        MessageSegmentObx obx = new MessageSegmentObx();
                        obx.setId(1);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("02001^Loading Mode^99MRC");
                        obx.setObservationValue("A");
                        obx.setObserveResultStatus("F");
                        orro02.addObx(obx);
                        obx = new MessageSegmentObx();
                        obx.setId(2);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("02002^Blood Mode^99MRC");
                        obx.setObservationValue("W");
                        obx.setObserveResultStatus("F");
                        orro02.addObx(obx);
                        for (String alternativo : tests) {
                            obx = new MessageSegmentObx();
                            obx.setId(3);
                            obx.setValueType(MessageSegmentObx.ValueType.IS);
                            obx.setObservationId("02003^Test Mode^99MRC");
                            obx.setObservationValue(alternativo);
                            obx.setObserveResultStatus("F");
                            orro02.addObx(obx);
                        }
                        obx = new MessageSegmentObx();
                        obx.setId(4);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("03001^Ref Group^99MRC");
                        obx.setObservationValue("Geral");
                        obx.setObserveResultStatus("F");
                        orro02.addObx(obx);
                        this.enviaMensagem(messageId, orro02);
                        this.alteraSituacaoParaPendentes((InfoExameRequisicao)this.examesEnviadosPorSid.get(idTubo));
                        this.examesEnviadosPorSid.remove(idTubo);
                    }
                    break block16;
                }
                orro02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                this.enviaMensagem(messageId, orro02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    private boolean isSituacaoValida(int situacao) {
        return situacao == 0 || situacao == 1 || situacao == 3;
    }

    private int getQtdeDigitosTubo() {
        return ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
    }

    @Override
    protected void enviaMensagem(String id, Message mensagem) {
        try {
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setSendingApplication("Rayto");
            mensagem.getMsh().setSendingFacility("RT-7600");
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setVersionId("2.3.1");
            mensagem.getMsh().setCharacterSet("UNICODE");
            mensagem.setId(id);
            this.ultimaMensagemEnviada = mensagem;
            ++this.tentativasEnvio;
            this.getPortaCOM().write(this.messageParser.messageToText(mensagem, this.fieldSeparator));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }

    private String convertImg(String reqCodigo, String resultado, String p) throws IOException {
        Base64 b64 = new Base64();
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(b64.decode(resultado)));
        if (!Funcoes.objectIsNull(image)) {
            File img = File.createTempFile("rayto_".concat(reqCodigo), ".bmp");
            ImageIO.write((RenderedImage)image, "bmp", img);
            BufferedImage imgNew = ImageIO.read(img);
            resultado = b64.encodeAsString(ImagemUtils.imageToByte(imgNew));
            img.delete();
            return resultado;
        }
        return "";
    }

    private String tratarDescricao(String p) {
        String[] campo = p.split("\\^");
        return campo != null && campo.length > 1 ? campo[1] : p;
    }

    private jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx buscaObxPeloObservationID(List<jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx> listObx, String observationID) {
        for (jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx obx : listObx) {
            if (!obx.getObservationId().equals(observationID)) continue;
            return obx;
        }
        return null;
    }

    @Override
    public String parse(String text) {
        try {
            Message message = this.messageParser.textToMessageVidaCount3d(text);
            this.mensagemRecebida(message);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    @Override
    public void teste() {
        StringBuilder tmp = new StringBuilder();
        String requisicao = JOptionPane.showInputDialog("Informe o tubo: ");
        tmp.append("[SB]MSH|^~\\&|||||20241024135249||ORU^R01|2|P|2.3.1||||||UNICODE||[CR]");
        tmp.append("PID|2|||||||[CR]");
        tmp.append("PV1|2||[CR]");
        tmp.append("OBR|2||" + requisicao + "||||20241024135203|||||||||||||||||HM||||||||Admin[CR]");
        tmp.append("OBX|22|NM|WBC||4.7|10^9/L|4[SP]-[SP]10|N|||F[CR]");
        tmp.append("OBX|23|NM|Lymph#||1.9|10^9/L|0.8[SP]-[SP]4|N|||F[CR]");
        tmp.append("OBX|24|NM|Mid#||0.3|10^9/L|0.1[SP]-[SP]1.5|N|||F[CR]");
        tmp.append("OBX|25|NM|Gran#||2.5|10^9/L|2[SP]-[SP]7|N|||F[CR]");
        tmp.append("OBX|26|NM|Lymph%||40.6|%|20[SP]-[SP]40|H|||F[CR]");
        tmp.append("OBX|27|NM|Mid%||6.9|%|3[SP]-[SP]15|N|||F[CR]");
        tmp.append("OBX|28|NM|Gran%||52.5|%|50[SP]-[SP]70|N|||F[CR]");
        tmp.append("OBX|29|NM|RBC||3.02|10^12/L|3.5[SP]-[SP]5.5|L|||F[CR]");
        tmp.append("OBX|30|NM|HGB||8.9|g/dL|11[SP]-[SP]16|RL|||F[CR]");
        tmp.append("OBX|31|NM|HCT||28.2|%|37[SP]-[SP]54|L|||F[CR]");
        tmp.append("OBX|32|NM|MCV||93.5|fL|80[SP]-[SP]100|N|||F[CR]");
        tmp.append("OBX|33|NM|MCH||29.4|pg|27[SP]-[SP]34|N|||F[CR]");
        tmp.append("OBX|34|NM|MCHC||31.4|g/dL|32[SP]-[SP]36|L|||F[CR]");
        tmp.append("OBX|35|NM|RDW-CV||11.8|%|11[SP]-[SP]16|N|||F[CR]");
        tmp.append("OBX|36|NM|RWD-SD||39.3|fL|35[SP]-[SP]56|N|||F[CR]");
        tmp.append("OBX|37|NM|PLT||163|10^9/L|100[SP]-[SP]300|N|||F[CR]");
        tmp.append("OBX|38|NM|MPV||11.8|fL|6.5[SP]-[SP]12|N|||F[CR]");
        tmp.append("OBX|39|NM|PDW||16.0||15[SP]-[SP]17|N|||F[CR]");
        tmp.append("OBX|40|NM|PCT||0.192|%|0.108[SP]-[SP]0.282|N|||F[CR]");
        tmp.append("OBX|41|NM|PLCC||65|10^9/L|30[SP]-[SP]90|N|||F[CR]");
        tmp.append("OBX|42|NM|PLCR||40.0|%|11[SP]-[SP]45|N|||F[CR]");
        tmp.append("[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }
}

