/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.variant2;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    private HashMap<String, String> fields = new HashMap();

    public RecordParser(InterfaceASTMListener interfaceListener) {
        super(interfaceListener);
        this.fields.put("^^^Ao^AREA", "variant2_area_A0");
        this.fields.put("^^^A1a^AREA", "variant2_area_A1a");
        this.fields.put("^^^A1b^AREA", "variant2_area_A1b");
        this.fields.put("^^^A1c^AREA", "variant2_area_A1c");
        this.fields.put("^^^A1cIFCC^AREA", "variant2_area_A1cIFCC");
        this.fields.put("^^^A1cJDS^AREA", "variant2_area_A1cJDS");
        this.fields.put("^^^A1cMono-S^AREA", "variant2_area_A1cMono_S");
        this.fields.put("^^^A2^AREA", "variant2_area_A2");
        this.fields.put("^^^Ao^AREA", "variant2_area_Ao");
        this.fields.put("^^^C^AREA", "variant2_area_C");
        this.fields.put("^^^F^AREA", "variant2_area_D");
        this.fields.put("^^^E, D^AREA", "variant2_area_E_D");
        this.fields.put("^^^F^AREA", "variant2_area_F");
        this.fields.put("^^^S^AREA", "variant2_area_S");
        this.fields.put("^^^CHb^AREA", "variant2_area_CHb");
        this.fields.put("^^^LA1c ^AREA", "variant2_area_LA1c");
        this.fields.put("^^^LA1c/CHb ^AREA", "variant2_area_LA1c_CHb");
        this.fields.put("^^^P1^AREA", "variant2_area_P1");
        this.fields.put("^^^P2^AREA", "variant2_area_P2");
        this.fields.put("^^^P3^AREA", "variant2_area_P3");
        this.fields.put("^^^P4^AREA", "variant2_area_P4");
        this.fields.put("^^^UnknownN^AREA", "variant2_area_UnknownN");
        this.fields.put("^^^C-Window^AREA", "variant2_area_C_Window");
        this.fields.put("^^^D-window^AREA", "variant2_area_D_Window");
        this.fields.put("^^^E-Window^AREA", "variant2_area_E_Window");
        this.fields.put("^^^S-Window^AREA", "variant2_area_S_Window");
        this.fields.put("^^^ E,D-Window ^AREA", "variant2_area_E_D_Window");
        this.fields.put("^^^Variant Window^AREA", "variant2_area_Variant_Window");
        this.fields.put("^^^TOTAL^AREA", "variant2_area_total");
        this.fields.put("^^^Ao^TIME", "variant2_time_A0");
        this.fields.put("^^^A1a^TIME", "variant2_time_A1a");
        this.fields.put("^^^A1b^TIME", "variant2_time_A1b");
        this.fields.put("^^^A1c^TIME", "variant2_time_A1c");
        this.fields.put("^^^A1cIFCC^TIME", "variant2_time_A1cIFCC");
        this.fields.put("^^^A1cJDS^TIME", "variant2_time_A1cJDS");
        this.fields.put("^^^A1cMono-S^TIME", "variant2_time_A1cMono_S");
        this.fields.put("^^^A2^TIME", "variant2_time_A2");
        this.fields.put("^^^Ao^TIME", "variant2_time_Ao");
        this.fields.put("^^^C^TIME", "variant2_time_C");
        this.fields.put("^^^F^TIME", "variant2_time_D");
        this.fields.put("^^^E, D^TIME", "variant2_time_E_D");
        this.fields.put("^^^F^TIME", "variant2_time_F");
        this.fields.put("^^^S^TIME", "variant2_time_S");
        this.fields.put("^^^CHb^TIME", "variant2_time_CHb");
        this.fields.put("^^^LA1c ^TIME", "variant2_time_LA1c");
        this.fields.put("^^^LA1c/CHb ^TIME", "variant2_time_LA1c_CHb");
        this.fields.put("^^^P1^TIME", "variant2_time_P1");
        this.fields.put("^^^P2^TIME", "variant2_time_P2");
        this.fields.put("^^^P3^TIME", "variant2_time_P3");
        this.fields.put("^^^P4^TIME", "variant2_time_P4");
        this.fields.put("^^^UnknownN^TIME", "variant2_time_UnknownN");
        this.fields.put("^^^C-Window^TIME", "variant2_time_C_Window");
        this.fields.put("^^^D-window^TIME", "variant2_time_D_Window");
        this.fields.put("^^^E-Window^TIME", "variant2_time_E_Window");
        this.fields.put("^^^S-Window^TIME", "variant2_time_S_Window");
        this.fields.put("^^^ E,D-Window ^TIME", "variant2_time_E_D_Window");
        this.fields.put("^^^Variant Window^TIME", "variant2_time_Variant_Window");
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        if (req_codigo.indexOf("^") > 0) {
            instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
            sys_sample_id = this.equip.parseOrderSystemSID(instSID);
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        String emi_alternativo = components.get(this.equip.TEST_ITEM_NUMBER);
        Statement st = Conexao.getStatement();
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        String flags;
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String int_codigo = (String)this.exame_atual.get(INT_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
        String mco_codigo = (String)this.exame_atual.get(MCO_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        if ((resultado = resultado.replaceAll("\\.", ",")).startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        Statement st = Conexao.getStatement();
        int sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
        String campo = (String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID);
        if (this.fields.containsKey(campo)) {
            this.exame_atual.put(this.fields.get(campo), resultado);
        }
        if ((flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS)) != null && !flags.equals("")) {
            this.exame_atual.put("flag_alerta", flags);
        }
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados);
    }
}

