/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.variant2;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.variant2.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class InterfaceListener
extends InterfaceASTMListener {
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean hostQuery = false;
    protected boolean hostQueryVazio = false;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceListener() {
        RecordParser record = new RecordParser(this);
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.INSTRUMENT_SYSTEM_VERSION = "1394-97";
        this.INSTRUMENT_NAME = "Bio-Rad CDM System^CDM 5.1 V-II Instrument";
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    this.fireExcecaoEncontrada("Erro no bloco enviado pelo equipamento");
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                this.fireExcecaoEncontrada("Erro no bloco enviado pelo equipamento");
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                String[] msgs;
                message = message.substring(0, message.length() - 1);
                block7: for (String s : msgs = message.split(String.valueOf('\r'))) {
                    if (s.trim().length() <= 0) continue;
                    char c = s.charAt(0);
                    switch (c) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (this.rx_list.size() > 0) {
                                String msg = (String)this.rx_list.remove(this.rx_list.size() - 1);
                                msg = msg + s.trim().substring(1);
                                this.rx_list.add(msg);
                                continue block7;
                            }
                            this.rx_list.add(s);
                            continue block7;
                        }
                        default: {
                            this.rx_list.add(s);
                        }
                    }
                }
                if (termination.equals(this.getMiddleFrameEnd())) {
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    String s = (String)this.rx_list.remove(0);
                    this.recordParser.recordFound(s);
                }
                return "";
            }
            this.rx_list.clear();
            this.fireExcecaoEncontrada("Erro ao receber bloco de dados: CRC incompat\u00edvel!");
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            starting_range = starting_range.substring(1);
            if (starting_range.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.getPortaCOM().write(String.valueOf('\u0004'));
                return;
            }
            this.host_fil_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboFilial());
            starting_range = starting_range.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = starting_range.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
            this.hostQueryVazio = false;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Variant II: Host Query Response");
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome).trim();
            for (int i = 0; short_name.contains("  ") && i < 10; ++i) {
                short_name = short_name.replaceAll("  ", " ");
            }
            String nome = null;
            String nomeDoMeio = "";
            String ultimoNome = short_name;
            if (short_name.indexOf(" ") > 0) {
                String[] names = short_name.split(" ");
                nome = names[0];
                if (names.length <= 2) {
                    ultimoNome = names[1];
                } else {
                    ultimoNome = names[names.length - 1];
                    nomeDoMeio = names.length > 3 ? String.format("%s%s", names[1].substring(0, 1), names[2].substring(0, 1)) : (names.length > 1 && names[1].length() >= 2 ? names[1].substring(0, 2) : "");
                }
            }
            String dataNascimento = Funcoes.formataData("yyyyMMdd", BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo));
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            this.tx_list.add(this.getHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String patient_id = req_codigo;
            this.tx_list.add(this.getPatientRecord(1, patient_id, nome, ultimoNome, nomeDoMeio, pac_sexo, dataNascimento));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            for (ExameMaterial exameMaterial : alternativos) {
                this.tx_list.add(this.getOrderRecord(1, codigo.toString(), exameMaterial, "R", acao, tipo_amostra, "O"));
            }
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private String getOrderRecord(int sequence, String sampleId, ExameMaterial alternativo, String prioridadeRotina, String acao, String tipo_amostra, String reportType) {
        StringBuilder ret = new StringBuilder();
        ret.append("O").append("|");
        ret.append(sequence).append("|");
        ret.append(sampleId).append("|");
        ret.append("").append("|");
        ret.append("^^^").append(alternativo.getNomeExame()).append("|");
        ret.append(prioridadeRotina).append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append(acao).append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("1").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        return ret.toString();
    }

    private String getPatientRecord(int sequence, String patient_id, String nome, String lastName, String nomeMeio, String pac_sexo, String dataNascimento) {
        StringBuilder ret = new StringBuilder();
        ret.append("P").append("|");
        ret.append(sequence).append("|");
        ret.append(patient_id).append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append(lastName);
        if (!Funcoes.textoVazio(nome)) {
            ret.append("^").append(nome);
        }
        if (!Funcoes.textoVazio(nomeMeio)) {
            ret.append("^").append(nomeMeio);
        }
        ret.append("|");
        ret.append("").append("|");
        ret.append(dataNascimento).append("|");
        ret.append(pac_sexo).append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        return ret.toString();
    }

    private String getHeaderRecord(String delimiters, String password, String host_name, String host_system_version, Object object, String instrument_name, String instrument_system_version) {
        StringBuilder ret = new StringBuilder();
        ret.append("H|");
        ret.append(delimiters).append("|");
        ret.append("").append("|");
        ret.append(password).append("|");
        ret.append(host_name).append("|");
        ret.append(host_name).append("^").append(host_system_version).append("|");
        ret.append(instrument_name).append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append("|");
        ret.append("").append('\r');
        return ret.toString();
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    public void responseHostQuery() {
        try {
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String rack = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            StringBuilder pac_exames = new StringBuilder("");
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames.append((String)req[aba.getColIndice("Exame")]);
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (req != null) {
                    List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                    }
                }
            }
            String situacao = null;
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        situacao = (String)r[aba.getColIndice("Sit")];
                        pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                    }
                }
            }
            if (req != null) {
                String rec_codigoPai;
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                String string = aba.getColIndice("Tubo") >= 0 ? (String)req[aba.getColIndice("Tubo")] : (rec_codigoPai = null);
                if (Funcoes.textoVazio(pac_exames.toString())) {
                    pac_exames.append(aba.getColIndice("Exame") >= 0 ? (String)req[aba.getColIndice("Exame")] : "");
                }
                String tmp = pac_exames.toString();
                pac_exames.setLength(0);
                for (String exa : tmp.trim().split(" ")) {
                    if (BDUtil.isExameCurva(fil_codigo, int_codigo, exa, mco_codigo)) {
                        BDExame[] t;
                        for (BDExame bdExame : t = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exa, mco_codigo, rec_codigoPai, rec_codigo)) {
                            pac_exames.append(bdExame.getExame()).append(" ");
                        }
                        continue;
                    }
                    pac_exames.append(exa).append(" ");
                }
                if (situacao == null) {
                    situacao = aba.getColIndice("Sit") >= 0 ? (String)req[aba.getColIndice("Sit")] : null;
                }
                this.hostQueryVazio = false;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao);
            } else {
                this.hostQueryVazio = true;
            }
            this.hostQuery = false;
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Access: Host Query Response");
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    InterfaceListener.this.getPortaCOM().write(resultado.startsWith("Erro") ? String.valueOf('\u0015') : String.valueOf('\u0006'));
                    if (InterfaceListener.this.isRX()) {
                        InterfaceListener.this.aguardarProximoFrame();
                    }
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
                InterfaceListener.this.fireAtualizarTabela();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

