/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.uryxxon500;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final String LEU = "leu";
    private static final String KET = "ket";
    private static final String NIT = "nit";
    private static final String BIL = "bil";
    private static final String GLU = "glu";
    private static final String SG = "sg";
    private static final String PH = "ph";
    private static final String UBG = "ubg";
    private static final String BLD = "bld";
    private static final String PRO = "pro";
    private static final String SEQ = "seq";
    private static final String URI_ALTERNATIVO = "URI";
    private static final String LOC = "LOC";
    protected int MAX_PATIENT_NAME_CHARS = 25;
    public static final int EQUIP_TIMEOUT = 5000;
    public static final int TIPO_REQ_NOVO = 0;
    public static final int TIPO_REQ_REPETICAO = 1;
    String int_codigo;
    String fil_codigo;
    String req_codigo;
    String mco_codigo;
    String rec_codigo;
    String pac_nome;
    String pac_exames;
    String pac_sexo;
    String req_idade;
    String req_data;
    String req_hora;
    String acao;
    String frame;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    void limpaDadosRequisicao() {
        this.frame = null;
        this.fil_codigo = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        this.fil_codigo = fil_codigo;
        this.int_codigo = int_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = exames;
        this.acao = acao;
        try {
            this.encerrarTransmissao();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public synchronized String parse(String message) {
        String[] messages;
        String retorno = null;
        Object checksum = null;
        if (message.startsWith(this.getMsgStart())) {
            message = message.replaceFirst(this.getMsgStart(), "");
        }
        if (message.endsWith(this.getMsgEnd())) {
            message = message.replaceFirst(this.getMsgEnd(), "");
        }
        ArrayList<String> fields = new ArrayList<String>();
        for (String linha : messages = message.split("\n")) {
            if (linha.contains(LOC)) continue;
            fields.add(linha);
        }
        if (fields != null && !fields.isEmpty()) {
            try {
                retorno = this.parseResults(fields);
                if (retorno == null) {
                    return "";
                }
                if (retorno.startsWith("Erros")) {
                    return retorno;
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, 2000);
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao anular os dados recebidos";
                }
            }
        }
        return "Erro ao realizar parse dos dados recebidos";
    }

    private String parseResults(ArrayList<String> fields) throws SQLException {
        try {
            HashMap<String, String> maps = new HashMap<String, String>();
            int pos = 0;
            for (String linha : fields) {
                if (!Funcoes.textoVazio(linha) && linha.indexOf("Error") > -1) {
                    String erro = linha;
                    erro = erro + " - " + fields.get(++pos);
                    this.fireExcecaoEncontrada("Error: " + erro);
                    return null;
                }
                ++pos;
            }
            String aux = "";
            maps.put("linha1", fields.remove(0));
            while (Funcoes.textoVazio(aux = fields.remove(0))) {
            }
            maps.put(SEQ, aux.substring(7).trim());
            String tmp = fields.remove(0);
            if (Funcoes.textoVazio(tmp) || tmp.trim().length() < "Pat.ID:  ".length() + ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada("C\u00f3digo de requisi\u00e7\u00e3o incorreto para " + tmp);
                return null;
            }
            maps.put("requisicao", tmp.substring(7).trim().replaceAll("[a-z A-Z]", ""));
            maps.put("linha2", fields.remove(0));
            maps.put("date", fields.remove(0).trim());
            maps.put("linha3", fields.remove(0));
            for (String l : fields) {
                if (l.length() < 7) continue;
                String key = l.substring(0, 7).trim();
                key = key.replace("*", "").trim();
                String value = l.substring(7).trim();
                if (key.equalsIgnoreCase(BLD)) {
                    maps.put(BLD, value);
                    continue;
                }
                if (key.equalsIgnoreCase(UBG)) {
                    maps.put(UBG, value);
                    continue;
                }
                if (key.equalsIgnoreCase(BIL)) {
                    maps.put(BIL, value);
                    continue;
                }
                if (key.equalsIgnoreCase(PRO)) {
                    maps.put(PRO, value);
                    continue;
                }
                if (key.equalsIgnoreCase(NIT)) {
                    maps.put(NIT, value);
                    continue;
                }
                if (key.equalsIgnoreCase(KET)) {
                    maps.put(KET, value);
                    continue;
                }
                if (key.equalsIgnoreCase(GLU)) {
                    maps.put(GLU, value);
                    continue;
                }
                if (key.equalsIgnoreCase(PH)) {
                    String v;
                    String string = v = value == null ? "" : value;
                    if (v.indexOf(".") > 0) {
                        v = value.replace(".", ",");
                    }
                    maps.put(PH, v.trim());
                    continue;
                }
                if (key.equalsIgnoreCase(SG)) {
                    maps.put(SG, value);
                    continue;
                }
                if (!key.equalsIgnoreCase(LEU)) continue;
                maps.put(LEU, value);
            }
            String requisicao = (String)maps.get("requisicao");
            if (Funcoes.textoVazio(requisicao) || !Funcoes.isNumeric(requisicao)) {
                this.fireExcecaoEncontrada("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o localizado ou inv\u00e1lido nos dados recebidos (recebido " + requisicao + ")");
                return null;
            }
            Statement st = Conexao.getStatement();
            DescritorCodigoEtiqueta codigoEtiqueta = DescritorCodigoEtiqueta.getDescritor(requisicao);
            if (codigoEtiqueta == null) {
                this.fireExcecaoEncontrada("C\u00f3digo da requisi\u00e7\u00e3o inv\u00e1lido (recebido " + requisicao + ")");
                return null;
            }
            this.fil_codigo = Funcoes.preencheZero(codigoEtiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = Funcoes.preencheZero(codigoEtiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            this.req_codigo = Funcoes.preencheZero(codigoEtiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, URI_ALTERNATIVO);
            if (this.int_codigo == null) {
                this.fireExcecaoEncontrada("Erro ao identificar a interface da amostra.");
                return null;
            }
            HashMap<String, Object> resultados = new HashMap<String, Object>();
            resultados.put("rack_position", maps.get(SEQ));
            if (Funcoes.isNumeric((String)maps.get(PRO))) {
                resultados.put("PRO2", ((String)maps.get(PRO)).replace('.', ','));
                resultados.put("PRO", maps.get(PRO));
            } else {
                resultados.put("PRO", maps.get(PRO));
            }
            if (Funcoes.isNumeric((String)maps.get(BLD))) {
                resultados.put("BLD2", ((String)maps.get(BLD)).replace('.', ','));
                resultados.put("SAN", maps.get(BLD));
            } else {
                resultados.put("SAN", maps.get(BLD));
            }
            if (Funcoes.isNumeric((String)maps.get(UBG))) {
                resultados.put("URO2", ((String)maps.get(UBG)).replace('.', ','));
                resultados.put("UBG", maps.get(UBG));
            } else {
                resultados.put("UBG", maps.get(UBG));
            }
            if (Funcoes.isNumeric((String)maps.get(PH))) {
                resultados.put("PH2", ((String)maps.get(PH)).replace('.', ','));
                resultados.put("p.H", maps.get(PH));
            } else {
                resultados.put("p.H", maps.get(PH));
            }
            if (Funcoes.isNumeric((String)maps.get(SG))) {
                resultados.put("SG2", ((String)maps.get(SG)).replace('.', ','));
                resultados.put("DEN", maps.get(SG));
            } else {
                resultados.put("DEN", maps.get(SG));
            }
            if (Funcoes.isNumeric((String)maps.get(GLU))) {
                resultados.put("GLU2", ((String)maps.get(GLU)).replace('.', ','));
                resultados.put("GLI", maps.get(GLU));
            } else {
                resultados.put("GLI", maps.get(GLU));
            }
            if (Funcoes.isNumeric((String)maps.get(BIL))) {
                resultados.put("BIL2", ((String)maps.get(BIL)).replace('.', ','));
                resultados.put("BIL", maps.get(BIL));
            } else {
                resultados.put("BIL", maps.get(BIL));
            }
            if (Funcoes.isNumeric((String)maps.get(NIT))) {
                resultados.put("NIT2", ((String)maps.get(NIT)).replace('.', ','));
                resultados.put("NIT", maps.get(NIT));
            } else {
                resultados.put("NIT", maps.get(NIT));
            }
            if (Funcoes.isNumeric((String)maps.get(KET))) {
                resultados.put("KET2", ((String)maps.get(KET)).replace('.', ','));
                resultados.put("CET", maps.get(KET));
            } else {
                resultados.put("CET", maps.get(KET));
            }
            if (Funcoes.isNumeric((String)maps.get(LEU))) {
                resultados.put("LEU2", ((String)maps.get(LEU)).replace('.', ','));
                resultados.put("LEU", maps.get(LEU));
            } else {
                resultados.put("LEU", maps.get(LEU));
            }
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo);
            for (BDExame exame : exames) {
                String exa_codigo = exame.getExame();
                this.atualizarDadosExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exame.getExame(), exame.getMaterial(), this.int_codigo, resultados);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    public void encerrarTransmissao() throws Exception {
        Statement st = Conexao.getStatement();
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
        if (this.acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.interromperTimer();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    public void requisicaoExistente() throws Exception {
        Statement st = Conexao.getStatement();
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) re-enviado(s) com sucesso para " + this.pac_nome + ".", 0, 10000);
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(5000);
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    private void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(3000);
    }

    public void caracterNaoEsperado() throws Exception {
    }

    private void tratarAcknowledge() throws Exception {
        if (!this.isTX()) {
            this.caracterNaoEsperado();
        }
    }

    @Override
    public void handShakeCharReceived(final char c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    switch (c) {
                        case '\u0006': {
                            InterfaceListener.this.tratarAcknowledge();
                            break;
                        }
                        default: {
                            InterfaceListener.this.caracterNaoEsperado();
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
                    InterfaceListener.this.setIdle();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String message = InterfaceListener.this.getPortaCOM().removeInputString(InterfaceListener.this.getMsgEnd());
                    if (!message.equals("")) {
                        InterfaceListener.this.addListaRecebimento(message);
                        InterfaceListener.this.restartThreadRecebimento();
                    } else if (InterfaceListener.this.isRX()) {
                        InterfaceListener.this.aguardarProximoFrame();
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
            } else if (this.isRX()) {
                if (this.frame != null) {
                    this.abortarRecepcao();
                } else {
                    this.setIdle();
                }
            } else {
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void teste() {
        StringBuilder buf = new StringBuilder();
        String idAmostra = JOptionPane.showInputDialog("Digite o Id da amostra?");
        buf.append(this.equipamento.arruma("[STX][LINE][LINE][LINE]"));
        buf.append(this.equipamento.arruma("Seq.No:[SP][SP]0033[LINE]"));
        buf.append(this.equipamento.arruma("Pat.ID:[SP][SP]" + idAmostra + "[LINE][LINE]"));
        buf.append(this.equipamento.arruma("28/12/2015[SP][SP][SP][SP][SP][SP]17:27[LINE]"));
        buf.append(this.equipamento.arruma("************************[LINE]"));
        buf.append(this.equipamento.arruma("Farbe:[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("Klarheit:[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][LINE]"));
        buf.append(this.equipamento.arruma("*[SP]BLD[SP][SP][SP][SP][SP]50[SP]Ery/\u00b5l[SP][SP]++[LINE]"));
        buf.append(this.equipamento.arruma("[SP][SP]UBG[SP][SP][SP]NORM[LINE]"));
        buf.append(this.equipamento.arruma("[SP][SP]BIL[SP][SP][SP][SP]NEG[LINE]"));
        buf.append(this.equipamento.arruma("*[SP]PRO[SP][SP][SP][SP][SP]30[SP][SP]mg/dl[SP][SP][SP]+[LINE]"));
        buf.append(this.equipamento.arruma("*[SP]NIT[SP][SP][SP][SP]POS[LINE]"));
        buf.append(this.equipamento.arruma("[SP][SP]KET[SP][SP][SP][SP]NEG[LINE]"));
        buf.append(this.equipamento.arruma("[SP][SP]GLU[SP][SP][SP][SP]NEG[LINE]"));
        buf.append(this.equipamento.arruma("[SP][SP][SP]pH[SP][SP][SP][SP]6.5[LINE]"));
        buf.append(this.equipamento.arruma("[SP][SP][SP]SG[SP][SP]1.015[LINE]"));
        buf.append(this.equipamento.arruma("*[SP]LEU[SP][SP][SP][SP][SP]25[SP]Leu/\u00b5l[SP][SP][SP]+[LINE]"));
        buf.append(this.equipamento.arruma("------------------------[LINE]"));
        buf.append(this.equipamento.arruma("[ETX][CR]"));
        this.parse(buf.toString());
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

