/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.uroquick;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.uroquick.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final String FIELD6_SPARE = "spare";
    private static final String FIELD6_RESISTANCE = "resistencia_perc";
    private static final String FIELD6_ANALYSIS_RESULT = "resultado";
    private static final String FIELD6_SAMPLE_STATUS = "status_amostra";
    private static final String FIELD6_CHARGE = "carga_bacteriana";
    private static final String FIELD6_TIME = "time";
    private static final String FIELD6_ANTIBIOTICO = "antibiotico";
    private static final String FIELD6_MATERIAL_BIOLOGICO = "materialBiologico";
    private static final String FIELD6_EXAM_TYPE = "tipo_exame";
    private static final String FIELD6 = "field6";
    private static final String RAA_TEST = "resultado";
    private static final String BACTERIAL_COUNT = "contagem_bacteriana";
    private static final String NAME = "name";
    private static final String SUR_NAME = "surName";
    private static final String SAMPLE_ID = "sampleID";
    private static final int TIME_RETRY = 5000;
    private static final int MAX_TENTATIVAS_TX = 3;
    private static final String ALTERNATIVO = "UROCU";
    protected int tx_counter = 0;
    private boolean semResposta = false;
    private boolean enviado = false;
    private InfoExameRequisicao ultimo_enviado = new InfoExameRequisicao(null, null, null, null, null, null, null, null, null, null);
    private String ultimoEnvio = "";
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
    boolean exr_codigoapoiado = false;

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        Statement st = Conexao.getStatement();
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        ((PortaCOM)portaCOM).setBuscaHandshakeMensagemInteira(true);
        super.setPortaCOM(portaCOM);
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        if (this.semResposta) {
            this.semResposta = false;
            this.getPortaCOM().write(String.valueOf('\u0004'));
            this.fireMensagemEnviada("Sem resposta do equipamento", 1, 5000);
        } else if (this.isTX() && this.tx_counter < 3) {
            ++this.tx_counter;
            this.getPortaCOM().write(String.valueOf('\u0001'));
        } else {
            this.setIdle();
            this.getPortaCOM().write(String.valueOf('\u0004'));
        }
    }

    @Override
    public void dataChanged() {
        try {
            String msg = this.getPortaCOM().getInputString();
            if (msg.startsWith(String.valueOf('\u0001')) && msg.endsWith(String.valueOf('\u0001'))) {
                this.handShakeCharReceived(msg.charAt(0));
            }
            if (msg.startsWith(String.valueOf('\u0004')) && msg.endsWith(String.valueOf('\u0004'))) {
                this.handShakeCharReceived(msg.charAt(0));
            }
            if (msg.length() == 1) {
                this.handShakeCharReceived(msg.charAt(0));
            }
            if (!(msg = this.getPortaCOM().removeInputString(this.getMsgEnd())).isEmpty()) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
                this.addListaRecebimento(msg);
                this.restartThreadRecebimento();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0006': {
                    if (this.isTX() && !Funcoes.textoVazio(this.ultimoEnvio) && !this.enviado) {
                        this.semResposta = false;
                        this.enviarFrame();
                        break;
                    }
                    if (!this.isTX() || !this.enviado) break;
                    this.setIdle();
                    this.confirmaTransmissao();
                    this.getPortaCOM().write(String.valueOf('\u0004'));
                    break;
                }
                case '\u0015': {
                    if (this.isTX() && !this.enviado) {
                        this.setTX(5000);
                        this.semResposta = false;
                        break;
                    }
                    if (!this.enviado) break;
                    this.enviarFrame();
                    break;
                }
                case '\u0004': {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    break;
                }
                case '\u0001': {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "InterfaceListener: evento de caracter de handshake recebido");
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
        }
    }

    private void enviarFrame() throws IOException {
        this.enviado = true;
        this.getPortaCOM().write(this.ultimoEnvio);
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\n');
    }

    @Override
    public String getMsgStart() {
        return null;
    }

    @Override
    public String parse(String message) {
        try {
            String[] codigoJalis;
            String rec_codigo;
            String req_codigo;
            Map<String, String> fields = this.parseFields(message);
            String sampleID = fields.get(SAMPLE_ID).trim();
            if (sampleID.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo() || !Funcoes.isNumeric(sampleID)) {
                this.fireExcecaoEncontrada(String.format("id da amostra inv\u00e1lido %s", sampleID));
                return "";
            }
            String fil_codigo = sampleID.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo = sampleID.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial()), rec_codigo = sampleID.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()), ALTERNATIVO);
            if (int_codigo == null) {
                this.fireExcecaoEncontrada(String.format("N\u00e3o localizado a interface para a amostra %s %s %s alternativo %s", fil_codigo, req_codigo, rec_codigo, ALTERNATIVO));
                return "";
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, ALTERNATIVO);
            if (exame == null) {
                this.fireExcecaoEncontrada(String.format("N\u00e3o localizado o alternativo %s da amostra %s %s %s", ALTERNATIVO, fil_codigo, req_codigo, rec_codigo));
                return "";
            }
            Map<String, Object> dados = this.getField6(fields.get(FIELD6));
            dados.put(BACTERIAL_COUNT, fields.get(BACTERIAL_COUNT).trim());
            Statement st = Conexao.getStatement();
            if (this.exr_codigoapoiado && !Funcoes.textoVazio((codigoJalis = BDUtil.getCodigoJalis(fil_codigo, req_codigo, rec_codigo, int_codigo, exame.getNomeExame(), exame.getCodigoMaterial()))[0]) && !Funcoes.textoVazio(codigoJalis[1]) && !Funcoes.textoVazio(codigoJalis[2])) {
                fil_codigo = codigoJalis[0];
                req_codigo = codigoJalis[1];
                rec_codigo = codigoJalis[2];
            }
            this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "InterfaceListener: parse");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.toString() + "\n" + e.getMessage(), e.getStackTrace());
        }
        return "Resultados recebidos com sucesso";
    }

    private void confirmaTransmissao() {
        try {
            String[] exames;
            if (this.ultimo_enviado == null || this.ultimo_enviado.getExames() == null) {
                this.equipamento.mensagemEnviada("Erro ao receber resposta do equipamento", 1, 5000);
                this.ultimoEnvio = "";
                return;
            }
            Statement st = Conexao.getStatement();
            for (String exame : exames = this.ultimo_enviado.getExames().split(" ", 0)) {
                String rec_codigo;
                String int_codigo;
                String fil_codigo = this.ultimo_enviado.getFilial();
                String req_codigo = this.ultimo_enviado.getCodigo();
                String mco_codigo = this.ultimo_enviado.getMaterial();
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo = this.ultimo_enviado.getRecipiente(), exame, mco_codigo), req_codigo, exame, mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                if (!req_codigo.equals(this.ultimo_enviado.getCodigo())) continue;
                this.firePacienteEnviado(this.ultimo_enviado.getCodigo(), this.ultimo_enviado.getNome(), this.ultimo_enviado.getSexo(), this.ultimo_enviado.getIdade(), this.ultimo_enviado.getData(), this.ultimo_enviado.getHora(), this.ultimo_enviado.getExames());
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
            this.ultimoEnvio = "";
            this.equipamento.mensagemEnviada("Exame enviado com sucesso para " + this.ultimo_enviado.getNome(), 1, 5000);
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    private Map<String, String> parseFields(String message) {
        HashMap<String, String> campos = new HashMap<String, String>();
        String[] fields = message.split("@");
        campos.put(SAMPLE_ID, fields[0]);
        campos.put(SUR_NAME, fields[1]);
        campos.put(NAME, fields[2]);
        campos.put(BACTERIAL_COUNT, fields[3]);
        campos.put("resultado", fields[4]);
        campos.put(FIELD6, fields[5]);
        return campos;
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            this.tx_counter = 0;
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            String sampleID = String.format("%s%s%s", fil_codigo, req_codigo, rec_codigo);
            String[] listaExames = exames.split(" ");
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            String pacSexo = (String)req[aba.getColIndice("S")];
            String name = pac_nome = pac_nome.trim();
            String surName = "";
            if (name.indexOf(" ") > 0) {
                name = name.trim().substring(0, name.indexOf(" "));
                surName = name.trim().substring(name.indexOf(" ") + 1);
            }
            String bacterialCount = "";
            String RAA_test = "";
            if (listaExames != null && listaExames.length > 0) {
                String ex;
                String[] stringArray = listaExames;
                int n = stringArray.length;
                for (int i = 0; i < n && (RAA_test = BDUtil.getExmCodigoAlternativo(fil_codigo, ex = stringArray[i], mco_codigo, int_codigo)) == null; ++i) {
                }
            }
            if (Funcoes.textoVazio(RAA_test)) {
                RAA_test = ALTERNATIVO;
            }
            String field6 = "";
            this.ultimo_enviado = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pacSexo, data, hora, exames);
            this.ultimoEnvio = this.getDataStructure(sampleID, surName, name, bacterialCount, RAA_test, field6);
            this.semResposta = true;
            this.setTX(5000);
            ++this.tx_counter;
            this.getPortaCOM().write(String.valueOf('\u0001'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "InterfaceListener: 155");
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "InterfaceListener: 158");
        }
        return null;
    }

    private String getDataStructure(String sampleID, String surName, String name, String bacterialCount, String RAA_test, String field6) {
        StringBuilder msg = new StringBuilder();
        msg.append(StringUtil.preencheString(sampleID, 19, ' ', 0).substring(0, 19)).append("@");
        msg.append(StringUtil.preencheString(surName, 19, ' ', 0).substring(0, 19)).append("@");
        msg.append(StringUtil.preencheString(name, 19, ' ', 0).substring(0, 19)).append("@");
        msg.append(StringUtil.preencheString(bacterialCount, 19, ' ', 0).substring(0, 19)).append("@");
        msg.append(StringUtil.preencheString(RAA_test, 19, ' ', 0).substring(0, 19)).append("@");
        msg.append(StringUtil.preencheString(field6, 19, ' ', 0).substring(0, 19)).append('\n');
        return msg.toString();
    }

    private Map<String, Object> getField6(String field6) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        if (field6.length() >= 19) {
            fields.put(FIELD6_EXAM_TYPE, field6.substring(0, 1));
            fields.put(FIELD6_MATERIAL_BIOLOGICO, field6.substring(1, 2));
            fields.put(FIELD6_ANTIBIOTICO, field6.substring(2, 5));
            fields.put(FIELD6_TIME, field6.substring(5, 9));
            fields.put(FIELD6_CHARGE, field6.substring(9, 13));
            fields.put(FIELD6_SAMPLE_STATUS, field6.substring(13, 14));
            fields.put("resultado", field6.substring(14, 15));
            fields.put(FIELD6_RESISTANCE, field6.substring(15, 18));
            fields.put(FIELD6_SPARE, field6.substring(18, 19));
        }
        return fields;
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
                if (!InterfaceListener.this.equipamento.getStatusFecharInterfaceamento().isExportando()) {
                    InterfaceListener.this.fireAtualizarTabela(2);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

