/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.urocheck200;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    protected final String NOME_EXAME = "URI";
    public static final int EQUIP_TIMEOUT = 5000;
    protected String int_codigo;
    protected String fil_codigo;
    protected String req_codigo;
    protected String mco_codigo;
    protected String rec_codigo;
    protected String pac_nome;
    protected String pac_exames;
    protected String pac_sexo;
    protected String req_idade;
    protected String req_data;
    protected String req_hora;
    protected String acao;
    protected String frame;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    void limpaDadosRequisicao() {
        this.frame = null;
        this.fil_codigo = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        this.fil_codigo = fil_codigo;
        this.int_codigo = int_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = exames;
        this.acao = acao;
        try {
            this.encerrarTransmissao();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public synchronized String parse(String message) {
        String retorno = null;
        message = message.replaceAll("\n\r", "\r\n");
        ArrayList<String> fields = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(message, new String(new char[]{'\r', '\n'}));
        while (tokenizer.hasMoreElements()) {
            fields.add(tokenizer.nextToken());
        }
        if (fields != null && !fields.isEmpty()) {
            try {
                retorno = this.parseResults(fields);
                if (retorno == null) {
                    return "";
                }
                if (retorno.startsWith("Erro")) {
                    return retorno;
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, 2000);
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao anular os dados recebidos";
                }
            }
        }
        return "Erro ao realizar parse dos dados recebidos";
    }

    protected String parseResults(ArrayList<String> fields) throws SQLException {
        try {
            int digitosTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String requisicao = "";
            int INDEX_COPIA = 5;
            HashMap<String, Object> urina = new HashMap<String, Object>();
            boolean id = false;
            ArrayList<String> numbers = new ArrayList<String>();
            for (String s : fields) {
                if (s.startsWith("Operador:")) {
                    id = true;
                    continue;
                }
                if (id) {
                    numbers.add(s);
                    if (numbers.size() != 4) continue;
                    id = false;
                    continue;
                }
                if (Funcoes.textoVazio(s) || s.equals(StringUtil.repeteCaractere('-', 69)) || s.contains("Impressao Via Serial") || s.startsWith("Res:") || s.startsWith("R:") || s.startsWith("G:") || s.length() < 16 || s.startsWith("B:") || s.startsWith("T:") || s.startsWith("RELATIVO") || s.startsWith("COMPENSADO")) continue;
                if (numbers.size() == 4 && Funcoes.textoVazio(requisicao)) {
                    String temp = "";
                    for (int i = 0; i < numbers.size(); ++i) {
                        String idTemp = this.getId((String)numbers.get(i));
                        if (!Funcoes.isNumeric(idTemp) || idTemp.trim().length() != digitosTubo) continue;
                        requisicao = idTemp;
                        break;
                    }
                }
                String campoCruz = "";
                String campo = s.substring(0, 5).trim();
                String cruz = "";
                String resultado = s.substring(11).trim();
                if (!resultado.equalsIgnoreCase("POSITIVO") && !resultado.contains("NEG")) {
                    resultado = s.substring(11, s.length() - 1).trim();
                }
                if (Funcoes.textoVazio(resultado)) {
                    resultado = s.substring(16).trim();
                }
                String campoTraduzido = campo;
                if (campo.equals("SNG")) {
                    campoTraduzido = "SAN";
                } else if (campo.equals("pH")) {
                    campoTraduzido = "p.H";
                }
                String tmp = resultado.replaceAll("[a-zA-Z/]", "");
                if (tmp.trim().length() != resultado.trim().length() && !resultado.equalsIgnoreCase("POSITIVO") || resultado.contains("NEG")) {
                    resultado = resultado.contains("NEG") ? "NEG" : tmp;
                }
                if (s.indexOf("+") > 0) {
                    int x = 0;
                    for (int i = s.indexOf("+"); i < s.length() && s.charAt(i) == '+'; ++i) {
                        ++x;
                    }
                    if (x > 0) {
                        cruz = StringUtil.repeteCaractere('+', x);
                        campoCruz = campoTraduzido + "_CRUZ";
                    }
                }
                urina.put(campoTraduzido, resultado);
                urina.put(campoCruz, cruz);
            }
            if (Funcoes.textoVazio(requisicao) || !Funcoes.isNumeric(requisicao)) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o localizado nos dados recebidos %s. ", requisicao));
                return null;
            }
            Statement st = Conexao.getStatement();
            requisicao = StringUtil.preencheString(requisicao.trim(), digitosTubo, '0', 1);
            this.fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = requisicao.substring(requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            if (this.fil_codigo.equals(StringUtil.preencheString("", ParametrosGerais.getDigitosTuboFilial(), '0', 1)) || this.req_codigo.equals(StringUtil.preencheString("", ParametrosGerais.getDigitosTuboRequisicao(), '0', 1)) || this.rec_codigo.equals(StringUtil.preencheString("", ParametrosGerais.getDigitosTuboTubo(), '0', 1))) {
                this.fireExcecaoEncontrada("C\u00f3digo da requisi\u00e7\u00e3o inv\u00e1lida pois est\u00e1 diferente do padr\u00e3o de etiquetas utilizado ");
                return null;
            }
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, "URI");
            if (this.int_codigo == null) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo da interface n\u00e3o localizada ou amostra n\u00e3o interfaceada %s %s %s", this.fil_codigo, this.req_codigo, this.rec_codigo));
                return null;
            }
            ExameMaterial exame = this.getReqExameLIS(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo, "URI");
            if (exame == null) {
                this.fireExcecaoEncontrada(String.format("Nenhum exame localizado nos dados recebidos %s %s %s", this.fil_codigo, this.req_codigo, this.rec_codigo));
                return null;
            }
            String exa_codigo = exame.getNomeExame();
            String mco_codigo = exame.getCodigoMaterial();
            this.atualizarDadosExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exa_codigo, mco_codigo, this.int_codigo, urina);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    protected String getId(String id) {
        StringBuilder sampleId = new StringBuilder();
        int tamanhoId = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        for (String s : id.split(" ")) {
            if (Funcoes.textoVazio(s) || !Funcoes.isNumeric(s.trim())) continue;
            int i = Integer.parseInt(s);
            char c = (char)i;
            sampleId.append(c);
            if (sampleId.length() == tamanhoId) break;
        }
        return sampleId.reverse().toString();
    }

    public void encerrarTransmissao() throws Exception {
        Statement st = Conexao.getStatement();
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
        if (this.acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.interromperTimer();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    public void requisicaoExistente() throws Exception {
        Statement st = Conexao.getStatement();
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) re-enviado(s) com sucesso para " + this.pac_nome + ".", 0, 10000);
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(5000);
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    private void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(3000);
    }

    public void caracterNaoEsperado() throws Exception {
    }

    private void tratarAcknowledge() throws Exception {
        if (!this.isTX()) {
            this.caracterNaoEsperado();
        }
    }

    @Override
    public void handShakeCharReceived(final char c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    switch (c) {
                        case '\u0006': {
                            InterfaceListener.this.tratarAcknowledge();
                            break;
                        }
                        default: {
                            InterfaceListener.this.caracterNaoEsperado();
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
                    InterfaceListener.this.setIdle();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("") && message.contains("Fim da Impressao Via Serial") && message.substring(message.indexOf("Fim da Impressao Via Serial")).contains("---" + LINE)) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
            } else if (this.isRX()) {
                if (this.frame != null) {
                    this.abortarRecepcao();
                } else {
                    this.setIdle();
                }
            } else {
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    protected void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    protected void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public String getMsgEnd() {
        return "Fim da Impressao Via Serial                " + LINE + "---------------------------------------------------------------------" + LINE + '\n' + '\r';
    }

    @Override
    public String getMsgStart() {
        return null;
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

