/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.urivision720;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    protected final String NOME_EXAME = "URI";
    public static final int EQUIP_TIMEOUT = 5000;
    public boolean exr_codigoapoiado = false;
    private ThreadRecebimento threadRecebimento;
    protected String int_codigo;
    protected String fil_codigo;
    protected String req_codigo;
    protected String mco_codigo;
    protected String rec_codigo;
    protected String pac_nome;
    protected String pac_exames;
    protected String pac_sexo;
    protected String req_idade;
    protected String req_data;
    protected String req_hora;
    protected String acao;
    protected String frame;
    public final String DELIMITADOR = String.valueOf('\n') + String.valueOf('\r');
    private final String NUMERO = "\\-?\\d+(\\.\\d+)*(\\,\\d+)?";

    public InterfaceListener() {
        this.threadRecebimento = new ThreadRecebimento(this);
        this.threadRecebimento.start();
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
            } else if (this.isRX()) {
                if (this.frame != null) {
                    this.abortarRecepcao();
                } else {
                    this.setIdle();
                }
            } else {
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    @Override
    public void dataChanged() {
        try {
            String deli = '\n' + LINE + LINE + LINE + '\r';
            String message = this.getPortaCOM().removeInputString(deli);
            if (Funcoes.textoVazio(message)) {
                message = this.getPortaCOM().removeInputString("SERIE");
            }
            if (!message.equals("")) {
                this.parse(message);
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0006': {
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
            this.setIdle();
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf(this.DELIMITADOR);
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String message) {
        String retorno = null;
        Object checksum = null;
        String requisicao = "";
        String ID2 = "ID";
        ArrayList<String> fields = new ArrayList<String>();
        String[] mensagem = message.split(this.DELIMITADOR);
        for (int i = 0; i < mensagem.length; ++i) {
            if (mensagem[i].indexOf("ID") > -1 && !mensagem[i].contains("CTRL")) {
                requisicao = mensagem[i].substring(mensagem[i].indexOf("ID"), mensagem[i].length());
                requisicao = StringUtil.removeCaracteresNaoNumericos(requisicao.replaceAll("\n", "").trim());
            }
            fields.add(mensagem[i]);
        }
        if (fields != null && !fields.isEmpty()) {
            try {
                retorno = this.parseResults(fields, requisicao);
                if (retorno == null) {
                    return "";
                }
                if (retorno.startsWith("Erro")) {
                    return retorno;
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, 2000);
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao anular os dados recebidos";
                }
            }
        }
        return "Erro ao realizar parse dos dados recebidos";
    }

    private String parseResults(ArrayList<String> fields, String requisicao) throws SQLException {
        try {
            String[] codigoJalis;
            String DATA = "Data:";
            String DATA_INGLES = "Date:";
            String DATAESPACO = "Data :";
            String DATA_INGLES_ESPACO = "Date :";
            String ENFERMARIA = "Emfermaria:";
            String ENFERMARIA_INGLES = "Ward:";
            String NOME = "Nome:";
            String NOME_INGLES = "Name:";
            int INDEX_COPIA = 5;
            String resultado = "";
            if (Funcoes.textoVazio(requisicao) || !Funcoes.isNumeric(requisicao)) {
                this.fireExcecaoEncontrada("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o localizado nos dados recebidos");
                return null;
            }
            Statement st = Conexao.getStatement();
            requisicao = StringUtil.preencheString(requisicao.trim(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            this.fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = requisicao.substring(requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, "URI");
            HashMap<String, Object> urina = new HashMap<String, Object>();
            urina.put("ID", requisicao);
            for (String field : fields) {
                String campo;
                String[] camposTraduzido;
                if (Funcoes.textoVazio(field = field.replaceAll("\n", "")) || field.contains("N_SEQ") || field.contains("//") || field.indexOf("ID") > -1 || (camposTraduzido = this.validaParametroExame(campo = field.substring(0, 4).trim())).length <= 1) continue;
                String[] campos = field.split("\t");
                String[] resultados = campos[1].trim().split(" ");
                String resultadoQualitativo = resultados[0];
                String resultadoQuantitativo = resultados[resultados.length - 1];
                if (resultadoQuantitativo.matches("\\-?\\d+(\\.\\d+)*(\\,\\d+)?mg/dL")) {
                    resultadoQuantitativo = StringUtil.removeCaracteresNaoNumericos(resultadoQuantitativo);
                }
                if (campo.equals("p.H") || campo.equals("DEN") || campo.equals("SG2")) {
                    resultadoQuantitativo.replaceAll("\\.", ",");
                }
                urina.put(camposTraduzido[0], resultadoQualitativo);
                urina.put(camposTraduzido[1], resultadoQuantitativo);
            }
            ExameMaterial exame = this.getReqExameLIS(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo, "URI");
            if (exame == null) {
                this.fireExcecaoEncontrada("Nenhum exame localizado nos dados recebidos");
                return null;
            }
            String exa_codigo = exame.getNomeExame();
            String mco_codigo = exame.getCodigoMaterial();
            if (this.exr_codigoapoiado && !Funcoes.textoVazio((codigoJalis = BDUtil.getCodigoJalis(this.fil_codigo, this.req_codigo, this.rec_codigo, this.int_codigo, exa_codigo, mco_codigo))[0]) && !Funcoes.textoVazio(codigoJalis[1]) && !Funcoes.textoVazio(codigoJalis[2])) {
                this.fil_codigo = codigoJalis[0];
                this.req_codigo = codigoJalis[1];
                this.rec_codigo = codigoJalis[2];
            }
            this.atualizarDadosExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exa_codigo, mco_codigo, this.int_codigo, urina);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    private String[] validaParametroExame(String campo) {
        switch (campo) {
            case "URO": {
                return new String[]{"URO", "URO2"};
            }
            case "GLI": {
                return new String[]{"GLI", "GLU2"};
            }
            case "CET": {
                return new String[]{"CET", "KET2"};
            }
            case "BIL": {
                return new String[]{"BIL", "BIL2"};
            }
            case "SAN": 
            case "SNG": {
                return new String[]{"SAN", "BLD2"};
            }
            case "PRO": {
                return new String[]{"PRO", "PRO2"};
            }
            case "NIT": {
                return new String[]{"NIT", "NIT2"};
            }
            case "p.H": 
            case "pH": {
                return new String[]{"p.H", "PH2"};
            }
            case "DEN": {
                return new String[]{"DEN", "SG2"};
            }
            case "LEU": {
                return new String[]{"LEU", "LEU2"};
            }
        }
        return new String[0];
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return null;
    }

    private void limpaDadosRequisicao() {
        this.frame = null;
        this.fil_codigo = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(5000);
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    private void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(3000);
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    @Override
    public void teste() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.equipamento.arruma("[LF]"));
        buff.append(this.equipamento.arruma("[CR]"));
        buff.append(this.equipamento.arruma("N_SEQ("));
        buff.append(this.equipamento.arruma("0434)[LF]"));
        buff.append(this.equipamento.arruma("[CR]"));
        buff.append(this.equipamento.arruma("//20[SP][SP][SP][SP][SP]"));
        buff.append(this.equipamento.arruma("[SP]::[LF]"));
        buff.append(this.equipamento.arruma("[CR]"));
        buff.append(this.equipamento.arruma("URO\tNORM[SP][SP][SP]"));
        buff.append(this.equipamento.arruma("[SP]0.1mg/d"));
        buff.append(this.equipamento.arruma("L[LF]"));
        buff.append(this.equipamento.arruma("[CR]"));
        buff.append(this.equipamento.arruma("GLI\t[SP][SP][SP]-[SP][SP][SP][SP][SP]"));
        buff.append(this.equipamento.arruma("[SP][SP]NEG[SP][SP][LF]"));
        buff.append(this.equipamento.arruma("[CR]"));
        buff.append(this.equipamento.arruma("CET\t[SP][SP][SP]-[SP][SP][SP][SP][SP][SP][SP]NEG[SP][SP][LF]"));
        buff.append(this.equipamento.arruma("[CR]"));
        buff.append(this.equipamento.arruma("B"));
        buff.append(this.equipamento.arruma("IL\t[SP][SP][SP]-[SP][SP][SP][SP][SP][SP][SP]NE"));
        buff.append(this.equipamento.arruma("G[SP][SP][LF]"));
        buff.append(this.equipamento.arruma("[CR]"));
        buff.append(this.equipamento.arruma("PRO\t[SP][SP][SP]+[SP][SP][SP]"));
        buff.append(this.equipamento.arruma("[SP][SP]30mg/dL[LF]"));
        buff.append(this.equipamento.arruma("[CR]"));
        buff.append(this.equipamento.arruma("NIT\t[SP]"));
        buff.append(this.equipamento.arruma("[SP][SP][SP][SP][SP][SP][SP]NEGATIVO[LF]"));
        buff.append(this.equipamento.arruma(""));
        buff.append(this.equipamento.arruma("[CR]"));
        buff.append(this.equipamento.arruma("[SP]pH\t[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]"));
        buff.append(this.equipamento.arruma("6.5[SP][SP][LF]"));
        buff.append(this.equipamento.arruma("[CR]"));
        buff.append(this.equipamento.arruma("SNG\t[SP]+++[SP][SP][SP]250RBC"));
        buff.append(this.equipamento.arruma("/uL[LF]"));
        buff.append(this.equipamento.arruma("[CR]"));
        buff.append(this.equipamento.arruma("DEN\t[SP][SP][SP][SP][SP][SP][SP]"));
        buff.append(this.equipamento.arruma("[SP][SP][SP]1.000[SP][LF]"));
        buff.append(this.equipamento.arruma("[CR]"));
        buff.append(this.equipamento.arruma("LEU\t[SP]"));
        buff.append(this.equipamento.arruma("[SP][SP]-[SP][SP][SP][SP][SP][SP][SP]NEG[SP][SP][LF]"));
        buff.append(this.equipamento.arruma(""));
        buff.append(this.equipamento.arruma("[LINE]"));
        buff.append(this.equipamento.arruma("[CR]"));
        buff.append(this.equipamento.arruma("ID(0100064147"));
        buff.append(this.equipamento.arruma("11[NUL])[LF]"));
        buff.append(this.equipamento.arruma("[CR]"));
        buff.append(this.equipamento.arruma("N.[SP]SERIE(1"));
        buff.append(this.equipamento.arruma("8010058)[LF]"));
        buff.append(this.equipamento.arruma("[LINE]"));
        buff.append(this.equipamento.arruma("[CR]"));
        buff.append(this.equipamento.arruma(""));
        buff.append(this.equipamento.arruma(""));
        PortaCOM porta = new PortaCOM();
        porta = (PortaCOM)this.getPortaCOM();
        porta.read(buff.toString(), 0);
    }
}

