/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.uriview;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.urocheck200.InterfaceListener {
    String inputString = "";
    Map<String, Object> urina = new HashMap<String, Object>();
    List<String> campos = new ArrayList<String>();

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            String endMsg = this.getMsgFinal(message);
            if (Funcoes.textoVazio(endMsg)) {
                this.aguardarProximoFrame();
                return;
            }
            System.out.println("endMsg " + endMsg);
            message = this.getPortaCOM().removeInputString(endMsg);
            if (!message.equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public InterfaceListener() {
        this.campos.add("SAN");
        this.campos.add("BIL");
        this.campos.add("URO");
        this.campos.add("CET");
        this.campos.add("PRO");
        this.campos.add("NIT");
        this.campos.add("GLI");
        this.campos.add("p.H");
        this.campos.add("DEN");
        this.campos.add("LEU");
        this.campos.add("VTC");
        this.campos.add("COL");
        this.campos.add("ASP");
        this.campos.add("UBG");
        this.campos.add("ERY");
        this.campos.add("pH");
        this.campos.add("VC");
        this.campos.add("GRA");
        this.campos.add("URI");
        this.campos.add("SNG");
        this.campos.add("SAN_CRUZ");
        this.campos.add("BIL_CRUZ");
        this.campos.add("KET_CRUZ");
        this.campos.add("PRO_CRUZ");
        this.campos.add("GLI_CRUZ");
        this.campos.add("LEU_CRUZ");
        this.campos.add("URO_CRUZ");
    }

    public void dataChanged(String message) {
        try {
            this.inputString = this.inputString + message;
            String endMsg = this.getMsgFinal(this.inputString);
            if (Funcoes.textoVazio(endMsg)) {
                this.aguardarProximoFrame();
                return;
            }
            System.out.println("endMsg " + endMsg);
            message = this.removeInputString(endMsg);
            if (!message.equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private String removeInputString(String delimitador) {
        if (this.inputString.indexOf(delimitador) >= 0) {
            int delsize = delimitador.length();
            String head = this.inputString.substring(0, this.inputString.indexOf(delimitador) + delsize);
            this.inputString = this.inputString.substring(this.inputString.indexOf(delimitador) + delsize);
            return head;
        }
        return "";
    }

    private String getMsgFinal(String msg) {
        String msgEnd;
        int indexStart = msg.indexOf("L: ");
        int indexEnd = -1;
        if (indexStart > 0) {
            indexEnd = msg.substring(indexStart).indexOf(String.valueOf('\n') + String.valueOf('\r')) + 2 + indexStart;
        }
        if (indexStart > 0 && indexEnd > indexStart && (msgEnd = msg.substring(indexStart, indexEnd)).length() >= 76) {
            return msgEnd;
        }
        return null;
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    @Override
    protected String parseResults(ArrayList<String> fields) throws SQLException {
        try {
            int digitosTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String requisicao = "";
            int INDEX_COPIA = 5;
            boolean id = false;
            boolean numeric = false;
            ArrayList<String> numbers = new ArrayList<String>();
            for (String s : fields) {
                String[] lines;
                for (String str : lines = s.trim().split(" ")) {
                    numeric = true;
                    if (Funcoes.textoVazio(str) || Funcoes.isNumeric(str)) continue;
                    numeric = false;
                    break;
                }
                if (s.startsWith("Operador:")) {
                    id = true;
                    continue;
                }
                if (Funcoes.textoVazio(s)) continue;
                if (id || numeric && !id) {
                    numbers.add(s);
                    if (numbers.size() != 4) continue;
                    id = false;
                    continue;
                }
                if (s.equals(StringUtil.repeteCaractere('-', 69)) || s.contains("Impressao Via Serial") || s.startsWith("Res:") || s.startsWith("R:") || s.startsWith("G:") || s.length() < 16 || s.startsWith("B:") || s.startsWith("T:") || s.startsWith("RELATIVO") || s.startsWith("COMPENSADO")) continue;
                if (Funcoes.textoVazio(requisicao)) {
                    String temp = "";
                    for (int i = 0; i < numbers.size(); ++i) {
                        String idTemp = this.getId((String)numbers.get(i));
                        if (!Funcoes.isNumeric(idTemp)) continue;
                        requisicao = idTemp;
                        break;
                    }
                }
                String campoCruz = "";
                String campo = s.substring(0, 5).trim();
                String cruz = "";
                String resultado = s.substring(11).trim();
                if (!resultado.equalsIgnoreCase("POSITIVO") && !resultado.contains("NEG")) {
                    resultado = s.substring(11, s.length() - 1).trim();
                }
                if (Funcoes.textoVazio(resultado)) {
                    resultado = s.substring(16).trim();
                }
                String campoTraduzido = campo;
                if (campo.equals("SNG")) {
                    campoTraduzido = "SAN";
                } else if (campo.equals("pH")) {
                    campoTraduzido = "p.H";
                }
                String tmp = resultado.replaceAll("[a-zA-Z/]", "");
                if (tmp.trim().length() != resultado.trim().length() && !resultado.equalsIgnoreCase("POSITIVO") || resultado.contains("NEG")) {
                    resultado = resultado.contains("NEG") ? "NEG" : tmp;
                }
                if (s.indexOf("+") > 0) {
                    int x = 0;
                    for (int i = s.indexOf("+"); i < s.length() && s.charAt(i) == '+'; ++i) {
                        ++x;
                    }
                    if (x > 0) {
                        cruz = StringUtil.repeteCaractere('+', x);
                        campoCruz = campoTraduzido + "_CRUZ";
                    }
                }
                if (!Funcoes.textoVazio(campoTraduzido) && !Funcoes.textoVazio(resultado) && this.campos.indexOf(campoTraduzido) >= 0) {
                    if (Funcoes.isNumeric(resultado.trim())) {
                        resultado = resultado.replaceFirst("\\.", ",");
                    }
                    this.urina.put(campoTraduzido, resultado);
                }
                if (Funcoes.textoVazio(campoCruz) || Funcoes.textoVazio(cruz) || this.campos.indexOf(campoCruz) < 0) continue;
                this.urina.put(campoCruz, cruz);
            }
            if (Funcoes.textoVazio(requisicao) || !Funcoes.isNumeric(requisicao)) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o localizado nos dados recebidos %s. ", requisicao));
                return null;
            }
            Statement st = Conexao.getStatement();
            requisicao = StringUtil.preencheString(requisicao.trim(), digitosTubo, '0', 1);
            this.fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = requisicao.substring(requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            if (this.fil_codigo.equals(StringUtil.preencheString("", ParametrosGerais.getDigitosTuboFilial(), '0', 1)) || this.req_codigo.equals(StringUtil.preencheString("", ParametrosGerais.getDigitosTuboRequisicao(), '0', 1)) || this.rec_codigo.equals(StringUtil.preencheString("", ParametrosGerais.getDigitosTuboTubo(), '0', 1))) {
                this.fireExcecaoEncontrada("C\u00f3digo da requisi\u00e7\u00e3o inv\u00e1lida pois est\u00e1 diferente do padr\u00e3o de etiquetas utilizado ");
                return null;
            }
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, "URI");
            if (this.int_codigo == null) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo da interface n\u00e3o localizada ou amostra n\u00e3o interfaceada %s %s %s", this.fil_codigo, this.req_codigo, this.rec_codigo));
                return null;
            }
            ExameMaterial exame = this.getReqExameLIS(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo, "URI");
            if (exame == null) {
                this.fireExcecaoEncontrada(String.format("Nenhum exame localizado nos dados recebidos %s %s %s", this.fil_codigo, this.req_codigo, this.rec_codigo));
                return null;
            }
            String exa_codigo = exame.getNomeExame();
            String mco_codigo = exame.getCodigoMaterial();
            this.atualizarDadosExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exa_codigo, mco_codigo, this.int_codigo, this.urina);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    @Override
    public synchronized String parse(String message) {
        String[] x;
        String retorno = null;
        ArrayList<String> fields = new ArrayList<String>();
        for (String line : x = message.split("[" + String.valueOf('\n') + String.valueOf('\r') + "" + String.valueOf('\r') + String.valueOf('\n') + "]")) {
            if (Funcoes.textoVazio(line)) continue;
            fields.add(line);
        }
        this.urina.clear();
        if (fields != null && !fields.isEmpty()) {
            try {
                retorno = this.parseResults(fields);
                if (retorno == null) {
                    return "";
                }
                if (retorno.startsWith("Erro")) {
                    return retorno;
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, 2000);
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao anular os dados recebidos";
                }
            }
        }
        return "Erro ao realizar parse dos dados recebidos";
    }
}

