/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.uritbh70p;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class InterfaceListener
extends InterfaceHl7Listener {
    private static final String ALTERNATIVO = "HEMOG";
    private Map<String, String> parametros = new HashMap<String, String>();
    private Map<String, String> flags = new HashMap<String, String>();

    public InterfaceListener() {
        super("Urit BH-70P");
        this.parametros.put("WBC", "leucocitos");
        this.parametros.put("LYM%", "linfocitos_tipicos_percentual");
        this.parametros.put("MID%", "monocitos_percentual");
        this.parametros.put("GRAN%", "granulocitos_percentual");
        this.parametros.put("LYM#", "linfocitos_tipicos_contagem");
        this.parametros.put("MID#", "monocitos_contagem");
        this.parametros.put("GRAN#", "granulocitos_contagem");
        this.parametros.put("RBC", "hemacias");
        this.parametros.put("HGB", "hgb");
        this.parametros.put("HCT", "hct");
        this.parametros.put("VCM", "vcm");
        this.parametros.put("HCM", "hcm");
        this.parametros.put("CHCM", "chcm");
        this.parametros.put("RDW_CV", "rdw_cv");
        this.parametros.put("RDW_SD", "rdw_sd");
        this.parametros.put("PLT", "plaquetas");
        this.parametros.put("VPM", "vpm");
        this.parametros.put("PCT", "pct");
        this.parametros.put("P_LCR", "plaquetas_lcr");
        this.parametros.put("P_LCC", "plaquetas_lcc");
        this.parametros.put("WBCHistogram^LeftLine", "urit_bh70p_wbc_histogram_left_line");
        this.parametros.put("WBCHistogram^RightLine", "urit_bh70p_wbc_histogram_right_line");
        this.parametros.put("WBCHistogram^MiddleLine", "urit_bh70p_wbc_histogram_middle_line");
        this.parametros.put("WBCHistogram", "urit_bh70p_wbc_histogram");
        this.parametros.put("RBCHistogram^LeftLine", "urit_bh70p_rbc_histogram_left_line");
        this.parametros.put("RBCHistogram^RightLine", "urit_bh70p_rbc_histogram_right_line");
        this.parametros.put("RBCHistogram", "urit_bh70p_rbc_histogram");
        this.parametros.put("PLTHistogram^LeftLine", "urit_bh70p_plt_histogram_left_line");
        this.parametros.put("PLTHistogram^RightLine", "urit_bh70p_plt_histogram_right_line");
        this.parametros.put("PLTHistogram", "urit_bh70p_plt_histogram");
        this.flags.put("PDW_SD", "PDW SD");
        this.flags.put("PDW_CV", "PDW CV");
    }

    public Map<String, String> getParametros() {
        return this.parametros;
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01;
        block15: {
            ackR01 = new MessageAckR01();
            ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
            ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
            ackR01.getMsa().setTextMessage("Mensagem aceita");
            ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
            try {
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                String tuboId = oruR01.getObr().getFilterOrderNumber();
                if (!Funcoes.objectIsNull(tuboId) && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                    String intCodigo;
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                    if (!Funcoes.objectIsNull(etiqueta)) {
                        filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                        reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                        recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    }
                    if ((intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, ALTERNATIVO)) == null) {
                        this.fireExcecaoEncontrada("Interfaceamento do exame HEMOG n\u00e3o encontrado para requisi\u00e7\u00e3o " + filCodigo + " " + reqCodigo + " " + recCodigo);
                        return;
                    }
                    ExameMaterial exame = null;
                    if (Funcoes.objectIsNull(intCodigo)) break block15;
                    HashMap<String, Object> dados = new HashMap<String, Object>();
                    ArrayList<String> flag = new ArrayList<String>();
                    exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, ALTERNATIVO);
                    if (!Funcoes.objectIsNull(exame)) {
                        for (MessageSegmentObx obx : oruR01.getObxList()) {
                            if (!Funcoes.objectIsNull((Object)obx.getAbnormalFlag())) {
                                flag.add(obx.getAbnormalFlag().toString());
                            }
                            String campo = this.getParametros().get(obx.getObservationId());
                            if (this.flags.containsKey(obx.getObservationId())) {
                                flag.add(this.flags.get(obx.getObservationId()));
                            }
                            if (Funcoes.objectIsNull(campo)) continue;
                            String resultado = obx.getObservationValue().replace('.', ',');
                            if (campo.equalsIgnoreCase("urit_bh70p_wbc_histogram") || campo.equalsIgnoreCase("urit_bh70p_rbc_histogram") || campo.equalsIgnoreCase("urit_bh70p_plt_histogram")) {
                                try {
                                    resultado = this.convertImg(reqCodigo, obx.getObservationValue());
                                }
                                catch (Exception e) {
                                    this.fireExcecaoEncontrada(String.format("Imagem corrompida para a requisi\u00e7\u00e3o %s %s %s Campo %s ", filCodigo, reqCodigo, recCodigo, campo));
                                    resultado = null;
                                }
                            }
                            dados.put(campo, resultado);
                        }
                        if (!dados.isEmpty()) {
                            this.atualizarDadosExame(Conexao.getStatement(), filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados, flag);
                            Conexao.arquivaSQL();
                            this.fireAtualizarTabela();
                        }
                        break block15;
                    }
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame n\u00e3o encontrado para requisi\u00e7\u00e3o " + filCodigo + " " + reqCodigo + " " + recCodigo);
                    break block15;
                }
                this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o fora do padr\u00e3o do jalis (%s) ou n\u00e3o interfaceada", tuboId));
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                ackR01.getMsa().setTextMessage("Erro ao receber a mensagem");
                ackR01.getMsa().setErrorCondition(ErrorCondition.APPLICATION_INTERNAL_ERROR);
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    protected String convertImg(String reqCodigo, String resultado) {
        resultado = resultado.replace("3^Histogram^32Byte^HEX^", "");
        List<Integer> decimalValues = InterfaceListener.hexParaDecimal(resultado);
        return InterfaceListener.salvaImagemBase64(decimalValues, reqCodigo);
    }

    public static String salvaImagemBase64(List<Integer> decimalValues, String requisicao) {
        double[] data = new double[decimalValues.size()];
        for (int i = 0; i < decimalValues.size(); ++i) {
            data[i] = decimalValues.get(i).intValue();
        }
        HistogramDataset dataset = new HistogramDataset();
        dataset.addSeries("Hexadecimal Values", data, 256);
        JFreeChart histogram = ChartFactory.createHistogram((String)"", (String)"Valor Decimal", (String)"Frequ\u00eancia", (IntervalXYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        try {
            File tempFile = File.createTempFile("urit_bh70_p" + requisicao, ".png");
            BufferedImage bufferedImage = histogram.createBufferedImage(250, 200);
            ImageIO.write((RenderedImage)bufferedImage, "PNG", tempFile);
            String base64Image = InterfaceListener.convertImageToBase64(tempFile);
            tempFile.delete();
            return base64Image;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String convertImageToBase64(File imageFile) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            BufferedImage img = ImageIO.read(imageFile);
            ImageIO.write((RenderedImage)img, "PNG", baos);
            baos.flush();
            byte[] imageBytes = baos.toByteArray();
            String string = Base64.getEncoder().encodeToString(imageBytes);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Integer> hexParaDecimal(String hexData) {
        ArrayList<Integer> decimalValues = new ArrayList<Integer>();
        for (int i = 0; i < hexData.length(); i += 2) {
            String hexByte = hexData.substring(i, i + 2);
            int decimalValue = Integer.parseInt(hexByte, 16);
            decimalValues.add(decimalValue);
        }
        return decimalValues;
    }

    @Override
    public synchronized void dataChanged() {
        String message = this.getPortaCOM().removeInputString(String.valueOf(LINE) + String.valueOf('\u001c'));
        if (!Funcoes.textoVazio(message) && this.checkMessage(message)) {
            this.parse(message);
            if (this.getPortaCOM().getInputString().length() > 0) {
                this.dataChanged();
            }
        }
    }

    public boolean checkMessage(String text) {
        return text.charAt(0) == '\u000b' && text.charAt(text.length() - 1) == '\u001c';
    }

    @Override
    public String parse(String text) {
        try {
            Message message = this.messageParser.textToMessageUritBh70p(text);
            this.mensagemRecebida(message);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    @Override
    public void teste() {
        String requisicao = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "010051553801");
        StringBuilder tmp = new StringBuilder();
        tmp.append("[SB]MSH|^~\\&|2|3|LIS|PC|20241104140000||ORU^R01|4|P|2.3.1||||||UNICODE[LINE]");
        tmp.append("PID|7||10||||0|[LINE]");
        tmp.append("OBR|5||" + requisicao + "|2^3|||20241104135900||||||||3|||||[LINE]");
        tmp.append("OBX|1|NM|WBC||4.4|x10^9/L|3.5-10.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|LYM%||38.6|%|20.0-40.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|MID%||12.6|%|1.0-15.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|GRAN%||48.8|%|50.0-70.0|L|||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|LYM#||1.6|x10^9/L|0.6-4.1||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|MID#||0.5|x10^9/L|0.1-1.8||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|GRAN#||2.3|x10^9/L|2.0-7.8||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|RBC||4.28|x10^12/L|3.50-6.00||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|HGB||12.5|g/dL|11.0-17.5||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|HCT||41.3|%|35.0-54.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|VCM||96.7|fL|80.0-100.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|HCM||29.2|Pg|26.0-34.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|CHCM||30.2|g/dL|31.5-36.0|L|||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|RDW_CV||11.4|%|11.0-16.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|RDW_SD||64.3|fL|35.0-56.0|H|||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|PLT||93|x10^9/L|100-350|L|||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|VPM||9.2|fL|6.5-12.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|PDW_SD||13.9|fL|9.0-17.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|PDW_CV||15.4|%|15.0-18.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|PCT||0.08|%|0.10-0.28|L|||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|P_LCR||28.6|%|11.0-45.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|1|NM|P_LCC||26|x10^9/L|11-135||||F|||||administrator|[LINE]");
        tmp.append("OBX|2|NM|WBCHistogram^LeftLine||19||||||F|||||administrator|[LINE]");
        tmp.append("OBX|2|NM|WBCHistogram^RightLine||54||||||F|||||administrator|[LINE]");
        tmp.append("OBX|2|NM|WBCHistogram^MiddleLine||85||||||F|||||administrator|[LINE]");
        tmp.append("OBX|2|ED|WBCHistogram||3^Histogram^32Byte^HEX^00000000000000000000000000000000000001040A1422344A647F9AB3C6D4DCDAD3C6B6A3917F6F62564C453F3B3734302E2B2A2827252525252524242425252525272727272725252424232324242425252727272828282829292A2A2B2C2C2E2F30313234353636363637373736373738393B3C3D3E3F3F4142424243434343424242424241413F3F3E3C39373532312F2E2C2C2B2A29282725242322211F1E1D1C1B1A18161514121211100F0F0E0E0D0D0B0B0A0A09090808070707050504040303020201010101010101010101010101010101010100000000000000000000000000000000000000000000000000000000000000000000000000000000||||||F|||||administrator|[LINE]");
        tmp.append("OBX|2|NM|RBCHistogram^LeftLine||43||||||F|||||administrator|[LINE]");
        tmp.append("OBX|2|NM|RBCHistogram^RightLine||250||||||F|||||administrator|[LINE]");
        tmp.append("OBX|2|ED|RBCHistogram||3^Histogram^32Byte^HEX^000000000000000000000000000000000000000000000000000000000000000000000000000000000000000101010102020202020202030304050607090B0D1013161B20262D353D46505A636C76818B96A2ADB7C0C8CFD4D8DADAD9D7D5D2CECAC5BEB7AFA79F97908A837E77716A645F5A56524F4C4A48464544434241414140404040404040403F3F3F3F3F4040404041403F3E3E3C3B393837353432302E2C2A28252321201F1E1D1C1B1A19171615141311100F0E0D0C0B0B0A0A09090808080706060505050505050505040404040404030303030303030303030303030303020202020202020202020202020202020202020202020201010000000000||||||F|||||administrator|[LINE]");
        tmp.append("OBX|2|NM|PLTHistogram^LeftLine||4||||||F|||||administrator|[LINE]");
        tmp.append("OBX|2|NM|PLTHistogram^RightLine||120||||||F|||||administrator|[LINE]");
        tmp.append("OBX|2|ED|PLTHistogram||3^Histogram^32Byte^HEX^00000000101E2F455968788892A0B0BEC8D0D4D4D1CFCECBC4BBB3A9A099948E87817C736C665E544C433C3837383835302D272422201C18140F0D0D0D0F101212100D0C0C0C0D0F100F0E0D0C0B0B0B0B0B0B0B0B0B0A090706050505050505050505050506070A0C0E0F100F0D0B0907070A0C0F1316181D1F2125282A3036||||||F|||||administrator|[LINE]");
        tmp.append("[EB]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }
}

