/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.urit5160;

import jalis.laboratorio.interfaceamento.util.TestesInterface;
import java.util.HashMap;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.urit5500.InterfaceListener {
    private HashMap<String, String> parametros = new HashMap();
    private final String ALTERNATIVO = "HEMOG";

    public InterfaceListener() {
        this.parametros.put("LEU", "leucocitos");
        this.parametros.put("LIN%", "linfocitos_tipicos_percentual");
        this.parametros.put("MON%", "monocitos_percentual");
        this.parametros.put("NEU%", "neutrofilo_percentual");
        this.parametros.put("EOS%", "eosinofilos_percentual");
        this.parametros.put("BASO%", "basofilos_percentual");
        this.parametros.put("LIN#", "linfocitos_tipicos_contagem");
        this.parametros.put("MON#", "monocitos_contagem");
        this.parametros.put("NEU#", "neutrofilo_contagem");
        this.parametros.put("EOS#", "eosinofilos_contagem");
        this.parametros.put("BASO#", "basofilos_contagem");
        this.parametros.put("HEM", "hemacias");
        this.parametros.put("HGB", "hgb");
        this.parametros.put("HCT", "hct");
        this.parametros.put("MCV", "vcm");
        this.parametros.put("MCH", "hcm");
        this.parametros.put("MCHC", "mchc");
        this.parametros.put("RDW_SD", "rdw_sd");
        this.parametros.put("RDW_CV", "rdw_cv");
        this.parametros.put("PLQ", "plaquetas");
        this.parametros.put("VPM", "vpm");
        this.parametros.put("PDW", "pdw");
        this.parametros.put("PCT", "pct");
        this.parametros.put("P_LCR", "plaquetas_lcr");
        this.parametros.put("P-LCC", "plaquetas_lcc");
        this.parametros.put("*ALY%", "linfocitos_atipicos_percentual");
        this.parametros.put("*ALY#", "linfocitos_atipicos_contagem");
        this.parametros.put("*LIC%", "lic_percentual");
        this.parametros.put("*LIC#", "lic_contagem");
        this.parametros.put("WBCHisto", "urit5160_histograma_wbc");
        this.parametros.put("RBCHisto", "urit5160_histograma_rbc");
        this.parametros.put("PLTHisto", "urit5160_histograma_plt");
        this.parametros.put("S0Histo", "urit5160_histograma_s0");
        this.parametros.put("S0_S10DIFFScattergram", "urit5160_diffscattergram_s0_s10");
        this.parametros.put("S90_S90DDIFFScattergram", "urit5160_diffscattergram_s90_s90");
        this.parametros.put("S0_S90Scattergram", "urit5160_diffscattergram_s0_s90");
    }

    @Override
    public HashMap<String, String> getParametros() {
        return this.parametros;
    }

    @Override
    public void teste() {
        StringBuilder tmp = new StringBuilder();
        String req = "010005406901";
        tmp.append("[SB]MSH|^~\\&|URIT|URIT-5160|LIS|PC|20220615173300||ORU^R01|4|P|2.3.1||||||UNICODE[CR]");
        tmp.append("PV1|0||[LINE]");
        tmp.append("PID|0||3||||0|[LINE]");
        tmp.append("OBR|1||").append(req).append("|URIT^URIT-5160|||20220615173200||||||||1|||||1|[LINE]");
        tmp.append("OBX|1|NM|LEU||15.83|10^9/L|6.00-17.00||||F|||||administrator|[LINE]");
        tmp.append("OBX|2|NM|LIN%||19.13|%|12.00-33.00||||F|||||administrator|[LINE]");
        tmp.append("OBX|3|NM|MON%||7.95|%|2.00-13.00||||F|||||administrator|[LINE]");
        tmp.append("OBX|4|NM|NEU%||70.74|%|52.00-81.00||||F|||||administrator|[LINE]");
        tmp.append("OBX|5|NM|EOS%||2.02|%|0.50-10.00||||F|||||administrator|[LINE]");
        tmp.append("OBX|6|NM|BASO%||0.16|%|0.00-1.30||||F|||||administrator|[LINE]");
        tmp.append("OBX|7|NM|LIN#||3.028|10^9/L|0.830-4.690||||F|||||administrator|[LINE]");
        tmp.append("OBX|8|NM|MON#||1.258|10^9/L|0.140-1.970||||F|||||administrator|[LINE]");
        tmp.append("OBX|9|NM|NEU#||11.200|10^9/L|3.620-11.320||||F|||||administrator|[LINE]");
        tmp.append("OBX|10|NM|EOS#||0.319|10^9/L|0.040-1.560||||F|||||administrator|[LINE]");
        tmp.append("OBX|11|NM|BASO#||0.025|10^9/L|0.000-0.120||||F|||||administrator|[LINE]");
        tmp.append("OBX|12|NM|NRBC%||1.94|%|0.00-99.99|H|||F|||||administrator|[LINE]");
        tmp.append("OBX|13|NM|NRBC#||0.30|10^9/L|0.00-999.99|H|||F|||||administrator|[LINE]");
        tmp.append("OBX|14|NM|HEM||6.65|10^12/L|5.10-8.50||||F|||||administrator|[LINE]");
        tmp.append("OBX|15|NM|HGB||18.2|g/dL|11.0-19.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|16|NM|HCT||45.8|%|36.0-56.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|17|NM|VCM||69.0|fL|62.0-78.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|18|NM|HCM||27.3|pg|21.0-28.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|19|NM|CHCM||39.7|g/dL|30.0-38.0|H|||F|||||administrator|[LINE]");
        tmp.append("OBX|20|NM|RDW_CV||11.5|%|11.0-19.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|21|NM|RDW_SD||25.5|fL|35.2-45.3|L|||F|||||administrator|[LINE]");
        tmp.append("OBX|22|NM|RDW||11.5|%|11.0-19.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|23|NM|PLQ||292|10^9/L|117-460||||F|||||administrator|[LINE]");
        tmp.append("OBX|24|NM|VPM||24.9|fL|5.0-15.0|H|||F|||||administrator|[LINE]");
        tmp.append("OBX|25|NM|PDW||11.2|fL|1.0-30.0||||F|||||administrator|[LINE]");
        tmp.append("OBX|26|NM|PCT||0.72|%|0.09-0.50|H|||F|||||administrator|[LINE]");
        tmp.append("OBX|27|NM|P_LCR||16.84|%|10.00-60.00||||F|||||administrator|[LINE]");
        tmp.append("OBX|28|NM|P_LCC||49|10^9/L|1-350||||F|||||administrator|[LINE]");
        tmp.append("OBX|29|NM|ALY%||0.24|%|0.00-99.99||||F|||||administrator|[LINE]");
        tmp.append("OBX|30|NM|ALY#||0.037|10^9/L|0.000-99.999||||F|||||administrator|[LINE]");
        tmp.append("OBX|31|NM|LIC%||1.06|%|0.00-99.99||||F|||||administrator|[LINE]");
        tmp.append("OBX|32|NM|LIC#||0.167|10^9/L|0.000-99.999||||F|||||administrator|[LINE]");
        tmp.append("OBX|34|ED|RBCHisto||URIT-5160^Image^PNG^Base64^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||||||F||||||[LINE]");
        tmp.append("OBX|35|ED|PLTHisto||URIT-5160^Image^PNG^Base64^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||||||F||||||[LINE]");
        tmp.append("OBX|41|ED|S0_S90Scattergram||URIT-5160^Image^PNG^Base64^iVBORw0KGgoAAAANSUhEUgAAASwAAACHCAYAAACs0WTsAAAACXBIWXMAAA9hAAAPYQGoP6dpAAARoUlEQVR4nO2dW2wV1ffHv1PLtSHciwUFysXkaDC+ECQoEPHFxGLSB1AREzXhBW8Yw4OJYEOMqE8+GBqJ4gMkRBSDChJoAgqE34NSDNJoAXu4Rf5UekPL0QL7/9DOMLPP3jN7Ts+cmen5fprm9OxZs2cPdL5da+2197H+1/x/YsK4ESCEkCRzretfVE4YNwJzZ46NeyyEEOJPtgcVcY+BEEJMoWARQlIDBYsQkhooWISQ1EDBIoSkBgoWISQ1ULAIIakhFsH64YcfcPjw4TguTQhJMbEI1uHDh8tSsCwr7hGoSeq4CJFhSFhk/B5+IUo3jjAkdVyEyFCwigwffkKig4JFCEkNFKxBUsz8D3NJhPhDwRokxQwBGU4S4g8FK8HQ4yLECwUrwdDjIsQLBYsQkhooWAMw/CIk+VCwBihm+EXxIyQaKFgRUKrcE4WRlBsUrBTDpDwpNyhYhJDUUBn2hL6+Puzduxe//fYb/vvvP9xzzz2oq6vD5MmToxhf7FgWPRlCkkIowTpx4gTq6+tx5coVZDIZ9Pb2IpvNoqenB6+//npUY4wVihUhySGUYD3//POoqqrC+fPnMWXKFADAX3/9hfb29kgGFwUmHhO9KkKSiXEO6+bNmzh9+jSeeOIJR6wAYNKkSchkMpEMLgpUQiTPtlGsCEkmxoJVWVmJTCaDL7/8EufPn49yTCVHCP8SAZYPEJIMQs0SNjY2oqurCw888AA2bNiA7u7uqMZVcvy8Kt0xlZBR3AiJjlCCtXjxYpw6dQpPPfUU3n33XcyaNQs7duyIamxGFEMg3H3o+lO1M3QkpLSErsO69957sWPHDpw8eRL3338/nnvuOezcuTOKsRkxGNGwrOAEuy1UJol6JusJiZaCC0fnzZuHpqYmzJs3D++//34xx1QyhPAKjEpwTAVI7osQUnyMBUsIASE9kSNGjMDcuXPR2dlZ9IGVEhMvyrZhjoqQ+DAWrH/++QePPvoodu7ciXPnzuHs2bPYsmULvv32WyxfvjzKMRYdO3xzC1WQENliJosaBYyQ0mFcODp8+HAIIbBq1Srcvn0bADBmzBi89tpr2LRpU2QDjAJbdFRekyxiblu3sOmOE0KiI5RgHTt2DLlcDhcvXsSoUaNQU1ODu+66K8rx5RGFMLj70/WtsqFAEVJaQi9+HjlyJObOnRvFWIwwFQlT70eVv7LtVeeoQkKT5D0hZPAM2e1ldF6TST2VLqflznvZ7+XwUtUfIaQ4DFnBAsKJU1DxqMoT8wslWQVPSPEZkoLlV6YgJ9rlJLpKuIKq3+XzdNem50XI4BiSgiWHdH7hmpznUiXUdUl2d3uY9YaEkMIInXRPLBYARZJdl2dyTgs4rrJVvdoEJd9Nl/oQQvIZMh6WW2vkeik/5FBQVaNlMutnGgJyCQ8JDd10h9AeVi6Xw+7du9Ha2ooZM2ZgxYoVqKqqimJsofCb2RPwChpwp00+R5eodwuYKkSURS1saQNLIYgW/mI4hPKwuru78fDDD+ONN95Ac3Mz3nzzTcyfP7/0awkt5CvQgDAJuLwYO2RDfk4q6G+WqhTC7leVsPcLDU0o5HeSf3hJuRFKsN5++21cvXoVp06dwp49e/DTTz/hwoUL2Lx5c1TjU2MrkyW1uZss6ZA75DN40E1n/VQiVaqF0vzDS8oNY8G6desWtm/fjjVr1jgf6VVbW4v6+nrs2rUrsgHqyJsFlBcy216U5dUnS3pvutOoe8G0UNioQktVqYTffZhCz4qUK8aCdebMGXR2dmLhwoWe9vnz56OtrQ3Xr18v+uAcVOGfcP0MhbMlteuecd3Dr0vcu8NJlRipyiN0lfYmS4Z0YyOkHDEWrEuXLgEApk2b5mmvqakBgGg+6st+aA0eUEec5FBOYef+WX7vXFoWRYNwz6/ANKhSXsZkh1NCyg3jWcIbN24A6N+0z83w4cMB9H8idNGxVUilOqrZPANzT3go2eW9t1ztBgl13UxlFB4RvSxSjhh7WKNGjQJwR7hsent7AfTvjRUJA2rj5KkCPAvT51goXsNogGoTQJ2dSXtQrmsw0BsjQwVjwZo+fToA5H0mYTabxejRo53QMBLsPJCBoui8JlmgbE/M7XmZPtdyOYNnqD5Lf4LsAr2mApWH3hgZKhgL1pw5c1BdXY2DBw962puamrBs2TJYxf4z7tedzmtRtMnPqlvATEfsiJ1mmU3eOEK2G0PlIWWOsWBVVFRg7dq12Lp1K/bt24dcLofGxkYcOnQI69evL/7ICng2VU6Y24NyH1dVvutwzwrqdoDQzRj6eWOEkHCEWprz1ltvIZvNoq6uDrdv38bYsWPx6aef4pFHHolqfP3I8ZvGBFALj1+i3T5H17UnkS+VOshFo6qShaAF16r3pMzgL4AxoQSrsrISn332GT788EO0t7ejtrY2b9aw6KjESqEwnpIE13vdr4FbiEyiT3umUFXeoFuuo9rixiTvVXT4QCQb/t8YU9D2MhMnTsTEiROLPZZ8dIpiMFOYV0gqtcldm+a03IWhqpqsvCJTzSxiSTWEDwQZIiR7e5kwmfEB5Nk+XWEoELrr/j6k5Tbyzg1yLivsflieELLQLD3rGMgQJdmCBQQm33U5KbdX5f7WdRe2pAFQ56H8vC/TfbWccwaMQ+sPPSoyREmeYKlK0oX07XOqbhZQ7t7uthDkPJbKu5JFyxGrAPXJEzXL0p9HT4qUGckTLNX6GtlNkszlU+USBkjvg0RNOSyDEE63yNnjdbnULWgZj8fedEtT+eLlSLnf/xAmEYJl6VTInRF3P8gB/eny9CrnzQTdjJ99TPfqW3slRJ4npbpuHiabbRU7JEybADAkHrLELlgWLAhFcGaLmDXw5UZ2vtyvbptQHpSpnTYJpvCYBtqUz7tirY6JLljw8biiggJAEkLsgmWLVZ6XBcASFoQlICzhqI/bzv2zLFB+haQqfGuxNLVV9jE7dMvzxCAgYKmjOoUI+HpUss1gvZ5SbYtKSBGJXbBsVF6WsAQsYcESVn+VubAkgROK/dktpXCprxk0JqlnTSmDfNyjAbbnNNCoW8aTR1D9QxivRxfPhu2HkJhJ9OcSWsLrTYkBCXEEw20LAMICLPMH0NLYO7VW8OaZTJbU6HPjYmDGz9uB5xruDospJKpdAylUJIUkxsOysf0j37yWy1txH7XFx/hZtITSVuWQyOKk2jYmaH2hSt2CwkT1uBnGkfIkUYKlTLTnZdO9XooTObk8Fd3zHCRO2nH5zBAqa6Rc7+3joSrYg47TOyJlSuyCZbm+xMCXB+2snHA+g9C2c1ebe7oIEDLZThU1+UZSrsb+nJrek5JrsbQDCetF+eWpCBkixC5YskCpZgs99pboF7eBJLxleQtCLam4VPfsy2IkV6arFi7LyXJdAl2rN5Zl7hyF9aJU6moKBY6khNgFC4Das9Ib5yfKnSS57eEMNPt4XTK6dX6ycOXlqWzxNJl8KzQmjRpWzJOUELtgBXlUSnvHs7LLGu54Lp6fLeT97KcZso1b8GRb53iIFYnK599ESeMSjjhzZRRLoiD2sga/wlGdvS1adjBo9+GUD9i2PsIl29gE1VrZbUH9KMcu2xR0UplQrvdNfIndwwqLOzl/p8xBstHkoGQb+1V2YvIq1l028qxgXt92yYWJALPanJBQJEKwdOsJVSgr4qVJN78lNG7Pyf0t96WaabwzI+m9oKrWSjiJNYMq8zR6ExRZEgOxhoRhhEp1jnyuLuxzH8vrL2AFjO6YcI1Ee67pINLIULoXkhpi9bDcwlNQ8h3BJQuBYxD5Hpqu36CZwEE7HfRaCPEl9pBQtX2MyTneRHsB19UInTt0VOW21G+0TfqLqaDX4g8FveyJXbAKwZlZtLzJbZMVL85aRY02yGUNRdEQ01L7tFHq+6Gglz2xClZYz0o+VwhvHksXonkLPc02ysu/YIHr/7QuWgwUW2Divh9SdsReh2VKXoJ9QHhMkuVyIWhogi7kvohpexwkaSyEFEBqQkL3ImkHoVefoB0bAtcKu0sWonjQh1p4SEgJSI1gAflrDv1KIoI8r6DCUqeeqlhaZbTYUGNLooX/3qkhNYJlUq8VJicmV8MXivE1w9ZakNLBf+/UkIg6rFLbAcUrMg9b+EoIKZzEzxKGXRxdyDXKFoZCJGXEHhLKOSntspsAT0abZKcHpIehEEkZiQgJ3ULlt1bQt69i57DpfRCSOGL3sGwaGhoADM4j0q0vLMiRMDkp7aKW9vEPhnK+9xSTGMHauHHjoPsY7PrC8BdMeUiV9vEPhnK+9xSTGMFS0dDQ4Hhe7raygxv9EQIg4YK1ceNGj+fV0NDgvPcTriH3XKd5oz9Cikji1hK6hUgXJrqFS4XfZn2hnvnQJxBCosRqbesSc2eOLelFGxoaIITAO++8E2gXlNsysSGEpJ8z2Z7kh4TFsCGEDA0SLViEEOKGgkUISQ0ULEJIaqBgEUJSAwWLEJIaKFiEkNRAwSKEpAYKFiEkNVCwCCGpgYJFCEkNFCxCSGqgYBFCUgMFixCSGmLbD+v8+fPluXsoISSPpUuXYsmSJYF2sQjW0qVL0dzcjHXr1nF7GEIIhOFGmbFs4EcIIWFJ/AZ+hBDihoJFCEkNFCxCSGqgYBFCUgMFixCSGihYhJDUkLgPUiWE6Ono6MB3332HbDaLYcOG4b777sOTTz6JESNGAAD6+vqwe/dutLS04O6778bKlSsxYcIETx+5XA67d+9Ga2srZsyYgRUrVqCqqiqO2wkN67AISQmff/45Xn31VVRWVmL27Nm4evUqLl68iBMnTuChhx5CR0cHHnvsMVy8eBELFizAyZMnAQBHjhzB7NmzAQDd3d1YsmQJrly5ggULFuDo0aOYMmUKjh07hvHjx8d5e4GcyfYArW1dghCSbC5fviyGDRsmnn32WZHL5Zz2lpYW0d7eLoQQ4qWXXhLV1dXi8uXLQgghOjs7RSaTEXV1dY79K6+8ImpqasTVq1eFEEL88ccfoqqqSqxfv76Ed1MYrW3dgjksQlJAS0sL+vr68MwzzzjhHwBkMhlMmjQJALBnzx6sXr0aU6dOBQCMGzcO69atw/fff4/r16/j1q1b2L59O9asWYPJkycDAGpra1FfX49du3aV/qYKgIJFSArIZDKorKzEli1b0Nvbq7S5ceMGRo8e7WmbMWMGbt68id9//x1nzpxBZ2cnFi5c6LGZP38+2tracP369cjGXywoWISkgGnTpuGDDz7A/v37kclksG3bNty6dctjM2/ePOzduxe3b9922g4cOAAA6OrqwqVLl5y+3NTU1AAA2tvbo7yFokDBIiQlrFu3DkePHsXUqVPx4osv4sEHH8TPP//sHN+0aRNOnjyJxYsXY/PmzVi1ahW+/vprAMDIkSNx48YNAPCElAAwfPhwAP0zjEmHgkVIili4cCGOHz+Ob775Bj09PVi6dCnOnj0LAHj88cfx448/YurUqdizZw8mTZqE9957D0C/FzVq1CgAcITLxg4xx4wZU8I7KQwKFiEppK6uDkeOHEFfXx8+/vhjp33RokX44osvcPz4cXz00Ue4cOECxo8fj1mzZmH69OkA+jfPdJPNZjF69GgnNEwyFCxCUoA7L2Uzc+ZMVFVVobOzU3nOzZs30djYiKeffhqWZWHOnDmorq7GwYMHPXZNTU1YtmwZLMuKZOzFhIJFSArYv38/Vq9ejQMHDuDChQv49ddf8fLLL6OjowPLly8HAJw+fRrNzc3I5XI4d+4cVq5cib///hsbNmwAAFRUVGDt2rXYunUr9u3bh1wuh8bGRhw6dAjr16+P8/bMYeEoIcnnl19+EXPmzBEAnO/p06eLTz75xLH56quvREVFhXN80aJFoqWlxdNPX1+feOGFFxy7sWPHim3btpX4bgqjta1bcGkOISmiu7sbf/75JyZOnOgUf7rp6upyjldXV2v7uXbtGtrb21FbW5s3a5hUzmR7uJaQEJIOuKc7ISRVULAIIamhsqPr3/5tGwghJMFc6/oX/w/F+vk1vpiBsgAAAABJRU5ErkJggk==||||||F||||||[LINE]");
        tmp.append("[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }
}

