/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.urit3000vetplussocket;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.logger.ErrorLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class InterfaceListener
extends InterfaceHl7Listener {
    private static final String IMAGE_BASE64 = "^Base64^";
    private HashMap<String, String> parametros = new HashMap();
    private static final String ALTERNATIVO = "HEMOG";

    public InterfaceListener() {
        super("");
        this.parametros.put("WBC", "leucocitos");
        this.parametros.put("LYM%", "linfocitos_tipicos_percentual");
        this.parametros.put("MID%", "monocitos_percentual");
        this.parametros.put("GRAN%", "segmentados_percentual");
        this.parametros.put("NEU%", "neutrofilo_percentual");
        this.parametros.put("EOS%", "eosinofilos_percentual");
        this.parametros.put("BASO%", "basofilos_percentual");
        this.parametros.put("LYM#", "linfocitos_tipicos_contagem");
        this.parametros.put("MID#", "monocitos_contagem");
        this.parametros.put("GRAN#", "segmentados_contagem");
        this.parametros.put("NEU#", "neutrofilo_contagem");
        this.parametros.put("EOS#", "eosinofilos_contagem");
        this.parametros.put("BASO#", "basofilos_contagem");
        this.parametros.put("RBC", "hemacias");
        this.parametros.put("HGB", "hgb");
        this.parametros.put("HCT", "hct");
        this.parametros.put("VCM", "vcm");
        this.parametros.put("HCM", "hcm");
        this.parametros.put("CHCM", "mchc");
        this.parametros.put("RDW_SD", "rdw_sd");
        this.parametros.put("RDW_CV", "rdw_cv");
        this.parametros.put("PLT", "plaquetas");
        this.parametros.put("VPM", "vpm");
        this.parametros.put("PDW", "pdw");
        this.parametros.put("PCT", "pct");
        this.parametros.put("P_LCR", "plaquetas_lcr");
        this.parametros.put("P-LCC", "plaquetas_lcc");
        this.parametros.put("*ALY%", "linfocitos_atipicos_percentual");
        this.parametros.put("*ALY#", "linfocitos_atipicos_contagem");
        this.parametros.put("*LIC%", "lic_percentual");
        this.parametros.put("*LIC#", "lic_contagem");
        this.parametros.put("RBCHistogram", "celldyn_histograma_rbc");
        this.parametros.put("PLTHistogram", "celldyn_histograma_plt");
    }

    public HashMap<String, String> getParametros() {
        return this.parametros;
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01;
        block14: {
            ackR01 = new MessageAckR01();
            ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
            ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
            ackR01.getMsa().setTextMessage("Mensagem aceita");
            ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
            try {
                String intCodigo;
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                String tuboId = oruR01.getObr().getFilterOrderNumber();
                if (Funcoes.objectIsNull(tuboId) || tuboId.length() != digitosCodigoTubo || !Funcoes.isNumeric(tuboId)) break block14;
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                if (!Funcoes.objectIsNull(etiqueta)) {
                    filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                    reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                    recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                }
                if (Funcoes.textoVazio(intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, ALTERNATIVO)) || intCodigo == null) {
                    this.fireExcecaoEncontrada("Alternativo n\u00e3o encontrado HEMOG");
                    return;
                }
                ExameMaterial exame = null;
                if (Funcoes.objectIsNull(intCodigo)) break block14;
                HashMap<String, Object> dados = new HashMap<String, Object>();
                ArrayList<String> flags = new ArrayList<String>();
                exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, ALTERNATIVO);
                if (exame == null) {
                    this.fireExcecaoEncontrada("Nenhum exame encontrado com o alternativo HEMOG");
                    return;
                }
                if (Funcoes.objectIsNull(exame)) break block14;
                for (int i = 0; i < oruR01.getObxList().size(); ++i) {
                    if (!Funcoes.objectIsNull((Object)oruR01.getObxList().get(i).getAbnormalFlag())) {
                        flags.add(oruR01.getObxList().get(i).getAbnormalFlag().toString());
                    }
                    String campo = this.getParametros().get(oruR01.getObxList().get(i).getObservationId());
                    if (i != oruR01.getObxList().size() - 1) {
                        String campoProximo = this.getParametros().get(oruR01.getObxList().get(i + 1).getObservationId());
                        campo = this.getCampoValido(campo, campoProximo);
                        System.out.println("Campo: " + campo);
                    }
                    if (Funcoes.objectIsNull(campo)) continue;
                    String resultado = oruR01.getObxList().get(i).getObservationValue().replace('.', ',');
                    if (campo.contains("celldyn_histograma_rbc") || campo.contains("celldyn_histograma_plt") || campo.contains("urit5160_histograma_rbc") || campo.contains("urit5160_histograma_plt") || campo.contains("urit5160_histograma_wbc") || campo.contains("urit5160_histograma_s0") || campo.contains("urit5160_diffscattergram_s0_s10") || campo.contains("urit5160_diffscattergram_s90_s90") || campo.contains("urit5160_diffscattergram_s0_s90")) {
                        try {
                            resultado = this.convertImg(reqCodigo, oruR01.getObxList().get(i).getObservationValue());
                        }
                        catch (Exception e) {
                            this.fireExcecaoEncontrada(String.format("Imagem corrompida para a requisi\u00e7\u00e3o %s %s %s Campo %s ", filCodigo, reqCodigo, recCodigo, campo));
                            resultado = null;
                        }
                    }
                    dados.put(campo, resultado);
                }
                if (!dados.isEmpty()) {
                    this.atualizarDadosExame(Conexao.getStatement(), filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados, flags);
                    Conexao.arquivaSQL();
                    this.fireAtualizarTabela();
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                ackR01.getMsa().setTextMessage("Erro ao receber a mensagem");
                ackR01.getMsa().setErrorCondition(ErrorCondition.APPLICATION_INTERNAL_ERROR);
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    private String getCampoValido(String campo, String campoProximo) {
        System.out.println(campo);
        if (Funcoes.textoVazio(campo) && !Funcoes.textoVazio(campoProximo) && (campoProximo.equals("linfocitos_tipicos_percentual") || campoProximo.equals("hgb") || campoProximo.equals("vpm"))) {
            switch (campoProximo) {
                case "linfocitos_tipicos_percentual": {
                    return "leucocitos";
                }
                case "hgb": {
                    return "hemacias";
                }
                case "vpm": {
                    return "plaquetas";
                }
            }
            return campo;
        }
        return campo;
    }

    protected String convertImg(String reqCodigo, String resultado) throws IOException {
        int index = resultado.indexOf("^");
        String nomeEquip = resultado.substring(0, index);
        Base64 b64 = new Base64();
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(b64.decode(resultado = this.convertResultado(resultado))));
        if (!Funcoes.objectIsNull(image)) {
            ImageIO.getCacheDirectory();
            File img = File.createTempFile(nomeEquip.toLowerCase() + "_" + reqCodigo, ".jpg");
            ImageIO.write((RenderedImage)image, "jpg", img);
            BufferedImage imgNew = ImageIO.read(img);
            resultado = b64.encodeAsString(ImagemUtils.imageToByte(imgNew));
            img.delete();
            return resultado;
        }
        return "";
    }

    protected String convertResultado(String resultado) {
        String conversao = "";
        int res = resultado.lastIndexOf(IMAGE_BASE64) + IMAGE_BASE64.length();
        conversao = resultado.substring(res);
        return conversao;
    }

    @Override
    public void teste() {
        StringBuilder tmp = new StringBuilder();
        String req = "010007099001";
        tmp.append("[SB]MSH|^~\\&|2|3|LIS|PC|20231207141600||ORU^R01|4|P|2.3.1||||||UNICODE[CR]");
        tmp.append("PID|7|180024585|10||||1|[CR]");
        tmp.append("OBR|5||").append(req).append("|2^3|||20231207140800||||||||0|||[CR]");
        tmp.append("OBX|1|NM|WBC||8.05|10^9/L|4.00[SP]~[SP]10.00||||F|||||||[CR]");
        tmp.append("OBX|1|NM|LYM%||31.25|%|20.00[SP]~[SP]40.00||||F|||||||[CR]");
        tmp.append("OBX|1|NM|MID%||4.41|%|3.00[SP]~[SP]10.00||||F|||||||[CR]");
        tmp.append("OBX|1|NM|NEU%||59.17|%|50.00[SP]~[SP]70.00||||F|||||||[CR]");
        tmp.append("OBX|1|NM|EOS%||5.15|%|0.50[SP]~[SP]5.00|H|||F|||||||[CR]");
        tmp.append("OBX|1|NM|BASO%||0.02|%|0.00[SP]~[SP]1.00||||F|||||||[CR]");
        tmp.append("OBX|1|NM|LYM#||2.516|10^9/L|0.800[SP]~[SP]4.000||||F|||||||[CR]");
        tmp.append("OBX|1|NM|MID#||0.355|10^9/L|0.120[SP]~[SP]1.200||||F|||||||[CR]");
        tmp.append("OBX|1|NM|NEU#||4.763|10^9/L|2.000[SP]~[SP]7.000||||F|||||||[CR]");
        tmp.append("OBX|1|NM|EOS#||0.415|10^9/L|0.020[SP]~[SP]0.500||||F|||||||[CR]");
        tmp.append("OBX|1|NM|BASO#||0.002|10^9/L|0.000[SP]~[SP]0.100||||F|||||||[CR]");
        tmp.append("OBX|1|NM|RBC||3.42|10^12/L|3.50[SP]~[SP]5.50|L|||F|||||||[CR]");
        tmp.append("OBX|1|NM|HGB||11.50|g/dL|11.00[SP]~[SP]16.00||||F|||||||[CR]");
        tmp.append("OBX|1|NM|HCT||29.7|%|37.0[SP]~[SP]54.0|L|||F|||||||[CR]");
        tmp.append("OBX|1|NM|MCV||87.1|fL|80.0[SP]~[SP]100.0||||F|||||||[CR]");
        tmp.append("OBX|1|NM|HCM||33.6|pg|27.0[SP]~[SP]34.0||||F|||||||[CR]");
        tmp.append("OBX|1|NM|MCHC||39|g/dL|32[SP]~[SP]36|H|||F|||||||[CR]");
        tmp.append("OBX|1|NM|RDW_SD||53.8|fL|35.0[SP]~[SP]56.0||||F|||||||[CR]");
        tmp.append("OBX|1|NM|RDW_CV||10.7|%|11.0[SP]~[SP]16.0|L|||F|||||||[CR]");
        tmp.append("OBX|1|NM|PLT||128|10^9/L|100[SP]~[SP]300||||F|||||||[CR]");
        tmp.append("OBX|1|NM|VPM||9.6|fL|6.5[SP]~[SP]12.0||||F|||||||[CR]");
        tmp.append("OBX|1|NM|PDW||15.6|fL|9.0[SP]~[SP]17.0||||F|||||||[CR]");
        tmp.append("OBX|1|NM|PCT||0.12|%|0.11[SP]~[SP]0.28||||F|||||||[CR]");
        tmp.append("OBX|1|NM|P_LCR||31.10|%|9.00[SP]~[SP]45.00||||F|||||||[CR]");
        tmp.append("OBX|1|NM|P_LCC||40|10^9/L|13[SP]~[SP]129||||F|||||||[CR]");
        tmp.append("OBX|1|NM|*ALY%||0.4|%|0.0~2.0||||F|||||||[CR]");
        tmp.append("OBX|1|NM|*ALY#||0.03|10^9/L|0.00~0.20||||F|||||||[CR]");
        tmp.append("OBX|1|NM|*LIC%||1.3|%|0.00~2.5||||F|||||||[CR]");
        tmp.append("OBX|1|NM|*LIC#||0.11|10^9/L|0.00~0.20||||F|||||||[CR]");
        tmp.append("OBX|1|NM|*NRBC%||0.24|%|0.00~9999.99||||F|||||||[CR]");
        tmp.append("OBX|1|NM|*NRBC#||0.019|10^9/L|0.000~9999.999||||F|||||||[CR]");
        tmp.append("OBX|1|ED|RBCHistogram||UT-5380^Image^JPG^Base64^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[CR]");
        tmp.append("OBX|1|ED|PLTHistogram||UT-5380^Image^JPG^Base64^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[CR]");
        tmp.append("OBX|1|ED|S0_S10DIFFScattergram||UT-5380^Image^JPG^Base64^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[CR]");
        tmp.append("OBX|1|ED|S90_S90DDIFFScattergram||UT-5380^Image^JPG^Base64^/9j/4AAQSkZJRgABAQEAYABgAAD/2wBDAAMCAgMCAgMDAwMEAwMEBQgFBQQEBQoHBwYIDAoMDAsKCwsNDhIQDQ4RDgsLEBYQERMUFRUVDA8XGBYUGBIUFRT/2wBDAQMEBAUEBQkFBQkUDQsNFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBT/wAARCAEsASwDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwD9LfH/AI+sfhvoser6pZ6ncaYJhHc3Gm2Ul39jj2MxnlSMFxENuGZVbbuBIChmGj4X8WaL420O21nw9q1lrek3I3Q32nzrNDIO+GUkHmuN+NWtazZ2vhXRNC8RR+FdQ8SayNLGqNYLeSRILS5uW8tXYIrkWxAdw6jJ+QkiuT8I/se/CPwvq1rrLaEuueKI71dRfX9VumlvZ7sOHEzkELu3AYCqFGAAAKANP4P/APJZvjx/2MGnf+mWxr2CvH/g/wD8lm+PH/Ywad/6ZbGvYKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigArj/ABb8HvAvj7U01HxJ4Q0TXr9IhAt1qNhFPIIwSQoZlJwCzHHua7CiplGMlaSubUa1XDy56MnF907P8DxP9qjwnoPijw54Pl8T+GtU8YaFpfiFb650PSdGfVHux9iu4VDRIcqitMr7zkAoox82R5b4N8P/AANh8YaG+l/s3+KNG1Nb+BrXUp/A00EdpKJF2TNIRhAjYYsegGe1eqftUaxqGl+FfC0MGoeKdJ0S+1+O21y+8G2c1xqUVkLW5kHl+TFJIgaeO3RnRchXIyM5rxD4f+LLLxd8QrbQ/FOv/FPVfCOjaxar4YsNS8LarD/aEh8qZLnUbv7OrSCG4do1WUogW2WSTeTuqjE95+D/APyWb48f9jBp3/plsa9grx/4P/8AJZvjx/2MGnf+mWxr2CgAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKACiiigAooooAKKKKAPP/jh4q8beDfA76h4B8Kx+Ltc89I3tZJwnkQkNunCZUzFSF/dKyltxweK+bfhb4uj+KX7QF1ovxE+Kep3t1pdhpmp6f4We2n8KRDUDc3LSRGzZhNdCMQ2rDe8ineM5BAr6s+IHxC0v4aaJHqurwarcWsk624XR9JudRm3FWYExW8buFwp+YjAOBnJFeEfFL45eF/iZp/h/S9D8MeJtQ8QL4j0WSzk1bwFqKx2yjUrYzyiW4tRHERAJTvJBGMgggUAd78H/APks3x4/7GDTv/TLY17BXj/wf/5LN8eP+xg07/0y2NewUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQBxnxV8N2/ijw3DaXXjLVvA0a3KyDUtFvorSZyFYeUXkR1KnOcYzlRzxXiOv7/g1deGtS0H42a54vv73XbDTD4b8Q6hZX6ajDcXMcM/lrHEkqvFG7zhkbAELblKlq9b+OvgPUPiH4Ot9M03w94L8S3Ed6k5s/HVi13YqoRwXVFUkSgsADjoz+tfLnwmuvE1n8Z9M074e/DH4L38FpdCHX/FPgzRZbWDTIA2Jo1vNqrJcbdwEUe/B+/tFAH0T8H/8Aks3x4/7GDTv/AEy2NewV4/8AB/8A5LN8eP8AsYNO/wDTLY17BQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAHmH7RXwsg+L3w1uNDvfGmqeBdLSUXV9qOl3CQebbqjh4ZmcbTCQ2WB4OwA8ZFfPHw48XxWvjHQfB/w1+L3iz4i2Ol3NoLvTfC3hvR49HsrMzbT51yttHGsRWOUYhcudjBRmvoP9pLwj8OPF3w0kT4o6hbaT4asbuK9TULq8FsttcrlYnDMdrN85AVgwJP3TxXiOj+IL34Y+PPDPjLQfif4d+J/hzxsNM8M2FneQpDqTWsN1N89s9jH5cxh+1zNJuhjCrGAzJgkgHsPwf/5LN8eP+xg07/0y2NewV4/8H/8Aks3x4/7GDTv/AEy2NewUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQB45+0rod9qlj4BvtK1bwrper6T4pgvLKPxhKyWd5O1rdW8cK7fmaUtcB0C85jyOleI+A5PEHw7/aQ1xdV8UfA628a+JNRtft+mQ3VxHq8NuYoS1vbIxDDzNr3AUjDSTMxzmvoX45aHrd1Z+EfEXh/TG16/wDCeuprLaPFIkct9CbW5tJUidyFEipdtIoYgMYgmV3bh5Lql3F8XtZk0zwj8OPFmkX2t+JdJ1/X9d8V6TNptvZpYyWj/uzMMyyOljDEEiBXLs5YAHIB6N8H/wDks3x4/wCxg07/ANMtjXsFeP8Awf8A+SzfHj/sYNO/9MtjXsFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAHj/wf/5LN8eP+xg07/0y2NewV4/8H/8Aks3x4/7GDTv/AEy2NewUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAeP/AAf/AOSzfHj/ALGDTv8A0y2NewV4/wDB/wD5LN8eP+xg07/0y2NewUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAeP/B//ks3x4/7GDTv/TLY17BXj/wf/wCSzfHj/sYNO/8ATLY17BQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQB4/8AB/8A5LN8eP8AsYNO/wDTLY17BXj/AMH/APks3x4/7GDTv/TLY17BQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQB4/8H/+SzfHj/sYNO/9MtjXsFeP/B//AJLN8eP+xg07/wBMtjXsFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABVe11C1v2uFtrmG4a2lME6xSBjFIACUbB+VsMpwecEetWKasax7iqhSxycDGT6mgelncdRRRQIKKKKACiiigAooooAKKKKACiiigAooooAKKKKAPH/AIP/APJZvjx/2MGnf+mWxr2CvH/g/wD8lm+PH/Ywad/6ZbGvYKACiiigAooooAKKKKACiiigAooooAKKKKACiqtjeSXjXQezntBDMYlafZiYAA+Ym1j8pzjnByDx0zaoG04uzCiqupxXk9jKlhcRWl2QPLmmhMqLyM5QMueM9xVqgLaXuFVb9b1lg+xSQRsJkMv2hGYGLPzhcEYbHQnIHoatUUAnZ3CiiigQUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFAHj/wAH/wDks3x4/wCxg07/ANMtjXsFeP8Awf8A+SzfHj/sYNO/9MtjXsFABRRRQAUUUUAFFFFABRRRQAUUUUAFZeg3E98t7dSTTPbyXLrbw3Fo1u8CpiNlIblgXR3DkDKuMZGCdSquqalDo+l3l/cbjBawvPJ5a7m2qpY4Hc4HSk+5pHX3UtX/AF/X/BLVFZPhfxTpnjHRLPVtJuVubO6hWaNujbWzjKnkHII59DVm6jl1C3gayvjbKJY5DJEqyCRAwLJyCMMMjI5GeKOZNXQSpyhNwmrNaO/QfqWoJpVjLdSxTzJGASltC80hyQOEQFj17CrVFVdS1O10e0a6vJ1t7dWRDI/TczBVH4swH40basSXNaMVqWqKKKZAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQB4/8AB/8A5LN8eP8AsYNO/wDTLY17BXj/AMH/APks3x4/7GDTv/TLY17BQAUUUUAFFFFABRRRQAVVXUrdtTk08O32uOFZ2TY2NjMyg7sY6qeM549xVqqt816ptvscUEoMyifz5GTbFg5K4U7mzjAOB15FJlxSejLVRfaoRdC2M0YuShkEO4byoIBbHXGSBn3rPsZotJuLXSJLm9vLqZJrhJriJnBUOuQ0iqEUjzFCqSCQDjO1iMrxPfXuh6FquvTxWNtPpu+dZI2Rmms0IkeMvM0SRM6qRln2IcMSQKlysrm0KLnNR77eetvuG3GstqWpLp97pF48treo4k0273RxjzCImlIZGGU2u0ZBGGH3q6K+S9Z7X7HLBEqzA3AmiZy8WDlUww2tnb8xyMA8c5GPfeJPD9j4ebXf7W0uxstQRDHqcl1FFDOzriI+dna2eACM9sZrP029l3aZYahrdnFJYfZraZrfUlknnv8AyWaS3lBjXIKGOQY2u2c7VAGYuk7NnS6cpx5oxsl6v10fn+aNmXTdJ8PX2s+JGh8i5ntoxfXK73LRQCRkGwZ+6Hk+6MnPfir+mWtpY6fbwWFvFa2aIBFDDGI0ReoAUAYHtiuT0bx/bf2jBYX2qWgIt2llnvoJdPldmuFihEcUq4ZctsJD5DNFx+9Wtuxje+06O50jXFvLe4uhdC6k23KNCXBaKMqVAXGVVsnHXmnGUX8JFWlVirVW1tq72stF0votvLobdFVZ4bt761kiuUjtEDieBotzSkgbSGyNuOexzntiorrWIImvoLcrfaja24uG0+CVPPKtu2cMwC7yjBSxAJU88HGlzjUW9v8AhvUv1V0vUrfWNPt760dpLa4QSRsyMhKnkHawBH0IqNlvbptOnjkFlEDvurWaIO7qUICBg2FIYqSRuB2kd8iTVIbu40+eOxuY7O8ZcRXEkXmqjepTcN30yKNR8sdE3r+Xrp89P+GtVU0uzl0+ySCa9n1CRSxNxcBA7ZYkA7FVeAQBx0Azk5NW6q6lYtqFr5K3U9mfMjfzbZgr/K4bbkg8NjaeOhPTrR5ii/svZlqisrT/ABPpmqa7q2jWtz5upaUITeQ7GHleapaPkjByATwTjvWrVyjKDtJW/wCDqvvWpAVQ19Q2hairak+jKbaQHUozGGtPlP74GRWQFPvfOCvHII4qDRfEEWt3mtW0cRjbS7z7FIxmik3t5MUucI7FOJQNsgVuM7dpVmg1jWoI9asNCvNJurq01aKaP7ULcTWoZVyYZcZK7kDkMy7Dt2ltzKrbRpzVRK22vTa1/TYV9Dah/wBTH+8Mvyj94cfNx14459qfSKoRQqgKoGAB0FLWAworKs7z7Hq01hfataT3l20l1Y2aqIpltkEav8u4mQK7jLgADzUBA4JqeKfFUej6D4huNPktr7VNJs2uWsd0kjK2xmjDpCkkoDbTjbGzHB2qx4rWNGcpKMVe/wCun56eornQUU2Ni0ak8EjNOrEYUUUUAFFU9W1WDRNPmvbkTGCEAsLeCSd+SBwiKWPJ7A1cp8rtzW0AKKKKQHj/AMH/APks3x4/7GDTv/TLY17BXj/wf/5LN8eP+xg07/0y2NewUAFFFFABVW++2/6P9iEB/fL53nlh+6/i24/i9M8VaooGnZ3Cqmn3c9xYxzXlqdPmYkNBJIrlfmIHzKcHPB/GrdZcg0rxTDPbTRQajDaXaCSKeLcqTxMsiHDD7ysEYEdCARyKTLik1qtO/b9CnaX1hJ4imN1bRWmvJDIkcRlV55bRZOJAFP3WbnHUHg1pQan9q0WPUIbeZfNgE6W9whhl5XIRlfGxucENjB61zPji2fQoZ/EGl6cmt6/C3n21jcyNI7hU2yR2oLYidkyMqMEnLA1a8U6Q11rFi8lta6jpl7tsr6y1CdvL2hi8bxxsTGXDZz8u5ht5G2srtXR3ezhU5JX0f6bq19tdHfV6enN6lDpGvWtq3ittSVvFF2dOsNNuo2iawlFrchlQL91iguT5v8QKY421ajibwTobeGpZLDRNKnddK0Oe1he4EG9Ssf2gONm5nwFBOGZgvU1zGh6hol54sGo6XHfa5o2hX15FdS6nfXFxPb6jM9rHG9vHNIV8vY9wocAbAJFTAdw3b6w+nWbaxr+oqug6PYr9o1G+ZXtriU2rCRJGlRhvgChwVYHcCQeCQcI6pv8AH/g+p6tZODjTalZ/ZdtHfRKOtny23Tbv53ItBhbxdb+JvDnibQHbT7O9aCH7bDF5F3bth4zGEyNqgheecjnms/xRrkFp8RJdK1HxLo+maRNpkN59iE3kakk63BTz1YdY2Bjj57qR3rX+GNvFYeHooryG1g8RxW1sNZaGR5iZhCuN08hLy4TADMzHAGTWvoFjeWPh140u4bq6ke4nguGklmjIkld48l3ZioDKMBsYGF2rgDRRcor+vl0OOdWNKrPTTZLZXaV5L4rbJ6bproLFHcR6xLFeRrf2riSdbt1jUWoBj2Q4zubJDPu/2Oe1Pj0d9P8ADg0rTtQltp1hMVveT4nkVscOQ3DkdeaoWH/CPa7pt3dXCaXePqNvHaalJ5SqtyuXjEbh+ShZpFVWz94gZyaqfEfxJoPw+0G117VtMlu0sZ47a0+w2wlnheYiIeXyNgIbBORgZzxXRTpyqyUYK7e3zOKT5WovS3lpdLs9N9PTW1zS8N6XqdvNd3mr6kL26kmnjijtyVgS38+RoRs6eYsbIjN3K1pX63H2d5dNW1a9You+4yFKB/mBK85Cl8e/41y2tae/w78EwW3hefS9LEEwZn1gSTefuYtKS3mK0k8jEnezEszEtkk1414s+Mni3wd4g8O6T4U8P6fpV7rP2pB4V19VtYImUGVbmO5iA2tK9wm5JAQxilCEMrM/qYHK6+OSVJrru+yu9/K+uy62ujnrV4e0lPfXTSyt6J6dND3PSdYtodavrHTtDvbZPtzfbru4ga3iLtGT5qM+POBZVTKZwWFU/iJoOlwwf8JZI1np+saPEXt9UvJ2hiiQHJSV158s/wAQ714HbftUafDH4nk+I9lYXOk+F5VfV7iNo3s7a5tmRopLKMqzys9w8KjfJlHVCvfG7D+0xd6bfahpU7/2vdR+Iry1a6tLcSeRaeawtoI1XaGnPEQ3dHB3bhzXqf6uY2m1zw5knfya0ej7q6unrqmk7ozeMXNzU24u1t9ezv6/dbQ9l8RePY9G1LTbQRyW7XGtQ6Qz3ltKqTF4GmzCwGG4GN33QVdScjFJpfjaeOPVL7xBbR6FoqXMUNhfXjGAzeZJ5KxvG+GR/N2gcYYSx7c81866h8UPBGjX+o3PxJ+I+tWeraZBbaoul2Gt3Ni88DJBtupLeF1UEo0SyQqzRbo5HRF8xwem8UfEzwZqWn3OktrmraloEkqfZ7e6kiltrxhbXV2si3jb5413rERLkNFJFbqmMkHslksoxjH2cne15crs1o3yPq7Nbq1tzl9p5nq11da9b+INV0eXUrLS/wC1I5V0fU5EjNxJPsLhEhzh1hRWJ38nHpmucvviVe+H9N0XwzqfiOzXxvaQ2o1XVDYuNKkufLDPA8uNsLSg71X720ggYrH8L/GvQ/iVo+sHQLnWE8WaXaXGlXtlotyNQbT5VjMgkCOfLlYlQElZCWJ2nAJrlr7wz4uvZvC2iNJfSam1vp9n4m0e+mn1KyijkiRZLy2Nw7rMEaPYfODjcGfbvZnNUcCozdPGRUHHo0k7pb7P3WrabN2eiauOXWJ7Fq3jLW5raOTwpoEOoyXsn2i1uZJP9FvLXyoiJxMmVQlpVwrkMywyFc4Fc/rnjTRdQXWtL1XV18QyaOzTa5aWcy29jY20iCGaG6kJClUjllmCOQ7CMkAlam+I3i/U9M0+/wDEljq8LeBRplzDqDPFJ5trcQzrHm38rbKXkDTpndhWiiK4yxar8LvFmofErRbKTXND07WvCF5JayaFqNqHuRKYd8wuLlZSTEyPDCFJLN5oznoRyU6Cp0PrLh7sXZ2dnfqtftJX91Wf2r8tkNvW1zo9BvLTxP4/e8sdWuLmw02BoLaPTLmU2LEHZKlwAPLMyt90ZyFGa0tD1hbXxp4h069u3jnurtX0+3uGkHmxpa25kMIcBSqs3Pl5UMTn5twrj/BOj2Fr4xgu/Da2GnW02lvPDDo8Zt7W8tQxjtUlgZeHjGP3ilTxtxt4qxH4s0vS7/w9rXii/uI/F66ZBb6jpuj6hcS6dbu7MssnkB/LZUmV08wqzqAoOBWFWgpTlGCbXKkl9pPfVeq19e+hSZ2PhXwbJ4d1DUru41m/1lrl8W638m/7JFkt5afVmOW6kLGvRBWvo+kRaNYx26Sz3LKu1ri6kMk0nJxvc8tjPeubm+KFha3C29xpmrQXbzQW8Vu9qPMleV5lG0BjwFt5JCTgBMHknFdNpGlxaLpsFlDJcTRQjCvd3DzynnPzO5LN17mvKxHtld1tG7fOy8v6fqWrdCpo5j0lrbQVOo3bWtmjfbrwPKJACV+aYjDScZIznnPeteqY1a0OrNpgmH25YBcmHBz5ZYqGzjHUEVcrlqXbu1v/AFcYUUUVmMKKKKACiiigDx/4P/8AJZvjx/2MGnf+mWxr2CvH/g//AMlm+PH/AGMGnf8Aplsa9goAKKKKACiisPRmt9Dk+wXLWNjeX13dXFvbQ3BZp1MhcuA+CWwwZgMhSeDjFK5pGPMm1v8A1+Rdhu4fEGlTNaXE8CSebAJ1jMckbKzIWUOvUMDgkEHAPIPORpWr2+j2d/o0eoX/AIm1jRLRJ7lJRH9smDh2jyQscZZ9jAY2jgZx1rK+Jlj4lltoJdC+3Xx+12gWy0+5is2jAkfzpJZXPzxlGXMajOUGOpxl3XxMHhXSdR1C4t11y5hiR5Ft4hY3SIPOdpLsTlEtoljicq8rhW2tjllBx5nzqNtfz9P6Z6dPDc9Lmg003tdabfE7Kys2vsq+qukyz4x1y38N313r99FrssmnRSXNnZR2kM8cpFsd6xbVLrgddzrluASOK5vUbXw/4j0Lwf4e8Qappra7A9p4ovo7PWJYIWLtIZJ4JWDM8JmZ9qBl+UqMqMA7V/q3h7WrDxD4i0Wz1K5uJI7nS9S1LRtz3Fu9uCCiRjJdtw2gxI2Tz05ryS00XQPiZ8J5LXU9OuBr6Qx6amrXK3MradNBPKs8Ut4kHlqtvcxXagrlNixMSA6mtfqOKrJyhTur28rvWz/qyPRw+IwtOMfazcGrbWut1e1+jbe93e+i0PXfDOjnXNPv5bXSJTaaxct9q1TWZlXUQ0bzqHEJhZAInjhMK52kSFyAwPmMaO38K2uq3kp0zxDo+tM81zNcX00hmhXAkRLfEyysIRM5EQQOVC7FB3Dym5+NZ+Hvja50drjVvEWp3Hh63un8TixMNrdRWkm790sxSKd5/t1vChtpJS0kw3Bdq58L8cftL6X4F+FOpeHdZ1wKs9sNYjuIYoTrDO97DHLaPbGURSI8UkgMkMuGRZMY2mvqMv4TzHHKnaPK5NW6uz62Xbqr3/M8uvmVGnUmk+aPldJ283rpZW0S0+FbL750rxdpl9cQaHqF9pFv4me2WS50OC/SaSPKgkBSFdlwfvFBkc4FcNrXxN0rwj4d16WTS9cbRTJdWdmZ4EtrRWgt0QW8JQCSKN3WREdl++r4O0xbvivx18frT4ZeH/Fd78Q0bXvEms3NnpviEaNDbReXP9hiE1lbXEUztG8Cgbi20McjORXzh46/bM0fxtF4It5PAsFtZaZaX1nqdutzKUaOe5kkhEI38tArIyu+Czs4IAwa+9yzw9r4xxqWc4aXatZ+627axbu7RWltU35fPzx3Jfl0v0+fz/zP0f8A+F++GdA8eafa65eafB/aFvZw3vhs21zqV1abIGuLWQSRWpJnDJKGt5CSAolV12Mj8brf7R2peM/G80FrpNtrHh/UNAj1DT7qOSXUrGFmYQXsrQJFG0kcMbOzQzLvdlwm04Ffmj4N+LPxB+Den+INY0PWtW0qPWHgks7q4u0hu5WLSCK78pwzyr5SXERZfkUyYLZwCeA/ihqPhL+zb3RdW0/SFkIsZ9c1NSbuyuJW82S4SGGRpGRGHyyCM+hXPFfoNPw7w+Gc6lK0mkop+drvRK6d7LVzbV9Ls4pY2dTSTPrr4hftcab4n+G8nhaG9XxzY2WpQXVwNHJkvr2Y/wClcSXMYO1nkeEyRQLtNszrHGkqxx8z4R+P1z8VPiXF4+u/HPgHQbzxLN9n17wrqjan+60q2Lui+Yd0RmKvI42bNrwQshDSSKfmLT7pfAnjL+0taXQ/H9lJbrpNhNbavHbgL5MX2e4wv7yILGUB8xVIO9H2urAc34g1RNL0fTXttZhTXLLXr+d9HsYVa0scfZzHNDMNyyK7K6gBmAECno+T9fQ4XwUYOjQTXNf3tHfmV5XVtPejFt8sNVFJ9HyuvLdn1PbftE+Ffh/4z1nVLDwsmueAZvGca674i0ZljtdXs2jMkFr/AGfdLIoKmIyb8h28thvjL7hj/tGfEDV9L+HloLbxZp+sCS9WfUJ9D0a505l1zzPNnFxI86O0vlnO4RBMcKkZ5rznwz8LZZNPtddTWZNFj1S+s9T0LxFdzxS2kTi8gt5mv0hMiWoja58zfKR90Lg78Vf8I3C+E7LxBpt/NLcaD4qurWVdW1C9h/4mFi8u10GwyMkueJGhWR0OVcLjNKOAwVKtGvQfPKDSd9XK1lu09Vd6Rtty8qUR80mrPqbPxa1W6+P3xM+Huiafb+H2ltNN0aL/AIRqzuZBC261RnSO7dnPlpBFH5ikp5TMyhZXV5ZPdrf4C+HPBPirwTqGreJta8J+GbJrTVdM1LTtJiv9Mutmos1xpsktnmR8yLYeS8zPnYxwGIRfOpPBHiH4F6DrU3iGw09NU8XNDpFjDDfw6iBGtxLZrYqRsiea2Fv88qS7k86IOuWbHs3hHwD468I65d/CnxV4dv8AxTpU0VhY3V9DBvisobiG9eFyLV5JIi1zaafuuPL2p9lbOAVZ/m8yxap4eFPC1lGlBPROLlJKynKDd4tpysr3bu1dt6bQjdtyWrOw/ZhsdEm/4Q7S/A+s+G01RtWnvr68sYfs+q/YyzTgXUbzEuZo0eF4l3CJpFkG0riuu8N6L4i+G/xM8Ga98RtbudJsV0K4iv8ASNK+2T2s91YOds6qbiWTy1haPa3LTctJGh4rmND/AGT9fvvhbq3ge80rwp8LtT1zVo2sNUsJwurXMUEqyP8AJGzqWMCyn5Zcn+MKM49IuZtU8Qa98LY/ijpMGja1eWCafrkFnqsfnvdMzLGjW8RkDWs0iOVYOCMENjGK/NsdiKVavVlRqqcZ8yl8Lm1yyalF7NNtpJL3XGO0pXOyMWkrr/IofDz46eIr3xN/aWkQ3mpeEdSeS6jt00+TU77WrozTqY7e682G2to0tVsJAHQL+8dCWlWSvbfhTpuqat8M9Plvr+bSr26u/tzQ6dbpbpbKJ932ZI3i+VCE2vkFjvkKvyrC3a+GzrGkXVjo11qGiaDfyXHmSRl7G8sJI3jjVbWNogFiYxysSeu/cu4PkaqeEr2PxVY6sNWWSK1gFp5U1tuleEod6mTcOWkEL7tuR5RH8Zx8Jj8Zh691Sgqb37v3b2T07vr235bJdMYtb6ieFZbNtQ8RzxatZ6zqIvGW6j0+Uk24UYjheMyuEkC4BI2bjyVFcqvhfw54ljvNNfQdY8H6jrEn21ZkVY51cx28s5ikjaRISW2pIAV8x1kI353np9P+GPh+xktrh7M3eow+WW1Cdv387I+9XkZcB23DOSOa09Hk1S+vbi7vI30+0w0EenTLGz7klkAn8xHYFZE2MEOCo64JIHme3jTlKpSk+nlqtrJbrTqrJaaMu3RmhHYW0N5NeJbQpdzokctwqASSKhYorN1IUu2Aem4+pqO7sZLq8sZ1vbi2S2dne3h2eXcAoVCyZUnAJDDaVOVGSRkG5RXlczvf+uxoFFFFSAUUUUAFFFFABRRRQB4/8H/+SzfHj/sYNO/9MtjXsFeP/B//AJLN8eP+xg07/wBMtjXrJvrZbP7WbiIWu3f5+8bNvru6Y96V0txNpbk9FY9n4r028to5xcKiySNGmWDZwzqG+UkBTsYgnsOx4qLR/FH9rX2qr9ikttMswhi1OWRDDdZDF2jIJ+VcDJPcnjis1VhK1nuZRrU5WcZXv/w5o3er2dje2NncXMcV1fO0dtEx+aVlQuwX6KpP0FS3u0W8jGVbZgpCzsB+7JGM88V5vpv7Rngi516DRb3W7Ow1a9uxb6baGUu16jnEUiYXAD84HbHWsq++N3gptF01NW1C31vRtaluvP8A7QMDi1ZfnW2kRFKHB+Rdx52A7mPNd8KMp8jUXr87+nyOyNGc0nFXvt5+nf8A4I7wn46t9c1rUdBSW7k8bWgtbO+8Q2OjnyZ4BNcmJ9zDaUzDcRuR8qSOwGMir/iLRZvCcmmeLL/TDq2pW11O+p30WqGCCxsZEPnEiUkvAqoj+SON6hgMgVw2sftC/wDCbeC9Rg8O39hNea9bNeaOLd5Ibi20owbHuJTnAmFyk0K7DgM0Zw2Du838VfFD4uzaasOhajdeF/BltbT358ZahcWkk0CxWEgjguEmtjiOW6EID7DI22Xk5XH1VDL6lat7Ony0nvJSdr6aq6SfvO6UUm9Glfq62HrU58tVNO11fe17L7j1PxB8ZvBXiSzfXdJ0izv76PSLe/0/UdQtScXTyCS0tWjGJBIx2yhRzjmvm74lfHLwzbLpWi3vgrSV+Ls149gbLw3aTw6hY3E0k1xPc2k+cshadXEin94xmx1pPiP8C9d8V2Oot/auoePLTWbG51NtQuHazv8AUZ51IhS3KSxKn7k/ZwHhaEsQPJ71yHh/9h7xt4q8E+CZtQtrPUdO0RVtdM0KxQ2EljceXuuxc3DBp/8Aj9MzFlkKKyFo02ShU/RMswWS4OmqlfEWSe12ns7K7t13i1C6vqmmn41SU27RR4H4++LXizRk8QSyfFnXNU0+1uhpRtb5Z4r/AFpUWP7Ta3UikNFEjPKI1c/xS7ed1eZXEer+JtPa+0WWePVrHQTiG01MzqdLEUq3MYDEvuRHJeMHCxhyRX1142/Z+8afFTQ/CHhjR7608EP4R1U/2/4b1dGkia6d7dV1PDI51F5XkkLO52qrJHtQFi/TaX+zjpnjb4hH4c+GNWh8HRR+H7/fcQ2jwG6uLmCSCa4t4btpy9q6uyvFC8BUkNyVUr+kUeIMuwVBOKSkruVloox0TlyxSfMrPTmvze6+WxxOlOTPgnUIZYvCP9tWsV1YaBr+rtHNZ29209oiRncsEuT5hlXJYbjkqVPesb4opKfG+qSG8XUrXzFitbmKV5UECxoIYgz/ADZji8tCrHcu3aeRX158QP2QfFfxIl8NaH8PtJ1DS20i2tdPuYbzTpNOS4voALefUJh58kacx/6yNdzY5B++fVtD/YQ8TXHg3TdPvvDJvdc1S5ZtUn1zVpLiBF86RL+c/wB26mK20sU0YUtHHGjAFZWm9eXF2V4NQrVKqu7pxulJJ2s3d32jv19TP6vOWiR+akOpato9pe20c91aW2oQi1uI8sqzxK6ShGHcB1jbHqFNeqax+yX8QrHWrTRdO0efxJrDQyT3NtosRuVt1RwrDevDEE/MB908Gv1at/2E/DmoaPYeGfEOrar4g0PRbqO7sL3U49PlupleGaG5t5HFor7GRosuXaTMcRRozEpqXwp+ySNN1BD4v1e61nVrm9ElprXhuKTTZbKIN51wkkomLqLhlCuYtvBKrtBNfJ4jxOwfxYayau2rN81/ha+HZayTafRXtrusFL7R+U/wz/ZvX4ka9qmj2PiSxfUSNukWbyC3uL1jLIikxSfMp2xl/KPzlXTHWvsSP9jPStP8PvZauuiWN3daja3d3BaXkluotYdOLWk32SQmIyNNb6gsiyqT+8kPQV9vaX8CvB7eNPGWqf2Rfpc6tdQT3lxdyszTXCAOk9vcFjPGEDiMIroibCFQZJZs/gKHwL48k8Rf23qVxpF83+ieGLZTHDBdRpPIq2yQeWn7zzbtpPPD+Y5hO5fLWvisy8QcRmFT/Z5OCUbpd3aLtdeeuqtpf+6umGEUVqfD2rfs4/Fe6+IXgXRvFepy2vwUeVXEOm3tvYx28d66Wps8xgIS/nBAiAZWRwmDXp3wv/Yh0eOPwxod3oOn21lo1xdr4g0qSeO5kuTgy6fLduBmXJKsYfuDsK+xW8D6LrK2V1e2d1OY74avHbX11LIsdyV+UmNnK/IcMqYKo6h1AYBq2rrSoLzULK8kacTWZcxCOeREO5dp3oGCvx03A4PIwa+RxXGmNrUlSp2hZP4Vyq/vWdk9X7zvLe9mtnfojh4p3ep41o/7NFjp/hHTtKnj0q9umskt7+4mslJjnZAJri2bG5DmK2VEPyIltGoA2im+BvgxqPwP+xy+F7STxFO881vfTX2qy+dPZ+Q8sbOZGKtL9rGF/hRbqUgDc2fW2/s3w3fSzyTXCTaxeouJJZZlM3lBVVFJIiXbFnChVzkn5mJOxXytTN8ZKMoTlzQnq09E38n0ext7OPQ5fVPCNrN4fuRY6Npiak0/9qQxXkW+Fb8EOsr7eSQ6qdw544rZ0m8i1rTbLUfsk1sbiFJRDeQGKePIyFdTyrDPIPQ5q/RXjyqylHll3/r9DSxznhOfV5tV8VLqczS20eqBNOVrUwiO3+zQHaGP+tHmmU7x6lf4a120iyk1aLVGtYjqMUD2yXRUeYsTMrMgPoWRCR6qKuUUTqOUuaOmltPS349QsFFFFYjCiiigAooooAKKKKACiiigAooooA+O/Fnxe1D4b/Ez46WWmQtZ3uoa1ZeVrFwhNvCV0OyJQbQSZTgBQQFy2ScA1474m+NXivxVoo0q6vxDYtEkU8VqvlrcbBgFxnAOOy7QfSvpub9k3w/48+LnxQ8T+NNP1RodavbNdPk0zxJf2CzWqadbQuJIrW4jUnzY5B84JIA7YqX/AIYD+CP/AELut/8AhYaz/wDJdfCZzkWYZnWcqeJ5YNW5ddvk9f6WqPzXP+G80zjESnSxnJTaty2e3yet9el7aO6PjfTfFOtaKlzHY6ldW8E9sbZ445SA0ZYsVx2GST+J9TmCz1vxzruND8PSa1BaW2mfZPsOnTgRTQCYuWkLblQb5fmclMBR1Ga+z/8AhgP4I/8AQu63/wCFhrP/AMl1p6P+xX8KvD9u1vpdn4q02Bs7orPxzrsSnPXIW9A5rPJ+HsZlk5c1dSjJJNWlay125kunbZu1nqc2R8I4zKaknUxEZRklFq0rWTTt8SWrSvpqm7WdmfC/jzwv8VtH8deFbL7KbW40ib+1Pt5iSVbC4Vd8HnTRxGONJApClnEagkuYxzXRX37MfxB8RW+t6Vp2j6jcaBPejUmvNLttMW41CdpWmQTKNRMccChwY9gyykZUCvstf2NvhjHcTTrF4uWaZSksg8d66GkU8kMftvIPoans/wBkX4dadbpBaP4ztYI1CJFD4/19FVQMAAC9wAAAK/ZcLn+IwNGhRw0UvZppt3k5O7ald9U27dFpZaH65SxVejGlCMrqCavL3m72erfxWknJX78tmkrcTpPwk1zxxpLWUvhjUPA6W4tkmkuJrKCXURHErLIjQfaBb/v0y8IGwjY6tkOrbNn8BZ9Xg1W3ihv9LOoLZ3c8niaWLU7f7RbyM0MIgRlMkSszyktIh3GLhhuUb8P7JHw8tpJnhl8aRPM/mSsnj/XwZGwF3Ni95OFUZPYD0rl/CX7J+nL4w8cNrt/42fQWv7c+H1X4g63lLb7HAJgdt7u/4+PPPz5PPHy4rjea143VPRb9d736t31738tNDrnj5y2il230el3q3vb0WlrLQ9sk8C6XNrlvq8sKtfpsMjbFKylFwnDA7QpAYBSMMAeab428Gw+NrLT7O5kCW1vfRXcqZlBkCZ+UNHIhU5I5O4ccqe3Bf8Mp+A/+fvxx/wCHC8Qf/J1H/DKfgP8A5+/HH/hwvEH/AMnV5ka9WMozUtVt5HmSbl8R6dpvhzTdIWD7LaIrwCURSyEySIJX3yKHYlgGYAkZx8o9BiafRtPutSttRmsbaXULVWWC7khVpYlYYYK5GVBHXB5ryv8A4ZT8B/8AP344/wDDheIP/k6j/hlPwH/z9+OP/DheIP8A5OqHUm3zNu/+e5J7BRXj/wDwyn4D/wCfvxx/4cLxB/8AJ1H/AAyn4D/5+/HH/hwvEH/ydWYz1SDSbW21O71CNGF3dJHHK5kYgqm7aApOBje3IAznnOBVyvnLwr+yfpy+NvGra1f+Nn8Otc2v9gqvxB1vKxfZo/Pztvd3+u8w/Pk+nGK63/hlPwH/AM/fjj/w4XiD/wCTqbk5atgewUV4/wD8Mp+A/wDn78cf+HC8Qf8AydR/wyn4D/5+/HH/AIcLxB/8nUgPYKK8f/4ZT8B/8/fjj/w4XiD/AOTqP+GU/Af/AD9+OP8Aw4XiD/5OoA9gorx//hlPwH/z9+OP/DheIP8A5OrkvCv7J+nL428atrV/42fw61za/wBgqvxB1vKxfZo/Pztvd3+u8w/Pk+nGKAPo2ivH/wDhlPwH/wA/fjj/AMOF4g/+TqP+GU/Af/P344/8OF4g/wDk6gD2CivH/wDhlPwH/wA/fjj/AMOF4g/+Tqw9L+BPwp1rxVrvhuy1jxxNrWhpbyaha/8ACe+I18lZ1ZoTuN4FbcEb7pOMc44oA98or5L1qy/Z78P6xqlheeJviF5ek3g0/U9Vt/FPi2fStOuPl3R3OoR3DWsDJvTf5kq+Xu+fbVjx/oPwG+GesNpmua38Sjdx6WNbl/srxJ4v1KOCxLOv2iWS1nkSOPMb/M5HCk9OaAPqyivlXwN8EvA+ufFjxnoM3iPxjf2i2enaxo0Nv8QNeZPsE8TJ5olW8w4eaKbGWJwMjClc6ln8O/gjqF9ZWdv4j8cSXN5rt14agT/hOPEw36jbJK88GTd4G1YJTvPyHbwxyMgH0tRXz18Rvg38IPhJ4Ov/ABV4t17xtpGg2Ozz7tvHviOXaXdUQBI7xmYlmUYUE81S+IHwv+DnwzsdFutc1X4iumtXX2PTotJ8XeKtTmupfKebakVrcyOf3cbtnbjCnmgD6Sor5e0fwf8AAjXdE0XVbPxN46e11fWG8P2ySeNPFEU66iokLWs0L3QkgkAhkysqpjAz95c42m2/wI1bxNL4etpfjQ2tQxxzTWclx48jeGOQusckm5hsRjHIAzYBKNg8GgD66or5us/hl8FdQ8O+EtdtPEfja60zxXNDb6NLB468Su13JKjOq7Bd7kwqOz7wvlhH37dpx2P/AAyn4D/5+/HH/hwvEH/ydQB7BRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAUUUUAFFFFABRRRQAV8x6L8V/BPw5/at+M9r4r8aeH/AApdahZeHxZx61qcFo85EFwCY1ldd+Cy5xnqPWvpyigD5K+Dfxh8A/CH9nuz+HXjTUrLT/HWjQT6TqXgyYh9V1O8eRsm3tP9ZdC6aUSI8aur+d14bHjWraRa/DzVtD8LfEf4rv8ACy/h+Cun6beYurINfSLNdK9r++RpJSo+XFs8crfwuCQR+jVFAHyJ8PfiBpnwr+KXh3X/AIkppvwrs/EHwz0W1t49UkFhYW13bTXDT2KvMwWOSNbiIiJmLbc9drVyVl4g0jwba/Czxt4g1O38OeGNb+Lev69balrci2MP2K5s9U+zTM0pXasqlGUtjIkXjkZ+6KKAPlr4q+OP+F+/EvwH4b+G6eEviRoGlW9x4q1YXOumLTpx+9srSL7RbwXIY+Y9zJs2YJtR8w24PmXh++8Xf2D8Dfh62oaTo/xC8A+O5/Dc817FLqlqscei30lrKUD20kqPayRAMTHlgxxwVr7yooA+HNJvII4/Aml6kGtfiHb/ABkjufF1jJKCFvprK7KTwKFUi0lhWJoCQTsGGZ5FkY+8eE/+TwviR/2J3h//ANKtUr2uigD5h+DPw5tNL/ar+JMAu5p9G8JxxXmgaVIF8nTZtX3z37R4H8UkGVH8IllA4avp6iigD//Z[CR]");
        tmp.append("[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }
}

