/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.urisys2400;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RecordParser
extends jalis.laboratorio.interfaceamento.interfaces.urisys1800.RecordParser {
    Map<String, String> camposDecimais = new HashMap<String, String>();

    public RecordParser(InterfaceASTMListener equip, boolean enviarMontandoRack) {
        super(equip, enviarMontandoRack, false);
        this.campos.remove("SG");
        this.campos.remove("pH");
        this.campos.remove("LEU");
        this.campos.remove("NIT");
        this.campos.remove("PRO");
        this.campos.remove("GLU");
        this.campos.remove("KET");
        this.campos.remove("UBG");
        this.campos.remove("BIL");
        this.campos.remove("ERY");
        this.campos.remove("COL");
        this.campos.remove("CLA");
        this.campos.put("1", "DEN");
        this.campos.put("2", "p.H");
        this.campos.put("3", "LEU");
        this.campos.put("4", "NIT");
        this.campos.put("5", "PRO");
        this.campos.put("6", "GLI");
        this.campos.put("7", "CET");
        this.campos.put("8", "URO");
        this.campos.put("9", "BIL");
        this.campos.put("10", "SAN");
        this.campos.put("11", "COL");
        this.campos.put("12", "ASP");
        this.camposDecimais.put("DEN", "SG2");
        this.camposDecimais.put("p.H", "PH2");
        this.camposDecimais.put("LEU", "LEU2");
        this.camposDecimais.put("NIT", "NIT2");
        this.camposDecimais.put("PRO", "PRO2");
        this.camposDecimais.put("GLI", "GLU2");
        this.camposDecimais.put("CET", "KET2");
        this.camposDecimais.put("URO", "URO2");
        this.camposDecimais.put("BIL", "BIL2");
        this.camposDecimais.put("SAN", "BLD2");
        this.envioMontandoRack = enviarMontandoRack;
    }

    @Override
    public void recordFound(String record) throws Exception {
        String record_type;
        String c = String.valueOf(record.charAt(0));
        String rec = record;
        if (!Funcoes.isNumeric(c)) {
            rec = String.format(" %s", record);
        }
        if ((record_type = ASTMStandard.getRecordTypeIdentifier(rec)) != null && record_type.equals(ASTMStandard.RECORD_TYPE_MANUFACTURER)) {
            this.trataManufacturerRecord(rec);
        } else {
            super.recordFound(rec);
        }
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        if (this.envioMontandoRack && Funcoes.textoVazio(req_codigo = this.equip.getRequisicaoRack(String.format("%s^%s", rack_id, rack_pos)))) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para rack n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(String.format("%s^%s", rack_id, rack_pos));
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int tam = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        if (!Funcoes.textoVazio(req_codigo) && req_codigo.trim().length() != tam) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos requisi\u00e7\u00e3o com tamanho diferente do padr\u00e3o: ");
            msg.append(String.format("%s (%s^%s)", req_codigo, rack_id, rack_pos));
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        String emi_alternativo = "URI";
        Statement st = Conexao.getStatement();
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo + " amostra n\u00e3o interfaciada ou j\u00e1 exportada");
            this.exame_atual = null;
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        String resultadoDecimal;
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String int_codigo = (String)this.exame_atual.get(INT_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
        String mco_codigo = (String)this.exame_atual.get(MCO_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String campoUrina = (String)result_fields.get(3);
        String resultado = (String)result_fields.get(4);
        campoUrina = campoUrina.substring(3);
        System.out.println(campoUrina);
        campoUrina = (String)this.campos.get(campoUrina);
        if (this.camposDecimais.containsKey(campoUrina) && !this.camposDecimais.get(campoUrina).equals("SG2")) {
            resultado = resultado.replaceAll("\\.", ",");
        }
        if (resultado.startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.length() >= 1 && resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        if ((resultadoDecimal = new String(resultado.trim())).startsWith("TR-")) {
            resultadoDecimal = resultadoDecimal.substring(3);
        } else if (resultadoDecimal.length() >= 2 && resultadoDecimal.charAt(1) == '+') {
            resultadoDecimal = resultadoDecimal.substring(2);
        }
        resultadoDecimal = resultadoDecimal.replaceAll("[a-zA-Z]", "").trim();
        if (Funcoes.isNumeric(resultadoDecimal) && this.camposDecimais.containsKey(campoUrina)) {
            if (this.camposDecimais.get(campoUrina).equals("SG2")) {
                this.exame_atual.put(this.camposDecimais.get(campoUrina), resultadoDecimal);
            } else {
                this.exame_atual.put(this.camposDecimais.get(campoUrina), resultadoDecimal.replace('.', ','));
            }
        }
        Statement st = Conexao.getStatement();
        this.exame_atual.put(campoUrina, resultado);
        System.out.println(String.format("%s = %s", campoUrina, resultado));
        this.lastField = campoUrina;
    }
}

