/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.urisys2400;

import jalis.comum.Conexao;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.urisys2400.RecordParser;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.urisys1800.InterfaceListener {
    private boolean middleFrameCR = false;

    public InterfaceListener() {
        RecordParser record = new RecordParser(this, super.enviarMontandoRack());
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        InfoExameRequisicao infoExame = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames);
        infoExame.setInterface(int_codigo);
        infoExame.setCurva(false);
        infoExame.setTuboPai(rec_codigo);
        try {
            this.encerrarTransmissao(infoExame, rackposition);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
    }

    private void encerrarTransmissao(InfoExameRequisicao infoExame, String rackPos) throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            Statement st = Conexao.getStatement();
            if (infoExame != null) {
                String[] exames = infoExame.getExames().split(" ");
                String fil_codigo = infoExame.getFilial();
                String int_codigo = infoExame.getInterface();
                String req_codigo = infoExame.getCodigo();
                String mco_codigo = infoExame.getMaterial();
                String rec_tuboPai = infoExame.getTuboPai();
                String rec_codigo = infoExame.getRecipiente();
                for (int i = 0; i < exames.length; ++i) {
                    int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, rackPos, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
            } else {
                this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
            }
        }
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(infoExame.getCodigo(), infoExame.getNome(), infoExame.getSexo(), infoExame.getIdade(), infoExame.getData(), infoExame.getHora(), infoExame.getExames());
        }
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
                message = message.substring(1, message.length() - 2);
                checksum = message.substring(message.length() - 2);
                termination = message.substring(message.length() - 3, message.length() - 2);
                message = this.middleFrame ? message.substring(1, message.length() - 2) : message.substring(0, message.length() - 2);
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    String messageLast = (String)this.rx_list.get(this.rx_list.getUltimoInserido());
                    int p = messageLast.indexOf(this.getMiddleFrameEnd());
                    if (p > -1) {
                        messageLast = messageLast.substring(0, p);
                    }
                    message = messageLast + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                    this.middleFrameCR = false;
                }
                if (message.contains(String.valueOf('\r'))) {
                    String[] tmp;
                    int frameCR = message.indexOf(this.getMiddleFrameEnd());
                    if (frameCR > 1 && !this.middleFrameCR) {
                        this.middleFrameCR = message.substring(frameCR - 1, frameCR).charAt(0) == '\r';
                    }
                    for (String s : tmp = message.split(String.format("[%s]", Character.valueOf('\r')))) {
                        if (s.length() <= 1) continue;
                        this.rx_list.add(s);
                    }
                } else {
                    this.rx_list.add(message);
                }
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    if (this.middleFrameCR) {
                        String tmp = (String)this.rx_list.get(this.rx_list.getUltimoInserido());
                        this.rx_list.add(tmp.substring(0, tmp.length() - 2) + '\r');
                        this.middleFrameCR = false;
                    }
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    String s = (String)this.rx_list.remove(0);
                    this.recordParser.recordFound(s);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }
}

