/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.urisys1800;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    protected Map<String, String> campos = new HashMap<String, String>();
    private Map<String, String> flags = new HashMap<String, String>();
    protected String lastField = "";
    private static final String SEDIMENT_RESULT_RECORD = "SD";
    private static final String RAW_RESULT_RECORD = "RR";
    private List<String> flagsSalva = null;
    protected boolean envioMontandoRack = false;
    private boolean importarResultadoQualitativo = false;

    public RecordParser(InterfaceASTMListener equip, boolean enviarMontandoRack, boolean importarResultadoQualitativo) {
        super(equip);
        this.flags.put("*", "Anormal");
        this.flags.put("S", "Sieve");
        this.flags.put("!", "Resultado editado");
        this.flags.put("#", "Modificado refer\u00eancia");
        this.flags.put("T", "Erro na tira de teste. Nenhum resultado gerado. Campo de resultado vazio");
        this.flags.put("C", "Calibra\u00e7\u00e3o expirada");
        this.campos.put("SG", "DEN");
        this.campos.put("pH", "p.H");
        this.campos.put("LEU", "LEU");
        this.campos.put("NIT", "NIT");
        this.campos.put("PRO", "PRO");
        this.campos.put("GLU", "GLI");
        this.campos.put("KET", "CET");
        this.campos.put("UBG", "UBG");
        this.campos.put("BIL", "BIL");
        this.campos.put("ERY", "ERY");
        this.campos.put("COL", "COL");
        this.campos.put("CLA", "ASP");
        this.envioMontandoRack = enviarMontandoRack;
        this.importarResultadoQualitativo = importarResultadoQualitativo;
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        String[] tmp;
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String int_codigo = (String)this.exame_atual.get(INT_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
        String mco_codigo = (String)this.exame_atual.get(MCO_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String campoUrina = (String)result_fields.get(3);
        String resultado = (String)result_fields.get(4);
        if (campoUrina.contains("^") && null != (tmp = campoUrina.split("\\^")) && tmp.length == 2) {
            campoUrina = tmp[1];
        }
        campoUrina = this.campos.get(campoUrina);
        if (resultado.contains("^") && null != (tmp = resultado.split("\\^")) && tmp.length == 2) {
            resultado = this.importarResultadoQualitativo ? tmp[1] : tmp[0];
        }
        if ((resultado = resultado.replaceAll("\\.", ",")).startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.length() >= 1 && resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        Statement st = Conexao.getStatement();
        this.exame_atual.put(campoUrina, resultado);
        this.lastField = campoUrina;
    }

    @Override
    protected void trataCommentRecord(String record) {
        String erro_traduzido;
        if (this.exame_atual == null) {
            return;
        }
        Hashtable comment_fields = ASTMStandard.parseDefaultCommentRecord(record);
        String type = (String)comment_fields.get(ASTMStandard.COMMENT_FIELD_TYPE);
        String exception = (String)comment_fields.get(ASTMStandard.COMMENT_FIELD_TEXT);
        if (!Funcoes.textoVazio(exception)) {
            StringBuilder flag = new StringBuilder();
            String[] flags = null;
            flags = exception.contains("^") ? exception.replaceAll("\\^", " ").split(" ") : new String[]{exception};
            if (!Funcoes.textoVazio(this.lastField) && flags != null) {
                if (this.exame_atual.containsKey("flag_alerta")) {
                    flag.append((String)this.exame_atual.get("flag_alerta"));
                }
                for (String str : flags) {
                    if (!this.flags.containsKey(str) || this.flagsSalva == null || this.flagsSalva.contains(this.lastField + ": " + this.flags.get(str))) continue;
                    flag.append(this.lastField).append(": ").append(this.flags.get(str)).append("\n");
                }
                if (!Funcoes.textoVazio(flag.toString())) {
                    this.exame_atual.put("flag_alerta", flag.toString());
                }
            }
        }
        if (type != null && type.equals("I") && (erro_traduzido = this.equip.getErroTraduzido(exception)) != null) {
            String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
            String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
            String exame = exa_codigo != null ? " (" + exa_codigo + ") " : "";
            this.equip.fireExcecaoEncontrada(req_codigo + exame + " - " + erro_traduzido);
        }
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        String flags = (String)dados.remove("flag_alerta");
        ArrayList<String> flag = new ArrayList<String>();
        if (flags != null) {
            for (String s : flags.split("\n")) {
                flag.add(s);
            }
        }
        this.lastField = "";
        Statement st = Conexao.getStatement();
        List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
        for (BDExame exame : exames) {
            this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getExame(), exame.getMaterial(), int_codigo, dados, flag);
        }
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        String emi_alternativo = "URI";
        Statement st = Conexao.getStatement();
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo + " amostra n\u00e3o interfaciada ou j\u00e1 exportada");
            this.exame_atual = null;
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
        Exame ex = new Exame(fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo, rec_codigo);
        this.flagsSalva = ex.getFlags();
    }

    @Override
    public void recordFound(String record) throws Exception {
        String rec = record.substring(1, record.length() - 1);
        String record_type = ASTMStandard.getRecordTypeIdentifier(rec);
        if (record_type != null && record_type.equals(ASTMStandard.RECORD_TYPE_MANUFACTURER)) {
            this.trataManufacturerRecord(record);
        } else {
            super.recordFound(record);
        }
    }

    protected void trataManufacturerRecord(String record) {
        if (this.exame_atual == null) {
            return;
        }
        Hashtable<Integer, String> comment_fields = ASTMStandard.parseDefaultManufacturerRecord(record);
        String sequence = (String)comment_fields.get(ASTMStandard.MANUFACTURER_FIELD_SEQUENCE);
        String type = (String)comment_fields.get(ASTMStandard.MANUFACTURER_FIELD_RECORD_SUB_ID);
        String rawTestCode = (String)comment_fields.get(ASTMStandard.MANUFACTURER_FIELD_RAW_OR_TEST_CODE);
        String result = (String)comment_fields.get(ASTMStandard.MANUFACTURER_FIELD_RESULT_VALUE);
        StringBuilder flag = new StringBuilder();
        int seq = Integer.parseInt(sequence);
        if (this.exame_atual.containsKey("flag_alerta")) {
            flag.append((String)this.exame_atual.get("flag_alerta"));
        }
        if (type.equals(SEDIMENT_RESULT_RECORD)) {
            flag.append(rawTestCode).append(" = ").append(result).append("\n");
            this.exame_atual.put("flag_alerta", flag.toString());
        } else if (!type.equals(RAW_RESULT_RECORD) || seq < 16) {
            // empty if block
        }
    }
}

