/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.urisys1800;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.urisys1800.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.urisys1800.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    private boolean hostQuery = false;
    private List<InfoExameRequisicao> examesEnviados = new ArrayList<InfoExameRequisicao>();
    private static final String EXAME = "URI";
    private InterfaceConfiguracao configuracao;

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        RecordParser record = new RecordParser(this, this.configuracao.getEnviarMontandoRack(), this.configuracao.isImportarResultadoQualitativo());
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
    }

    public boolean enviarMontandoRack() {
        return this.configuracao.getEnviarMontandoRack();
    }

    public int getQtdeExamesTotalRack() {
        String qtde = this.configuracao.getQtdeExamesTotalRack();
        if (!Funcoes.textoVazio(qtde) && Funcoes.isNumeric(qtde)) {
            return Integer.parseInt(qtde);
        }
        return 50;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            String short_name;
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            if (Funcoes.textoVazio(rackposition) && this.enviarMontandoRack()) {
                this.fireExcecaoEncontrada("Necess\u00e1rio montar rack para enviar para o equipamento");
                return "Necess\u00e1rio montar rack para enviar para o equipamento";
            }
            rackposition = Funcoes.textoVazio(rackposition) && !this.enviarMontandoRack() ? "^^^^SAMPLE" : String.format("^%s^^SAMPLE", rackposition);
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            if (this.enviarMontandoRack()) {
                this.tx_list.clear();
                this.rx_list.clear();
                this.tx_list.add(this.getHeaderRecord(this.DELIMITERS, this.HOST_NAME, this.HOST_SYSTEM_VERSION));
                if (this.tx_list.size() < 0) {
                    throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
                }
                this.tx_list.add("P|1" + '\r');
                if (this.tx_list.size() < 0) {
                    throw new Exception("N\u00e3o foi poss\u00edvel montar o registro do paciente");
                }
            }
            if ((short_name = StringUtil.removerAcentos(pac_nome)).length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            this.tx_list.add(this.getOrderRecord(codigo.toString(), rackposition, "R", "X"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            if (this.enviarMontandoRack()) {
                this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
                if (this.tx_list.size() < 0) {
                    throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
                }
                this.tx_list = this.makeFrames(this.tx_list);
                this.tx_list.resetUltimoLido();
                this.setTX(this.TIME_TX);
                this.tx_counter = 0;
            }
            InfoExameRequisicao infoexame = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames);
            infoexame.setInterface(int_codigo);
            infoexame.setCurva(false);
            infoexame.setTuboPai(rec_codigo);
            this.examesEnviados.add(infoexame);
            if (this.enviarMontandoRack()) {
                this.getPortaCOM().write(String.valueOf('\u0005'));
            }
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        while (!this.examesEnviados.isEmpty()) {
            this.encerrarTransmissao(this.examesEnviados.remove(0));
        }
        this.interromperTimer();
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
        if (this.hostQuery) {
            this.hostQuery = false;
        }
    }

    private void encerrarTransmissao(InfoExameRequisicao infoExame) throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            Statement st = Conexao.getStatement();
            if (infoExame != null) {
                String[] exames = infoExame.getExames().split(" ");
                String fil_codigo = infoExame.getFilial();
                String int_codigo = infoExame.getInterface();
                String req_codigo = infoExame.getCodigo();
                String mco_codigo = infoExame.getMaterial();
                String rec_tuboPai = infoExame.getTuboPai();
                String rec_codigo = infoExame.getRecipiente();
                for (int i = 0; i < exames.length; ++i) {
                    int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
            } else {
                this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
            }
        }
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(infoExame.getCodigo(), infoExame.getNome(), infoExame.getSexo(), infoExame.getIdade(), infoExame.getData(), infoExame.getHora(), infoExame.getExames());
        }
    }

    public void responseHostQuery() {
        this.examesEnviados.clear();
        PanelAbaAbstrata aba = this.equipamento.getTab(0);
        try {
            this.tx_list.clear();
            this.rx_list.clear();
            this.tx_list.add(this.getHeaderRecord(this.DELIMITERS, this.HOST_NAME, this.HOST_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            for (int i = 0; i < aba.getRowCount(); ++i) {
                aba.transmiteExames(i);
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
        }
        this.hostQuery = false;
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        this.hostQuery = true;
    }

    private String getHeaderRecord(String delimiters, String sender_id_name, String sender_id_system) {
        StringBuilder record = new StringBuilder("H|");
        record.append(delimiters == null ? "" : delimiters);
        record.append("||");
        record.append("|");
        record.append(sender_id_name == null ? "" : sender_id_name);
        record.append(sender_id_system == null ? "" : "^" + sender_id_system);
        record.append("||||");
        record.append("|");
        record.append("||P|").append('\r');
        return record.toString();
    }

    private String getOrderRecord(String sample_id, String InstrumentSpecimenID, String priority, String action_code) {
        StringBuilder record = new StringBuilder("O|");
        record.append("1|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("|").append(InstrumentSpecimenID).append("|");
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("||||||");
        record.append(action_code == null ? "" : action_code);
        record.append("|||");
        record.append(ASTMStandard.getCurrentMoment()).append('\r');
        return record.toString();
    }

    @Override
    public void teste() {
        String linha = "[STX]3O|1|1005088611|50^^^^SAMPLE||R||||||X|||20220713155032[CR][ETX]F5[LINE]\n[STX]4R|1|1^SG|1.020^1.020|||||||supervisor[CR][ETX]6A[LINE]\n[STX]5C|1|I|C|I[CR][ETX]7E[LINE]\n[STX]6R|2|2^pH|5^5|||||||supervisor[CR][ETX]14[LINE]\n[STX]7C|2|I|C|I[CR][ETX]81[LINE]\n[STX]0R|3|3^LEU|100^2+|/ul||||||supervisor[CR][ETX]D2[LINE]\n[STX]1C|3|I|C|I[CR][ETX]7C[LINE]\n[STX]2R|4|4^NIT|neg^neg|||||||supervisor[CR][ETX]51[LINE]\n[STX]3C|4|I|C|I[CR][ETX]7F[LINE]\n[STX]4R|5|5^PRO|neg^neg|||||||supervisor[CR][ETX]5B[LINE]\n[STX]5C|5|I|C|I[CR][ETX]82[LINE]\n[STX]6R|6|6^GLU|norm^neg|||||||supervisor[CR][ETX]D8[LINE]\n[STX]7C|6|I|C|I[CR][ETX]85[LINE]\n[STX]0R|7|7^KET|15^2+|mg/dl||||||supervisor[CR][ETX]70[LINE]\n[STX]1C|7|I|C|I[CR][ETX]80[LINE]\n[STX]2R|8|8^UBG|norm^neg|||||||supervisor[CR][ETX]CE[LINE]\n[STX]3C|8|I|C|I[CR][ETX]83[LINE]\n[STX]4R|9|9^BIL|neg^neg|||||||supervisor[CR][ETX]49[LINE]\n[STX]5C|9|I|C|I[CR][ETX]86[LINE]\n[STX]6R|10|10^ERY|neg^neg|||||||supervisor[CR][ETX]B4[LINE]\n[STX]7C|10|I|C|I[CR][ETX]B0[LINE]\n[STX]0R|11|11^COL|amber|||||||supervisor[CR][ETX]D3[LINE]\n[STX]1C|11|I|C|I[CR][ETX]AB[LINE]\n[STX]2R|12|12^CLA||||||||supervisor[CR][ETX]C2[LINE]\n[STX]3M|1|RC|52640916|20250930|54510901|20220831|||[CR][ETX]13[LINE]\n[STX]4L|1|N[CR][ETX]07[LINE]\n[EOT]\n";
        String[] linhas = linha.split("\n");
        String mensagem = "Enviar a linha: ";
        int contador = 0;
        for (String s : linhas) {
            mensagem = mensagem + String.valueOf(contador++) + ") " + s + "\n";
        }
        String op = JOptionPane.showInputDialog(mensagem);
        if (!Funcoes.textoVazio(op) && Funcoes.isNumeric(op)) {
            this.parse(this.equipamento.arruma(linhas[Integer.parseInt(op)]));
        }
    }
}

