/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.uriscansuper;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.uriscanpro2.InterfaceListener {
    Map<String, String> camposDecimais = new HashMap<String, String>();

    public InterfaceListener() {
        Statement st = Conexao.getStatement();
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
        this.camposDecimais.put("SAN", "BLD2");
        this.camposDecimais.put("BIL", "BIL2");
        this.camposDecimais.put("URO", "URO2");
        this.camposDecimais.put("CET", "KET2");
        this.camposDecimais.put("PRO", "PRO2");
        this.camposDecimais.put("NIT", "NIT2");
        this.camposDecimais.put("GLI", "GLU2");
        this.camposDecimais.put("p.H", "PH2");
        this.camposDecimais.put("DEN", "SG2");
        this.camposDecimais.put("LEU", "LEU2");
        this.camposDecimais.put("VTC", "VTC2");
    }

    @Override
    public synchronized String parse(String message) {
        String retorno = null;
        Object checksum = null;
        if (!message.startsWith(this.getMsgStart()) || !message.endsWith(this.getMsgEnd())) {
            return "Erro ao receber o bloco de resultados, caracter inicial ou final n\u00e3o localizado";
        }
        if (message.startsWith(this.getMsgStart())) {
            message = message.replaceFirst(this.getMsgStart(), "");
        }
        if (message.endsWith(this.getMsgEnd())) {
            message = message.replaceFirst(this.getMsgEnd(), "");
        }
        ArrayList<String> fields = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(message, new String(new char[]{'\r', '\n'}));
        while (tokenizer.hasMoreElements()) {
            fields.add(tokenizer.nextToken());
        }
        if (fields != null && !fields.isEmpty()) {
            try {
                retorno = this.parseResults(fields);
                if (retorno == null) {
                    return "";
                }
                if (retorno.startsWith("Erro")) {
                    return retorno;
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, 2000);
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao anular os dados recebidos";
                }
            }
        }
        return "Erro ao realizar parse dos dados recebidos";
    }

    private String parseResults(ArrayList<String> fields) throws SQLException {
        try {
            String[] codigoJalis;
            String DATA = "Data:";
            String DATA_INGLES = "Date:";
            String ID_NO = "ID_NO:";
            String ENFERMARIA = "Emfermaria :";
            String ENFERMARIA_INGLES = "Ward :";
            String NOME = "Nome :";
            String NOME_INGLES = "Name :";
            int INDEX_COPIA = 5;
            boolean pesquisar = true;
            String data = "";
            String id_no = "";
            String requisicao = "";
            String ward = "";
            String name = "";
            while (pesquisar && fields.size() > 0) {
                if (fields.get(0).indexOf("Data:") > -1 || fields.get(0).indexOf("Date:") > -1) {
                    data = fields.get(0).substring(5);
                } else if (fields.get(0).indexOf("ID_NO:") > -1) {
                    id_no = fields.get(0).substring(6);
                    requisicao = fields.get(0).substring(fields.get(0).indexOf("-") + 1);
                    if (Funcoes.textoVazio(requisicao)) {
                        fields.remove(0);
                        requisicao = fields.get(0).trim();
                    }
                } else if (fields.get(0).indexOf("Emfermaria :") > -1 || fields.get(0).indexOf("Ward :") > -1) {
                    String tmp = fields.get(0);
                    int pos = tmp.indexOf(":");
                    if (pos < tmp.length()) {
                        ward = tmp.substring(pos);
                    }
                } else if (fields.get(0).indexOf("Nome :") > -1 || fields.get(0).indexOf("Name :") > -1) {
                    name = fields.get(0).substring(5);
                    pesquisar = false;
                }
                fields.remove(0);
            }
            if (Funcoes.textoVazio(requisicao) || !Funcoes.isNumeric(requisicao)) {
                this.fireExcecaoEncontrada("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o localizado nos dados recebidos");
                return null;
            }
            Statement st = Conexao.getStatement();
            requisicao = StringUtil.preencheString(requisicao.trim(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            this.fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = requisicao.substring(requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, "URI");
            if (this.int_codigo == null) {
                this.fireExcecaoEncontrada(String.format("Exame n\u00e3o localizado nos dados recebidos para a requisicao %s %s %s ", this.fil_codigo, this.req_codigo, this.rec_codigo));
                return null;
            }
            System.out.println(this.fil_codigo + " " + this.req_codigo + " " + this.rec_codigo + " " + this.int_codigo);
            HashMap<String, Object> urina = new HashMap<String, Object>();
            for (String s : fields) {
                if (Funcoes.textoVazio(s)) continue;
                if (s.length() < 5) {
                    this.fireExcecaoEncontrada("Mensagem com tamanho menor que o necess\u00e1rio. \"" + s + "\" - " + this.fil_codigo + " " + this.req_codigo + " " + this.rec_codigo + " " + this.int_codigo);
                }
                String campo = s.substring(0, 5).trim();
                int ultimaColuna = s.length() > 15 ? 15 : s.length();
                int dif = 0;
                if (s.indexOf("COL") > -1 || s.indexOf("ASP") > -1 || s.indexOf("CLA") > -1) {
                    campo = s.substring(0, 4).trim();
                    dif = 1;
                }
                String resultado = s.substring(5 - dif, ultimaColuna).trim();
                String campoTraduzido = campo;
                if (campo.equals("BLD")) {
                    campoTraduzido = "SAN";
                } else if (campo.equals("BIL")) {
                    campoTraduzido = "BIL";
                } else if (campo.equals("URO")) {
                    campoTraduzido = "URO";
                } else if (campo.equals("KET")) {
                    campoTraduzido = "CET";
                } else if (campo.equals("PRO")) {
                    campoTraduzido = "PRO";
                } else if (campo.equals("NIT")) {
                    campoTraduzido = "NIT";
                } else if (campo.equals("GLU")) {
                    campoTraduzido = "GLI";
                } else if (campo.equals("pH")) {
                    campoTraduzido = "p.H";
                } else if (campo.equals("S.G")) {
                    campoTraduzido = "DEN";
                } else if (campo.equals("LEU")) {
                    campoTraduzido = "LEU";
                } else if (campo.equals("VTC")) {
                    campoTraduzido = "VTC";
                } else if (campo.equals("COL")) {
                    campoTraduzido = "COL";
                } else if (campo.equals("CLA")) {
                    campoTraduzido = "ASP";
                } else if (campo.equals("UBG")) {
                    campoTraduzido = "UBG";
                }
                String resultadoDecimal = resultado.replaceAll("[a-zA-Z]", "");
                if (Funcoes.isNumeric(resultadoDecimal) && this.camposDecimais.containsKey(campoTraduzido) && !this.camposDecimais.get(campoTraduzido).equalsIgnoreCase("SG2")) {
                    urina.put(this.camposDecimais.get(campoTraduzido), resultadoDecimal.replace('.', ','));
                }
                urina.put(campoTraduzido, resultado);
            }
            ExameMaterial exame = this.getReqExameLIS(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo, "URI");
            if (exame == null) {
                this.fireExcecaoEncontrada("Nenhum exame localizado nos dados recebidos");
                return null;
            }
            String exa_codigo = exame.getNomeExame();
            String mco_codigo = exame.getCodigoMaterial();
            if (this.exr_codigoapoiado && !Funcoes.textoVazio((codigoJalis = BDUtil.getCodigoJalis(this.fil_codigo, this.req_codigo, this.rec_codigo, this.int_codigo, exa_codigo, mco_codigo))[0]) && !Funcoes.textoVazio(codigoJalis[1]) && !Funcoes.textoVazio(codigoJalis[2])) {
                this.fil_codigo = codigoJalis[0];
                this.req_codigo = codigoJalis[1];
                this.rec_codigo = codigoJalis[2];
            }
            this.atualizarDadosExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exa_codigo, mco_codigo, this.int_codigo, urina);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }
}

