/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.uniceldxi;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.uniceldxi.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class InterfaceListener
extends InterfaceASTMListener {
    protected int MAX_PATIENT_NAME_CHARS = 30;
    protected int MAX_EXAMES = 10;
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean hostQuery = false;
    protected boolean hostQueryVazio = false;
    boolean exr_codigoapoiado = false;

    public InterfaceListener() {
        Statement st = Conexao.getStatement();
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        record.setPossuiCodigoApoiado(this.exr_codigoapoiado);
        super.setASTMRecordParser(record);
        this.INSTRUMENT_NAME = "Access";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        if (acao.equals("A")) {
            Statement st = Conexao.getStatement();
            try {
                String[] stringArray = exames.split(" ");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String exame;
                    int sitAtual = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame = stringArray[i], mcoCodigo, recCodigo);
                    this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame, mcoCodigo, intCodigo, null, sitAtual < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return null;
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            starting_range = starting_range.substring(1);
            if (starting_range.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                return;
            }
            this.host_fil_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboFilial());
            starting_range = starting_range.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = starting_range.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
            this.hostQueryVazio = false;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Access: Host Query Response");
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String rack = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = "";
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.hostQueryVazio = false;
                String codigoApoiado = "";
                if (this.exr_codigoapoiado) {
                    String filial;
                    String temp;
                    String string = aba.getColIndice("C\u00f3digo") >= 0 ? (String)req[aba.getColIndice("C\u00f3digo")] : (temp = null);
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        String string2 = aba.getColIndice("C\u00f3digo Temp.") >= 0 ? (String)req[aba.getColIndice("C\u00f3digo Temp.")] : (temp = null);
                    }
                    if (!fil_codigo.equalsIgnoreCase(filial = temp.substring(0, ParametrosGerais.getDigitosTuboFilial()))) {
                        String[] exames;
                        for (String exame : exames = pac_exames.toString().trim().split(" ")) {
                            String[] codigoJalis = BDUtil.getCodigoJalis(fil_codigo, req_codigo, rec_codigo, int_codigo, exame, mco_codigo);
                            if (codigoJalis == null || Funcoes.textoVazio(codigoJalis[0])) continue;
                            codigoApoiado = String.format("%s%s%s", fil_codigo, req_codigo, rec_codigo);
                            DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(codigoApoiado);
                            if (dce == null) break;
                            fil_codigo = Funcoes.preencheZero(dce.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                            req_codigo = Funcoes.preencheZero(dce.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                            rec_codigo = Funcoes.preencheZero(dce.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                            break;
                        }
                    }
                }
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.trim(), acao, codigoApoiado);
            } else {
                this.hostQueryVazio = true;
                this.fireExcecaoEncontrada(String.format("Solicita\u00e7\u00e3o do aparelho para a amostra %s %s %s n\u00e3o encontrada ou j\u00e1 se encontra conferido ", fil_codigo, req_codigo, rec_codigo));
                this.enviarRequisicaoSemExame(fil_codigo, req_codigo);
            }
            this.hostQuery = false;
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Access: Host Query Response");
        }
    }

    private String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, String codigoApoiado) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            if (!Funcoes.textoVazio(codigoApoiado)) {
                codigo.setLength(0);
                codigo.append(codigoApoiado);
            } else {
                rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
                codigo.append(rec_codigo);
            }
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            String nome = short_name;
            String sobrenome = null;
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String patient_id = req_codigo;
            String laboratory_pid = null;
            this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(ASTMStandard.getDefaultOrderRecord(1, codigo.toString(), alternativos, exa_lista, null, "R", acao, tipo_amostra, "O"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (!this.hostQueryVazio) {
            super.encerrarTransmissao();
        } else {
            this.interromperTimer();
            this.limpaDadosRequisicao();
            this.getPortaCOM().write(String.valueOf('\u0004'));
            this.getPortaCOM().clearInputString();
            this.setIdle();
        }
        this.hostQueryVazio = false;
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("F"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        StringBuilder msg = new StringBuilder();
        if (!Funcoes.textoVazio(erro)) {
            String[] erros;
            for (String e : erros = erro.split(";")) {
                if (e.equalsIgnoreCase("CEX")) {
                    msg.append("Curve expired.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("CRH")) {
                    msg.append("Result higher than critical (panic) reference range.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("CRL")) {
                    msg.append("Result lower than critical (panic) reference range.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("EDT")) {
                    msg.append("Result edit (currently unused).\t");
                    continue;
                }
                if (e.equalsIgnoreCase("GRY")) {
                    msg.append("Qualitative result in gray zone.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("IND")) {
                    msg.append("Result is indeterminant.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("LEX")) {
                    msg.append("Lot expired.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("LOW")) {
                    msg.append("Result lower than the minimum reportable result.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("NCR")) {
                    msg.append("No curve.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("NRV")) {
                    msg.append("Insufficient reagent, reaction vessels, wash, substrate, waste, or reaction vessel waste.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("OLD")) {
                    msg.append("Sample old.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("ORH")) {
                    msg.append("Result higher than normal reference range.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("ORL")) {
                    msg.append("Result lower than normal reference range.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("OVR")) {
                    msg.append("Result out of range of curve.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("PEX")) {
                    msg.append("Pack expired.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("QCF")) {
                    msg.append(" Control is outside QC limits.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("QEX")) {
                    msg.append(" Control lot expired.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("QNS")) {
                    msg.append(" Quantity not sufficient.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("RLU")) {
                    msg.append(" Relative light unit (RLU) value is outside of the acceptable luminometer measuring range.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("SYS")) {
                    msg.append(" Instrument error.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("TMP")) {
                    msg.append(" One or more of the following is outside the temperature specification: Incubator, wash/read carousel, substrate, reagent.\t");
                    continue;
                }
                if (e.equalsIgnoreCase("UNR")) {
                    msg.append(" The measured sample signal (RLU) is less than an RLU threshold limit for the least concentrated calibrator or calibration control for a positive slope assay, or is greater than the least concentrated calibrator for a negative slope assay, as defined in the assay protocol file.\t");
                    continue;
                }
                if (!e.equalsIgnoreCase("WVL")) continue;
                msg.append(" Quality control sample result was generated using a different reagent vial lot number than the vial lot number used to calibrate the assay.\t");
            }
        }
        return msg.toString();
    }

    @Override
    public void teste() {
        this.recebeResultado();
    }

    private void recebeResultado() {
        String req = "";
        req = "010006446504";
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||ACCESS^603484|||||LIS||P|1|20180327184129[CR][ETX]37[CR][LF]"));
        this.parse(this.equipamento.arruma("[STX]2P|1|201026[CR][ETX]E6[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3O|1|" + req + "|^10^1|^^^GToxo^1|||||||||||Serum||||||||||F[CR][ETX]09[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|1|^^^GToxo^1|2.6^Non-React.|IU/mL||N||F||||20180327184145|603484[CR][ETX]37[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5C|1|I|CEX|I[CR][ETX]1B[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6L|1|F[CR][ETX]01[LINE]"));
    }

    private void recebeQuery() {
        String req = "";
        req = "9026939904";
        this.parse(this.equipamento.arruma("[STX]1H|\\^&[CR][ETX]61[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2Q|1|^" + req + "||ALL||||||||O[CR][ETX]07[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3L|1|N[CR][ETX]06[LINE]"));
        this.handShakeCharReceived('\u0004');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
    }
}

