/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.uniceldxh800;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    private static Map<String, String> exameCamposByTestId;
    private static HashMap<String, String> exameCamposByFlag;
    private static List<String> listaFlags;

    public RecordParser() {
        exameCamposByTestId = new HashMap<String, String>();
        exameCamposByTestId.put("WBC", "leucocitos");
        exameCamposByTestId.put("UWBC", "leucocitos");
        exameCamposByTestId.put("RBC", "rbc");
        exameCamposByTestId.put("HGB", "hgb");
        exameCamposByTestId.put("HCT", "hct");
        exameCamposByTestId.put("MCV", "vcm");
        exameCamposByTestId.put("MCH", "hcm");
        exameCamposByTestId.put("MCHC", "chcm");
        exameCamposByTestId.put("@LHD", "");
        exameCamposByTestId.put("RDW", "rdw");
        exameCamposByTestId.put("@MAF", "");
        exameCamposByTestId.put("RDW-SD", "rdw_sd");
        exameCamposByTestId.put("PLT", "plaquetas");
        exameCamposByTestId.put("MPV", "plaquetas_lcc");
        exameCamposByTestId.put("PCT", "pct");
        exameCamposByTestId.put("PDW", "pdw");
        exameCamposByTestId.put("NE", "neutrofilo_percentual");
        exameCamposByTestId.put("LY", "linfocitos_tipicos_percentual");
        exameCamposByTestId.put("MO", "monocitos_percentual");
        exameCamposByTestId.put("EO", "eosinofilos_percentual");
        exameCamposByTestId.put("BA", "basofilos_percentual");
        exameCamposByTestId.put("@EGC", "");
        exameCamposByTestId.put("NE#", "neutrofilo_contagem");
        exameCamposByTestId.put("LY#", "linfocitos_tipicos_contagem");
        exameCamposByTestId.put("MO#", "monocitos_contagem");
        exameCamposByTestId.put("EO#", "eosinofilos_contagem");
        exameCamposByTestId.put("BA#", "basofilos_contagem");
        exameCamposByTestId.put("@EGC#", "");
        exameCamposByTestId.put("NRBC", "");
        exameCamposByTestId.put("NRBC#", "");
        exameCamposByTestId.put("@WDOP", "");
        exameCamposByTestId.put("@WNOP", "");
        exameCamposByTestId.put("RET", "reticulocitos_contagem");
        exameCamposByTestId.put("RET#", "reticulocitos_percentual");
        exameCamposByTestId.put("MRV", "");
        exameCamposByTestId.put("IRF", "");
        exameCamposByTestId.put("@MSCV", "");
        exameCamposByTestId.put("@HLR", "");
        exameCamposByTestId.put("@HLR#", "");
        exameCamposByTestId.put("@UGC", "");
        exameCamposByTestId.put("@RSF", "");
        exameCamposByTestId.put("@RDWR", "");
        exameCamposByTestId.put("@RDWR-SD", "");
        exameCamposByTestId.put("@WROP", "");
        exameCamposByTestId.put("@UWROP", "");
        exameCamposByFlag = new HashMap();
        exameCamposByFlag.put("E", "Parameter result edited flag");
        exameCamposByFlag.put("e", "Parameter result has been recalculated based on an edited result");
        exameCamposByFlag.put("M", "Parameter result amended flag");
        exameCamposByFlag.put("m", "Parameter result has been recalculated based on an amended result");
        exameCamposByFlag.put("R", "Review flag");
        exameCamposByFlag.put("+", "Result is higher than analytical measuring range high limit");
        exameCamposByFlag.put("-", "Result is lower than analytical measuring range low limit");
        exameCamposByFlag.put("H", "Result is higher than operator defined reference range");
        exameCamposByFlag.put("L", "Result is lower than operator defined reference range");
        exameCamposByFlag.put("P", "Partial Aspiration flag");
        exameCamposByFlag.put("N", "Non-Blood Specimen detected.");
        exameCamposByFlag.put("D", "Delta flag");
    }

    @Override
    public void recordFound(String record) throws Exception {
        String record_type = ASTMStandard.getRecordTypeIdentifier(record);
        if (record_type != null) {
            if (record_type.equals(ASTMStandard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_RESULT)) {
                this.trataResultRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return;
            }
        }
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String int_codigo = (String)this.exame_atual.get(INT_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String campoFlag = this.parseCampoFlag((String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE));
        campoFlag = campoFlag.substring(campoFlag.lastIndexOf("!") + 1);
        String campoHemog = this.parseCampoHemograma((String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID));
        String resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        String[] flagsResult = resultado.split("!");
        resultado = flagsResult[0].trim();
        String flags = flagsResult.length > 1 ? flagsResult[1].trim() : "";
        if ((resultado = resultado.replaceAll("\\.", ",")).startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.endsWith(",")) {
            resultado = resultado + "0";
        }
        if (campoHemog != null && !campoHemog.trim().isEmpty()) {
            this.exame_atual.put(campoHemog, resultado);
            if (flags != null && !flags.trim().isEmpty() && !Funcoes.textoVazio(campoFlag)) {
                String[] flagsAux;
                for (String f : flagsAux = campoFlag.split(" ")) {
                    String tipo = exameCamposByFlag.get(f);
                    if (Funcoes.textoVazio(tipo)) continue;
                    listaFlags.add(campoHemog + " - " + tipo);
                }
            }
        }
    }

    @Override
    protected void trataTerminationRecord() throws Exception {
        if (this.exame_atual == null) {
            return;
        }
        String fil_codigo = (String)this.exame_atual.remove(FIL_CODIGO);
        String int_codigo = (String)this.exame_atual.remove(INT_CODIGO);
        String req_codigo = (String)this.exame_atual.remove(REQ_CODIGO);
        String exa_codigo = (String)this.exame_atual.remove(EXA_CODIGO);
        String mco_codigo = (String)this.exame_atual.remove(MCO_CODIGO);
        String rec_codigo = (String)this.exame_atual.remove(REC_CODIGO);
        this.exame_atual.remove(ACTION_CODE);
        this.exame_atual.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, this.exame_atual, listaFlags);
        this.exame_atual = null;
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        String[] flagID = req_codigo.split("!");
        if (flagID.length > 0) {
            req_codigo = flagID[0];
        }
        if (req_codigo.contains("^")) {
            req_codigo = req_codigo.substring(0, req_codigo.indexOf("^"));
        }
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        listaFlags = new ArrayList<String>();
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        String emi_alternativo = components.get(this.equip.TEST_ID).replace("!", "");
        Statement st = Conexao.getStatement();
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
    }

    private String parseCampoHemograma(String campo) {
        String testId = campo.substring(campo.indexOf("!") + 3, campo.lastIndexOf("!"));
        return exameCamposByTestId.get(testId);
    }

    private String parseCampoFlag(String campo) {
        String campoFlag = campo.substring(campo.lastIndexOf("!") + 1);
        return campoFlag;
    }
}

