/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.uniceldxh800;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.uniceldxh800.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean hostQuery = false;

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            if (rackposition != null && rackposition.length() == 12) {
                codigo.setLength(0);
                codigo.append(rackposition);
            }
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            String nome = null;
            String sobrenome = short_name;
            StringBuilder buf = new StringBuilder();
            buf.append("H|\\!~||||||||||P|LIS2-A|").append(Funcoes.formataData("yyyyMMddHHmmss", Funcoes.getDataHoraServidor())).append('\r');
            this.tx_list.add(buf.toString());
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String patient_id = req_codigo;
            String laboratory_pid = null;
            String pac_nascimento = "";
            String med_nome = "";
            String idade = "";
            String[] idadeNasc = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
            if (idadeNasc[2] != null && !idadeNasc[2].trim().isEmpty()) {
                Date nascimento = Funcoes.stringToDate(idadeNasc[2]);
                pac_nascimento = Funcoes.formataData("yyyyMMdd", nascimento);
                idade = idadeNasc[0];
            } else if (idadeNasc[0] != null && !idadeNasc[0].trim().isEmpty() && idadeNasc[1] != null) {
                Date dataReq = Funcoes.stringToDate("dd/MM/yyyy", this.req_data);
                int calendarField = 5;
                if (idadeNasc[1].equalsIgnoreCase("A")) {
                    calendarField = 1;
                } else if (idadeNasc[1].equalsIgnoreCase("M")) {
                    calendarField = 2;
                }
                GregorianCalendar nascimento = new GregorianCalendar();
                nascimento.setTime(dataReq);
                ((Calendar)nascimento).add(calendarField, -Integer.parseInt(idadeNasc[0]));
                pac_nascimento = Funcoes.formataData("yyyyMMdd", nascimento.getTime());
            }
            this.tx_list.add(this.getPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo, pac_nascimento, med_nome, idade));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro do paciente");
            }
            this.tx_list.add(this.getOrderRecord(1, codigo.toString(), alternativos, exa_lista, null, "R", acao, tipo_amostra, "O"));
            this.tx_list.add("C|1|L||I\r");
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da coment\u00e1rio");
            }
            this.tx_list.add("L|1|N\r");
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String laboratory_pid, String pac_nome, String pac_sobrenome, String pac_sexo, String pac_nascimento, String med_nome, String idade) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("||");
        record.append(patient_id == null ? "" : patient_id);
        record.append("||");
        record.append(pac_sobrenome == null ? "" : pac_sobrenome.replaceAll(" ", "!"));
        record.append(pac_nome == null ? "!" : "" + pac_nome.replaceAll("[SP]", "!"));
        record.append("||");
        record.append(pac_nascimento == null ? "" : pac_nascimento);
        record.append("!").append(idade).append("!Y|").append(pac_sexo).append("|H||||");
        record.append("!!!!|||||");
        record.append("|||||||");
        record.append('\r');
        return record.toString();
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                String retorno = this.parse(message);
                this.getPortaCOM().write(retorno.startsWith("Erro") ? String.valueOf('\u0015') : String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private String getOrderRecord(int order_sequence, String sample_id, ExameMaterial[] test_item_numbers, ExameMaterial[] test_item_names, String dilution, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("||");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            for (int i = 0; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null) continue;
                if (i > 0) {
                    record.append("\\");
                }
                record.append("!!!");
                record.append(Funcoes.textoVazio(test_item_numbers[i].getNomeExame()) ? "CD" : test_item_numbers[i].getNomeExame());
                record.append(dilution == null ? "" : "^" + dilution);
            }
        }
        record.append("|").append(priority);
        record.append("||||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||");
        record.append(sample_type == null ? "" : sample_type);
        record.append("||||||||||F");
        record.append('\r');
        return record.toString();
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    message = (String)this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                this.rx_list.add(message);
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    String[] records;
                    String recordsString = (String)this.rx_list.remove(0);
                    recordsString = recordsString.substring(1, recordsString.length() - 1);
                    for (String record : records = recordsString.split("\r")) {
                        if (record.trim().isEmpty()) continue;
                        this.recordParser.recordFound(record);
                    }
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            if (Funcoes.textoVazio(starting_range)) {
                return;
            }
            if (starting_range.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                return;
            }
            this.host_fil_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboFilial());
            starting_range = starting_range.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = starting_range.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "CellDyn Ruby: Host Query Response");
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void responseHostQuery() {
        try {
            fil_codigo = this.host_fil_codigo;
            req_codigo = this.host_req_codigo;
            rec_codigo = this.host_rec_codigo;
            pac_nome = null;
            pac_sexo = null;
            pac_idade = null;
            data = null;
            hora = null;
            rack = null;
            prioridade = null;
            int_codigo = null;
            mco_codigo = null;
            pac_exames = null;
            acao = "A";
            req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames.trim();
                }
            }
            if (req == null) {
                return;
            }
            if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                    requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        requisicao = (String)req[aba.getColIndice("Multiguia")];
                    }
                    filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
                    tubo = (String)req[aba.getColIndice("Tubo")];
                    tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
                    fil_codigo = filial;
                    req_codigo = requisicao;
                    rec_codigo = tubo;
                }
            }
            pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
            pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
            data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
            hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
            if (req[aba.getColIndice("Cod. Apoiado")] == null) ** GOTO lbl-1000
            if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
            } else lbl-1000:
            // 2 sources

            {
                rack = (String)req[aba.getColIndice("Cod. Apoiado")];
            }
            int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
            mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
            this.hostQuery = false;
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "CellDyn Ruby: Host Query Response");
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            Statement st = Conexao.getStatement();
            if (this.exames != null) {
                for (int i = 0; i < this.exames.length; ++i) {
                    int situacao;
                    if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                        for (String exame : this.examesFilho) {
                            int situacao2 = BDUtil.getDesmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, exame, this.mco_codigo);
                            BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, this.mco_codigo, this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                        }
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        if (!BDUtil.isGrupoInteiroPendente(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai)) continue;
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    if (!this.examesFilho.isEmpty()) {
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                        BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                    this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
            } else {
                this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
            }
        }
        this.interromperTimer();
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.getPortaCOM().clearInputString();
        this.fireAtualizarTabela();
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.limpaDadosRequisicao();
        this.setIdle();
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "Resultado", "ENQ", "ACK"}, null);
        switch (op) {
            case 0: {
                this.testeQuery();
                break;
            }
            case 1: {
                this.testeResultado();
                break;
            }
            case 2: {
                this.handShakeCharReceived('\u0005');
                break;
            }
            case 3: {
                this.handShakeCharReceived('\u0006');
            }
        }
    }

    private void testeResultado() {
        StringBuilder buf = new StringBuilder();
        String tubo = JOptionPane.showInputDialog("Informe o tubo");
        buf.append("[STX]1H|\\!~|||DxH[SP]500!01|||||||P|LIS2-A2|20170602094055[CR][ETX]DE[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]3O|1|").append(tubo).append("||!!!CBC+DIFF|R||||||A||||||||||||||F[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]4R|1|!!!WBC!33256-9|15.4!R|g/dL||13.6 to 17.2|||F||System||20120406125959|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]5R|2|!!!RBC!789-8|5.37!R H |10^6/uL|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]6R|3|!!!HGB!718-7|13.7! H |g/dL|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]7R|4|!!!HCT!4544-3|42.9!R H |%|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]8R|5|!!!MCV!787-2|79.9!R L |fL|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]9R|6|!!!MCH!785-6|25.5!R L |pg|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]10R|7|!!!MCHC!786-4|31.9!R L |g/dL|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]11R|8|!!!RDW!788-0|13.9!R |%|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]12R|9|!!!RDW-SD!21000-5|41.1!R |fL|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]13R|10|!!!PLT!777-3|361!R L |10^3/uL|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]14R|11|!!!MPV!32623-1|8.7!R |fL|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]15R|12|!!!@PCT!X-PCT|0.314!R L |%|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]16R|13|!!!@PDW!32207-3|16.1!R H | |||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]17R|14|!!!NE!770-8|52.0!R L |%|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]18R|15|!!!LY!736-9|33.6!R H |%|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]19R|16|!!!MO!5905-5|9.6!R L |%|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]20R|17|!!!EO!713-8|3.2!R |%|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]21R|18|!!!BA!706-2|1.6!R H |%|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]22R|19|!!!NE#!751-8|2.8!R L |10^3/uL|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]23R|20|!!!LY#!731-0|1.8!R |10^3/uL|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]24R|21|!!!MO#!742-7|0.5!R L |10^3/uL|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]25R|22|!!!EO#!711-2|0.2!R |10^3/uL|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]26R|23|!!!BA#!704-7|0.1!R |10^3/uL|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]27R|24|!!!NRBC!34200-6|0.2! L |/100WBC|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]28R|25|!!!NRBC#!771-6|0.01!R L |10^3/uL|||A||F||||20080925093226|AM44001[CR][ETX]72[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]5L|1|N[CR][ETX]08[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        try {
            this.tratarEndOfTX();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void testeQuery() {
        StringBuilder buf = new StringBuilder();
        String tubo = JOptionPane.showInputDialog("Informe o tubo");
        buf.append("[STX]1H|\\!~|||DxH[SP]500!01|||||||P|LIS2-A2|20170602094055[CR][ETX]DE[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]2Q|1|").append(tubo).append("||ALL||||||||O[CR][ETX]DE[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        buf.append("[STX]5L|1|N[CR][ETX]08[LINE]");
        this.getPortaCOM().read(this.equipamento.arruma(buf.toString()), buf.toString().length());
        buf.delete(0, buf.toString().length());
        try {
            this.tratarEndOfTX();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }
}

