/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.u500;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.uriscanpro2.InterfaceListener {
    @Override
    public synchronized String parse(String message) {
        String retorno = null;
        Object checksum = null;
        if (!message.startsWith(this.getMsgStart()) || !message.endsWith(this.getMsgEnd())) {
            return "Erro ao receber o bloco de resultados, caracter inicial ou final n\u00e3o localizado";
        }
        if (message.startsWith(this.getMsgStart())) {
            message = message.replaceFirst(this.getMsgStart(), "");
        }
        if (message.endsWith(this.getMsgEnd())) {
            message = message.replaceFirst(this.getMsgEnd(), "");
        }
        ArrayList<String> fields = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(message, new String(new char[]{'\r', '\n'}));
        while (tokenizer.hasMoreElements()) {
            fields.add(tokenizer.nextToken());
        }
        if (fields != null && !fields.isEmpty()) {
            try {
                retorno = this.parseResults(fields);
                if (retorno == null) {
                    return "";
                }
                if (retorno.startsWith("Erro")) {
                    return retorno;
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, 2000);
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao anular os dados recebidos";
                }
            }
        }
        return "Erro ao realizar parse dos dados recebidos";
    }

    private String parseResults(ArrayList<String> fields) throws SQLException {
        try {
            String[] codigoJalis;
            String DATA = "Data:";
            String DATA_INGLES = "Date:";
            String ID2 = "ID:";
            String ENFERMARIA = "Emfermaria:";
            String ENFERMARIA_INGLES = "Ward:";
            String NOME = "Nome:";
            String NOME_INGLES = "NAME:";
            int INDEX_COPIA = 5;
            int INDEX_REQUISICAO = 6;
            boolean pesquisar = true;
            String data = "";
            String id_no = "";
            String requisicao = "";
            String ward = "";
            String name = "";
            String requisicaoAux = "";
            while (pesquisar && fields.size() > 0) {
                if (fields.get(0).indexOf("Data:") > -1 || fields.get(0).indexOf("Date:") > -1) {
                    data = fields.get(0).substring(5);
                } else if (fields.get(0).indexOf("ID:") > -1) {
                    id_no = fields.get(0).substring(6, fields.get(0).indexOf("-"));
                    requisicao = fields.get(0).substring(fields.get(0).indexOf("-") + 1);
                    if (!Funcoes.textoVazio(requisicao)) {
                        requisicao = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo());
                    }
                    pesquisar = false;
                    if (Funcoes.textoVazio(requisicao)) {
                        fields.remove(0);
                        requisicao = fields.get(0).trim();
                    }
                } else if (fields.get(0).indexOf("Emfermaria:") > -1 || fields.get(0).indexOf("Ward:") > -1) {
                    String tmp = fields.get(0);
                    ward = tmp.substring(tmp.indexOf(":"));
                } else if (fields.get(0).indexOf("Nome:") > -1 || fields.get(0).indexOf("NAME:") > -1) {
                    name = fields.get(0).substring(5);
                    if (Funcoes.textoVazio(requisicao)) {
                        requisicaoAux = fields.get(0).substring(6);
                    }
                }
                fields.remove(0);
            }
            requisicao = requisicaoAux;
            int tamTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            if (Funcoes.textoVazio(requisicao) || !Funcoes.isNumeric(requisicao) || requisicao.length() < tamTubo) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o localizado nos dados recebidos. Requisi\u00e7\u00e3o: %s", requisicao));
                return null;
            }
            Statement st = Conexao.getStatement();
            requisicao = StringUtil.preencheString(requisicao.trim(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            this.fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = requisicao.substring(requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, "URI");
            System.out.println(this.fil_codigo + " " + this.req_codigo + " " + this.rec_codigo + " " + this.int_codigo);
            HashMap<String, Object> urina = new HashMap<String, Object>();
            urina.put("ID", requisicaoAux);
            for (String s : fields) {
                if (Funcoes.textoVazio(s)) continue;
                String campo = s.substring(0, 5).trim();
                int ultimaColuna = s.length();
                int dif = 0;
                if (s.indexOf("Col") > -1 || s.indexOf("Cla") > -1) {
                    campo = s.substring(0, 4).trim();
                    dif = 1;
                }
                String resultado = s.substring(5 - dif, ultimaColuna).trim();
                String campoTraduzido = campo;
                if (campo.contains("*")) {
                    campo = campo.replace("*", "");
                }
                if (campo.equals("BLD")) {
                    campoTraduzido = "SAN";
                } else if (campo.equalsIgnoreCase("BIL")) {
                    campoTraduzido = "BIL";
                } else if (campo.equalsIgnoreCase("URO")) {
                    campoTraduzido = "URO";
                } else if (campo.equalsIgnoreCase("KET")) {
                    campoTraduzido = "CET";
                } else if (campo.equalsIgnoreCase("PRO")) {
                    campoTraduzido = "PRO";
                } else if (campo.equalsIgnoreCase("NIT")) {
                    campoTraduzido = "NIT";
                } else if (campo.equalsIgnoreCase("GLU")) {
                    campoTraduzido = "GLI";
                } else if (campo.equalsIgnoreCase("pH")) {
                    campoTraduzido = "p.H";
                    resultado = resultado.replaceAll("\\.", ",");
                } else if (campo.equalsIgnoreCase("SG")) {
                    campoTraduzido = "DEN";
                    resultado = resultado.replaceAll("\\.", ",");
                } else if (campo.equalsIgnoreCase("LEU")) {
                    campoTraduzido = "LEU";
                } else if (campo.equalsIgnoreCase("VTC")) {
                    campoTraduzido = "VTC";
                } else if (campo.equalsIgnoreCase("COL")) {
                    campoTraduzido = "COL";
                } else if (campo.equalsIgnoreCase("CLA")) {
                    campoTraduzido = "ASP";
                } else if (campo.equalsIgnoreCase("UBG")) {
                    campoTraduzido = "UBG";
                } else if (campo.equalsIgnoreCase("BLO")) {
                    campoTraduzido = "SAN";
                }
                urina.put(campoTraduzido, resultado);
            }
            ExameMaterial exame = this.getReqExameLIS(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo, "URI");
            if (exame == null) {
                this.fireExcecaoEncontrada(String.format("Nenhum exame localizado nos dados recebidos.  Requisi\u00e7\u00e3o: %s ", requisicao));
                return null;
            }
            String exa_codigo = exame.getNomeExame();
            String mco_codigo = exame.getCodigoMaterial();
            if (this.exr_codigoapoiado && !Funcoes.textoVazio((codigoJalis = BDUtil.getCodigoJalis(this.fil_codigo, this.req_codigo, this.rec_codigo, this.int_codigo, exa_codigo, mco_codigo))[0]) && !Funcoes.textoVazio(codigoJalis[1]) && !Funcoes.textoVazio(codigoJalis[2])) {
                this.fil_codigo = codigoJalis[0];
                this.req_codigo = codigoJalis[1];
                this.rec_codigo = codigoJalis[2];
            }
            this.atualizarDadosExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exa_codigo, mco_codigo, this.int_codigo, urina);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    @Override
    public void teste() {
        StringBuilder bui = new StringBuilder();
        bui.append(this.equipamento.arruma("[STX][LINE]"));
        bui.append(this.equipamento.arruma("[SP]2017[SP]NOV[SP]09[SP][SP][SP]09:02:56[LINE]"));
        bui.append(this.equipamento.arruma("[SP]NAME:123[LINE]"));
        bui.append(this.equipamento.arruma("[SP]ID:[SP][SP]0-0001[SP][SP][SP][SP][SP](00000052)[LINE]"));
        bui.append(this.equipamento.arruma("[SP]Col[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]Yellow[LINE]"));
        bui.append(this.equipamento.arruma("[SP]Cla[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]Clear[LINE]"));
        bui.append(this.equipamento.arruma("*LEU[SP][SP][SP][SP][SP][SP][SP][SP]2+[SP][SP]125Leu/uL[LINE]"));
        bui.append(this.equipamento.arruma("[SP]NIT[SP][SP][SP][SP][SP][SP][SP][SP][SP]-[SP][SP][SP][SP][SP][SP][SP][SP]neg[LINE]"));
        bui.append(this.equipamento.arruma("[SP]URO[SP][SP][SP][SP][SP][SP][SP][SP][SP]-[SP][SP][SP]0.2mg/dL[LINE]"));
        bui.append(this.equipamento.arruma("[SP]PRO[SP][SP][SP][SP][SP][SP][SP][SP][SP]-[SP][SP][SP][SP][SP][SP][SP][SP]neg[LINE]"));
        bui.append(this.equipamento.arruma("[SP]pH[SP][SP][SP][SP][SP][SP][SP][SP][SP]7.0[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][LINE]"));
        bui.append(this.equipamento.arruma("[SP]BLO[SP][SP][SP][SP][SP][SP][SP][SP][SP]-[SP][SP][SP][SP][SP][SP][SP][SP]neg[LINE]"));
        bui.append(this.equipamento.arruma("[SP]SG[SP][SP][SP][SP][SP][SP][SP][SP][SP]1.020[SP][SP][SP][SP][SP][SP][SP][SP][LINE]"));
        bui.append(this.equipamento.arruma("[SP]KET[SP][SP][SP][SP][SP][SP][SP][SP][SP]-[SP][SP][SP][SP][SP][SP][SP][SP]neg[LINE]"));
        bui.append(this.equipamento.arruma("[SP]BIL[SP][SP][SP][SP][SP][SP][SP][SP][SP]-[SP][SP][SP][SP][SP][SP][SP][SP]neg[CR]"));
        bui.append(this.equipamento.arruma("[LF]"));
        bui.append(this.equipamento.arruma("[SP]GLU[SP][SP][SP][SP][SP][SP][SP][SP][SP]-[SP][SP][SP][SP][SP][SP][SP][SP]neg[LINE]"));
        bui.append(this.equipamento.arruma("[ETX]"));
        this.parse(bui.toString());
    }
}

