/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.tosohhlc723RP;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.tosohhlc723RP.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final int TIME_OUT = 20000;
    private static final int TIME_RETRY = 5;
    private int tx_counter = 0;
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
    private ThreadRecebimento threadRecebimento = null;
    private DadosResultado dadosResultado = new DadosResultado();
    private Map<String, ArrayList<String>> parametrosAnalisador = new HashMap<String, ArrayList<String>>();
    private static final String FIL_CODIGO = "fil_codigo";
    private static final String REQ_CODIGO = "req_codigo";
    private static final String REC_CODIGO = "rec_codigo";
    private static final String INT_CODIGO = "int_codigo";
    private static final String EXA_CODIGO = "exa_codigo";
    private static final String MCO_CODIGO = "mco_codigo";
    private static final String PARAMETRO_TIPO_RECIPIENTE = "tipoRecipiente";
    private static final int GHB_RESULT_FORMAT_N3 = 78;
    private static final int GHB_RESULT_FORMAT_N5 = 80;
    private static final int GHB_RESULT_FORMAT_N8 = 83;
    private static final int PATIENT_FORMAT_N3 = 110;
    private static final int PATIENT_FORMAT_N5 = 112;
    private static final int PATIENT_FORMAT_N8 = 115;
    private HostResponseQuery hostResponseQuery = null;
    private boolean hostQuery = false;
    private InfoExameRequisicao dadosExameRequisicao = null;
    private String lastMsg = "";

    public InterfaceListener() {
        this.threadRecebimento = new ThreadRecebimento(this, 25);
        this.threadRecebimento.start();
        this.configurarParametros();
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.configuracao.getModoHostQuery();
        if (Funcoes.textoVazio(this.configuracao.getTamanhoDigitosAmostra())) {
            this.fireExcecaoEncontrada("Configura\u00e7\u00e3o do tamanho de dig\u00edtos da amostra n\u00e3o configurado, verifique as configura\u00e7\u00f5es de Interface no Jalis");
        } else if ("3;5;8".contains(this.configuracao.getTamanhoDigitosAmostra())) {
            this.fireExcecaoEncontrada(String.format("Configura\u00e7\u00e3o do tamanho de dig\u00edtos da amostra configurado errado [%s], valor deve ser 3, 5 ou 8 ", this.configuracao.getTamanhoDigitosAmostra()));
        }
    }

    private void configurarParametros() {
        this.parametrosAnalisador.put(TipoExame.STD_MODE.toString(), new ArrayList());
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("hlc723_percentual_h_fp");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("variant2_percentual_A1a");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("variant2_percentual_A1b");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("variant2_percentual_F");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("variant2_percentual_LA1c");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("variant2_percentual_SA1cIFCC");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("variant2_percentual_A0");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("Reserved1");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("Reserved2");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("variant2_percentual_total");
        this.parametrosAnalisador.put(TipoExame.VAR_MODE.toString(), new ArrayList());
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("variant2_percentual_A1a");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("variant2_percentual_A1b");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("variant2_percentual_F");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("variant2_percentual_LA1c");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("variant2_percentual_SA1cIFCC");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("variant2_percentual_A0");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("hlc723_percentual_h_v0");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("hlc723_percentual_h_v1");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("hlc723_percentual_h_v2");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("variant2_percentual_total");
        this.parametrosAnalisador.put(TipoExame.BETA_THALASSEMI_MODE.toString(), new ArrayList());
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("variant2_percentual_F");
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("variant2_percentual_A0");
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("variant2_percentual_A2");
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("variant2_percentual_D");
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("variant2_percentual_S");
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("variant2_percentual_C");
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("Reserved1");
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("Reserved2");
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("Reserved3");
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("Reserved4");
    }

    @Override
    public void dataChanged() {
        try {
            String message;
            this.setRX();
            this.lastMsg = message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (message.startsWith(this.getMsgStart()) && message.contains(this.getMsgEnd())) {
                int end = message.indexOf(this.getMsgEnd());
                if (end > 1) {
                    if (message.endsWith(this.getMsgEnd())) {
                        String checkSum = this.getPortaCOM().getInputString();
                        if (checkSum.length() == 1) {
                            message = message + this.getPortaCOM().removeInputString(checkSum);
                        } else if (checkSum.length() > 1) {
                            message = message + this.getPortaCOM().removeInputString(String.valueOf(checkSum.charAt(0)));
                        } else {
                            this.lastMsg = message;
                            this.aguardarProximoFrame();
                            return;
                        }
                    }
                    Thread.sleep(50L);
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    this.aguardarProximoFrame();
                    this.parse(message);
                    this.lastMsg = "";
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                }
            });
        }
    }

    @Override
    public String parse(String message) {
        String msg = message.substring(1, message.length() - 2);
        this.setIdle();
        int digitosAmostra = Integer.parseInt(this.configuracao.getTamanhoDigitosAmostra());
        digitosAmostra = this.pegaDigitosAmostra(msg, digitosAmostra);
        Integer tamanhoMensagem = msg.length();
        if (tamanhoMensagem == 24 && msg.charAt(0) == 'G') {
            this.parseQuery(msg);
        } else if (msg.length() == 110 || msg.length() == 112 || msg.length() == 115) {
            this.dadosResultado.patientInformation = new PatientInformation(msg);
        } else if (msg.length() == 78 || msg.length() == 80 || msg.length() == 83) {
            GHbResults ghbResults;
            this.dadosResultado.ghbResults = ghbResults = new GHbResults(msg, digitosAmostra);
            this.parseResultado(this.dadosResultado.ghbResults, this.dadosResultado);
            this.parse(this.dadosResultado);
        } else if (msg.length() == 56) {
            new ReservedRecord(msg);
        }
        return "Mensagem recebida com sucesso";
    }

    private int pegaDigitosAmostra(String message, int digitosAmostra) {
        if (message.length() == 78 || message.length() == 80 || message.length() == 83) {
            digitosAmostra = this.tipoMensagemResultado(message, digitosAmostra);
        } else if (message.length() == 110 || message.length() == 112 || message.length() == 115) {
            digitosAmostra = this.tipoMensagemPaciente(message, digitosAmostra);
        }
        return digitosAmostra;
    }

    private int tipoMensagemPaciente(String message, int digitosAmostra) {
        if (110 == message.length()) {
            digitosAmostra = 3;
        } else if (112 == message.length()) {
            digitosAmostra = 5;
        } else if (115 == message.length()) {
            digitosAmostra = 8;
        }
        return digitosAmostra;
    }

    private int tipoMensagemResultado(String message, int digitosAmostra) {
        if (78 == message.length()) {
            digitosAmostra = 3;
        } else if (80 == message.length()) {
            digitosAmostra = 5;
        } else if (83 == message.length()) {
            digitosAmostra = 8;
        }
        return digitosAmostra;
    }

    protected void aguardarProximoFrame() throws Exception {
        this.setRX(20000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this, 25);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0006': {
                    if (!Funcoes.textoVazio(this.lastMsg)) {
                        this.parse(this.lastMsg + '\u0006');
                        this.lastMsg = "";
                        break;
                    }
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    if (!Funcoes.textoVazio(this.lastMsg)) {
                        this.parse(this.lastMsg + '\u0015');
                        this.lastMsg = "";
                        break;
                    }
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0004': {
                    if (!Funcoes.textoVazio(this.lastMsg)) {
                        this.parse(this.lastMsg + '\u0004');
                        this.lastMsg = "";
                        break;
                    }
                    this.tratarEndOfTX();
                    break;
                }
                default: {
                    this.parse(this.lastMsg + c);
                    this.lastMsg = "";
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    this.caracterNaoEsperado(c);
                    break;
                }
            }
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                }
            });
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
            this.setIdle();
        }
    }

    private void tratarAcknowledge() throws SQLException {
        if (this.hostResponseQuery != null && this.dadosExameRequisicao != null) {
            this.encerrarTransmissao();
        }
    }

    private void caracterNaoEsperado(char c) {
    }

    private void tratarEndOfTX() throws SQLException {
        if (this.hostQuery && this.hostResponseQuery != null) {
            this.hostQuery = false;
            this.tx_counter = 0;
            this.enviaPaciente();
        }
        this.setIdle();
        this.interromperTimer();
    }

    private void enviaPaciente() {
        try {
            this.setTX(20000);
            this.getPortaCOM().write(this.empacotar(this.hostResponseQuery.enviaPaciente()));
        }
        catch (IOException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
            });
        }
    }

    private String empacotar(String mensagem) {
        StringBuilder frame = new StringBuilder();
        frame.append(this.getMsgStart());
        frame.append(mensagem);
        frame.append(this.getMsgEnd());
        frame.append(this.getBCC(frame.toString().substring(1)));
        return frame.toString();
    }

    private void encerrarTransmissao() throws SQLException {
        if (this.dadosExameRequisicao != null) {
            Statement st = Conexao.getStatement();
            String acaoEnvioAparelho = this.dadosExameRequisicao.getAcao();
            if (Funcoes.textoVazio(acaoEnvioAparelho)) {
                this.fireExcecaoEncontrada(String.format("Erro ao tentar mudar a situa\u00e7\u00e3o do exame fil_codigo = %s, req_codigo = %s, rec_codigo = %s, mco_codigo = %s, int_codigo = %s", this.dadosExameRequisicao.getFilial(), this.dadosExameRequisicao.getCodigo(), this.dadosExameRequisicao.getRecipiente(), this.dadosExameRequisicao.getMaterial(), this.dadosExameRequisicao.getInterface()));
            } else {
                this.atualizarSituacaoTubo(st, this.dadosExameRequisicao.getFilial(), this.dadosExameRequisicao.getCodigo(), this.dadosExameRequisicao.getRecipiente(), this.dadosExameRequisicao.getMaterial(), this.dadosExameRequisicao.getInterface(), acaoEnvioAparelho.equals("N") ? 1 : 3);
                Conexao.arquivaSQL();
                this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.dadosExameRequisicao.getNome() + ".", 0, 10000);
                if (Funcoes.textoVazio(acaoEnvioAparelho) || acaoEnvioAparelho.equals("N")) {
                    this.firePacienteEnviado(this.dadosExameRequisicao.getCodigo(), this.dadosExameRequisicao.getNome(), this.dadosExameRequisicao.getSexo(), this.dadosExameRequisicao.getIdade(), this.dadosExameRequisicao.getData(), this.dadosExameRequisicao.getHora(), this.dadosExameRequisicao.getExames());
                }
            }
        }
        this.fireAtualizarTabela(0);
        this.interromperTimer();
        this.setIdle();
        this.dadosExameRequisicao = null;
        this.hostResponseQuery = null;
    }

    private void tratarNegativeAck() throws IOException {
        if (this.isTX() && this.tx_counter < 5) {
            ++this.tx_counter;
            this.retransmistirRecusado();
            this.setTX(20000);
        } else if (this.tx_counter == 5 && this.hostResponseQuery != null) {
            this.fireExcecaoEncontrada(String.format("Tentativas de envio do paciente esgotadas verifique(%s)", this.hostResponseQuery.sampleId));
            this.hostResponseQuery = null;
            this.tx_counter = 0;
        } else if (this.hostResponseQuery != null) {
            // empty if block
        }
    }

    private void retransmistirRecusado() throws IOException {
        if (this.hostResponseQuery != null) {
            this.enviaPaciente();
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    public void parse(ArrayList<String> buffer) {
        for (String msg : buffer) {
            this.addListaRecebimento(msg);
        }
    }

    public String parseQuery(String query) {
        PatientInformation patientInformation = new PatientInformation(query);
        this.hostQuery = true;
        if (Funcoes.textoVazio(patientInformation.SpecimenID) || patientInformation.SpecimenID.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            return this.enviarRequisicaoNaoExistente(patientInformation.sampleNo);
        }
        String fil_codigo = patientInformation.SpecimenID.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = patientInformation.SpecimenID.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        String rec_codigo = patientInformation.SpecimenID.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        String acao = "N";
        ArrayList<String> listaExames = null;
        Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
        PanelAbaAbstrata aba = this.equipamento.getTab(0);
        if (req == null) {
            req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
            aba = this.equipamento.getTab(1);
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    listaExames = this.getExamesRequisicoesAba(fil_codigo, req_codigo, rec_codigo, aba);
                }
            } else {
                listaExames = this.getExamesRequisicoesAba(fil_codigo, req_codigo, rec_codigo, aba);
            }
        } else {
            String aux = (String)req[aba.getColIndice("Exame")];
            if (!Funcoes.textoVazio(aux)) {
                listaExames = new ArrayList<String>();
                listaExames.addAll(StringUtil.explode(aux, " "));
            }
        }
        if (req != null && listaExames != null && listaExames.size() > 0) {
            String nomePaciente = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
            String sexoPaciente = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
            String data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
            String hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
            String codigoInterfaceamento = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
            String codigoMaterial = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
            HashMap<String, String> parametros = new HashMap<String, String>();
            parametros.put(PARAMETRO_TIPO_RECIPIENTE, this.configuracao.getTipoRecipiente() ? "00" : "01");
            return this.enviarRequisicao(nomePaciente, sexoPaciente, null, data, hora, null, null, fil_codigo, codigoInterfaceamento, req_codigo, codigoMaterial, rec_codigo, StringUtil.implode(listaExames, " "), acao, parametros);
        }
        return this.enviarRequisicaoNaoExistente(patientInformation.sampleNo);
    }

    private String enviarRequisicaoNaoExistente(String sampleId) {
        this.hostResponseQuery = new HostResponseQuery("A", sampleId, "00", this.configuracao.getTipoRecipiente() ? "00" : "01", "00");
        return String.format("Nenhum exame para enviar para a amostra %s ", sampleId);
    }

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackPosition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put(PARAMETRO_TIPO_RECIPIENTE, this.configuracao.getTipoRecipiente() ? "00" : "01");
        return this.enviarRequisicao(pacNome, pacSexo, null, data, hora, null, null, filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo, exames.trim(), acao, parametros);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao, HashMap<String, String> mapaParametros) {
        this.dadosExameRequisicao = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, exames);
        this.dadosExameRequisicao.setInterface(int_codigo);
        this.dadosExameRequisicao.setAcao(acao);
        StringBuilder codigo = new StringBuilder();
        try {
            String filialDigitos = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            String requisicaoDigitos = StringUtil.preencheString(req_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            String recipienteDigitos = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(filialDigitos).append(requisicaoDigitos).append(recipienteDigitos);
            Statement st = Conexao.getStatement();
            ExameMaterial[] listaExames = ExamesUtil.anexarCodigoMaterial(exames.split(" "), mco_codigo);
            String material = ExamesUtil.getMaterialAlternativo(st, fil_codigo, int_codigo, listaExames);
            String pac_codigo = BDUtil.getCodigoPaciente(fil_codigo, req_codigo);
            pac_codigo = fil_codigo + StringUtil.preencheString(pac_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            this.hostResponseQuery = new HostResponseQuery("A", codigo.toString(), material, mapaParametros.get(PARAMETRO_TIPO_RECIPIENTE), "01");
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            final String amostra = codigo.toString();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    InterfaceListener.this.fireExcecaoEncontrada("Erro ao tentar enviar paciente. C\u00f3digo da amostra = \"" + amostra + "\". " + e.getMessage());
                }
            });
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private ArrayList<String> getExamesRequisicoesAba(String codigoFilial, String codigoRequisicao, String codigoRecipiente, PanelAbaAbstrata componenteAba) {
        List<Object[]> reqs = this.getTodasRequisicaoAba(codigoFilial, codigoRequisicao, codigoRecipiente, componenteAba.getTipoAba());
        ArrayList<String> listaExames = new ArrayList<String>();
        for (Object[] r : reqs) {
            listaExames.add((String)r[componenteAba.getColIndice("Exame")]);
        }
        return listaExames.size() > 0 ? listaExames : null;
    }

    private void parse(DadosResultado dadosResultado) {
        Map<String, Object> dados = this.parseResultado(dadosResultado.ghbResults, dadosResultado);
        try {
            if (dados != null) {
                this.salvaExame(dados);
            }
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
            });
        }
    }

    private void salvaExame(Map<String, Object> dados) throws Exception {
        if (dados != null) {
            String filCodigo = (String)dados.remove(FIL_CODIGO);
            String reqCodigo = (String)dados.remove(REQ_CODIGO);
            String recCodigo = (String)dados.remove(REC_CODIGO);
            String intCodigo = (String)dados.remove(INT_CODIGO);
            Statement st = Conexao.getStatement();
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
            for (BDExame exame : exames) {
                this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getExame(), exame.getMaterial(), intCodigo, dados);
            }
        }
        this.fireAtualizarTabela(2);
    }

    private Map<String, Object> parseResultado(GHbResults ghbResult, DadosResultado dadosResultado) {
        Map<String, Object> dados = null;
        try {
            if (Funcoes.textoVazio(ghbResult.specimenID)) {
                this.fireExcecaoEncontrada("Resultado sem Id da amostra");
                return dados;
            }
            if (!Funcoes.isNumeric(ghbResult.specimenID)) {
                this.fireExcecaoEncontrada(String.format("Id da amostra inv\u00e1lido %s", ghbResult.sampleNo));
                return dados;
            }
            TipoExame alternativo = TipoExame.getTipoExame(String.valueOf(ghbResult.operatingMode));
            String filCodigo = ghbResult.specimenID.trim().substring(0, ParametrosGerais.getDigitosTuboFilial());
            String reqCodigo = ghbResult.specimenID.trim().substring(ParametrosGerais.getDigitosTuboFilial());
            String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            if (!(Funcoes.isNumeric(filCodigo.trim()) && Funcoes.isNumeric(reqCodigo.trim()) && Funcoes.isNumeric(recCodigo.trim()))) {
                this.fireExcecaoEncontrada(String.format("Id da amostra inv\u00e1lido %s %s %s", filCodigo, reqCodigo, recCodigo));
                return dados;
            }
            Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo);
            if (req == null) {
                this.fireExcecaoEncontrada(String.format("Amostra ID %s %s %s n\u00e3o localizada ou n\u00e3o interfaceada", filCodigo, reqCodigo, recCodigo));
                return dados;
            }
            String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, alternativo.codigo);
            if (intCodigo == null) {
                this.fireExcecaoEncontrada(String.format("N\u00e3o foi poss\u00edvel encontrar a interface! alternativo %s ID %s %s %s", alternativo.codigo, filCodigo, reqCodigo, recCodigo));
                return dados;
            }
            ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, alternativo.codigo);
            if (exame == null) {
                this.fireExcecaoEncontrada(String.format("N\u00e3o foi poss\u00edvel encontrar o exame! alternativo %s ID %s %s %s", alternativo.codigo, filCodigo, reqCodigo, recCodigo));
                return dados;
            }
            dados = new HashMap<String, Object>();
            dados.put(FIL_CODIGO, filCodigo);
            dados.put(REQ_CODIGO, reqCodigo);
            dados.put(REC_CODIGO, recCodigo);
            dados.put(INT_CODIGO, intCodigo);
            dados.put(EXA_CODIGO, exame.getNomeExame());
            dados.put(MCO_CODIGO, exame.getCodigoMaterial());
            dados = this.deparaResultado(dados, alternativo.codigo, dadosResultado);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return dados;
    }

    private Map<String, Object> deparaResultado(Map<String, Object> dados, String alternativo, DadosResultado dadosResultado) {
        ArrayList<String> analisador = this.parametrosAnalisador.get(alternativo);
        dados.put(analisador.get(0), null != dadosResultado.ghbResults.no1Component ? dadosResultado.ghbResults.no1Component.toString().replace('.', ',') : "");
        dados.put(analisador.get(1), null != dadosResultado.ghbResults.no2Component ? dadosResultado.ghbResults.no2Component.toString().replace('.', ',') : "");
        dados.put(analisador.get(2), null != dadosResultado.ghbResults.no3Component ? dadosResultado.ghbResults.no3Component.toString().replace('.', ',') : "");
        dados.put(analisador.get(3), null != dadosResultado.ghbResults.no4Component ? dadosResultado.ghbResults.no4Component.toString().replace('.', ',') : "");
        dados.put(analisador.get(4), null != dadosResultado.ghbResults.no5Component ? dadosResultado.ghbResults.no5Component.toString().replace('.', ',') : "");
        dados.put(analisador.get(5), null != dadosResultado.ghbResults.no6Component ? dadosResultado.ghbResults.no6Component.toString().replace('.', ',') : "");
        dados.put(analisador.get(6), null != dadosResultado.ghbResults.no7Component ? dadosResultado.ghbResults.no7Component.toString().replace('.', ',') : "");
        dados.put(analisador.get(7), null != dadosResultado.ghbResults.no8Component ? dadosResultado.ghbResults.no8Component.toString().replace('.', ',') : "");
        dados.put(analisador.get(8), null != dadosResultado.ghbResults.no9Component ? dadosResultado.ghbResults.no9Component.toString().replace('.', ',') : "");
        dados.put(analisador.get(9), null != dadosResultado.ghbResults.no10Component ? dadosResultado.ghbResults.no10Component.toString().replace('.', ',') : "");
        return dados;
    }

    @Override
    public void teste() {
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        this.setIdle();
    }

    public char getBCC(String msg) {
        int bcc = 0;
        byte[] inputStream = msg.getBytes();
        if (inputStream != null && inputStream.length > 0) {
            for (int i = 0; i < inputStream.length; ++i) {
                bcc = (byte)(bcc ^ inputStream[i] & 0xFF);
            }
        }
        return (char)bcc;
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        super.setPortaCOM(portaCOM);
        if (portaCOM instanceof PortaCOM) {
            ((PortaCOM)portaCOM).setBuscaHandshakeMensagemInteira(true);
        }
    }

    class ReservedRecord
    extends Record {
        String effectiveFlag;
        String deviceId;
        String specimenID;
        String patientID;
        String analyteNo;
        String gluResult;
        String comment;
        String verificationFlag;

        public ReservedRecord(String message) {
            super(String.valueOf(message.charAt(0)));
            if (message.length() >= 0) {
                this.effectiveFlag = message.substring(0, 1).trim();
            }
            if (message.length() >= 2) {
                this.deviceId = message.substring(1, 3).trim();
            }
            if (message.length() >= 20) {
                this.specimenID = message.substring(3, 23);
            }
            if (message.length() >= 23) {
                this.patientID = message.substring(23, 36);
            }
            if (message.length() >= 36) {
                this.analyteNo = message.substring(36, 40).trim();
            }
            if (message.length() >= 40) {
                this.gluResult = message.substring(40, 50).trim();
            }
            if (message.length() >= 50) {
                this.comment = message.substring(50, 54).trim();
            }
            if (message.length() >= 54) {
                this.verificationFlag = message.substring(54, 56).trim();
            }
        }
    }

    class GHbResults
    extends Record {
        Integer effectiveFlag;
        String operatingMode;
        String sampleNo;
        String specimenPosition;
        String specimenID;
        String flagResult;
        Double no1Component;
        Double no2Component;
        Double no3Component;
        Double no4Component;
        Double no5Component;
        Double no6Component;
        Double no7Component;
        Double no8Component;
        Double no9Component;
        Double no10Component;

        public GHbResults(String message, int digitosAmostra) {
            super(String.valueOf(message.charAt(0)));
            Integer qtdCaracteres = 3 + digitosAmostra;
            if (message.length() >= 0 && !Funcoes.textoVazio(message.substring(0, 1).trim())) {
                this.effectiveFlag = Integer.parseInt(message.substring(0, 1).trim());
            }
            if (message.length() >= 1) {
                this.operatingMode = message.substring(1, 2);
            }
            if (message.length() >= 2) {
                this.specimenPosition = message.substring(2, 3);
            }
            if (message.length() >= qtdCaracteres) {
                this.sampleNo = message.substring(3, qtdCaracteres);
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 5;
                this.no1Component = this.obterResultadoComponent(message.substring(n, qtdCaracteres).trim(), "1");
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 5;
                this.no2Component = this.obterResultadoComponent(message.substring(n, qtdCaracteres).trim(), "2");
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 5;
                this.no3Component = this.obterResultadoComponent(message.substring(n, qtdCaracteres).trim(), "3");
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 5;
                this.no4Component = this.obterResultadoComponent(message.substring(n, qtdCaracteres).trim(), "4");
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 5;
                this.no5Component = this.obterResultadoComponent(message.substring(n, qtdCaracteres).trim(), "5");
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 5;
                this.no6Component = this.obterResultadoComponent(message.substring(n, qtdCaracteres).trim(), "6");
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 5;
                this.no7Component = this.obterResultadoComponent(message.substring(n, qtdCaracteres).trim(), "7");
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 5;
                this.no8Component = this.obterResultadoComponent(message.substring(n, qtdCaracteres).trim(), "8");
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 5;
                this.no9Component = this.obterResultadoComponent(message.substring(n, qtdCaracteres).trim(), "9");
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 5;
                this.no10Component = this.obterResultadoComponent(message.substring(n, qtdCaracteres).trim(), "10");
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 2;
                this.flagResult = message.substring(n, qtdCaracteres).trim();
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 20;
                this.specimenID = message.substring(n, qtdCaracteres).trim();
            }
        }

        private double obterResultadoComponent(String component, String pos) {
            if (Funcoes.isNumeric(component)) {
                return Double.parseDouble(component);
            }
            InterfaceListener.this.fireExcecaoEncontrada(String.format("Resultado recebido do componente %s inv\u00e1lido ou n\u00e3o num\u00e9rico verifique as configura\u00e7\u00f5es do tamanho dos digitos da amostra", pos));
            return 0.0;
        }
    }

    class PatientInformation
    extends Record {
        String deviceID;
        String SpecimenID;
        String sampleNo;
        String patientID;
        String firtsName;
        String lastName;
        String sex;
        String birthDate;
        String comment1;
        String comment2;

        public PatientInformation(String message) {
            super(String.valueOf(message.charAt(0)));
            Integer digitosAmostra = Integer.parseInt(InterfaceListener.this.configuracao.getTamanhoDigitosAmostra());
            Integer qtdCaracteres = 22 + digitosAmostra;
            if (message.length() >= 0) {
                this.deviceID = message.substring(0, 2).trim();
            }
            if (message.length() >= 22) {
                this.SpecimenID = message.substring(2, 22).trim();
            }
            if (message.length() >= qtdCaracteres) {
                this.sampleNo = message.substring(22, qtdCaracteres);
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 13;
                this.patientID = message.substring(n, qtdCaracteres);
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 10;
                this.firtsName = message.substring(n, qtdCaracteres).trim();
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 10;
                this.lastName = message.substring(n, qtdCaracteres).trim();
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 2;
                this.sex = message.substring(n, qtdCaracteres).trim();
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 10;
                this.birthDate = message.substring(n, qtdCaracteres).trim();
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 20;
                this.comment1 = message.substring(n, qtdCaracteres).trim();
            }
            if (message.length() >= qtdCaracteres) {
                int n = qtdCaracteres;
                qtdCaracteres = qtdCaracteres + 20;
                this.comment2 = message.substring(n, qtdCaracteres).trim();
            }
        }
    }

    abstract class Record {
        String header;

        public Record(String header) {
            this.header = header;
        }
    }

    class DadosResultado {
        PatientInformation patientInformation;
        GHbResults ghbResults;

        DadosResultado() {
        }
    }

    class HostResponseQuery
    extends Record {
        String sampleId;
        String sampleType;
        String containerType;
        String a1cItem;

        public HostResponseQuery(String header, String sampleId, String sampleType, String containerType, String a1cItem) {
            super(header);
            this.sampleId = sampleId;
            this.sampleType = sampleType;
            this.containerType = containerType;
            this.a1cItem = a1cItem;
        }

        public String enviaPaciente() {
            StringBuilder frame = new StringBuilder(this.header);
            frame.append(",");
            frame.append(StringUtil.preencheString(this.sampleId, 20, ' ', 0));
            frame.append(",");
            frame.append(this.sampleType);
            frame.append(this.containerType);
            frame.append("  ");
            frame.append(",");
            frame.append(this.a1cItem);
            frame.append("      ");
            frame.append(",");
            frame.append("        ");
            return frame.toString();
        }
    }

    private static enum TipoExame {
        STD_MODE("0"),
        VAR_MODE("1"),
        BETA_THALASSEMI_MODE("2");

        String codigo = "";

        private TipoExame(String codigo) {
            this.codigo = codigo;
        }

        public String toString() {
            return this.codigo;
        }

        public static TipoExame getTipoExame(String codigo) {
            for (TipoExame aux : TipoExame.values()) {
                if (!aux.codigo.equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }
    }
}

