/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.tosohhlc723;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.tosohhlc723.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.MemoryList;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.binary.Base64;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.CategoryTableXYDataset;
import org.jfree.data.xy.XYDataset;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final int TIME_OUT = 20000;
    private static final int TIME_RETRY = 5;
    private int tx_counter = 0;
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
    private ThreadRecebimento threadRecebimento = null;
    private DadosResultado dadosResultado = new DadosResultado();
    private Map<String, ArrayList<String>> parametrosAnalisador = new HashMap<String, ArrayList<String>>();
    private Map<String, String> parametrosJalis = new HashMap<String, String>();
    private static final String FIL_CODIGO = "fil_codigo";
    private static final String REQ_CODIGO = "req_codigo";
    private static final String REC_CODIGO = "rec_codigo";
    private static final String INT_CODIGO = "int_codigo";
    private static final String EXA_CODIGO = "exa_codigo";
    private static final String MCO_CODIGO = "mco_codigo";
    private static final String PARAMETRO_TIPO_RECIPIENTE = "tipoRecipiente";
    private static final int BORDA_HORIZONTAL = 10;
    private static final int BORDA_VERTICAL = 10;
    private final Color[] CORES_RACHURA = new Color[]{ScreenUtil.clarearCor(Color.CYAN, 100), ScreenUtil.clarearCor(Color.GREEN, 100), ScreenUtil.clarearCor(Color.YELLOW, 100), ScreenUtil.clarearCor(Color.MAGENTA, 100)};
    private final Color[] CORES_RACHURA_PRETO = new Color[]{new Color(77, 77, 77, 255), new Color(100, 100, 100, 255), new Color(133, 133, 133, 255), new Color(166, 166, 166, 255)};
    private HostResponseQuery hostResponseQuery = null;
    private boolean hostQuery = false;
    private InfoExameRequisicao dadosExameRequisicao = null;
    private String lastMsg = "";
    protected MemoryList<String> rx_list = new MemoryList();
    private boolean enviouOk;
    private boolean endPacketRecebido = false;

    public InterfaceListener() {
        this.threadRecebimento = new ThreadRecebimento(this, 25);
        this.threadRecebimento.start();
        this.parametrosAnalisador.put(TipoExame.STD_MODE.toString(), new ArrayList());
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("Total A1");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("FP");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("A1a");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("A1b");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("F");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("LA1c");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("SA1c;IFCC");
        this.parametrosAnalisador.get(TipoExame.STD_MODE.toString()).add("A0");
        this.parametrosAnalisador.put(TipoExame.VAR_MODE.toString(), new ArrayList());
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("Total A1");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("A1a");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("A1b");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("F");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("LA1c");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("SA1c;IFCC");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("A0");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("H-V0");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("H-V1");
        this.parametrosAnalisador.get(TipoExame.VAR_MODE.toString()).add("H-V2");
        this.parametrosAnalisador.put(TipoExame.BETA_THALASSEMI_MODE.toString(), new ArrayList());
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("Total A1");
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("HbF");
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("A0");
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("HbA2");
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("HbD+");
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("HbS+");
        this.parametrosAnalisador.get(TipoExame.BETA_THALASSEMI_MODE.toString()).add("HbC+");
        this.parametrosJalis.put("Total A1%", "variant2_percentual_total");
        this.parametrosJalis.put("F%", "variant2_percentual_F");
        this.parametrosJalis.put("A1a%", "variant2_percentual_A1a");
        this.parametrosJalis.put("A1b%", "variant2_percentual_A1b");
        this.parametrosJalis.put("A0%", "variant2_percentual_A0");
        this.parametrosJalis.put("LA1c%", "variant2_percentual_LA1c");
        this.parametrosJalis.put("SA1c;IFCC%", "variant2_percentual_SA1cIFCC");
        this.parametrosJalis.put("HbA2%", "variant2_percentual_A2");
        this.parametrosJalis.put("HbC+%", "variant2_percentual_C");
        this.parametrosJalis.put("HbD+%", "variant2_percentual_D");
        this.parametrosJalis.put("HbF%", "variant2_percentual_F");
        this.parametrosJalis.put("HbS+%", "variant2_percentual_S");
        this.parametrosJalis.put("FP%", "hlc723_percentual_h_fp");
        this.parametrosJalis.put("H-V0%", "hlc723_percentual_h_v0");
        this.parametrosJalis.put("H-V1%", "hlc723_percentual_h_v1");
        this.parametrosJalis.put("H-V2%", "hlc723_percentual_h_v2");
        this.parametrosJalis.put("Total A1", "variant2_area_total");
        this.parametrosJalis.put("F", "variant2_area_F");
        this.parametrosJalis.put("A1a", "variant2_area_A1a");
        this.parametrosJalis.put("A1b", "variant2_area_A1b");
        this.parametrosJalis.put("A0", "variant2_area_A0");
        this.parametrosJalis.put("LA1c", "variant2_area_LA1c");
        this.parametrosJalis.put("SA1c;IFCC", "variant2_area_A1cIFCC");
        this.parametrosJalis.put("HbA2", "variant2_area_A2");
        this.parametrosJalis.put("HbC+", "variant2_area_C");
        this.parametrosJalis.put("HbD+", "variant2_area_D");
        this.parametrosJalis.put("HbF", "variant2_area_F");
        this.parametrosJalis.put("HbS+", "variant2_area_S");
        this.parametrosJalis.put("FP", "hlc723_area_h_fp");
        this.parametrosJalis.put("H-V0", "hlc723_area_h_v0");
        this.parametrosJalis.put("H-V1", "hlc723_area_h_v1");
        this.parametrosJalis.put("H-V2", "hlc723_area_h_v2");
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.configuracao.getModoHostQuery();
        if (Funcoes.textoVazio(this.configuracao.getTamanhoDigitosAmostra())) {
            this.fireExcecaoEncontrada("Configura\u00e7\u00e3o do tamanho de dig\u00edtos da amostra n\u00e3o configurado, verifique as configura\u00e7\u00f5es de Interface no Jalis");
        } else if ("3;5;8".contains(this.configuracao.getTamanhoDigitosAmostra())) {
            this.fireExcecaoEncontrada(String.format("Configura\u00e7\u00e3o do tamanho de dig\u00edtos da amostra configurado errado [%s], valor deve ser 3, 5 ou 8 ", this.configuracao.getTamanhoDigitosAmostra()));
        }
        this.configuracao.getModoHostQuery();
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        String endMsg;
        this.fireMensagemEnviada("Tempo esgotado ao tentar transmitir dados ao aparelho.", 1, 5000);
        this.setIdle();
        int end = this.lastMsg.indexOf(this.getMsgEnd());
        if (end > 1 && (endMsg = this.lastMsg.substring(end)).length() < 2) {
            this.fireExcecaoEncontrada(String.format("\u00daltima mensagem recebida sem o BCC", new Object[0]));
        }
        this.getPortaCOM().write(String.valueOf('\u0004'));
    }

    @Override
    public void dataChanged() {
        try {
            String message;
            this.setRX();
            this.lastMsg = message = this.getPortaCOM().getInputString();
            if (message.startsWith(this.getMsgStart()) && message.contains(this.getMsgEnd())) {
                int end = message.indexOf(this.getMsgEnd());
                if (end > 1) {
                    String endMsg = message.substring(end);
                    if (endMsg.length() < 2) {
                        this.aguardarProximoFrame();
                        return;
                    }
                    this.lastMsg = message = this.getPortaCOM().removeInputString(endMsg);
                    if (this.validaCheckSum(message)) {
                        Thread.sleep(50L);
                        this.getPortaCOM().write(String.valueOf('\u0006'));
                        this.aguardarProximoFrame();
                        String msg = message.substring(1, message.length() - 2);
                        String tipo = this.getTipoMensagem(msg);
                        if (tipo.equals(TipoMensagem.DADOS_REQUEST.toString())) {
                            this.setRX();
                            this.parseQuery(msg);
                        } else if (Funcoes.isNumeric(tipo) && Integer.parseInt(tipo) <= 7) {
                            this.endPacketRecebido = false;
                            this.lastMsg = "";
                            this.rx_list.add(msg);
                        } else if (Funcoes.isNumeric(tipo) && Integer.parseInt(tipo) == 8) {
                            this.endPacketRecebido = true;
                            this.lastMsg = "";
                            this.rx_list.add(msg);
                            if (this.rx_list.size() > 0) {
                                ArrayList buffer = (ArrayList)this.rx_list.clone();
                                this.rx_list.clear();
                                this.parse(buffer);
                            }
                        }
                    }
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                }
            });
        }
    }

    public void dataChanged(String message) {
        try {
            this.setRX();
            this.lastMsg = message;
            if (message.startsWith(this.getMsgStart()) && message.contains(this.getMsgEnd())) {
                int end = message.indexOf(this.getMsgEnd());
                if (end > 1) {
                    String endMsg = message.substring(end);
                    if (endMsg.length() < 2) {
                        this.aguardarProximoFrame();
                        return;
                    }
                    this.lastMsg = message = message.substring(0, message.indexOf(endMsg) + endMsg.length());
                    if (this.validaCheckSum(message)) {
                        Thread.sleep(50L);
                        this.getPortaCOM().write(String.valueOf('\u0006'));
                        this.aguardarProximoFrame();
                        String msg = message.substring(1, message.length() - 2);
                        String tipo = this.getTipoMensagem(msg);
                        if (tipo.equals(TipoMensagem.DADOS_REQUEST.toString())) {
                            this.setRX();
                            this.parseQuery(msg);
                        } else if (Funcoes.isNumeric(tipo) && Integer.parseInt(tipo) <= 7) {
                            this.endPacketRecebido = false;
                            this.lastMsg = "";
                            this.rx_list.add(msg);
                        } else if (Funcoes.isNumeric(tipo) && Integer.parseInt(tipo) == 8) {
                            this.endPacketRecebido = true;
                            this.lastMsg = "";
                            this.rx_list.add(msg);
                            if (this.rx_list.size() > 0) {
                                ArrayList buffer = (ArrayList)this.rx_list.clone();
                                this.rx_list.clear();
                                this.parse(buffer);
                            }
                        }
                    }
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                }
            });
        }
    }

    private String getTipoMensagem(String message) {
        return String.valueOf(message.charAt(0));
    }

    protected void aguardarProximoFrame() throws Exception {
        this.setRX(20000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this, 25);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    private boolean validaCheckSum(String message) {
        char bccCalculado;
        String msg = message.substring(0, message.length() - 1);
        char bccTosoh = message.charAt(message.length() - 1);
        return bccTosoh == (bccCalculado = InterfaceListener.getBCC(msg.substring(1)));
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0006': {
                    if (!this.endPacketRecebido && !Funcoes.textoVazio(this.lastMsg)) {
                        this.rx_list.add(this.lastMsg + '\u0006');
                        this.getPortaCOM().clearInputString();
                        this.getPortaCOM().write(String.valueOf('\u0006'));
                        break;
                    }
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    if (!this.endPacketRecebido && !Funcoes.textoVazio(this.lastMsg)) {
                        this.rx_list.add(this.lastMsg + '\u0015');
                        this.getPortaCOM().clearInputString();
                        this.getPortaCOM().write(String.valueOf('\u0006'));
                        break;
                    }
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0004': {
                    if (!this.endPacketRecebido && !Funcoes.textoVazio(this.lastMsg)) {
                        this.rx_list.add(this.lastMsg + '\u0004');
                        this.getPortaCOM().clearInputString();
                        this.getPortaCOM().write(String.valueOf('\u0006'));
                        break;
                    }
                    this.tratarEndOfTX();
                    break;
                }
                default: {
                    this.rx_list.add(this.lastMsg + c);
                    this.getPortaCOM().clearInputString();
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    this.caracterNaoEsperado(c);
                    break;
                }
            }
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                }
            });
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
            this.setIdle();
        }
    }

    private void tratarAcknowledge() {
        if (this.hostResponseQuery != null && this.dadosExameRequisicao != null) {
            this.enviouOk = true;
        }
    }

    private void caracterNaoEsperado(char c) {
        this.fireMensagemEnviada("Caracter n\u00e3o esperado recebido na comunica\u00e7\u00e3o " + String.valueOf(c).codePointAt(0), 1, 5000);
    }

    private void tratarEndOfTX() throws SQLException {
        if (this.enviouOk && this.dadosExameRequisicao != null) {
            this.encerrarTransmissao();
        } else if (this.isRX() && this.rx_list.size() > 0) {
            ArrayList buffer = (ArrayList)this.rx_list.clone();
            this.rx_list.clear();
            this.parse(buffer);
        } else if (this.hostQuery && this.hostResponseQuery != null) {
            this.hostQuery = false;
            this.tx_counter = 0;
            this.enviaPaciente();
        }
        this.setIdle();
        this.interromperTimer();
    }

    private void enviaPaciente() {
        try {
            this.setTX(20000);
            this.enviouOk = false;
            this.getPortaCOM().write(this.empacotar(this.hostResponseQuery.enviaPaciente()));
        }
        catch (IOException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
            });
        }
    }

    private String empacotar(String mensagem) {
        StringBuilder frame = new StringBuilder();
        frame.append(this.getMsgStart());
        frame.append(mensagem);
        frame.append(this.getMsgEnd());
        char bcc = InterfaceListener.getBCC(frame.toString().substring(1));
        frame.append(bcc);
        return frame.toString();
    }

    public static char getBCC(String msg) {
        int bcc = 0;
        byte[] inputStream = msg.getBytes();
        if (inputStream != null && inputStream.length > 0) {
            for (int i = 0; i < inputStream.length; ++i) {
                bcc = (byte)(bcc ^ inputStream[i] & 0xFF);
            }
        }
        return (char)bcc;
    }

    private void encerrarTransmissao() throws SQLException {
        if (this.dadosExameRequisicao != null) {
            Statement st = Conexao.getStatement();
            String acaoEnvioAparelho = this.dadosExameRequisicao.getAcao();
            if (Funcoes.textoVazio(acaoEnvioAparelho)) {
                this.fireExcecaoEncontrada(String.format("Erro ao tentar mudar a situa\u00e7\u00e3o do exame fil_codigo = %s, req_codigo = %s, rec_codigo = %s, mco_codigo = %s, int_codigo = %s", this.dadosExameRequisicao.getFilial(), this.dadosExameRequisicao.getCodigo(), this.dadosExameRequisicao.getRecipiente(), this.dadosExameRequisicao.getMaterial(), this.dadosExameRequisicao.getInterface()));
            } else {
                this.atualizarSituacaoTubo(st, this.dadosExameRequisicao.getFilial(), this.dadosExameRequisicao.getCodigo(), this.dadosExameRequisicao.getRecipiente(), this.dadosExameRequisicao.getMaterial(), this.dadosExameRequisicao.getInterface(), acaoEnvioAparelho.equals("N") ? 1 : 3);
                Conexao.arquivaSQL();
                this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.dadosExameRequisicao.getNome() + ".", 0, 10000);
                if (Funcoes.textoVazio(acaoEnvioAparelho) || acaoEnvioAparelho.equals("N")) {
                    this.firePacienteEnviado(this.dadosExameRequisicao.getCodigo(), this.dadosExameRequisicao.getNome(), this.dadosExameRequisicao.getSexo(), this.dadosExameRequisicao.getIdade(), this.dadosExameRequisicao.getData(), this.dadosExameRequisicao.getHora(), this.dadosExameRequisicao.getExames());
                }
            }
        }
        this.fireAtualizarTabela(0);
        this.interromperTimer();
        this.setIdle();
        this.dadosExameRequisicao = null;
        this.hostResponseQuery = null;
    }

    private void tratarNegativeAck() throws IOException {
        if (this.isTX() && this.tx_counter < 5) {
            ++this.tx_counter;
            this.retransmistirRecusado();
            this.setTX(20000);
        } else if (this.tx_counter == 5 && this.hostResponseQuery != null) {
            this.fireExcecaoEncontrada(String.format("Tentativas de envio do paciente esgotadas verifique(%s)", this.hostResponseQuery.sampleId));
            this.hostResponseQuery = null;
            this.tx_counter = 0;
        } else if (this.hostResponseQuery != null) {
            // empty if block
        }
    }

    private void retransmistirRecusado() throws IOException {
        if (this.hostResponseQuery != null) {
            this.enviaPaciente();
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    public void parse(ArrayList<String> buffer) {
        for (String msg : buffer) {
            this.addListaRecebimento(msg);
        }
    }

    public String parseQuery(String query) {
        AnalyzerQuery analyzerQuery = new AnalyzerQuery(query);
        this.hostQuery = true;
        if (Funcoes.textoVazio(analyzerQuery.sampleId) || analyzerQuery.sampleId.length() > ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            return this.enviarRequisicaoNaoExistente(analyzerQuery.sampleId);
        }
        String fil_codigo = analyzerQuery.sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = analyzerQuery.sampleId.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        String rec_codigo = analyzerQuery.sampleId.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        String acao = "N";
        ArrayList<String> listaExames = null;
        Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
        PanelAbaAbstrata aba = this.equipamento.getTab(0);
        if (req == null) {
            req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
            aba = this.equipamento.getTab(1);
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    listaExames = this.getExamesRequisicoesAba(fil_codigo, req_codigo, rec_codigo, aba);
                }
            } else {
                listaExames = this.getExamesRequisicoesAba(fil_codigo, req_codigo, rec_codigo, aba);
            }
        } else {
            String aux = (String)req[aba.getColIndice("Exame")];
            if (!Funcoes.textoVazio(aux)) {
                listaExames = new ArrayList<String>();
                listaExames.addAll(StringUtil.explode(aux, " "));
            }
        }
        if (req != null && listaExames != null && listaExames.size() > 0) {
            String nomePaciente = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
            String sexoPaciente = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
            String data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
            String hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
            String codigoInterfaceamento = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
            String codigoMaterial = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
            HashMap<String, String> parametros = new HashMap<String, String>();
            parametros.put(PARAMETRO_TIPO_RECIPIENTE, this.configuracao.getTipoRecipiente() ? "00" : "01");
            return this.enviarRequisicao(nomePaciente, sexoPaciente, null, data, hora, null, null, fil_codigo, codigoInterfaceamento, req_codigo, codigoMaterial, rec_codigo, StringUtil.implode(listaExames, " "), acao, parametros);
        }
        return this.enviarRequisicaoNaoExistente(analyzerQuery.sampleId);
    }

    private String enviarRequisicaoNaoExistente(String sampleId) {
        this.hostResponseQuery = new HostResponseQuery(TipoMensagem.DADOS_ANALISE.toString(), sampleId, "00", this.configuracao.getTipoRecipiente() ? "00" : "01", "00");
        return String.format("Nenhum exame para enviar para a amostra %s ", sampleId);
    }

    @Override
    @Deprecated
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackPosition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        return "";
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao, HashMap<String, String> mapaParametros) {
        this.dadosExameRequisicao = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, exames);
        this.dadosExameRequisicao.setInterface(int_codigo);
        this.dadosExameRequisicao.setAcao(acao);
        StringBuilder codigo = new StringBuilder();
        try {
            String filialDigitos = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            String requisicaoDigitos = StringUtil.preencheString(req_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            String recipienteDigitos = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(filialDigitos).append(requisicaoDigitos).append(recipienteDigitos);
            Statement st = Conexao.getStatement();
            ExameMaterial[] listaExames = ExamesUtil.anexarCodigoMaterial(exames.split(" "), mco_codigo);
            String material = ExamesUtil.getMaterialAlternativo(st, fil_codigo, int_codigo, listaExames);
            String pac_codigo = BDUtil.getCodigoPaciente(fil_codigo, req_codigo);
            pac_codigo = fil_codigo + StringUtil.preencheString(pac_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            this.hostResponseQuery = new HostResponseQuery(TipoMensagem.DADOS_ANALISE.toString(), codigo.toString(), material, mapaParametros.get(PARAMETRO_TIPO_RECIPIENTE), "01");
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            final String amostra = codigo.toString();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    InterfaceListener.this.fireExcecaoEncontrada("Erro ao tentar enviar paciente. C\u00f3digo da amostra = \"" + amostra + "\". " + e.getMessage());
                }
            });
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private ArrayList<String> getExamesRequisicoesAba(String codigoFilial, String codigoRequisicao, String codigoRecipiente, PanelAbaAbstrata componenteAba) {
        List<Object[]> reqs = this.getTodasRequisicaoAba(codigoFilial, codigoRequisicao, codigoRecipiente, componenteAba.getTipoAba());
        ArrayList<String> listaExames = new ArrayList<String>();
        for (Object[] r : reqs) {
            listaExames.add((String)r[componenteAba.getColIndice("Exame")]);
        }
        return listaExames.size() > 0 ? listaExames : null;
    }

    @Override
    public String parse(String message) {
        String tipo = this.getTipoMensagem(message);
        if (tipo.equals(TipoMensagem.DADOS_SAMPLE_INFORMATION.toString())) {
            this.dadosResultado = new DadosResultado();
            this.dadosResultado.sampleInformation = new SampleInformation(message);
        } else if (tipo.equals(TipoMensagem.DADOS_SAMPLE_NUMBER.toString())) {
            this.dadosResultado.sampleNumber = new SampleNumber(message);
        } else if (tipo.equals(TipoMensagem.DADOS_SAMPLE_MEASUREMENT_VALUE.toString())) {
            this.dadosResultado.measurementValue = new MeasurementValue(message);
        } else if (tipo.equals(TipoMensagem.DADOS_SAMPLE_COLLECTION_PARAMETERS.toString())) {
            this.dadosResultado.dataCollectionParameters = new DataCollectionParameters(message);
        } else if (tipo.equals(TipoMensagem.DADOS_SAMPLE_PEAK_DATA.toString())) {
            this.dadosResultado.peakDatas.add(new PeakData(message));
        } else if (tipo.equals(TipoMensagem.DADOS_SAMPLE_PEAK_DATA_END.toString())) {
            this.dadosResultado.peakDataEnd = new PeakDataEnd(message);
        } else if (tipo.equals(TipoMensagem.DADOS_SAMPLE_RAW_DATA.toString())) {
            this.dadosResultado.rawDatas.add(new RawData(message));
        } else if (tipo.equals(TipoMensagem.DADOS_SAMPLE_RAW_DATA_END.toString())) {
            this.dadosResultado.rawDataEnd = new RawDataEnd(message);
            if (this.dadosResultado.sampleInformation == null || this.dadosResultado.measurementValue == null || this.dadosResultado.peakDatas == null || this.dadosResultado.peakDatas.isEmpty()) {
                this.fireExcecaoEncontrada("Resultado recebido do aparelho incompleto");
                return null;
            }
            HashMap<String, Object> dados = new HashMap<String, Object>();
            this.parseFracoes(this.dadosResultado.peakDatas, dados);
            int larguraDisponivel = 0;
            int alturaDisponivel = 0;
            try {
                larguraDisponivel = Funcoes.textoVazio(this.configuracao.getLarguraGrafico()) ? 500 : Integer.parseInt(this.configuracao.getLarguraGrafico());
                alturaDisponivel = Funcoes.textoVazio(this.configuracao.getAlturaGrafico()) ? 400 : Integer.parseInt(this.configuracao.getAlturaGrafico());
            }
            catch (Exception e) {
                larguraDisponivel = 300;
                larguraDisponivel = 216;
            }
            this.parse(this.dadosResultado);
        }
        return null;
    }

    private void parse(DadosResultado dadosResultado) {
        Map<String, Object> dados = this.parseResultado(dadosResultado.sampleInformation, dadosResultado);
        try {
            if (dados != null) {
                this.salvaExame(dados);
            }
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
            });
        }
    }

    private void salvaExame(Map<String, Object> dados) throws Exception {
        if (dados != null) {
            String filCodigo = (String)dados.remove(FIL_CODIGO);
            String reqCodigo = (String)dados.remove(REQ_CODIGO);
            String recCodigo = (String)dados.remove(REC_CODIGO);
            String intCodigo = (String)dados.remove(INT_CODIGO);
            Statement st = Conexao.getStatement();
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
            if (null != this.dadosResultado.peakDatas && null != this.dadosResultado.rawDatas && !this.dadosResultado.rawDatas.isEmpty()) {
                int larguraDisponivel = 0;
                int alturaDisponivel = 0;
                try {
                    larguraDisponivel = Funcoes.textoVazio(this.configuracao.getLarguraGrafico()) ? 500 : Integer.parseInt(this.configuracao.getLarguraGrafico());
                    alturaDisponivel = Funcoes.textoVazio(this.configuracao.getAlturaGrafico()) ? 400 : Integer.parseInt(this.configuracao.getAlturaGrafico());
                }
                catch (Exception e) {
                    larguraDisponivel = 300;
                    alturaDisponivel = 216;
                }
                String message = this.getPortaCOM().getInputString();
                this.parseCurva(message, dados, larguraDisponivel, alturaDisponivel, this.dadosResultado);
            }
            for (BDExame exame : exames) {
                this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getExame(), exame.getMaterial(), intCodigo, dados);
            }
        }
        this.fireAtualizarTabela(2);
    }

    private Map<String, Object> parseResultado(SampleInformation sampleInformation, DadosResultado dadosResultado) {
        Map<String, Object> dados = null;
        try {
            if (Funcoes.textoVazio(sampleInformation.sampleId)) {
                this.fireExcecaoEncontrada("Resultado sem Id da amostra");
                return dados;
            }
            if (!Funcoes.isNumeric(sampleInformation.sampleId)) {
                this.fireExcecaoEncontrada(String.format("Id da amostra inv\u00e1lido %s", sampleInformation.sampleId));
                return dados;
            }
            TipoExame alternativo = TipoExame.getTipoExame(String.valueOf(sampleInformation.operationMode));
            String filCodigo = sampleInformation.sampleId.trim().substring(0, ParametrosGerais.getDigitosTuboFilial());
            String reqCodigo = sampleInformation.sampleId.trim().substring(ParametrosGerais.getDigitosTuboFilial());
            String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            if (!(Funcoes.isNumeric(filCodigo.trim()) && Funcoes.isNumeric(reqCodigo.trim()) && Funcoes.isNumeric(recCodigo.trim()))) {
                this.fireExcecaoEncontrada(String.format("Id da amostra inv\u00e1lido %s %s %s", filCodigo, reqCodigo, recCodigo));
                return dados;
            }
            Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo);
            if (req == null) {
                this.fireExcecaoEncontrada(String.format("Amostra ID %s %s %s n\u00e3o localizada ou n\u00e3o interfaceada", filCodigo, reqCodigo, recCodigo));
                return dados;
            }
            String intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, alternativo.codigo);
            if (intCodigo == null) {
                this.fireExcecaoEncontrada(String.format("N\u00e3o foi poss\u00edvel encontrar a interface! alternativo %s ID %s %s %s", alternativo.codigo, filCodigo, reqCodigo, recCodigo));
                return dados;
            }
            ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, alternativo.codigo);
            if (exame == null) {
                this.fireExcecaoEncontrada(String.format("N\u00e3o foi poss\u00edvel encontrar o exame! alternativo %s ID %s %s %s", alternativo.codigo, filCodigo, reqCodigo, recCodigo));
                return dados;
            }
            dados = new HashMap<String, Object>();
            dados.put(FIL_CODIGO, filCodigo);
            dados.put(REQ_CODIGO, reqCodigo);
            dados.put(REC_CODIGO, recCodigo);
            dados.put(INT_CODIGO, intCodigo);
            dados.put(EXA_CODIGO, exame.getNomeExame());
            dados.put(MCO_CODIGO, exame.getCodigoMaterial());
            dados = this.deparaResultado(dados, this.parametrosAnalisador.get(alternativo.codigo), dadosResultado);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return dados;
    }

    private Map<String, Object> deparaResultado(Map<String, Object> dados, ArrayList<String> analisador, DadosResultado dadosResultado) {
        List<PeakData> componentResultados = dadosResultado.peakDatas;
        dados.put(this.parametrosJalis.get(analisador.get(0) + "%"), dadosResultado.measurementValue.component.get(0).replace('.', ','));
        for (int i = 0; i < componentResultados.size(); ++i) {
            if (!this.parametrosJalis.containsKey(analisador.get(i)) || componentResultados.size() < i) continue;
            try {
                dados.put(this.parametrosJalis.get(analisador.get(i + 1)), null != componentResultados.get((int)i).peakArea ? componentResultados.get((int)i).peakArea.toString().replace('.', ',') : "");
                dados.put(this.parametrosJalis.get(analisador.get(i + 1) + "%"), null != componentResultados.get((int)i).peakAreaPerc ? componentResultados.get((int)i).peakAreaPerc.toString().replace('.', ',') : "");
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                this.fireExcecaoEncontrada("Quantidade de par\u00e2metros Jalis: " + this.parametrosJalis.size() + "\nQuantidade par\u00e2metros analizador: " + analisador.size() + "\nErro: " + e.getMessage());
                return null;
            }
        }
        return dados;
    }

    @Override
    public void teste() {
        String req = JOptionPane.showInputDialog("Informe o Id da amostra");
        this.dataChanged(this.equipamento.arruma("[STX]10001000" + req + "[SP][SP][SP][SP][SP][SP][SP][SP][SP][ETX]\""));
        this.dataChanged(this.equipamento.arruma("[STX]208030003[ETX]9"));
        this.dataChanged(this.equipamento.arruma("[STX]300[SP]14.2[SP][SP]0.4[SP][SP]1.4[SP][SP]0.6[SP][SP]3.1[SP]12.5[SP]83.9[SP][SP]0.0[SP][SP]0.0[SP][SP]0.0[SP][SP]0.0[SP][SP][SP][SP]0[ETX]8"));
        this.dataChanged(this.equipamento.arruma("[STX]4[SP][SP][SP]02[SP]6[SP]603[ETX][SYN]"));
        this.dataChanged(this.equipamento.arruma("[STX]5[SP]1A1A[SP][SP]B[SP][SP]30[SP]602[SP][SP]30[SP][SP]93[SP][SP]95[SP][SP][SP][SP]9.69[SP][SP]0.4[ETX]t"));
        this.dataChanged(this.equipamento.arruma("[STX]5[SP]2A1B[SP][SP]V[SP][SP]30[SP]602[SP][SP]95[SP]117[SP]143[SP][SP][SP]35.41[SP][SP]1.4[ETX]|"));
        this.dataChanged(this.equipamento.arruma("[STX]5[SP]3F[SP][SP][SP][SP]V[SP][SP]30[SP]602[SP]143[SP]155[SP]168[SP][SP][SP]15.14[SP][SP]0.6[ETX]"));
        this.dataChanged(this.equipamento.arruma("[STX]5[SP]4LA1C+V[SP][SP]30[SP]602[SP]168[SP]185[SP]200[SP][SP][SP]80.71[SP][SP]3.1[ETX][LF]"));
        this.dataChanged(this.equipamento.arruma("[STX]5[SP]5SA1C[SP]V[SP][SP]30[SP]602[SP]200[SP]218[SP]253[SP][SP]272.72[SP]12.5[ETX]"));
        this.dataChanged(this.equipamento.arruma("[STX]5[SP]6A0[SP][SP][SP]V[SP][SP]30[SP]602[SP]253[SP]321[SP]602[SP]2151.57[SP]83.9[ETX][ETB]"));
        this.dataChanged(this.equipamento.arruma("[STX]6[ETX]5"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP][SP]1[SP][SP]248.080[SP][SP]248.080[SP][SP]248.120[SP][SP]248.104[SP][SP]248.109[SP][SP]248.107[SP][SP]248.099[SP][SP]248.089[SP][SP]248.086[SP][SP]248.083[ETX]\t"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP][SP]2[SP][SP]248.082[SP][SP]248.081[SP][SP]248.081[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[ETX][EOT]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP][SP]3[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP][SP]4[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[ETX][NUL]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP][SP]5[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[ETX][SOH]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP][SP]6[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.080[SP][SP]248.088[SP][SP]248.098[SP][SP]248.117[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP][SP]7[SP][SP]248.139[SP][SP]248.163[SP][SP]248.196[SP][SP]248.232[SP][SP]248.278[SP][SP]248.334[SP][SP]248.394[SP][SP]248.466[SP][SP]248.532[SP][SP]248.608[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP][SP]8[SP][SP]248.684[SP][SP]248.762[SP][SP]248.841[SP][SP]248.929[SP][SP]249.034[SP][SP]249.145[SP][SP]249.260[SP][SP]249.369[SP][SP]249.494[SP][SP]249.613[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP][SP]9[SP][SP]249.733[SP][SP]249.845[SP][SP]249.972[SP][SP]250.083[SP][SP]250.195[SP][SP]250.296[SP][SP]250.402[SP][SP]250.508[SP][SP]250.606[SP][SP]250.703[ETX][ETX]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]10[SP][SP]250.774[SP][SP]250.831[SP][SP]250.881[SP][SP]250.926[SP][SP]250.962[SP][SP]250.986[SP][SP]251.013[SP][SP]251.040[SP][SP]251.059[SP][SP]251.068[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]11[SP][SP]251.081[SP][SP]251.102[SP][SP]251.141[SP][SP]251.184[SP][SP]251.249[SP][SP]251.335[SP][SP]251.453[SP][SP]251.597[SP][SP]251.770[SP][SP]251.961[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]12[SP][SP]252.178[SP][SP]252.396[SP][SP]252.627[SP][SP]252.837[SP][SP]253.021[SP][SP]253.163[SP][SP]253.261[SP][SP]253.317[SP][SP]253.308[SP][SP]253.253[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]13[SP][SP]253.152[SP][SP]253.033[SP][SP]252.893[SP][SP]252.737[SP][SP]252.566[SP][SP]252.381[SP][SP]252.197[SP][SP]252.020[SP][SP]251.843[SP][SP]251.669[ETX][NAK]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]14[SP][SP]251.502[SP][SP]251.354[SP][SP]251.227[SP][SP]251.108[SP][SP]251.003[SP][SP]250.910[SP][SP]250.839[SP][SP]250.774[SP][SP]250.722[SP][SP]250.675[ETX][NAK]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]15[SP][SP]250.648[SP][SP]250.625[SP][SP]250.614[SP][SP]250.616[SP][SP]250.630[SP][SP]250.665[SP][SP]250.707[SP][SP]250.762[SP][SP]250.814[SP][SP]250.875[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]16[SP][SP]250.930[SP][SP]250.993[SP][SP]251.049[SP][SP]251.104[SP][SP]251.151[SP][SP]251.203[SP][SP]251.255[SP][SP]251.300[SP][SP]251.327[SP][SP]251.341[ETX][ETB]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]17[SP][SP]251.350[SP][SP]251.354[SP][SP]251.357[SP][SP]251.358[SP][SP]251.359[SP][SP]251.367[SP][SP]251.393[SP][SP]251.448[SP][SP]251.544[SP][SP]251.694[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]18[SP][SP]251.928[SP][SP]252.260[SP][SP]252.726[SP][SP]253.341[SP][SP]254.149[SP][SP]255.186[SP][SP]256.499[SP][SP]258.129[SP][SP]260.046[SP][SP]262.187[ETX][D1C]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]19[SP][SP]264.398[SP][SP]266.501[SP][SP]268.284[SP][SP]269.493[SP][SP]270.155[SP][SP]270.178[SP][SP]269.723[SP][SP]268.796[SP][SP]267.600[SP][SP]266.263[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]20[SP][SP]264.893[SP][SP]263.559[SP][SP]262.290[SP][SP]261.114[SP][SP]260.049[SP][SP]259.113[SP][SP]258.296[SP][SP]257.634[SP][SP]257.170[SP][SP]256.897[ETX][DLE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]21[SP][SP]256.861[SP][SP]257.088[SP][SP]257.686[SP][SP]258.715[SP][SP]260.240[SP][SP]262.319[SP][SP]265.000[SP][SP]268.296[SP][SP]272.195[SP][SP]276.642[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]22[SP][SP]281.503[SP][SP]286.637[SP][SP]291.828[SP][SP]296.845[SP][SP]301.431[SP][SP]305.335[SP][SP]308.177[SP][SP]309.998[SP][SP]310.555[SP][SP]309.991[ETX][CAN]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]23[SP][SP]308.085[SP][SP]305.135[SP][SP]301.396[SP][SP]297.202[SP][SP]292.848[SP][SP]288.602[SP][SP]284.642[SP][SP]281.073[SP][SP]277.911[SP][SP]275.141[ETX][NAK]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]24[SP][SP]272.722[SP][SP]270.605[SP][SP]268.737[SP][SP]267.060[SP][SP]265.536[SP][SP]264.127[SP][SP]262.813[SP][SP]261.580[SP][SP]260.422[SP][SP]259.336[ETX][ETB]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]25[SP][SP]258.328[SP][SP]257.397[SP][SP]256.561[SP][SP]255.800[SP][SP]255.136[SP][SP]254.547[SP][SP]254.041[SP][SP]253.614[SP][SP]253.259[SP][SP]252.974[ETX][SYN]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]26[SP][SP]252.759[SP][SP]252.611[SP][SP]252.522[SP][SP]252.482[SP][SP]252.497[SP][SP]252.556[SP][SP]252.659[SP][SP]252.795[SP][SP]252.947[SP][SP]253.092[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]27[SP][SP]253.216[SP][SP]253.310[SP][SP]253.361[SP][SP]253.358[SP][SP]253.304[SP][SP]253.188[SP][SP]253.026[SP][SP]252.819[SP][SP]252.593[SP][SP]252.354[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]28[SP][SP]252.125[SP][SP]251.912[SP][SP]251.727[SP][SP]251.576[SP][SP]251.461[SP][SP]251.383[SP][SP]251.353[SP][SP]251.363[SP][SP]251.391[SP][SP]251.447[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]29[SP][SP]251.544[SP][SP]251.710[SP][SP]251.939[SP][SP]252.218[SP][SP]252.535[SP][SP]252.887[SP][SP]253.260[SP][SP]253.653[SP][SP]254.039[SP][SP]254.410[ETX][CAN]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]30[SP][SP]254.754[SP][SP]255.097[SP][SP]255.434[SP][SP]255.794[SP][SP]256.174[SP][SP]256.618[SP][SP]257.158[SP][SP]257.827[SP][SP]258.645[SP][SP]259.582[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]31[SP][SP]260.581[SP][SP]261.577[SP][SP]262.552[SP][SP]263.594[SP][SP]264.941[SP][SP]267.043[SP][SP]270.405[SP][SP]275.442[SP][SP]282.145[SP][SP]290.005[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]32[SP][SP]298.214[SP][SP]305.860[SP][SP]312.711[SP][SP]322.458[SP][SP]348.346[SP][SP]405.937[SP][SP]504.280[SP][SP]637.795[SP][SP]789.687[SP][SP]935.921[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]33[SP]1041.121[SP]1098.752[SP]1097.079[SP]1054.894[SP][SP]974.563[SP][SP]879.507[SP][SP]782.574[SP][SP]693.744[SP][SP]616.792[SP][SP]552.171[ETX][DLE]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]34[SP][SP]498.473[SP][SP]453.865[SP][SP]416.691[SP][SP]385.775[SP][SP]360.317[SP][SP]339.490[SP][SP]322.498[SP][SP]308.726[SP][SP]297.517[SP][SP]288.392[ETX][SYN]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]35[SP][SP]281.014[SP][SP]275.033[SP][SP]270.193[SP][SP]266.301[SP][SP]263.163[SP][SP]260.637[SP][SP]258.624[SP][SP]257.012[SP][SP]255.719[SP][SP]254.690[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]36[SP][SP]253.866[SP][SP]253.207[SP][SP]252.671[SP][SP]252.240[SP][SP]251.878[SP][SP]251.583[SP][SP]251.316[SP][SP]251.092[SP][SP]250.890[SP][SP]250.716[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]37[SP][SP]250.553[SP][SP]250.406[SP][SP]250.280[SP][SP]250.177[SP][SP]250.091[SP][SP]250.014[SP][SP]249.941[SP][SP]249.887[SP][SP]249.830[SP][SP]249.783[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]38[SP][SP]249.731[SP][SP]249.687[SP][SP]249.643[SP][SP]249.602[SP][SP]249.569[SP][SP]249.530[SP][SP]249.492[SP][SP]249.452[SP][SP]249.421[SP][SP]249.399[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]39[SP][SP]249.372[SP][SP]249.346[SP][SP]249.320[SP][SP]249.301[SP][SP]249.284[SP][SP]249.269[SP][SP]249.247[SP][SP]249.223[SP][SP]249.198[SP][SP]249.172[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]40[SP][SP]249.146[SP][SP]249.120[SP][SP]249.093[SP][SP]249.067[SP][SP]249.040[SP][SP]249.021[SP][SP]249.004[SP][SP]248.989[SP][SP]248.975[SP][SP]248.961[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]41[SP][SP]248.947[SP][SP]248.934[SP][SP]248.928[SP][SP]248.916[SP][SP]248.905[SP][SP]248.892[SP][SP]248.879[SP][SP]248.866[SP][SP]248.853[SP][SP]248.848[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]42[SP][SP]248.844[SP][SP]248.842[SP][SP]248.841[SP][SP]248.841[SP][SP]248.840[SP][SP]248.840[SP][SP]248.848[SP][SP]248.858[SP][SP]248.877[SP][SP]248.891[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]43[SP][SP]248.922[SP][SP]248.954[SP][SP]248.991[SP][SP]249.013[SP][SP]249.033[SP][SP]249.065[SP][SP]249.108[SP][SP]249.155[SP][SP]249.204[SP][SP]249.264[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]44[SP][SP]249.318[SP][SP]249.380[SP][SP]249.444[SP][SP]249.533[SP][SP]249.627[SP][SP]249.744[SP][SP]249.866[SP][SP]250.002[SP][SP]250.134[SP][SP]250.259[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]45[SP][SP]250.359[SP][SP]250.436[SP][SP]250.503[SP][SP]250.556[SP][SP]250.596[SP][SP]250.606[SP][SP]250.592[SP][SP]250.552[SP][SP]250.493[SP][SP]250.417[ETX][D1C]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]46[SP][SP]250.326[SP][SP]250.221[SP][SP]250.109[SP][SP]250.010[SP][SP]249.912[SP][SP]249.816[SP][SP]249.714[SP][SP]249.626[SP][SP]249.556[SP][SP]249.500[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]47[SP][SP]249.443[SP][SP]249.397[SP][SP]249.352[SP][SP]249.326[SP][SP]249.296[SP][SP]249.276[SP][SP]249.258[SP][SP]249.243[SP][SP]249.228[SP][SP]249.206[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]48[SP][SP]249.191[SP][SP]249.175[SP][SP]249.153[SP][SP]249.130[SP][SP]249.105[SP][SP]249.095[SP][SP]249.096[SP][SP]249.094[SP][SP]249.094[SP][SP]249.086[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]49[SP][SP]249.084[SP][SP]249.082[SP][SP]249.081[SP][SP]249.081[SP][SP]249.080[SP][SP]249.080[SP][SP]249.080[SP][SP]249.072[SP][SP]249.062[SP][SP]249.051[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]50[SP][SP]249.047[SP][SP]249.035[SP][SP]249.016[SP][SP]248.994[SP][SP]248.978[SP][SP]248.962[SP][SP]248.948[SP][SP]248.926[SP][SP]248.911[SP][SP]248.895[ETX][CAN]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]51[SP][SP]248.881[SP][SP]248.867[SP][SP]248.854[SP][SP]248.840[SP][SP]248.819[SP][SP]248.796[SP][SP]248.779[SP][SP]248.771[SP][SP]248.758[SP][SP]248.746[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]52[SP][SP]248.733[SP][SP]248.728[SP][SP]248.724[SP][SP]248.714[SP][SP]248.704[SP][SP]248.692[SP][SP]248.687[SP][SP]248.684[SP][SP]248.674[SP][SP]248.664[ETX][SYN]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]53[SP][SP]248.652[SP][SP]248.639[SP][SP]248.626[SP][SP]248.605[SP][SP]248.582[SP][SP]248.557[SP][SP]248.532[SP][SP]248.514[SP][SP]248.497[SP][SP]248.482[ETX][SYN]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]54[SP][SP]248.460[SP][SP]248.436[SP][SP]248.411[SP][SP]248.394[SP][SP]248.377[SP][SP]248.362[SP][SP]248.348[SP][SP]248.326[SP][SP]248.311[SP][SP]248.295[ETX]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]55[SP][SP]248.289[SP][SP]248.277[SP][SP]248.265[SP][SP]248.252[SP][SP]248.248[SP][SP]248.244[SP][SP]248.242[SP][SP]248.241[SP][SP]248.233[SP][SP]248.223[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]56[SP][SP]248.203[SP][SP]248.189[SP][SP]248.174[SP][SP]248.169[SP][SP]248.165[SP][SP]248.163[SP][SP]248.161[SP][SP]248.161[SP][SP]248.160[SP][SP]248.152[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]57[SP][SP]248.143[SP][SP]248.131[SP][SP]248.127[SP][SP]248.124[SP][SP]248.122[SP][SP]248.121[SP][SP]248.121[SP][SP]248.120[SP][SP]248.120[SP][SP]248.120[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]58[SP][SP]248.120[SP][SP]248.120[SP][SP]248.120[SP][SP]248.120[SP][SP]248.120[SP][SP]248.120[SP][SP]248.120[SP][SP]248.120[SP][SP]248.120[SP][SP]248.120[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]59[SP][SP]248.120[SP][SP]248.120[SP][SP]248.120[SP][SP]248.112[SP][SP]248.102[SP][SP]248.091[SP][SP]248.087[SP][SP]248.084[SP][SP]248.082[SP][SP]248.081[ETX] "));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]60[SP][SP]248.081[SP][SP]248.088[SP][SP]248.090[SP][SP]248.092[SP][SP]248.084[SP][SP]248.083[SP][SP]248.082[SP][SP]248.081[SP][SP]248.081[SP][SP]248.080[ETX][EB]"));
        this.dataChanged(this.equipamento.arruma("[STX]7[SP]61[SP][SP]248.080[SP][SP]248.080[SP][SP]248.120[SP][SP][SP][SP]0.000[SP][SP][SP][SP]0.000[SP][SP][SP][SP]0.000[SP][SP][SP][SP]0.000[SP][SP][SP][SP]0.000[SP][SP][SP][SP]0.000[SP][SP][SP][SP]0.000[ETX][ACK]"));
        this.dataChanged(this.equipamento.arruma("[STX]8[ETX];[EOT]"));
    }

    private int calculaTamanhoFonte(int larguraDisponivel) {
        return (5 * larguraDisponivel + 2740) / 524;
    }

    private int calculaPosicaoDoEixoX(int larguraDisponivel, int qtdePontos, int bordaHorizontal, int x) {
        return x * larguraDisponivel / qtdePontos + bordaHorizontal;
    }

    private Color getCorPontoRachura(int[] rachuras, int posicaoNoEixoX) {
        if (posicaoNoEixoX > rachuras[7] && posicaoNoEixoX < rachuras[6]) {
            return this.configuracao.getGraficoPreto() != false ? this.CORES_RACHURA_PRETO[0] : this.CORES_RACHURA[0];
        }
        if (posicaoNoEixoX > rachuras[5] && posicaoNoEixoX < rachuras[4]) {
            return this.configuracao.getGraficoPreto() != false ? this.CORES_RACHURA_PRETO[1] : this.CORES_RACHURA[1];
        }
        if (posicaoNoEixoX > rachuras[3] && posicaoNoEixoX < rachuras[2]) {
            return this.configuracao.getGraficoPreto() != false ? this.CORES_RACHURA_PRETO[2] : this.CORES_RACHURA[2];
        }
        if (posicaoNoEixoX > rachuras[1] && posicaoNoEixoX < rachuras[0]) {
            return this.configuracao.getGraficoPreto() != false ? this.CORES_RACHURA_PRETO[3] : this.CORES_RACHURA[3];
        }
        return null;
    }

    private void parseFracoes(List<PeakData> peakDatas, Map<String, Object> dados) {
        int fracao = 0;
        for (PeakData pd : peakDatas) {
            if (Funcoes.textoVazio(pd.peakName)) continue;
            String campo = "fracao" + (++fracao + 1);
            String campoPerc = campo + "_porcentagem";
            String campoValor = campo + "_contagem";
            String perc = String.valueOf(pd.peakAreaPerc);
            String vlr = String.valueOf(pd.peakArea);
            perc = perc.replaceAll("\\.", ",");
            vlr = vlr.replaceAll("\\.", ",");
            dados.put(campoPerc.toLowerCase(), perc);
            dados.put(campoValor.toLowerCase(), vlr);
        }
    }

    private int[] obtemPosicaoRachurasGrafico(String message, int qtdePontos) {
        int[] posicaoRachuras = new int[8];
        return posicaoRachuras;
    }

    private void parseCurva(String mensagem, Map<String, Object> dados, int larguraDisponivel, int alturaDisponivel, DadosResultado dadosResultado) {
        List<PeakData> peakDatas = dadosResultado.peakDatas;
        List<RawData> rawDatas = dadosResultado.rawDatas;
        int qtdePontos = dadosResultado.dataCollectionParameters.numberOfRawDataSets;
        int[] rachuras = this.obtemPosicaoRachurasGrafico(mensagem, qtdePontos);
        String[] nomesFracoes = new String[peakDatas.size()];
        int x = 0;
        for (PeakData pd : peakDatas) {
            nomesFracoes[x] = pd.peakName;
        }
        int[] posicoesFracoes = new int[peakDatas.size() + 1];
        String pontos = peakDatas.get((int)0).baseStartPoint.toString();
        CategoryTableXYDataset dt = new CategoryTableXYDataset();
        double altura = 0.0;
        for (int i = 0; i < rawDatas.size(); ++i) {
            for (Double y : rawDatas.get((int)i).blockSignal) {
                if (null == y || y == 0.0) continue;
                altura = y;
                if (y < 1.0) {
                    altura = 1.0;
                }
                dt.add((double)i, altura, "");
            }
        }
        JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)"", (String)"", (XYDataset)dt, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        XYPlot plt = chart.getXYPlot();
        plt.setRangeGridlinesVisible(false);
        plt.setDomainGridlinesVisible(false);
        plt.setOutlinePaint((Paint)Color.WHITE);
        plt.setDomainTickBandPaint((Paint)Color.WHITE);
        plt.getDomainAxis().setRange(0.0, (double)qtdePontos);
        plt.getDomainAxis().setTickLabelsVisible(false);
        plt.getDomainAxis().setTickMarksVisible(false);
        plt.getRangeAxis().setTickLabelsVisible(false);
        plt.getRangeAxis().setTickMarksVisible(false);
        plt.getDomainAxis().setInverted(true);
        plt.setInsets(new Insets(0, 0, 0, 0));
        XYItemRenderer lineRenderer = plt.getRenderer();
        lineRenderer.setSeriesPaint(0, (Paint)Color.BLACK);
        plt.setRenderer(lineRenderer);
        int width = larguraDisponivel;
        int height = alturaDisponivel;
        int bordaHorizontal = 10;
        int bordaVertical = 10;
        bordaHorizontal = bordaHorizontal * larguraDisponivel / qtdePontos;
        bordaVertical = bordaVertical * alturaDisponivel / 108;
        BufferedImage imgGrafico = chart.createBufferedImage(width, height);
        BufferedImage imgFinal = new BufferedImage(width, height, 1);
        Graphics g = imgFinal.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.BLACK);
        g.drawImage(imgGrafico, bordaHorizontal, bordaVertical, null);
        g.setColor(this.configuracao.getGraficoPreto() != false ? Color.BLACK : Color.BLUE);
        g.drawLine(bordaHorizontal, height + bordaVertical, width + bordaHorizontal, height + bordaVertical);
        block3: for (int j = 0; j < qtdePontos; ++j) {
            Color cor = this.getCorPontoRachura(rachuras, x);
            if (cor == null) continue;
            g.setColor(cor);
            for (int y = height + bordaVertical - 1; y > 0; --y) {
                if (imgFinal.getRGB(this.calculaPosicaoDoEixoX(larguraDisponivel, qtdePontos, bordaHorizontal, x), y) == -1) continue;
                g.drawLine(this.calculaPosicaoDoEixoX(larguraDisponivel, qtdePontos, bordaHorizontal, x), height + bordaVertical - 1, this.calculaPosicaoDoEixoX(larguraDisponivel, qtdePontos, bordaHorizontal, x), y);
                continue block3;
            }
        }
        JLabel label = new JLabel();
        Font fonte = new Font(label.getFont().getName(), label.getFont().getStyle(), this.calculaTamanhoFonte(larguraDisponivel));
        g.setFont(fonte);
        FontMetrics metrica = g.getFontMetrics(fonte);
        g.setColor(Color.BLACK);
        for (int i = 0; i < posicoesFracoes.length - 1; ++i) {
            int posicaoX = 0;
            int posicaoY = Integer.MAX_VALUE;
            block6: for (int k = posicoesFracoes[i]; k < posicoesFracoes[i + 1]; ++k) {
                for (int y = height + bordaVertical - 1; y > 0; --y) {
                    if (imgFinal.getRGB(x, y) == -1) continue;
                    if (posicaoY <= y) continue block6;
                    posicaoY = y;
                    posicaoX = x;
                    continue block6;
                }
            }
        }
        Image i = Toolkit.getDefaultToolkit().createImage(imgFinal.getSource());
        String foto64 = new Base64().encodeAsString(ImagemUtils.imageToByte(i));
        dados.put("eforese_grafico", foto64);
    }

    private void geraImagemCurva(BufferedImage image, String name) {
        File img = new File("C://thread//" + name + ".png");
        try {
            ImageIO.write((RenderedImage)image, "png", img);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class RawDataEnd
    extends Record {
        public RawDataEnd(String message) {
            super(String.valueOf(message.charAt(0)));
        }
    }

    class RawData
    extends Record {
        Integer blockNumber;
        List<Double> blockSignal;

        public RawData(String message) {
            super(String.valueOf(message.charAt(0)));
            this.blockSignal = new ArrayList<Double>();
            if (message.length() >= 4 && Funcoes.isNumeric(message.substring(1, 4))) {
                this.blockNumber = Integer.parseInt(message.substring(1, 4).trim());
            }
            String signals = message.substring(4);
            for (int i = 0; i < 10; ++i) {
                if (message.length() >= i * 9 + 9 && Funcoes.isNumeric(signals.substring(i * 9, i * 9 + 9))) {
                    this.blockSignal.add(Double.parseDouble(signals.substring(i * 9, i * 9 + 9)));
                    continue;
                }
                this.blockSignal.add(null);
            }
        }
    }

    class PeakDataEnd
    extends Record {
        public PeakDataEnd(String message) {
            super(String.valueOf(message.charAt(0)));
        }
    }

    class PeakData
    extends Record {
        Integer peakNumber;
        String peakName;
        String peakShape;
        Integer baseStartPoint;
        Integer baseEndPoint;
        Integer peakStartPoint;
        Integer peakTop;
        Integer peakEndPoint;
        Double peakArea;
        Double peakAreaPerc;

        public PeakData(String message) {
            super(String.valueOf(message.charAt(0)));
            if (message.length() >= 3 && Funcoes.isNumeric(message.substring(1, 3))) {
                this.peakNumber = Integer.parseInt(message.substring(1, 3).trim());
            }
            if (message.length() >= 8) {
                this.peakName = message.substring(3, 8);
            }
            if (message.length() >= 9) {
                this.peakShape = message.substring(8, 9);
            }
            if (message.length() >= 13 && Funcoes.isNumeric(message.substring(9, 13))) {
                this.baseStartPoint = Integer.parseInt(message.substring(9, 13).trim());
            }
            if (message.length() >= 17 && Funcoes.isNumeric(message.substring(13, 17))) {
                this.baseEndPoint = Integer.parseInt(message.substring(13, 17).trim());
            }
            if (message.length() >= 21 && Funcoes.isNumeric(message.substring(17, 21))) {
                this.peakStartPoint = Integer.parseInt(message.substring(17, 21).trim());
            }
            if (message.length() >= 25 && Funcoes.isNumeric(message.substring(21, 25))) {
                this.peakTop = Integer.parseInt(message.substring(21, 25).trim());
            }
            if (message.length() >= 29 && Funcoes.isNumeric(message.substring(25, 29))) {
                this.peakEndPoint = Integer.parseInt(message.substring(25, 29).trim());
            }
            if (message.length() >= 37 && Funcoes.isNumeric(message.substring(29, 37))) {
                this.peakArea = Double.parseDouble(message.substring(29, 37).trim());
            }
            if (message.length() >= 42 && Funcoes.isNumeric(message.substring(37, 42))) {
                this.peakAreaPerc = Double.parseDouble(message.substring(37, 42).trim());
            }
        }
    }

    class DataCollectionParameters
    extends Record {
        Integer startTime;
        Integer pitch;
        Integer numberOfPeaks;
        Integer numberOfRawDataSets;

        public DataCollectionParameters(String message) {
            super(String.valueOf(message.charAt(0)));
            if (message.length() >= 5 && Funcoes.isNumeric(String.valueOf(message.substring(1, 5)))) {
                this.startTime = Integer.parseInt(message.substring(1, 5).trim());
            }
            if (message.length() >= 6 && Funcoes.isNumeric(String.valueOf(message.substring(5, 6)))) {
                this.pitch = Integer.parseInt(message.substring(5, 6).trim());
            }
            if (message.length() >= 8 && Funcoes.isNumeric(String.valueOf(message.substring(6, 8)))) {
                this.numberOfPeaks = Integer.parseInt(message.substring(6, 8).trim());
            }
            if (message.length() >= 12 && Funcoes.isNumeric(String.valueOf(message.substring(8, 12)))) {
                this.numberOfRawDataSets = Integer.parseInt(message.substring(8, 12).trim());
            }
        }
    }

    class MeasurementValue
    extends Record {
        String flagJudgement;
        List<String> component;

        public MeasurementValue(String message) {
            super(String.valueOf(message.charAt(0)));
            this.component = new ArrayList<String>();
            this.flagJudgement = message.substring(1, 3);
            String component = message.substring(3);
            if (component.length() == 60) {
                for (int i = 0; i < 12; ++i) {
                    if (message.length() >= i * 5 + 5) {
                        this.component.add(component.substring(i * 5, i * 5 + 5));
                        continue;
                    }
                    this.component.add("");
                }
            }
        }
    }

    class SampleNumber
    extends Record {
        Integer sampleNumber;

        public SampleNumber(String message) {
            super(String.valueOf(message.charAt(0)));
            if (message.length() >= 1 && Funcoes.isNumeric(message.substring(1))) {
                this.sampleNumber = Integer.parseInt(message.substring(1).trim());
            }
        }
    }

    class SampleInformation
    extends Record {
        Integer operationMode;
        Integer samplePosition;
        String sampleId;

        public SampleInformation(String message) {
            super(String.valueOf(message.charAt(0)));
            if (message.length() >= 1 && Funcoes.isNumeric(String.valueOf(message.charAt(1)))) {
                this.operationMode = Integer.parseInt(String.valueOf(message.charAt(1)));
            }
            if (message.length() >= 2 && Funcoes.isNumeric(String.valueOf(message.charAt(2)))) {
                this.samplePosition = Integer.parseInt(String.valueOf(message.charAt(2)));
            }
            if (message.length() >= 3 && !Funcoes.textoVazio(message.substring(3))) {
                this.sampleId = message.substring(3).trim();
            }
        }
    }

    abstract class Record {
        String header;

        public Record(String header) {
            this.header = header;
        }
    }

    class DadosResultado {
        SampleInformation sampleInformation;
        SampleNumber sampleNumber;
        MeasurementValue measurementValue;
        DataCollectionParameters dataCollectionParameters;
        List<PeakData> peakDatas = new ArrayList<PeakData>();
        PeakDataEnd peakDataEnd;
        List<RawData> rawDatas = new ArrayList<RawData>();
        RawDataEnd rawDataEnd;

        DadosResultado() {
        }
    }

    class HostResponseQuery
    extends Record {
        String sampleId;
        String sampleType;
        String containerType;
        String a1cItem;

        public HostResponseQuery(String header, String sampleId, String sampleType, String containerType, String a1cItem) {
            super(header);
            this.sampleId = sampleId;
            this.sampleType = sampleType;
            this.containerType = containerType;
            this.a1cItem = a1cItem;
        }

        public String enviaPaciente() {
            StringBuilder frame = new StringBuilder(this.header);
            frame.append(",");
            frame.append(StringUtil.preencheString(this.sampleId, 20, ' ', 0));
            frame.append(",");
            frame.append(this.sampleType);
            frame.append(this.containerType);
            frame.append("  ");
            frame.append(",");
            frame.append(this.a1cItem);
            frame.append("      ");
            frame.append(",");
            frame.append("        ");
            return frame.toString();
        }
    }

    class AnalyzerQuery
    extends Record {
        String sampleId;

        public AnalyzerQuery(String message) {
            super(String.valueOf(message.charAt(0)));
            if (message.length() >= 2) {
                this.sampleId = message.substring(2).trim();
            }
        }
    }

    private static enum TipoExame {
        STD_MODE("0"),
        VAR_MODE("1"),
        BETA_THALASSEMI_MODE("2");

        String codigo = "";

        private TipoExame(String codigo) {
            this.codigo = codigo;
        }

        public String toString() {
            return this.codigo;
        }

        public static TipoExame getTipoExame(String codigo) {
            for (TipoExame aux : TipoExame.values()) {
                if (!aux.codigo.equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }
    }

    private static enum TipoMensagem {
        DADOS_ANALISE("A"),
        DADOS_REQUEST("G"),
        DADOS_SAMPLE_INFORMATION("1"),
        DADOS_SAMPLE_NUMBER("2"),
        DADOS_SAMPLE_MEASUREMENT_VALUE("3"),
        DADOS_SAMPLE_COLLECTION_PARAMETERS("4"),
        DADOS_SAMPLE_PEAK_DATA("5"),
        DADOS_SAMPLE_PEAK_DATA_END("6"),
        DADOS_SAMPLE_RAW_DATA("7"),
        DADOS_SAMPLE_RAW_DATA_END("8");

        String codigo = "";

        private TipoMensagem(String codigo) {
            this.codigo = codigo;
        }

        public String toString() {
            return this.codigo;
        }
    }
}

