/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.thermoscientific;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.arquivo.InterfaceArquivoListener;
import jalis.util.Funcoes;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.excel.Excel;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class InterfaceListener
extends InterfaceArquivoListener {
    private final int COL_ID_SAMPLE = 0;
    private final int COL_CALCULATED_AMOUNT = 5;
    private final int COL_ACQ_DATE = 30;
    private String diretorioImportacao = "";
    ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
    private Map<String, String> recipientes = new HashMap<String, String>();

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.diretorioImportacao = c.getDiretorioImportacao();
        this.recipientes = this.getRecipientes();
    }

    private Map<String, String> getRecipientes() {
        String int_codigo = "0";
        for (ConfiguracaoSerial c : Variaveis.equipamentos) {
            for (EquipamentoFilial e : c.getEquipamentos()) {
                int_codigo = e.getEquipamento().toString();
            }
        }
        StringBuilder query = new StringBuilder();
        query.append("select emi_alternativo, rec_codigo  ");
        query.append("  from examematinterface a ");
        query.append("  left join recipcoleta b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and  a.mco_codigo = b.mco_codigo ");
        query.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        query.append(" and a.int_codigo = ").append(int_codigo);
        query.append(" and emi_alternativo is not null and emi_alternativo <> '' ");
        Statement st = Conexao.getStatement();
        HashMap<String, String> recipientes = new HashMap<String, String>();
        try {
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                if (Funcoes.textoVazio(rs.getString("emi_alternativo").trim())) continue;
                recipientes.put(rs.getString("emi_alternativo"), rs.getString("rec_codigo"));
            }
            st.close();
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return recipientes;
    }

    @Override
    public void buscarResultados(Date inicio, Date termino) {
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser("Arquivo para importa\u00e7\u00e3o", this.diretorioImportacao);
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de Planilha de resultado", "xls"));
            if (chooser.showOpenDialog(null) == 0) {
                String path = chooser.getSelectedFile().getPath();
                this.parse(path);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
    }

    @Override
    public String parse(String path) {
        File file = new File(path);
        try {
            Statement st = Conexao.getStatement();
            HSSFWorkbook filePlan = Excel.lerAllPlans(file);
            for (int i = 0; i < filePlan.getNumberOfSheets(); ++i) {
                String alternativo = filePlan.getSheetName(i);
                HSSFSheet plan = filePlan.getSheetAt(i);
                for (int j = 5; j <= plan.getLastRowNum(); ++j) {
                    String rec_codigo;
                    String req_codigo;
                    String amostra;
                    if (plan.getRow(j) == null || plan.getRow(j).getLastCellNum() < 30 || plan.getRow(j).getCell(0) == null || (amostra = plan.getRow(j).getCell(0).getStringCellValue()).isEmpty()) continue;
                    if (amostra.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
                        this.fireExcecaoEncontrada(String.format("ID Amostra fora do tamanho definido nas conf. gerais %s.", amostra));
                        continue;
                    }
                    if (!Funcoes.isNumeric(amostra)) {
                        this.fireExcecaoEncontrada(String.format("ID Amostra inv\u00e1lida %s.", amostra));
                        continue;
                    }
                    if (!this.recipientes.containsKey(alternativo) || Funcoes.textoVazio(this.recipientes.get(alternativo))) {
                        this.fireExcecaoEncontrada(String.format("Exame do equipamento com alternativo %s n\u00e3o configurado.", alternativo));
                        continue;
                    }
                    String fil_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String int_codigo = this.getIntCodigo(fil_codigo, req_codigo = amostra.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo = Funcoes.preencheZero(this.recipientes.get(alternativo), ParametrosGerais.getDigitosTuboTubo()), alternativo);
                    if (int_codigo == null) {
                        this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada %s %s %s.", fil_codigo, req_codigo, rec_codigo));
                        continue;
                    }
                    ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, alternativo);
                    if (exame != null) {
                        String resultado = "";
                        if (1 == plan.getRow(j).getCell(5).getCellType()) {
                            resultado = plan.getRow(j).getCell(5).getStringCellValue();
                        } else if (0 == plan.getRow(j).getCell(5).getCellType()) {
                            resultado = String.valueOf(plan.getRow(j).getCell(5).getNumericCellValue());
                        }
                        String data = "";
                        if (0 == plan.getRow(j).getCell(30).getCellType()) {
                            data = Funcoes.formataData("dd/MM/yyyy HH:mm", plan.getRow(j).getCell(30).getDateCellValue());
                        }
                        HashMap<String, Object> dados = new HashMap<String, Object>();
                        dados.put("data_resultado", data);
                        if (Funcoes.isNumeric(resultado)) {
                            dados.put("resultado_quantitativo", this.converteResultado(resultado));
                            dados.put("resultado_qualitativo", "");
                        } else {
                            dados.put("resultado_qualitativo", resultado);
                            dados.put("resultado_quantitativo", "");
                        }
                        this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
                        Conexao.arquivaSQL();
                        continue;
                    }
                    this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada para o exame %s %s %s.", fil_codigo, req_codigo, rec_codigo));
                }
            }
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fireExcecaoEncontrada("Resultado n\u00e3o encontrado no arquivo " + file.getName() + e.getMessage());
        }
        return null;
    }

    private Object converteResultado(Object resultado) {
        return resultado != null && !Funcoes.textoVazio(resultado.toString()) ? resultado.toString().replaceAll("\\.", ",") : "";
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            if (acao.equals("R")) {
                this.buscarResultados(null, null);
                return "";
            }
            Statement st = Conexao.getStatement();
            rackposition = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            rackposition = rackposition + Funcoes.preencheZero(Long.parseLong(req_codigo), ParametrosGerais.getDigitosTuboRequisicao());
            this.atualizarSituacaoRackTubo(st, fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, 1, rackposition);
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
            this.fireAtualizarTabela(1);
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }
}

