/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.thermoct300;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    private static final String REPETICAO = "repeticao";
    LinkedList<Map<String, String>> flags = new LinkedList();

    public RecordParser() {
        HashMap<String, String> technicalRangeCode = new HashMap<String, String>();
        technicalRangeCode.put("01", "Technical range over \"High\"");
        technicalRangeCode.put("02", "Technical range over \"Low\"");
        HashMap<String, String> normalRangeCode = new HashMap<String, String>();
        normalRangeCode.put("01", "Normal range over \"High\"");
        normalRangeCode.put("02", "Normal range over \"Low\"");
        HashMap<String, String> errorFlagCode = new HashMap<String, String>();
        errorFlagCode.put("01", "Sample short");
        errorFlagCode.put("02", "Sample liquid level detection out of range at aspiration.");
        errorFlagCode.put("03", "Sample liquid level not detected at aspiration");
        errorFlagCode.put("04", "Sample liquid level detection out of range at dispensation");
        errorFlagCode.put("05", "Sample short (diluted sample)");
        errorFlagCode.put("06", "Sample liquid level detection out of range at aspiration (diluted sample)");
        errorFlagCode.put("07", "R1 short");
        errorFlagCode.put("08", "R1 liquid level detection out of range at aspiration");
        errorFlagCode.put("09", "R2 short");
        errorFlagCode.put("10", "R2 liquid level detection out of range at aspiration");
        errorFlagCode.put("15", "Diluent short");
        errorFlagCode.put("16", "Diluent liquid level detection out of range at aspiration");
        errorFlagCode.put("17", "Wash solution short");
        errorFlagCode.put("18", "Wash solution liquid level detection out of range at aspiration");
        errorFlagCode.put("19", "R1 reagent bottle not registered.");
        errorFlagCode.put("20", "R1 reagent no inventory");
        errorFlagCode.put("21", "R2 reagent bottle not registered.");
        errorFlagCode.put("22", "R2 reagent no inventory");
        errorFlagCode.put("27", "Diluent bottle not registered.");
        errorFlagCode.put("28", "Diluent no inventory");
        errorFlagCode.put("29", "Wash solution bottle not registered.");
        errorFlagCode.put("30", "Wash solution no inventory");
        errorFlagCode.put("31", "Sampling stop due to error");
        errorFlagCode.put("32", "Reagent lot number mismatch");
        errorFlagCode.put("33", "SPT wash failure");
        errorFlagCode.put("34", "RPT wash between methods failed (R1)");
        errorFlagCode.put("35", "RPT wash between methods failed (R2)");
        errorFlagCode.put("38", "SPT clot");
        errorFlagCode.put("40", "IRU temperature less than 35 degrees centigrade.");
        errorFlagCode.put("41", "IRU temperature more than 39 degrees centigrade.");
        errorFlagCode.put("42", "RCU temperature more than 15 degrees centigrade.");
        errorFlagCode.put("50", "Measured with expired reagent");
        errorFlagCode.put("51", "Measured with expired onboard stability reagent");
        errorFlagCode.put("52", "Terms of validity of calibration is expired");
        errorFlagCode.put("53", "Control expired");
        errorFlagCode.put("54", "Calibrator expired");
        errorFlagCode.put("60", "No response from ISE module.");
        errorFlagCode.put("61", "No measurement results from ISE module.");
        errorFlagCode.put("62", "ISE unit abnormal");
        errorFlagCode.put("70", "Concentration calculation failure");
        errorFlagCode.put("71", "Calibrator out of valid range error");
        errorFlagCode.put("72", "Linearity Limit error");
        errorFlagCode.put("73", "Prozone Limit error");
        errorFlagCode.put("74", "Absorbance Limit1 error");
        errorFlagCode.put("75", "Absorbance Limit2 error");
        errorFlagCode.put("76", "Duplicate Limit error");
        errorFlagCode.put("77", "Sensitivity Limit error");
        errorFlagCode.put("78", "Calibration failed");
        errorFlagCode.put("82", "Sample type mismatch");
        errorFlagCode.put("83", "Reagent lot mismatch");
        errorFlagCode.put("84", "Measurement is not performed due to reagent mismatch.");
        HashMap<String, String> rerunResultCode = new HashMap<String, String>();
        rerunResultCode.put("00", "Primeiro Resultado");
        rerunResultCode.put("01", "Segundo resultado");
        technicalRangeCode.put("1", "Current result exceeds 2SD");
        technicalRangeCode.put("2", "Current result exceeds 3SD");
        technicalRangeCode.put("3", "Current result exceeds 4SD");
        technicalRangeCode.put("4", "Last two results exceed 2SD range");
        technicalRangeCode.put("5", "2 results out of 3 last results exceed 2SD");
        technicalRangeCode.put("6", "Range for a defined period exceeds 4SD");
        technicalRangeCode.put("7", "Any 3 results for a defined period exceed 1SD");
        technicalRangeCode.put("8", "Any 4 results for a defined period exceed 1SD");
        technicalRangeCode.put("9", "Last 10 results higher or lower than mean");
        technicalRangeCode.put("10", "Last 7 results trend");
        this.flags.add(technicalRangeCode);
        this.flags.add(normalRangeCode);
        this.flags.add(errorFlagCode);
        this.flags.add(rerunResultCode);
        this.flags.add(technicalRangeCode);
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        int tamTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        if (req_codigo.length() >= tamTubo) {
            req_codigo = req_codigo.substring(0, tamTubo);
        }
        DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(req_codigo);
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        if (!Funcoes.textoVazio(req_codigo) && req_codigo.contains("^")) {
            req_codigo = StringUtil.limpaString(req_codigo, new String[]{"^"});
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        req_codigo = Funcoes.preencheZero(req_codigo, tamTubo);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        Statement st = Conexao.getStatement();
        if (etiqueta != null) {
            fil_codigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            rec_codigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
        }
        this.exame_atual.put("fil_codigo", fil_codigo);
        this.exame_atual.put("req_codigo", req_codigo);
        this.exame_atual.put("rec_codigo", rec_codigo);
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        String[] listaFlags;
        Statement st;
        int sit;
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String result_status = (String)result_fields.get(ASTMStandard.RESULT_FIELD_RESULT_STATUS);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String[] emi_alternativo = ((String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID)).split("\\^");
        String codigoAlternativo = "";
        if (Funcoes.textoVazio(emi_alternativo[3])) {
            this.equip.fireExcecaoEncontrada("N\u00e3o foi possivel identificar o c\u00f3digo LIS do exame para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return;
        }
        codigoAlternativo = emi_alternativo[3];
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, codigoAlternativo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + codigoAlternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, codigoAlternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + codigoAlternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
        String exa_codigo = exame.getNomeExame();
        String mco_codigo = exame.getCodigoMaterial();
        resultado = resultado.replaceAll("\\.", ",");
        if (resultado.startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        String campo = (sit = this.equip.getExameSituacao(st = Conexao.getStatement(), fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo)) < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !Funcoes.textoVazio(flags) && (listaFlags = flags.split("\\^")) != null && listaFlags.length > 4) {
            if (!this.exame_atual.containsKey("flag")) {
                this.exame_atual.put("flag", new ArrayList());
            }
            ((ArrayList)this.exame_atual.get("flag")).add(this.flags.get(0).get(listaFlags[0]));
            ((ArrayList)this.exame_atual.get("flag")).add(this.flags.get(1).get(listaFlags[1]));
            ((ArrayList)this.exame_atual.get("flag")).add(this.flags.get(2).get(listaFlags[2]));
            if (listaFlags[3].equals("01") && sit == 2) {
                this.equip.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, null, 3);
                campo = "repeticao_quantitativo";
            }
        }
        this.exame_atual.put(campo, resultado);
        try {
            this.salvaExame(this.exame_atual);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void trataTerminationRecord() throws Exception {
        this.exame_atual = null;
        super.trataTerminationRecord();
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.get(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.get(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.get(REC_CODIGO);
        ArrayList flags = (ArrayList)this.exame_atual.get("flag");
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados, flags);
    }
}

