/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.thermoct300;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.thermoct300.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.CodString;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    private ThreadRecebimento threadRecebimento;
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean hostQuery = false;
    private boolean semExames = false;

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.MAX_PATIENT_NAME_CHARS = 36;
        this.HOST_NAME = "60^HOST";
        this.INSTRUMENT_NAME = "";
        this.HOST_SYSTEM_VERSION = "5.0";
        this.threadRecebimento = new ThreadRecebimento(this);
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        if (portaCOM instanceof PortaSocketServer) {
            ((PortaSocketServer)portaCOM).setEscreverEmBytes(true);
        }
        super.setPortaCOM(portaCOM);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            Object exameCurva;
            this.tx_list.clear();
            this.rx_list.clear();
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            if (!this.hostQuery) {
                this.encerrarTransmissao();
                return "";
            }
            ExameMaterial[] alternativos = null;
            ExameMaterial[] listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String exame = exa_lista[0].toString();
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            String tipo_amostra = "";
            if (exa_lista != null) {
                tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, (exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista))[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
                if (Funcoes.textoVazio(tipo_amostra)) {
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exame, mco_codigo, int_codigo);
                }
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.removeDuplicados(alternativos);
            }
            if (!exa_listaCurva.isEmpty()) {
                exameCurva = new ArrayList();
                for (ExameMaterial exameMaterial : exa_listaCurva) {
                    exameCurva.add(exameMaterial.getNomeExame());
                }
                if (Funcoes.textoVazio(this.rec_tuboPai)) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, (String)exameCurva.get(0), mco_codigo);
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((ExameMaterial)exa_listaCurva.get(0)).getString(), ((ExameMaterial)exa_listaCurva.get(0)).getCodigo().toString(), int_codigo);
                }
                listaCurva = ExamesUtil.anexarCodigoMaterial(exameCurva.toArray(new String[exameCurva.size()]), mco_codigo);
                listaCurva = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, String.valueOf(Integer.parseInt(rec_codigo)), st, exa_listaCurva, this.rec_tuboPai, true, this.examesFilho);
            }
            if (Funcoes.textoVazio(tipo_amostra)) {
                if (exa_lista != null) {
                    Object ex;
                    exameCurva = exa_lista;
                    int n = ((ExameMaterial[])exameCurva).length;
                    for (int exameMaterial = 0; exameMaterial < n && Funcoes.textoVazio(tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((CodString)(ex = exameCurva[exameMaterial])).getString(), ((CodString)ex).getCodigo().toString(), int_codigo)); ++exameMaterial) {
                    }
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    for (String exFilho : this.examesFilho) {
                        tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exFilho, mco_codigo, int_codigo);
                    }
                }
            }
            this.tx_list.add(this.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION, null));
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            Date dataNasc = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String sex = "U";
            if (!Funcoes.textoVazio(pac_sexo) && pac_sexo.equalsIgnoreCase("M")) {
                sex = "M";
            } else if (!Funcoes.textoVazio(pac_sexo) && pac_sexo.equalsIgnoreCase("F")) {
                sex = "F";
            }
            String t = this.getPatientRecord(1, patient_id.toString(), short_name, sex, dataNasc);
            this.tx_list.add(t);
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                t = this.getOrderRecord(++seq, codigo.toString(), alternativos, acao, tipo_amostra);
                this.tx_list.add(t);
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    t = this.getOrderRecord(++seq, sample_id.append(tubo).toString(), alternativosCurva.get(key).toArray(new ExameMaterial[alternativosCurva.get(key).size()]), acao, tipo_amostra);
                    this.tx_list.add(t);
                }
            }
            t = this.getTerminationRecord();
            this.tx_list.add(t);
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public String getDefaultHeaderRecord(String delimiters, String password, String sender_id_name, String sender_id_system, String control, String receiver_id_name, String receiver_id_system, String version_number) {
        StringBuilder record = new StringBuilder("H|");
        record.append(delimiters == null ? "" : delimiters);
        record.append("||");
        record.append(password == null ? "" : password);
        record.append("|");
        record.append(sender_id_name == null ? "" : sender_id_name);
        record.append(sender_id_system == null ? "" : "^" + sender_id_system);
        record.append("||||");
        record.append(control == null ? "" : control);
        record.append("|");
        record.append(receiver_id_name == null ? "" : receiver_id_name);
        record.append(receiver_id_system == null ? "" : "^" + receiver_id_system);
        record.append("||P|");
        record.append(version_number == null ? "" : version_number);
        record.append("|");
        record.append(ASTMStandard.getCurrentMoment());
        record.append('\r');
        return record.toString();
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo, String rec_codigo) {
        try {
            this.semExames = true;
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            this.tx_list.add(this.getPatientRecord(1, fil_codigo + req_codigo, "", "", null));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o paciente de envio");
            }
            this.tx_list.add(this.getOrderRecord(1, fil_codigo + req_codigo + rec_codigo, null, "A", ""));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o paciente de envio");
            }
            this.tx_list.add(this.getTerminationRecord());
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    private String getOrderRecord(int order_sequence, String sample_id, ExameMaterial[] alternativos, String acao, String tipo_amostra) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence).append("|");
        record.append(sample_id == null ? "" : sample_id).append("|");
        record.append("|");
        if (alternativos != null && alternativos[0] != null) {
            record.append("^^^");
            record.append(alternativos[0].getNomeExame());
            for (int i = 1; i < alternativos.length; ++i) {
                if (alternativos[i] == null) continue;
                record.append("\\^^^");
                record.append(alternativos[i].getNomeExame());
            }
        }
        record.append("|R|");
        record.append(StringUtil.repeteCaractere('|', 5));
        record.append(acao == null ? "" : acao);
        record.append(StringUtil.repeteCaractere('|', 4));
        record.append("|");
        record.append(tipo_amostra == null ? "" : tipo_amostra);
        record.append(StringUtil.repeteCaractere('|', 9));
        record.append("Q\\O");
        record.append(StringUtil.repeteCaractere('|', 5));
        record.append('\r');
        return record.toString();
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String pac_nome, String pac_sexo, Date dataNasc) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("|||");
        record.append(pac_nome);
        record.append("||");
        record.append(dataNasc == null ? "" : Funcoes.formataData("yyyyMMdd", dataNasc));
        record.append("|");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append(StringUtil.repeteCaractere('|', 25));
        record.append('\r');
        return record.toString();
    }

    private String getTerminationRecord() {
        StringBuilder record = new StringBuilder("L|1|F");
        record.append('\r');
        return record.toString();
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            String sampleId = StringUtil.limpaString(starting_range, new String[]{"^"});
            this.hostQuery = true;
            if (Funcoes.textoVazio(sampleId)) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                return;
            }
            if (sampleId.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                return;
            }
            this.host_fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            sampleId = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Labmax 560: Host Query Response");
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "A";
            if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(rec_codigo)) {
                return;
            }
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames) && req != null && aba != null) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                pac_exames = "";
                if (req != null) {
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) >= 7) continue;
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
                if (Funcoes.textoVazio(pac_exames)) {
                    req = null;
                }
            }
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
            } else {
                this.enviarRequisicaoSemExame(fil_codigo, req_codigo, rec_codigo);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Labmax 560: Host Query Response");
            this.hostQuery = false;
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (!(this.semExames || Funcoes.textoVazio(this.req_codigo) || Funcoes.textoVazio(this.pac_exames) || Funcoes.textoVazio(this.rec_codigo) || Funcoes.textoVazio(this.fil_codigo) || Funcoes.textoVazio(this.mco_codigo))) {
            if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                Statement st = Conexao.getStatement();
                if (this.exames != null) {
                    for (int i = 0; i < this.exames.length; ++i) {
                        int situacao;
                        if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                            for (String exame : this.examesFilho) {
                                int situacao2 = BDUtil.getDesmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, exame, this.mco_codigo);
                                BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, this.mco_codigo, this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                            }
                            situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                            if (!BDUtil.isGrupoInteiroPendente(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai)) continue;
                            this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                            continue;
                        }
                        if (!this.examesFilho.isEmpty()) {
                            situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                            this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                            BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                            continue;
                        }
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                    }
                    Conexao.arquivaSQL();
                    String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                    this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
                } else {
                    this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
                }
            }
            this.interromperTimer();
            if (this.hostQuery) {
                this.getPortaCOM().write(String.valueOf('\u0004'));
                this.getPortaCOM().clearInputString();
            }
            if (this.ultima_acao.equals("N")) {
                this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
            this.limpaDadosRequisicao();
            this.fireAtualizarTabela();
            this.fireAtualizarTabela(0);
            this.setIdle();
        } else {
            this.interromperTimer();
            this.getPortaCOM().write(String.valueOf('\u0004'));
            this.getPortaCOM().clearInputString();
            this.limpaDadosRequisicao();
            this.fireAtualizarTabela();
            this.fireAtualizarTabela(0);
            this.setIdle();
            this.semExames = false;
        }
        this.hostQuery = false;
    }

    @Override
    public String getMsgEnd() {
        return LINE;
    }

    @Override
    public void teste() {
        String idAmostra = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "010006390604");
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "Resultado"}, null);
        if (op == 0) {
            this.query(idAmostra);
        } else if (op == 1) {
            this.resultado(idAmostra);
        }
    }

    private void resultado(String reqs1) {
        this.handShakeCharReceived('\u0005');
        HashMap<String, String> alternativos = new HashMap<String, String>();
        alternativos.put("30", "2.1");
        alternativos.put("22", "2.2");
        alternativos.put("15", "2.3");
        alternativos.put("13", "2.4");
        alternativos.put("23", "2.5");
        alternativos.put("32", "2.6");
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||30^1^7.2.1|||||||P[CR][ETX]53[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2P|1|||||||Masculino|||||||||||||||||||||||||[CR][ETX]6A[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3O|1|" + reqs1 + "^0.0^1^1||^^^ALL^|R||||||X||||1|||||||||1|F[CR][ETX]DA[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|1|^^^CRE^0.0|3.98|mg/dL|0.72^1.16^Masculino|HH||F||||20171027114025|1[CR][ETX]34[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5R|2|^^^URE^0.0|45|mg/dL|[SP]10^[SP]50^Masculino|HH||F||||20171027113922|1[CR][ETX]8D[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5R|3|^^^CAL^0.0|35|mg/dL|[SP]10^[SP]50^Masculino|HH||F||||20171027113922|1[CR][ETX]8D[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6L|1|N[CR][ETX]09[LINE][EOT]"));
        this.handShakeCharReceived('\u0004');
    }

    private void query(String reqs1) {
        int i;
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||30^1^7.2.1|||||||P[CR][ETX]53[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2Q|1|^" + reqs1 + "^^||^^^CRE^||||||||O[CR][ETX]A4[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2Q|1|^" + reqs1 + "^^||^^^URE^||||||||O[CR][ETX]A4[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3L|1|N[CR][ETX]06[LINE]"));
        this.handShakeCharReceived('\u0004');
        for (i = 0; i < 10; ++i) {
            this.handShakeCharReceived('\u0006');
        }
        this.handShakeCharReceived('\u0006');
        for (i = 0; i < 10; ++i) {
            this.handShakeCharReceived('\u0006');
        }
    }
}

