/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.test1;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.test1.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final String ANALISE_REQUERIDA = "0001";
    private static final String ANALISE_NOT_FOUNT = "0000";
    private static final String FIELD_WORKSTATION_NUMBER = "workstationNumber";
    private static final String FIELD_PATIENT_ID_NUMBER = "patientIdNumber";
    private static final String FIELD_RACK_NO = "rackNo";
    private static final String FIELD_POSITION = "position";
    private static final String FIELD_BAYER = "bayer";
    private static final String FIELD_RESULT = "result";
    private static final String ALTERNATIVO = "TEST1";
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento(this);
    private InterfaceConfiguracao configuracao;
    private InfoExameRequisicao ultimo_enviado;
    private String frame;
    private int timeOut = 20000;

    public InterfaceListener() {
        this.threadRecebimento.start();
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        if (!Funcoes.textoVazio(this.configuracao.getTimeOut()) && Funcoes.isNumeric(this.configuracao.getTimeOut())) {
            this.timeOut = Integer.parseInt(this.configuracao.getTimeOut()) * 1000;
        }
        if (Funcoes.textoVazio(this.configuracao.getIdentificacaoEquipamento())) {
            this.configuracao.setIdentificacaoEquipamento("01");
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        if (this.ultimo_enviado != null) {
            this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
        }
        this.setIdle();
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("") && this.getTipoMensagem(message).equals((Object)TipoMensagem.DADOS_QUERY)) {
                if (this.validaMensagem(message)) {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    this.parseQuery(message);
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0015'));
                }
                return;
            }
            if (!message.equals("")) {
                if (this.validaMensagem(message)) {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    this.addListaRecebimento(message);
                    this.restartThreadRecebimento();
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0015'));
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                }
            });
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(this.timeOut);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0015': {
                    this.tratarNegativeAck();
                }
            }
        }
        catch (Exception ex) {
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
            ex.printStackTrace();
            this.setIdle();
        }
    }

    private void tratarNegativeAck() {
        if (this.ultimo_enviado != null) {
            this.fireExcecaoEncontrada(String.format("Envio do paciente recusada pelo equipamento ID %s %s %s Exame %s", this.ultimo_enviado.getFilial(), this.ultimo_enviado.getCodigo(), this.ultimo_enviado.getRecipiente(), this.ultimo_enviado.getExames()));
            this.ultimo_enviado = null;
            this.frame = null;
        }
    }

    private void tratarAcknowledge() {
        if (this.ultimo_enviado != null) {
            this.encerrarTransmissao();
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String message) {
        try {
            TipoMensagem tipo = this.getTipoMensagem(message);
            if (TipoMensagem.DADOS_QUERY.equals((Object)tipo)) {
                return this.parseQuery(message);
            }
            if (TipoMensagem.DADOS_RESULTADO.equals((Object)tipo)) {
                return this.parseResultado(message);
            }
            this.fireExcecaoEncontrada(String.format("Mensagem de tipo desconhecida transmitida pelo equipamento [%s]", tipo.codigo));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, "Erro ao executar parse \n+(" + message + ")\n" + e.getMessage(), e.getStackTrace());
        }
        return "";
    }

    private String parseResultado(String message) throws Exception {
        Map<String, String> fields = this.getFieldsResultado(message);
        String idNumber = Funcoes.preencheZero(fields.get(FIELD_PATIENT_ID_NUMBER).trim(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo());
        String fil_codigo = idNumber.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = idNumber.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = idNumber.substring(ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        if (!(Funcoes.isNumeric(fil_codigo) && Funcoes.isNumeric(req_codigo) && Funcoes.isNumeric(rec_codigo) && Integer.parseInt(fil_codigo) != 0)) {
            this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o com formato fora do padr\u00e3o %s %s %s ", fil_codigo, req_codigo, rec_codigo));
            return "";
        }
        Statement st = Conexao.getStatement();
        String int_codigo = "";
        try {
            int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, ALTERNATIVO);
            if (int_codigo == null) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo LIS do exame %s n\u00e3o encontrado na interface para requisi\u00e7\u00e3o %s %s %s ", ALTERNATIVO, fil_codigo, req_codigo, rec_codigo));
                return "";
            }
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada(String.format("C\u00f3digo LIS do exame %s n\u00e3o encontrado na interface para requisi\u00e7\u00e3o %s %s %s ", ALTERNATIVO, fil_codigo, req_codigo, rec_codigo));
            return "";
        }
        ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, ALTERNATIVO);
        if (exame == null) {
            this.fireExcecaoEncontrada(String.format("C\u00f3digo LIS do exame %s n\u00e3o encontrado para requisi\u00e7\u00e3o %s %s %s ", ALTERNATIVO, fil_codigo, req_codigo, rec_codigo));
            return "";
        }
        Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
        if (req != null) {
            PanelAbaAbstrata aba = this.equipamento.getTab(1);
            String codigo = (String)req[aba.getColIndice("C\u00f3digo")];
            String tubo = (String)req[aba.getColIndice("Tubo")];
            String filCodigo = codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String reqCodigo = codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            if (!fil_codigo.equalsIgnoreCase(filCodigo) || !req_codigo.equalsIgnoreCase(reqCodigo)) {
                fil_codigo = filCodigo;
                req_codigo = reqCodigo;
                rec_codigo = tubo;
            }
        }
        String res = fields.get(FIELD_RESULT).replaceFirst("\\.", ",");
        HashMap<String, Object> dados = new HashMap<String, Object>();
        dados.put("resultado_quantitativo", res);
        this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
        this.fireAtualizarTabela(1);
        this.fireAtualizarTabela(2);
        return "";
    }

    private Map<String, String> getFieldsQuery(String message) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(FIELD_WORKSTATION_NUMBER, message.substring(2, 4));
        fields.put(FIELD_PATIENT_ID_NUMBER, message.substring(4, 19));
        return fields;
    }

    private Map<String, String> getFieldsResultado(String message) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(FIELD_WORKSTATION_NUMBER, message.substring(2, 4));
        fields.put(FIELD_PATIENT_ID_NUMBER, message.substring(4, 19));
        fields.put(FIELD_RACK_NO, message.substring(19, 21));
        fields.put(FIELD_POSITION, message.substring(21, 23));
        fields.put(FIELD_BAYER, message.substring(23, 25));
        fields.put(FIELD_RESULT, message.substring(25, 29));
        return fields;
    }

    private String parseQuery(String message) throws IOException, SQLException {
        List<Object[]> reqs;
        Map<String, String> fields = this.getFieldsQuery(message);
        int tam = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        String idAmostra = Funcoes.preencheZero(fields.get(FIELD_PATIENT_ID_NUMBER).trim(), tam);
        String fil_codigo = idAmostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = idAmostra.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = idAmostra.substring(ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        if (!(Funcoes.isNumeric(fil_codigo) && Funcoes.isNumeric(req_codigo) && Funcoes.isNumeric(rec_codigo) && Integer.parseInt(fil_codigo) != 0)) {
            this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o n\u00e3o interfaceada: %s %s %s", fil_codigo, req_codigo, rec_codigo));
            this.enviaRequisicaoSemExame(fields.get(FIELD_PATIENT_ID_NUMBER));
            return "";
        }
        String pac_nome = null;
        String pac_sexo = null;
        String pac_idade = null;
        String rack = null;
        Object prioridade = null;
        String int_codigo = null;
        String mco_codigo = null;
        StringBuilder pac_exames = new StringBuilder("");
        String requisicaoMae = req_codigo;
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            requisicaoMae = Funcoes.preencheZero(BDUtil.getReqMultiGuiaMae(fil_codigo, req_codigo), ParametrosGerais.getDigitosTuboRequisicao());
        }
        Object[] req = this.getRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 0);
        PanelAbaAbstrata aba = this.getAba(0);
        if (req != null) {
            reqs = this.getTodasRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 0);
            for (Object[] r : reqs) {
                pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
            }
        }
        if (req == null) {
            req = this.getRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 1);
            aba = this.equipamento.getTab(1);
            if (req != null) {
                reqs = this.getTodasRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 1);
                for (Object[] r : reqs) {
                    pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                }
            }
        }
        if (req == null && (req = this.getRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 2)) != null) {
            aba = this.equipamento.getTab(2);
            if (req != null) {
                reqs = this.getTodasRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 2);
                for (Object[] r : reqs) {
                    if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                    pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                }
            }
        }
        if (req == null) {
            this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o n\u00e3o interfaceada: %s %s %s", fil_codigo, req_codigo, rec_codigo));
            this.enviaRequisicaoSemExame(fields.get(FIELD_PATIENT_ID_NUMBER));
            return "";
        }
        if (req != null) {
            String codigo = (String)req[aba.getColIndice("C\u00f3digo")];
            String tubo = (String)req[aba.getColIndice("Tubo")];
            String filCodigo = codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String reqCodigo = codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            fil_codigo = filCodigo;
            req_codigo = reqCodigo;
            rec_codigo = tubo;
        }
        pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
        pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
        String data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
        String hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
        rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
        int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
        String string = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : (mco_codigo = null);
        if (Funcoes.textoVazio(pac_exames.toString())) {
            pac_exames.append((String)req[aba.getColIndice("Exame")]);
        }
        Statement st = Conexao.getStatement();
        this.ultimo_enviado = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames.toString());
        this.ultimo_enviado.setInterface(int_codigo);
        this.frame = this.getFrame(fields.get(FIELD_PATIENT_ID_NUMBER), ANALISE_REQUERIDA);
        this.getPortaCOM().write(this.frame);
        this.encerrarTransmissao();
        this.fireAtualizarTabela(0);
        this.fireAtualizarTabela(1);
        return "";
    }

    private String getFrame(String id, String analiseRequerida) {
        StringBuilder frame = new StringBuilder();
        frame.append(this.getMsgStart());
        frame.append(TipoMensagem.DADOS_ANALISE.toString());
        frame.append(this.configuracao.getIdentificacaoEquipamento());
        frame.append(id);
        frame.append(analiseRequerida);
        String check = String.valueOf(Checksum.getLRC(frame.toString().substring(1, frame.length())));
        frame.append(check.toLowerCase());
        frame.append(this.getMsgEnd());
        return frame.toString();
    }

    private void enviaRequisicaoSemExame(String id) throws IOException {
        String frame = this.getFrame(id, ANALISE_REQUERIDA);
        this.getPortaCOM().write(frame);
    }

    private TipoMensagem getTipoMensagem(String message) {
        String tipo = message.substring(1, 2);
        return TipoMensagem.getTipoMensagem(tipo);
    }

    public boolean validaMensagem(String message) {
        String check = message.substring(message.length() - 2, message.length() - 1);
        String checkCalc = String.valueOf(Checksum.getLRC(message.substring(1, message.length() - 2)));
        boolean ok = checkCalc.equals(check);
        if (!ok) {
            this.fireExcecaoEncontrada(String.format("Checksum inv\u00e1lido recebido [%s-%x] calculado [%s-%x]", check, (int)check.charAt(0), checkCalc, (int)checkCalc.charAt(0)));
        }
        return ok;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        if (!this.configuracao.getModoHostQuery()) {
            this.ultimo_enviado = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, exames);
            this.ultimo_enviado.setInterface(int_codigo);
            this.encerrarTransmissao();
        }
        return "";
    }

    private void encerrarTransmissao() {
        try {
            if (this.ultimo_enviado == null || this.ultimo_enviado.getExames() == null) {
                return;
            }
            Statement st = Conexao.getStatement();
            String[] exames = this.ultimo_enviado.getExames().split(" ", 0);
            int situacao = 0;
            for (String exame : exames) {
                String int_codigo;
                String fil_codigo = this.ultimo_enviado.getFilial();
                String req_codigo = this.ultimo_enviado.getCodigo();
                String mco_codigo = this.ultimo_enviado.getMaterial();
                String rec_codigo = this.ultimo_enviado.getRecipiente();
                situacao = this.getExameSituacao(st, fil_codigo, int_codigo = this.ultimo_enviado.getInterface(), req_codigo, exame, mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                if (!req_codigo.equals(this.ultimo_enviado.getCodigo())) continue;
                this.firePacienteEnviado(this.ultimo_enviado.getCodigo(), this.ultimo_enviado.getNome(), this.ultimo_enviado.getSexo(), this.ultimo_enviado.getIdade(), this.ultimo_enviado.getData(), this.ultimo_enviado.getHora(), this.ultimo_enviado.getExames());
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(situacao < 2 ? 0 : 2);
            this.equipamento.mensagemEnviada("Exame enviado com sucesso para " + this.ultimo_enviado.getNome(), 0, 5000);
            this.ultimo_enviado = null;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    public void dataChanged(String message) {
        try {
            if (!message.equals("") && this.getTipoMensagem(message).equals((Object)TipoMensagem.DADOS_QUERY)) {
                if (this.validaMensagem(message)) {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    this.parseQuery(message);
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0015'));
                }
                return;
            }
            if (!message.equals("")) {
                if (this.validaMensagem(message)) {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    this.addListaRecebimento(message);
                    this.restartThreadRecebimento();
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0015'));
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                }
            });
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static enum TipoMensagem {
        DADOS_QUERY("Q"),
        DADOS_ANALISE("T"),
        DADOS_RESULTADO("R");

        private static TipoMensagem[] tipos;
        String codigo = "";

        private TipoMensagem(String codigo) {
            this.codigo = codigo;
        }

        public String toString() {
            return this.codigo;
        }

        public static TipoMensagem[] getTiposMensagem() {
            return tipos;
        }

        public static TipoMensagem getTipoMensagem(String nome) {
            for (TipoMensagem p : tipos) {
                if (!p.codigo.equals(nome)) continue;
                return p;
            }
            return null;
        }

        static {
            tipos = new TipoMensagem[]{DADOS_QUERY, DADOS_ANALISE, DADOS_RESULTADO};
        }
    }
}

