/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.targa3000plus;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.interfaces.targa3000plus.EnvioRackListener;
import jalis.laboratorio.interfaceamento.interfaces.targa3000plus.ExameRequisicao;
import jalis.util.Funcoes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ThreadEnvio
extends Thread {
    private Map<String, ExameRequisicao> requisicoes;
    private ArrayList<EnvioRackListener> listeners = new ArrayList();
    private int indexRequisicao;
    private int indexRack;
    private int indexTubo;
    private PanelAbaAbstrata aba;
    private int indexCodigoApoiado;
    private AbstractInterfaceamento equip;

    public void addEnvioRackListener(EnvioRackListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeEnvioRackListener(EnvioRackListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public ThreadEnvio(Map<String, ExameRequisicao> requisicoes, int indexRequisicao, int indexRack, int indexTubo, int indexCodigoApoiado, PanelAbaAbstrata aba, AbstractInterfaceamento equip) {
        this.requisicoes = requisicoes;
        this.indexRequisicao = indexRequisicao;
        this.indexRack = indexRack;
        this.indexTubo = indexTubo;
        this.indexCodigoApoiado = indexCodigoApoiado;
        this.aba = aba;
        this.equip = equip;
    }

    @Override
    public void run() {
        if (this.requisicoes.size() == 0) {
            for (EnvioRackListener l : this.listeners) {
                l.envioFinalizado();
            }
            return;
        }
        HashMap racks = new HashMap();
        for (String key : this.requisicoes.keySet()) {
            if (!racks.containsKey(this.requisicoes.get(key).getPosicaoRack())) {
                racks.put(this.requisicoes.get(key).getPosicaoRack(), new ArrayList());
            }
            ((List)racks.get(this.requisicoes.get(key).getPosicaoRack())).add(this.requisicoes.get(key));
        }
        for (String key : racks.keySet()) {
            for (int row = 0; row < this.aba.getRowCount(); ++row) {
                String reqApoiado;
                String reqNew = this.aba.getValueAt(row, this.indexRequisicao).toString();
                String recNew = this.aba.getValueAt(row, this.indexTubo).toString();
                String string = reqApoiado = this.aba.getValueAt(row, this.indexCodigoApoiado) != null ? this.aba.getValueAt(row, this.indexCodigoApoiado).toString() : reqNew;
                if (!Funcoes.textoVazio(reqApoiado) && reqApoiado.length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                    reqApoiado = reqApoiado.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                }
                if (!((ExameRequisicao)((List)racks.get(key)).get(0)).getFilialRequisicao().equalsIgnoreCase(reqNew) && !((ExameRequisicao)((List)racks.get(key)).get(0)).getFilialRequisicao().equalsIgnoreCase(reqApoiado) || !((ExameRequisicao)((List)racks.get(key)).get(0)).getTubo().equalsIgnoreCase(recNew)) continue;
                this.aba.setValueAt(Funcoes.preencheZero(key, 4), row, this.indexRack);
            }
            String fil_codigo = ((ExameRequisicao)((List)racks.get(key)).get(0)).getFilialRequisicao().substring(0, ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = ((ExameRequisicao)((List)racks.get(key)).get(0)).getFilialRequisicao().substring(ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = ((ExameRequisicao)((List)racks.get(key)).get(0)).getCodigoInterface();
            String mco_codigo = ((ExameRequisicao)((List)racks.get(key)).get(0)).getMaterial();
            StringBuilder exames = new StringBuilder();
            for (ExameRequisicao er : (List)racks.get(key)) {
                exames.append(er.getExame()).append(" ");
            }
            this.equip.enviarRequisicao(((ExameRequisicao)((List)racks.get(key)).get(0)).getNomePaciente(), "", "", "", "", Funcoes.preencheZero(key, 2), "", fil_codigo, int_codigo, req_codigo, mco_codigo, ((ExameRequisicao)((List)racks.get(key)).get(0)).getTubo(), exames.toString().trim(), "N", null);
            try {
                ThreadEnvio.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.requisicoes.clear();
        this.aba.reloadExames();
        for (EnvioRackListener l : this.listeners) {
            l.envioFinalizado();
        }
    }
}

