/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.targa3000plus;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultPendentes;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.targa3000plus.AbaExamesNaoEnviadosRack;
import jalis.laboratorio.interfaceamento.interfaces.targa3000plus.EnvioRackListener;
import jalis.laboratorio.interfaceamento.interfaces.targa3000plus.ExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.targa3000plus.Exames;
import jalis.laboratorio.interfaceamento.interfaces.targa3000plus.ThreadEnvio;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class RequisicaoRack
extends JDialog
implements ActionListener,
EnvioRackListener {
    public static final int COLUNA_REQUISICAO = 0;
    public static final int COLUNA_NOME_PACIENTE = 1;
    public static final int COLUNA_MENSAGEM = 2;
    public static final int COLUNA_POSICAO_RACK = 3;
    public static final int COLUNA_TUBO = 4;
    public static final int COLUNA_CURVA = 5;
    public static final int COLUNA_REQUISICAO_JALIS = 6;
    private AbstractInterfaceamento equip;
    private JPanel panelRoot = new JPanel(new GridBagLayout());
    private ArrayList exames;
    private int indexRequisicao;
    private int indexNomePaciente;
    private int indexExame;
    private int indexRack;
    private int indexTubo;
    private int tuboFilho;
    private int indexAparelho;
    private int indexMaterial;
    private int indexInterface;
    private int indexCodigoApoiado;
    private boolean curva;
    private boolean reenvio;
    private PanelAbaAbstrata aba;
    private TTextField textCodigoBarras = ComponenteFactory.novoTTextField(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), 1);
    private TTextField textNomePaciente = ComponenteFactory.novoTTextField(50, 3);
    private TTextField textPosicao = ComponenteFactory.novoTTextField(6, 1);
    private JComboBox comboExames = ComponenteFactory.novoJComboBox(this);
    private JButton buttonAddRequisicao = ComponenteFactory.novoJButton("OK", 'o', this);
    private ModeloGridTable tableModel = new ModeloGridTable(new String[]{"C\u00f3digo", "Paciente", "Exame", "Rack", "Tubo"});
    private JTable tableRequisicao = new JTable(this.tableModel);
    private JScrollPane scrollTable = new JScrollPane(this.tableRequisicao);
    private JPanel panelButton = new JPanel(new FlowLayout(2));
    private JButton buttonEnviar = ComponenteFactory.novoJButton("Enviar", 'e', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'c', this);
    private HashMap<String, ExameRequisicao> exameRequisicao = new HashMap();

    public RequisicaoRack(JFrame parent, AbstractInterfaceamento equip, ArrayList exames, int indexRequisicao, int indexNomePaciente, int indexExame, int indexRack, int indexTubo, int indexAparelho, int indexMaterial, boolean reenvio, PanelAbaAbstrata aba, int indexInterface, int indexCodigoApoiado, int tuboFilho) {
        super(parent);
        this.equip = equip;
        this.exames = exames;
        this.indexRequisicao = indexRequisicao;
        this.indexNomePaciente = indexNomePaciente;
        this.indexExame = indexExame;
        this.indexRack = indexRack;
        this.indexTubo = indexTubo;
        this.tuboFilho = tuboFilho;
        this.indexAparelho = indexAparelho;
        this.indexMaterial = indexMaterial;
        this.indexInterface = indexInterface;
        this.indexCodigoApoiado = indexCodigoApoiado;
        this.reenvio = reenvio;
        this.aba = aba;
        this.setDefaultCloseOperation(0);
        this.configTela();
    }

    private void configTela() {
        this.setPreferredSize(new Dimension(650, 350));
        this.setTitle("Rack");
        this.setModal(true);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.tableModel.setColumnSize(new int[]{100, 0, 80, 50, 40}, this.tableRequisicao);
        this.tableModel.ordenarColuna(0);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Requisi\u00e7\u00e3o"), c);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Paciente"), c);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Exame(s)"), c);
        ++c.gridx;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Posic\u00e3o"), c);
        this.textCodigoBarras.setPreferredSize(new Dimension(130, 20));
        this.textCodigoBarras.setMinimumSize(new Dimension(130, 20));
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        this.panelRoot.add((Component)this.textCodigoBarras, c);
        this.textNomePaciente.setPreferredSize(new Dimension(250, 20));
        this.textNomePaciente.setMinimumSize(new Dimension(250, 20));
        this.textNomePaciente.setEditable(false);
        this.textNomePaciente.setFocusable(false);
        ++c.gridx;
        this.panelRoot.add((Component)this.textNomePaciente, c);
        this.comboExames.setPreferredSize(new Dimension(100, 20));
        this.comboExames.setMinimumSize(new Dimension(100, 20));
        ++c.gridx;
        this.panelRoot.add((Component)this.comboExames, c);
        this.textPosicao.setPreferredSize(new Dimension(65, 20));
        this.textPosicao.setMinimumSize(new Dimension(65, 20));
        ++c.gridx;
        this.panelRoot.add((Component)this.textPosicao, c);
        this.buttonAddRequisicao.setPreferredSize(new Dimension(40, 20));
        this.buttonAddRequisicao.setMinimumSize(new Dimension(40, 20));
        ++c.gridx;
        this.panelRoot.add((Component)this.buttonAddRequisicao, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridwidth = 7;
        this.panelRoot.add((Component)this.scrollTable, c);
        this.panelButton.add(this.buttonEnviar);
        this.panelButton.add(this.buttonCancelar);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.0;
        this.panelRoot.add((Component)this.panelButton, c);
        this.textCodigoBarras.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                RequisicaoRack.this.loadExamesRequisicao();
            }
        });
        this.tableRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (RequisicaoRack.this.tableRequisicao.getSelectedRowCount() > 0 && e.getKeyCode() == 127) {
                    int row = RequisicaoRack.this.tableRequisicao.getSelectedRow();
                    if (row > -1) {
                        String chave = RequisicaoRack.this.getChave(RequisicaoRack.this.tableRequisicao.getValueAt(row, 0).toString(), RequisicaoRack.this.tableRequisicao.getValueAt(row, 4).toString(), RequisicaoRack.this.tableRequisicao.getValueAt(row, 2).toString());
                        RequisicaoRack.this.exameRequisicao.remove(chave);
                    }
                    RequisicaoRack.this.populateTable();
                }
            }
        });
        this.add((Component)this.panelRoot, "Center");
        Funcoes.montaEnter((JComponent)this.panelRoot);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public String getChave(String filialRequisicao, String tubo, String exame) {
        return String.format("%s%s|%s", filialRequisicao, tubo, exame);
    }

    private void addRequisicao(String requisicao, String rack, Exames selectedItem, ArrayList exames) throws SQLException {
        ExameMaterial[] tubo = "";
        String reqApoiado = "";
        if (requisicao.trim().length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            tubo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(requisicao + (String)tubo);
            if (dce != null) {
                requisicao = Funcoes.preencheZero(dce.getFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(dce.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            }
        }
        if (requisicao.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
            requisicao = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        }
        for (int i = 0; i < exames.size(); ++i) {
            String[] exasOld;
            String codigoApoiado;
            Object[] linha = (Object[])exames.get(i);
            String req = linha[this.indexRequisicao].toString();
            String fil_codigo = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = linha[this.indexAparelho].toString();
            String mco_codigo = linha[this.indexMaterial].toString();
            String string = codigoApoiado = linha[this.indexCodigoApoiado] != null ? linha[this.indexCodigoApoiado].toString() : null;
            if (!Funcoes.textoVazio(codigoApoiado) && codigoApoiado.length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                reqApoiado = req;
                reqApoiado = codigoApoiado.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            }
            if (Funcoes.textoVazio(codigoApoiado)) {
                codigoApoiado = requisicao;
            }
            if (!req.equalsIgnoreCase(requisicao) && !reqApoiado.equalsIgnoreCase(requisicao) || !selectedItem.toString().trim().equals(linha[this.indexExame].toString().trim()) && !selectedItem.getExames().contains(linha[this.indexExame].toString())) continue;
            String exaRec = "";
            String exaReq = linha[this.indexExame].toString();
            String material = linha[this.indexMaterial].toString();
            String codigoInterface = linha[this.indexInterface].toString();
            exaRec = Funcoes.preencheZero(linha[this.indexTubo].toString(), ParametrosGerais.getDigitosTuboTubo());
            for (String s : exasOld = exaReq.split(" ")) {
                ExameMaterial[] rec_kodigo;
                if (this.curva) {
                    String rec_codigo;
                    String rq = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                    BDExame[] bdExames = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, rq, s, mco_codigo, rec_codigo = BDUtil.getExameDesmembradoTuboPai(fil_codigo, rq, (String)(rec_kodigo = tubo), int_codigo, s, mco_codigo), (String)rec_kodigo);
                    if (bdExames.length <= 0) continue;
                    this.curva = false;
                    for (BDExame bdExame : bdExames) {
                        String filialRequisicao = requisicao.equalsIgnoreCase(reqApoiado) ? reqApoiado : req;
                        ExameRequisicao exReq = new ExameRequisicao(filialRequisicao, linha[this.indexNomePaciente].toString(), bdExame.getExame(), material, codigoInterface, rack, (String)(!Funcoes.textoVazio((String)tubo) ? tubo : exaRec), this.curva, req);
                        this.exameRequisicao.put(exReq.getChave(), exReq);
                    }
                    continue;
                }
                if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, s, mco_codigo)) {
                    ExameMaterial[] filhos;
                    rec_kodigo = filhos = BDUtil.getExamesFilhos(fil_codigo, int_codigo, s, mco_codigo);
                    int n = rec_kodigo.length;
                    for (int j = 0; j < n; ++j) {
                        ExameMaterial e = rec_kodigo[j];
                        String filialRequisicao = requisicao.equalsIgnoreCase(reqApoiado) ? reqApoiado : req;
                        ExameRequisicao exReq = new ExameRequisicao(filialRequisicao, linha[this.indexNomePaciente].toString(), e.getNomeExame(), material, codigoInterface, rack, (String)(!Funcoes.textoVazio((String)tubo) ? tubo : exaRec), this.curva, req);
                        this.exameRequisicao.put(exReq.getChave(), exReq);
                    }
                    continue;
                }
                String filialRequisicao = requisicao.equalsIgnoreCase(reqApoiado) ? reqApoiado : req;
                ExameRequisicao exReq = new ExameRequisicao(filialRequisicao, linha[this.indexNomePaciente].toString(), s, material, codigoInterface, rack, (String)(!Funcoes.textoVazio((String)tubo) ? tubo : exaRec), this.curva, req);
                this.exameRequisicao.put(exReq.getChave(), exReq);
            }
        }
    }

    private void loadExamesRequisicao() {
        String requisicao = this.textCodigoBarras.getText();
        if (Funcoes.textoVazio(requisicao)) {
            return;
        }
        if (requisicao.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() && requisicao.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            return;
        }
        this.comboExames.removeAllItems();
        DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(requisicao);
        if (etiqueta != null) {
            requisicao = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
        }
        boolean isNaoEncontrado = true;
        for (int i = 0; i < this.exames.size(); ++i) {
            String tuboFilhoZero;
            boolean isCodigoApoiado;
            Object[] linha = (Object[])this.exames.get(i);
            String req = linha[this.indexRequisicao].toString();
            String codigoApoiado = linha[this.indexCodigoApoiado] != null ? linha[this.indexCodigoApoiado].toString() : null;
            boolean bl = isCodigoApoiado = !Funcoes.textoVazio(codigoApoiado);
            if (requisicao.trim().length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
                if (!req.equalsIgnoreCase(requisicao)) continue;
                String fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                try {
                    if (BDUtil.isExameCurva(fil_codigo, linha[this.indexInterface].toString(), linha[this.indexExame].toString(), linha[this.indexMaterial].toString())) {
                        Funcoes.mensagem(this, "Para exames de curva \u00e9 necess\u00e1rio digitar o c\u00f3digo da etiqueta completa incluindo o c\u00f3digo do recipiente!", 5);
                        return;
                    }
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(this, "Erro  - " + e.getMessage(), e.getStackTrace());
                }
                this.comboExames.addItem(new Exames(linha[this.indexExame].toString(), linha[this.indexTubo].toString(), linha[this.indexMaterial].toString()));
                this.textNomePaciente.setText(linha[this.indexNomePaciente].toString());
                isNaoEncontrado = false;
                continue;
            }
            String tubo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            String rq = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            String tb = Funcoes.preencheZero(linha[this.indexTubo].toString(), ParametrosGerais.getDigitosTuboTubo());
            String fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            if (!req.equalsIgnoreCase(rq) && (!isCodigoApoiado || !requisicao.equalsIgnoreCase(codigoApoiado))) continue;
            if (tubo.equalsIgnoreCase(tb)) {
                StringBuilder exames = new StringBuilder();
                for (String exa : linha[this.indexExame].toString().split(" ")) {
                    try {
                        if (BDUtil.isExameCurva(fil_codigo, linha[this.indexInterface].toString(), exa, linha[this.indexMaterial].toString())) continue;
                        exames.append(exa).append(" ");
                        this.textNomePaciente.setText(linha[this.indexNomePaciente].toString());
                        isNaoEncontrado = false;
                        this.curva = false;
                    }
                    catch (SQLException e) {
                        ErrorLogger.mostraMensagem(this, "Erro  - " + e.getMessage(), e.getStackTrace());
                    }
                }
                this.comboExames.addItem(new Exames(exames.toString(), linha[this.indexTubo].toString(), linha[this.indexMaterial].toString()));
                continue;
            }
            if (linha[this.tuboFilho] == null || !(tuboFilhoZero = this.preencheTuboFilho(linha[this.tuboFilho].toString())).contains(tubo)) continue;
            fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            for (String exa : linha[this.indexExame].toString().split(" ")) {
                try {
                    if (!BDUtil.isExameCurva(fil_codigo, linha[this.indexInterface].toString(), exa, linha[this.indexMaterial].toString())) continue;
                    this.comboExames.addItem(new Exames(exa, linha[this.indexTubo].toString(), linha[this.indexMaterial].toString()));
                    this.textNomePaciente.setText(linha[this.indexNomePaciente].toString());
                    isNaoEncontrado = false;
                    this.curva = true;
                    ((AbaExamesNaoEnviadosRack)this.aba).setCurva(true);
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(this, "Erro  - " + e.getMessage(), e.getStackTrace());
                }
            }
        }
        this.comboExames.setEnabled(this.comboExames.getItemCount() > 0);
    }

    private String preencheTuboFilho(String tuboFilho) {
        char chaveA = ']';
        char chaveB = '[';
        String tratamentoTuboA = StringUtil.removeCaractere(tuboFilho, chaveA);
        String tratamentoTuboB = StringUtil.removeCaractere(tratamentoTuboA, chaveB);
        String[] tubosFilho = tratamentoTuboB.split(", ");
        ArrayList<String> sb = new ArrayList<String>();
        for (int i = 0; i <= tubosFilho.length - 1; ++i) {
            sb.add(Funcoes.preencheZero(tubosFilho[i], ParametrosGerais.getDigitosTuboTubo()));
        }
        return sb.toString();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.exameRequisicao.clear();
            this.setVisible(false);
        } else if (e.getSource() == this.buttonAddRequisicao) {
            this.addRequisicao();
        } else if (e.getSource() == this.buttonEnviar && (this.reenvio || this.validarLote())) {
            this.enviar();
        }
    }

    private void addRequisicao() {
        try {
            if (this.validaRequisicao(this.textCodigoBarras.getText(), this.textPosicao.getText(), this.comboExames.getSelectedItem() != null ? (Exames)this.comboExames.getSelectedItem() : null)) {
                this.addRequisicao(this.textCodigoBarras.getText(), this.textPosicao.getText(), (Exames)this.comboExames.getSelectedItem(), this.exames);
                if (Funcoes.textoVazio(this.textPosicao.getText())) {
                    Funcoes.mensagem(this, "Rack n\u00e3o preenchida!", 5);
                    ScreenUtil.requisitarFoco(this.textPosicao);
                    this.exameRequisicao.clear();
                    return;
                }
                int posicao = Integer.parseInt(this.textPosicao.getText()) + 1;
                this.populateTable();
                this.textNomePaciente.setText("");
                this.comboExames.removeAllItems();
                this.textPosicao.setText(Integer.toString(posicao));
                this.textCodigoBarras.setText("");
                this.textCodigoBarras.grabFocus();
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "RequisicaoRack (384)");
        }
        catch (SQLException e) {
            e.printStackTrace();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "RequisicaoRack (387)");
        }
    }

    private boolean validaRequisicao(String requisicao, String rack, Exames selectedItem) {
        if (Funcoes.textoVazio(requisicao)) {
            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o preenchida!", 5);
            return false;
        }
        if (selectedItem == null) {
            Funcoes.mensagem(this, "Exame n\u00e3o selecionado!", 5);
            return false;
        }
        if (this.exameRequisicao.size() > 0) {
            Iterator<String> iterator = this.exameRequisicao.keySet().iterator();
            while (iterator.hasNext()) {
                String rack_new = rack;
                String key = iterator.next();
                ExameRequisicao exReq = this.exameRequisicao.get(key);
                if (rack_new.equalsIgnoreCase(exReq.getPosicaoRack())) {
                    Funcoes.mensagem(this, "Rack j\u00e1 adicionada!", 5);
                    return false;
                }
                String string = this.comboExames.getSelectedItem().toString();
            }
        }
        String reqApoiado = "";
        if (requisicao.trim().length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            String tubo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(requisicao + tubo);
            if (dce != null) {
                requisicao = Funcoes.preencheZero(dce.getFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(dce.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            }
        }
        return true;
    }

    private void populateTable() {
        while (this.tableRequisicao.getRowCount() > 0) {
            this.tableModel.removeLine(0);
        }
        for (String key : this.exameRequisicao.keySet()) {
            ExameRequisicao er = this.exameRequisicao.get(key);
            Object[] o = new Object[]{er.getFilialRequisicao(), er.getNomePaciente(), er.getExame(), er.getPosicaoRack(), er.getTubo(), er.isCurva(), er.getRequisicaoJalis()};
            this.tableModel.addLine(o);
        }
        this.tableModel.ordenarColuna(3, 1);
        this.tableRequisicao.setModel(this.tableModel);
    }

    public HashMap<String, ExameRequisicao> getRequisicoes() {
        if (!this.exameRequisicao.isEmpty()) {
            ArrayList<Object[]> requisicoes = new ArrayList<Object[]>();
            for (String key : this.exameRequisicao.keySet()) {
                Object[] line = new Object[]{this.exameRequisicao.get(key).getFilialRequisicao(), this.exameRequisicao.get(key).getNomePaciente(), this.exameRequisicao.get(key).getExame(), this.exameRequisicao.get(key).getPosicaoRack(), this.exameRequisicao.get(key).getTubo(), this.exameRequisicao.get(key).isCurva(), this.exameRequisicao.get(key).getRequisicaoJalis()};
                requisicoes.add(line);
            }
            return this.exameRequisicao;
        }
        return null;
    }

    private boolean validarLote() {
        ((AbaDefaultPendentes)this.equip.examesPendentes).reloadExames();
        ArrayList pendentes = ((AbaDefaultPendentes)this.equip.examesPendentes).getExames();
        for (String key : this.exameRequisicao.keySet()) {
            String rack;
            int requisicao;
            int row;
            ExameRequisicao er = this.exameRequisicao.get(key);
            String req_codigo = er.getRequisicaoJalis();
            if (this.curva) {
                req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            }
            if ((row = this.validaExisteExame(requisicao = Integer.parseInt(req_codigo))) < 0 || er.getPosicaoRack() == null || !this.validaExisteExamePendente(rack = er.getPosicaoRack(), pendentes)) continue;
            Funcoes.mensagem(this, "A rack " + rack + " j\u00e1 esta cadastrada\npara exame que espera retorno!", 5);
            return false;
        }
        return true;
    }

    private int validaExisteExame(int requisicao) {
        for (int i = 0; i < this.exames.size(); ++i) {
            Object[] exame = (Object[])this.exames.get(i);
            int requisicaoExame = Integer.parseInt(exame[this.indexRequisicao].toString());
            if (requisicao != requisicaoExame) continue;
            return i;
        }
        return -1;
    }

    private boolean validaExisteExamePendente(String contador, ArrayList pendentes) {
        for (int i = 0; i < pendentes.size(); ++i) {
            String contadorExame;
            Object[] pendente = (Object[])pendentes.get(i);
            if (pendente[this.indexRack] == null || !contador.equalsIgnoreCase(contadorExame = pendente[this.indexRack].toString())) continue;
            return true;
        }
        return false;
    }

    private void enviar() {
        ThreadEnvio envio = new ThreadEnvio(this.getRequisicoes(), this.indexRequisicao, this.indexRack, this.indexTubo, this.indexCodigoApoiado, this.aba, this.equip);
        this.buttonEnviar.setEnabled(false);
        this.buttonCancelar.setEnabled(false);
        envio.addEnvioRackListener(this);
        envio.start();
    }

    @Override
    public void envioFinalizado() {
        this.setVisible(false);
    }
}

