/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.targa3000plus;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.targa3000plus.AbaExamesNaoEnviadosRack;
import jalis.laboratorio.interfaceamento.interfaces.targa3000plus.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.targa3000plus.Mensagem;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final int EQUIP_TIMEOUT = 15000;
    public static final int MAX_TENTATIVAS = 2;
    public static final int TIPO_REQ_NOVO = 0;
    public static final int TIPO_REQ_REPETICAO = 1;
    public static final int QTDE_EXAMES_TOTAL_RACK = 52;
    public static final int QTDE_EXAMES_ENVIO_RACK = 52;
    public static final String ACAO_CANCELAR = "C";
    protected String ultimaRequisicao = "";
    protected boolean curva = false;
    protected List<String> examesFilho = new LinkedList<String>();
    protected String rec_tuboPai = "";
    protected Map<Integer, String> msgErros = new HashMap<Integer, String>();
    protected ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    protected String int_codigo;
    protected String fil_codigo;
    protected String req_codigo;
    protected String mco_codigo;
    protected String rec_codigo;
    protected String pac_nome;
    protected String pac_exames;
    protected String pac_sexo;
    protected String req_idade;
    protected String req_data;
    protected String req_hora;
    protected String acao;
    protected int tx_counter = 0;
    Mensagem ultimoFrame;
    protected List<Mensagem> frames = new ArrayList<Mensagem>();
    private boolean solicitadoResultado = false;
    protected InterfaceConfiguracao configuracao;
    private Timer timerResultados = new Timer(120000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (InterfaceListener.this.getPortaCOM() != null && !InterfaceListener.this.isTX() && !InterfaceListener.this.isRX()) {
                try {
                    InterfaceListener.this.buscarResultados("R");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    });

    public InterfaceListener() {
        this.msgErros.put(1, "Erro de Check-Sum");
        this.msgErros.put(2, "Comando Desconhecido");
        this.msgErros.put(3, "Erro no campo \"Rotina / STAT\"");
        this.msgErros.put(4, "Erro no campo \"Soro / Urina\"");
        this.msgErros.put(5, "Erro no campo \"Clone Yes / No\"");
        this.msgErros.put(6, "Erro na posi\u00e7\u00e3o do soro");
        this.msgErros.put(7, "Erro no campo \"N\u00famero de testes\"");
        this.msgErros.put(8, "N\u00famero do teste errado");
        this.msgErros.put(9, "Posi\u00e7\u00e3o j\u00e1 em execu\u00e7\u00e3o");
        this.msgErros.put(10, "Clonagem imposs\u00edvel");
        this.msgErros.put(11, "C\u00f3digo repetido");
        this.msgErros.put(12, "Uma an\u00e1lise ou mais n\u00e3o presentes no analisador ");
        this.msgErros.put(13, "Uma an\u00e1lise ou mais n\u00e3o presentes no prato atual");
        this.msgErros.put(14, "Demasiadas an\u00e1lises para o paciente");
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        if (this.configuracao.getTempoSolicitacaoResultado() > 0) {
            this.timerResultados.setDelay(this.configuracao.getTempoSolicitacaoResultado() * 1000);
        }
        this.timerResultados.start();
    }

    public boolean isEnvioRack() {
        return this.configuracao.getEnviarMontandoRack();
    }

    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0004');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    void limpaDadosRequisicao() {
        this.ultimoFrame = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao, HashMap<String, String> mapaParametros) {
        if (acao.equals("R")) {
            this.requisitarResultado();
            return "";
        }
        this.frames.clear();
        this.fil_codigo = fil_codigo;
        this.int_codigo = int_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = exames;
        this.acao = acao;
        int qtdeDigitos = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        try {
            String mat;
            ExameMaterial[] exameMaterial;
            ExameMaterial[] examePai;
            if (acao.equalsIgnoreCase(ACAO_CANCELAR)) {
                return "";
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            req_codigo = StringUtil.preencheString(Integer.toString(Integer.parseInt(req_codigo)), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo).append(rec_codigo);
            String emi_material = "S";
            this.examesFilho.clear();
            this.curva = false;
            PanelAbaAbstrata aba = this.getAba(0);
            String[] temp = exames.split(" ", 0);
            if (temp.length > 0 && aba instanceof AbaExamesNaoEnviadosRack && ((AbaExamesNaoEnviadosRack)aba).isCurva() && (examePai = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_codigo, temp[0], mco_codigo)).length > 0) {
                this.curva = true;
                this.rec_tuboPai = rec_codigo;
                for (String exa : temp) {
                    this.examesFilho.add(exa);
                }
                exames = examePai[0].getNomeExame();
            }
            String retorno = "Enviando " + pac_nome + " para o equipamento";
            Object alternativos = null;
            ArrayList<ExameMaterial> exa_lista = new ArrayList<ExameMaterial>();
            Statement st = Conexao.getStatement();
            int i = -1;
            String codigoApoiado = "";
            if (this.curva) {
                for (ExameMaterial exameMaterial2 : exameMaterial = BDUtil.getExameDesmembradosTubo(fil_codigo, req_codigo, rec_codigo, int_codigo, mco_codigo)) {
                    exa_lista.add(exameMaterial2);
                }
                codigoApoiado = BDUtil.getCodigoApoioRecipiente(Integer.parseInt(fil_codigo), Integer.parseInt(req_codigo), ((ExameMaterial)exa_lista.get(0)).getNomeExame(), Integer.parseInt(mco_codigo), Integer.parseInt(rec_codigo));
                if (!Funcoes.textoVazio(codigoApoiado)) {
                    codigo = qtdeDigitos == 10 && ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() == 10 ? new StringBuilder(codigoApoiado.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao())) : new StringBuilder(codigoApoiado);
                }
            } else {
                exameMaterial = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
                for (int j = 0; j < exa_lista.size(); ++j) {
                    exameMaterial[i] = (ExameMaterial)exa_lista.get(j);
                }
                for (ExameMaterial exameMaterial3 : exameMaterial = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exameMaterial)) {
                    exa_lista.add(exameMaterial3);
                }
            }
            if (!Funcoes.textoVazio(((ExameMaterial)exa_lista.get(0)).getNomeExame()) && !Funcoes.textoVazio(mat = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((ExameMaterial)exa_lista.get(0)).getNomeExame(), mco_codigo, int_codigo))) {
                emi_material = mat;
            }
            String sampleID = Funcoes.preencheZero(codigo.toString(), 15);
            if (this.configuracao.getPreencherCodigoAmostraEspaco()) {
                sampleID = Funcoes.preencheVazio(codigo.toString(), 15, 2);
            }
            if (Funcoes.textoVazio(rackposition) || rackposition.length() > 2) {
                rackposition = "00";
            }
            rackposition = Funcoes.preencheZero(rackposition, 2);
            String clone = "N";
            String rotina = "T";
            StringBuilder worklist = new StringBuilder(sampleID).append(rotina).append(emi_material).append(clone).append(rackposition);
            worklist.append(StringUtil.preencheString(Integer.toString(exa_lista.size()), 2, '0', 1));
            for (ExameMaterial exa : exa_lista) {
                String exa_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exa.getNomeExame(), mco_codigo, int_codigo);
                if (!Funcoes.textoVazio(exa_alternativo)) {
                    worklist.append(Funcoes.preencheVazio(exa_alternativo, 4, 2));
                    continue;
                }
                this.fireExcecaoEncontrada(String.format("Exame %s sem o alternativo configurado ", exa.getNomeExame()));
            }
            worklist.append(this.getChecksumMod256(worklist.toString()));
            worklist.append(this.getMsgEnd());
            Mensagem mensagem = new Mensagem(worklist.toString(), fil_codigo, int_codigo, req_codigo, rec_codigo, mco_codigo, exames);
            this.frames.add(mensagem);
            this.setTX(15000);
            this.tx_counter = 0;
            if (exa_lista != null) {
                for (ExameMaterial e : exa_lista) {
                    int situacao;
                    if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                        for (String exame : this.examesFilho) {
                            int situacao2 = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), this.rec_tuboPai, exame, mco_codigo);
                            BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), exame, mco_codigo, this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                        }
                        situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo);
                        if (!BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), this.rec_tuboPai)) continue;
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, this.rec_tuboPai, e.getNomeExame(), e.getCodigoMaterial(), int_codigo, null, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    if (!this.examesFilho.isEmpty()) {
                        situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo);
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, e.getNomeExame(), e.getCodigoMaterial(), int_codigo, rackposition, situacao < 2 ? 1 : 3);
                        BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, e.getNomeExame(), e.getCodigoMaterial(), int_codigo, rackposition, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                this.fireMensagemEnviada("Exame(s) " + (acao.equals(ACAO_CANCELAR) ? "excluido(s)" : "enviado(s)") + " com sucesso para " + pac_nome, 0, 10000);
            }
            this.getPortaCOM().write(String.valueOf('\u0002'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    protected void requisitarResultado() {
        try {
            if (!this.isRX() && !this.isTX()) {
                TelaBuscaResultado telaBuscaResultado = new TelaBuscaResultado(this.getAba(1));
                telaBuscaResultado.setVisible(true);
                if (telaBuscaResultado.isOk()) {
                    this.buscarResultados(telaBuscaResultado.getTipoSolicitacao());
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, "Erro  - " + e.getMessage(), e.getStackTrace());
        }
    }

    private void buscarResultados(String tipoSolicitacao) throws IOException {
        this.frames.clear();
        this.solicitadoResultado = true;
        this.frames.add(new Mensagem(tipoSolicitacao + '\u0004'));
        this.getPortaCOM().clearInputString();
        this.getPortaCOM().write(String.valueOf('\u0002'));
    }

    public void addRequisicaoLote(String requisicao, String tubo, String exames, String int_codigo, String mco_codigo) {
        try {
            String mat;
            String codigo = requisicao + StringUtil.preencheString(tubo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            String fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = tubo;
            String emi_material = "S";
            String[] temp = exames.split(" ", 0);
            ArrayList<ExameMaterial> exa_lista = new ArrayList<ExameMaterial>();
            int i = -1;
            for (String t : temp) {
                ExameMaterial exa = new ExameMaterial(t, new Integer(mco_codigo));
                ExameMaterial[] exas = null;
                exas = BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa.getString(), mco_codigo) ? BDUtil.getExamesFilhos(fil_codigo, int_codigo, exa.getString(), mco_codigo) : new ExameMaterial[]{new ExameMaterial(exa.getString(), Integer.parseInt(mco_codigo))};
                for (ExameMaterial e : exas) {
                    if (exa_lista.contains(e)) continue;
                    exa_lista.add(e);
                }
            }
            if (!Funcoes.textoVazio(((ExameMaterial)exa_lista.get(0)).getNomeExame()) && !Funcoes.textoVazio(mat = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((ExameMaterial)exa_lista.get(0)).getNomeExame(), mco_codigo, int_codigo))) {
                emi_material = mat;
            }
            String clone = "N";
            StringBuilder worklist = new StringBuilder(Funcoes.preencheZero(codigo.toString(), 15)).append("T").append(emi_material).append(clone).append("00");
            worklist.append(StringUtil.preencheString(Integer.toString(exa_lista.size()), 2, '0', 1));
            for (ExameMaterial exa : exa_lista) {
                String exa_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exa.getNomeExame(), mco_codigo, int_codigo);
                worklist.append(Funcoes.preencheVazio(exa_alternativo, 4, 2));
            }
            worklist.append(this.getChecksumMod256(worklist.toString()));
            worklist.append(this.getMsgEnd());
            this.frames.add(new Mensagem(String.valueOf('\u0002')));
            this.frames.add(new Mensagem(worklist.toString(), fil_codigo, int_codigo, req_codigo, rec_codigo, mco_codigo, exames));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    public void stopTimerResultado() {
        this.timerResultados.stop();
    }

    public void restarTimerResultado() {
        this.timerResultados.restart();
        if (!this.timerResultados.isRunning()) {
            this.timerResultados.start();
        }
    }

    public void enviarLote() throws IOException {
        this.setTX(15000);
        this.tx_counter = 0;
        Mensagem m = this.frames.remove(0);
        if (!m.isHandShake().booleanValue()) {
            this.fil_codigo = m.getFil_codigo();
            this.int_codigo = m.getInt_codigo();
            this.req_codigo = m.getReq_codigo();
            this.rec_codigo = m.getRec_codigo();
            this.mco_codigo = m.getMco_codigo();
            this.pac_exames = m.getPac_exames();
            this.acao = "N";
        }
        this.getPortaCOM().write(m.getMensagem());
    }

    @Override
    public String parse(String message) {
        try {
            if (this.validaMsg(message)) {
                Statement st = Conexao.getStatement();
                int digTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                String req_codigo = this.ultimaRequisicao = message.substring(15 - digTubo, 15);
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                try {
                    Long.parseLong(req_codigo);
                }
                catch (Exception ex) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                    msg.append(req_codigo);
                    this.fireExcecaoEncontrada(msg.toString());
                    return "";
                }
                Map<String, String> resultados = this.parseResultados(message);
                for (String emi_alternativo : resultados.keySet()) {
                    String resultado = resultados.get(emi_alternativo);
                    String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (Funcoes.textoVazio(int_codigo)) {
                        this.fireExcecaoEncontrada("Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                        continue;
                    }
                    ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (exame == null) {
                        this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                        continue;
                    }
                    HashMap<String, Object> dados = new HashMap<String, Object>();
                    int sit = -1;
                    if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial())) {
                        ExameMaterial[] examesPais;
                        for (ExameMaterial examePai : examesPais = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial())) {
                            sit = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, examePai.getNomeExame(), examePai.getCodigoMaterial(), rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial());
                        }
                    } else {
                        sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
                    }
                    if (sit == 2 || sit == 7) continue;
                    String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                    dados.put(campo, resultado.replaceAll("\\.", ","));
                    this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
                }
            }
            Conexao.arquivaSQL();
            return "";
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, String.format("Erro ao inserir resultados recebidos ao banco de dados %s\n", this.ultimaRequisicao) + ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
                return String.format("Erro ao inserir resultados recebidos ao banco de dados %s", this.ultimaRequisicao);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                return String.format("Erro ao inserir resultados recebidos ao banco de dados %s", this.ultimaRequisicao);
            }
        }
    }

    protected Map<String, String> parseResultados(String message) {
        HashMap<String, String> resultados = new HashMap<String, String>();
        int qtExames = Integer.parseInt(message.substring(17, 20));
        String msg = message.substring(20, message.length() - 4);
        if (msg.length() % 11 == 0) {
            int posI = 0;
            int posF = 11;
            while (posI < msg.length()) {
                String tmp = msg.substring(posI, posF);
                String alternativo = tmp.substring(0, 4).trim();
                String resultado = tmp.substring(4);
                resultados.put(alternativo, resultado);
                posI = posF;
                posF += 11;
            }
        }
        return resultados;
    }

    protected boolean validaMsg(String message) {
        String checkSum = Funcoes.preencheZero(message.substring(message.length() - 4, message.length() - 1), 3);
        String msg = message.substring(0, message.length() - 4);
        String calcCheckSum = this.getChecksumMod256(msg);
        boolean ret = calcCheckSum.equals(checkSum);
        if (!ret) {
            this.fireExcecaoEncontrada(String.format("Erro de comunica\u00e7\u00e3o Check Sum recebido (%s) diferente do calculado (%s)", checkSum, calcCheckSum));
            System.out.println(message);
        }
        return ret;
    }

    public void encerrarTransmissao() throws Exception {
        if (this.tx_counter < 2) {
            Statement st = Conexao.getStatement();
            for (String exame : this.pac_exames.split(" ")) {
                int sitAtual;
                String int_codigo = this.int_codigo;
                if (int_codigo == null) {
                    int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, exame, this.mco_codigo);
                }
                int novaSit = (sitAtual = this.getExameSituacao(st, this.fil_codigo, int_codigo, this.req_codigo, exame, this.mco_codigo, this.rec_codigo)) < 2 ? 1 : 3;
                this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exame, this.mco_codigo, int_codigo, null, novaSit);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
            if (this.acao.equals("N")) {
                this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
        }
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.setIdle();
        this.fireAtualizarTabela(0);
    }

    protected void aguardarProximoFrame() throws Exception {
        this.setRX(15000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    public void caracterNaoEsperado() throws Exception {
        String mensagem = "comando desconhecido";
        if (this.ultimoFrame != null && this.ultimoFrame.getMensagem().startsWith("N")) {
            String errorCode = this.ultimoFrame.getMensagem().substring(1);
            if (Funcoes.isNumeric(errorCode)) {
                int erro = Integer.parseInt(errorCode);
                switch (erro) {
                    case 2: {
                        mensagem = "erro de sintaxe";
                        break;
                    }
                    case 3: {
                        mensagem = "teste n\u00e3o localizado no equipamento";
                        break;
                    }
                    case 4: {
                        mensagem = "nenhum teste localizado no protocolo";
                        break;
                    }
                    case 5: {
                        mensagem = "par\u00e2metros incorretos";
                        break;
                    }
                    case 6: {
                        mensagem = "worklist cheia";
                        break;
                    }
                    case 7: {
                        mensagem = "paciente desconhecido";
                        break;
                    }
                    case 8: {
                        mensagem = "'standardization' em progresso";
                        break;
                    }
                    case 9: {
                        mensagem = "processando paciente";
                        break;
                    }
                    case 12: {
                        mensagem = "posi\u00e7\u00e3o n\u00e3o localizada";
                        break;
                    }
                    default: {
                        mensagem = "repeti\u00e7\u00e3o n\u00e3o permitida";
                    }
                }
            }
            this.fireMensagemEnviada("Erro ao enviar (" + mensagem + ")...", 0, 10000);
            this.encerrarTransmissao();
        }
    }

    protected void tratarAcknowledge() throws Exception {
        if (this.isTX() || this.frames.size() > 0) {
            this.enviarProximoFrame();
        } else {
            this.caracterNaoEsperado();
        }
    }

    protected void tratarStx() throws Exception {
        this.getPortaCOM().write(String.valueOf('\u0006'));
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0002': {
                    this.tratarStx();
                    break;
                }
                case '\u0015': {
                    this.tratarNak();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
            this.setIdle();
        }
    }

    private void tratarNak() {
        if (this.solicitadoResultado) {
            this.solicitadoResultado = false;
            this.frames.clear();
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (!message.equals("")) {
                if (this.isTX() && message.length() == 2 && message.charAt(0) == 'N') {
                    this.envioRecusado(message);
                    this.getPortaCOM().clearInputString();
                }
                if (message.length() == 1 && message.equals(String.valueOf('\u0002'))) {
                    this.getPortaCOM().clearInputString();
                    this.tratarStx();
                    return;
                }
                if (message.length() == 1 && message.equalsIgnoreCase(String.valueOf('\u0006'))) {
                    this.getPortaCOM().clearInputString();
                    this.tratarAcknowledge();
                    return;
                }
                if (message.length() == 3 && message.startsWith("Y") && message.endsWith(String.valueOf('\u0002'))) {
                    message = message.substring(0, 2);
                    this.getPortaCOM().clearInputString();
                }
                if (message.length() == 2 && message.startsWith("Y")) {
                    this.encerrarTransmissao();
                    if (this.frames.size() > 0) {
                        this.enviarProximoFrame();
                    }
                }
                if (!Funcoes.textoVazio(message) && message.length() > 15 && message.endsWith(String.valueOf('\u0004'))) {
                    String resultado = message;
                    this.addListaRecebimento(resultado);
                    this.restartThreadRecebimento();
                }
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void envioRecusado(String message) {
        Integer errorCode = message.charAt(1);
        if (this.msgErros.containsKey(errorCode)) {
            this.fireExcecaoEncontrada(String.format("Aparelho recusou o envio (%s - %s)", String.valueOf(errorCode), this.msgErros.get(errorCode)));
        } else {
            this.fireExcecaoEncontrada(String.format("Aparelho recusou o envio (Erro desconhecido)", String.valueOf(errorCode), this.msgErros.get(errorCode)));
        }
    }

    protected void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    protected void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.limpaDadosRequisicao();
                this.setPausa(5000);
                this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    @Override
    protected void encerrar() {
        super.encerrar();
        if (this.timerResultados != null) {
            this.timerResultados.stop();
        }
    }

    protected void enviarProximoFrame() throws IOException {
        if (this.frames.size() > 0) {
            this.ultimoFrame = this.frames.remove(0);
            if (!this.ultimoFrame.isHandShake().booleanValue()) {
                this.fil_codigo = this.ultimoFrame.getFil_codigo();
                this.int_codigo = this.ultimoFrame.getInt_codigo();
                this.req_codigo = this.ultimoFrame.getReq_codigo();
                this.rec_codigo = this.ultimoFrame.getRec_codigo();
                this.mco_codigo = this.ultimoFrame.getMco_codigo();
                this.pac_exames = this.ultimoFrame.getPac_exames();
                this.acao = "N";
            }
            this.getPortaCOM().write(this.ultimoFrame.getMensagem());
            if (this.solicitadoResultado) {
                this.solicitadoResultado = false;
            }
        }
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"ACK", "Resultado", "EOT", "NAK", "ENQ"}, null);
        if (op == 0) {
            this.handShakeCharReceived('\u0006');
        } else if (op == 1) {
            this.resultado();
        } else if (op == 2) {
            this.handShakeCharReceived('\u0004');
        } else if (op == 3) {
            this.handShakeCharReceived('\u0015');
        } else if (op == 4) {
            this.handShakeCharReceived('\u0005');
        } else if (op == 5) {
            // empty if block
        }
    }

    private void resultado() {
    }

    protected String getChecksumMod256(String s) {
        int sum = 0;
        for (int i = 0; i < s.length(); ++i) {
            sum += (byte)s.charAt(i);
        }
        int checksum = sum % 256;
        return Funcoes.preencheZero(checksum, 3);
    }

    public void setCurva(boolean curva) {
        this.curva = curva;
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
                InterfaceListener.this.fireAtualizarTabela();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private class TelaBuscaResultado
    extends JDialog
    implements ActionListener {
        private String tipoSolicitacao;
        private boolean ok = false;
        private JPanel panelBotoes = new JPanel(new FlowLayout(2));
        private JPanel panelCentro = new JPanel(new GridBagLayout());
        private JButton buttonOk = ComponenteFactory.novoJButton("OK", this);
        private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", this);
        private JComboBox comboRelatorio = ComponenteFactory.novoJComboBox(new String[]{"Pr\u00f3ximo relat\u00f3rio", "\u00daltimo relat\u00f3rio", "Primeiro relat\u00f3rio"});

        public TelaBuscaResultado(JPanel pai) {
            this.setTitle("Solicitar Resultado");
            this.setLayout(new BorderLayout());
            this.setLocationRelativeTo(pai);
            this.setModal(true);
            this.buttonOk.setMnemonic('K');
            this.buttonCancelar.setMnemonic('C');
            this.panelBotoes.add(this.buttonOk);
            this.panelBotoes.add(this.buttonCancelar);
            this.comboRelatorio.setPreferredSize(new Dimension(200, 20));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.insets = new Insets(1, 1, 1, 1);
            c.gridx = 0;
            c.gridy = 0;
            this.panelCentro.add((Component)new JLabel("Tipo solicita\u00e7\u00e3o:"), c);
            c.gridx = 1;
            c.gridy = 0;
            this.panelCentro.add((Component)this.comboRelatorio, c);
            c.gridx = 2;
            c.gridy = 0;
            this.add((Component)this.panelCentro, "Center");
            this.add((Component)this.panelBotoes, "South");
            Funcoes.montaEnter((JComponent)this.panelCentro);
            Funcoes.montaEnter((JComponent)this.panelBotoes);
            this.pack();
        }

        public String getTipoSolicitacao() {
            return this.tipoSolicitacao;
        }

        public boolean isOk() {
            return this.ok;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == this.buttonOk) {
                if (this.comboRelatorio.getSelectedIndex() == 0) {
                    this.tipoSolicitacao = "R";
                } else if (this.comboRelatorio.getSelectedIndex() == 1) {
                    this.tipoSolicitacao = "L";
                } else if (this.comboRelatorio.getSelectedIndex() == 2) {
                    this.tipoSolicitacao = "A";
                }
                this.ok = true;
            } else if (o == this.buttonCancelar) {
                this.ok = false;
            }
            this.setVisible(false);
        }
    }
}

