/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.targa3000plus;

import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultPendentes;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ExameLote
extends JDialog
implements ActionListener {
    private static String PARAMETRO_MOSTRAR_INDIVIDUAL = "targa3000.exameLote.MostrarIndividual";
    private ArrayList exames;
    private int indexRequisicao;
    private int indexTubo;
    private int indexNomePaciente;
    private int indexExame;
    private int indexContador;
    private AbstractInterfaceamento equipamento;
    private JPanel panelRoot = new JPanel(new GridBagLayout());
    private TTextField textRequisicao = ComponenteFactory.novoTTextField(12, 1);
    private TTextField textNomePaciente = ComponenteFactory.novoTTextField(50, 3);
    private TTextField textContador = ComponenteFactory.novoTTextField(5, 1);
    private JButton buttonAddRequisicao = ComponenteFactory.novoJButton("OK", 'o', this);
    private ModeloGridTable tableModel = new ModeloGridTable(new String[]{"C\u00f3digo", "Paciente", "Exame"});
    private JTable tableRequisicao = new JTable(this.tableModel);
    private JScrollPane scrollTable = new JScrollPane(this.tableRequisicao);
    private JPanel panelButton = new JPanel(new GridBagLayout());
    private JButton buttonEnviar = ComponenteFactory.novoJButton("Enviar", 'e', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'c', this);
    private JCheckBox checkBoxAdicionarAuto = ComponenteFactory.novoJCheckBox("Adicionar Auto.", this);
    private JCheckBox checkMostrarIndividual = ComponenteFactory.novoJCheckBox("Mostrar Exames Individualmente", this);
    private ArrayList requisicoes = new ArrayList();

    public ExameLote(JFrame parent, ArrayList exames, int indexRequisicao, int indexTubo, int indexNomePaciente, int indexExame, int indexContador, AbstractInterfaceamento equipamento) {
        super(parent);
        this.setPreferredSize(new Dimension(500, 350));
        this.setTitle("Lote");
        this.setModal(true);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.equipamento = equipamento;
        this.checkBoxAdicionarAuto.setSelected(true);
        String sMostrar = ParametrosUsuarios.getValor(PARAMETRO_MOSTRAR_INDIVIDUAL);
        if (!Funcoes.textoVazio(sMostrar) && sMostrar.equalsIgnoreCase("true")) {
            this.checkMostrarIndividual.setSelected(true);
        }
        this.tableModel.setColumnSize(new int[]{90, 0, 80}, this.tableRequisicao);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Requisi\u00e7\u00e3o"), c);
        ++c.gridx;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("Paciente"), c);
        if (equipamento.isContadorEnvio()) {
            ++c.gridx;
            c.gridy = 0;
            c.fill = 0;
            c.anchor = 17;
            this.panelRoot.add((Component)new JLabel("Contador"), c);
        }
        this.textRequisicao.setPreferredSize(new Dimension(100, 20));
        this.textRequisicao.setMinimumSize(new Dimension(100, 20));
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 0;
        this.panelRoot.add((Component)this.textRequisicao, c);
        this.textNomePaciente.setPreferredSize(new Dimension(90, 20));
        this.textNomePaciente.setMinimumSize(new Dimension(90, 20));
        this.textNomePaciente.setEnabled(false);
        this.textNomePaciente.setEditable(false);
        this.textNomePaciente.setFocusable(false);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelRoot.add((Component)this.textNomePaciente, c);
        if (equipamento.isContadorEnvio()) {
            this.textContador.setPreferredSize(new Dimension(65, 20));
            this.textContador.setMinimumSize(new Dimension(65, 20));
            ++c.gridx;
            c.gridy = 1;
            c.fill = 0;
            c.weightx = 0.0;
            this.panelRoot.add((Component)this.textContador, c);
        }
        this.buttonAddRequisicao.setPreferredSize(new Dimension(40, 20));
        this.buttonAddRequisicao.setMinimumSize(new Dimension(40, 20));
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        this.panelRoot.add((Component)this.buttonAddRequisicao, c);
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 1;
        c.weighty = 1.0;
        c.gridwidth = 4;
        this.panelRoot.add((Component)this.scrollTable, c);
        GridBagConstraints cb = new GridBagConstraints();
        cb.gridx = 0;
        cb.gridy = 0;
        cb.anchor = 17;
        cb.weightx = 1.0;
        this.panelButton.add((Component)this.checkBoxAdicionarAuto, cb);
        ++cb.gridx;
        this.panelButton.add((Component)this.checkMostrarIndividual, cb);
        cb.weightx = 0.0;
        ++cb.gridx;
        this.panelButton.add((Component)this.buttonEnviar, cb);
        ++cb.gridx;
        this.panelButton.add((Component)this.buttonCancelar, cb);
        c.gridx = 0;
        c.gridy = 3;
        c.weighty = 0.0;
        this.panelRoot.add((Component)this.panelButton, c);
        this.exames = exames;
        this.indexRequisicao = indexRequisicao;
        this.indexTubo = indexTubo;
        this.indexNomePaciente = indexNomePaciente;
        this.indexExame = indexExame;
        this.indexContador = indexContador;
        this.textRequisicao.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                boolean requisicaoOk = ExameLote.this.validaRequisicao(false);
                if (requisicaoOk && ExameLote.this.checkBoxAdicionarAuto.isSelected()) {
                    ExameLote.this.addRequisicao();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.tableRequisicao.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (ExameLote.this.tableRequisicao.getSelectedRowCount() > 0) {
                    if (e.getKeyCode() == 127) {
                        ExameLote.this.removerRequisicao(ExameLote.this.tableRequisicao.getSelectedRow());
                        ExameLote.this.populateTable();
                    } else if (e.getKeyCode() == 32 && !ExameLote.this.checkMostrarIndividual.isSelected()) {
                        ExameLote.this.editaRequisicao();
                    }
                }
            }
        });
        this.add((Component)this.panelRoot, "Center");
        Funcoes.montaEnter((JComponent)this.panelRoot);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.requisicoes.clear();
            this.fechar();
        } else if (e.getSource() == this.buttonAddRequisicao) {
            this.addRequisicao();
        } else if (e.getSource() == this.buttonEnviar) {
            if (this.validarLote()) {
                this.fechar();
            }
        } else if (e.getSource() == this.checkMostrarIndividual) {
            this.populateTable();
        }
    }

    private void fechar() {
        ParametrosUsuarios.setValor(PARAMETRO_MOSTRAR_INDIVIDUAL, this.checkMostrarIndividual.isSelected() ? "true" : "false");
        this.setVisible(false);
    }

    private void addRequisicao() {
        this.validaRequisicao(true);
        this.populateTable();
        this.textRequisicao.setText("");
        this.textNomePaciente.setText("");
        ScreenUtil.requisitarFoco(this.textRequisicao);
        ScreenUtil.requisitarFoco(this.textRequisicao);
    }

    private boolean validaRequisicao(boolean adicionaLista) {
        String requisicao = this.textRequisicao.getText();
        String tubo = "";
        String filial = "";
        boolean achou = false;
        if (Funcoes.textoVazio(requisicao)) {
            return false;
        }
        if (requisicao.length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            tubo = requisicao.substring(requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        } else if (requisicao.length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
            filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
        } else {
            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o inv\u00e1lida!", 5);
            this.textRequisicao.setText("");
            this.textNomePaciente.setText("");
            ScreenUtil.requisitarFoco(this.textRequisicao);
            return false;
        }
        if (this.equipamento.isContadorEnvio() && this.requisicoes.size() > 0) {
            for (int i = 0; i < this.requisicoes.size(); ++i) {
                Object[] req = (Object[])this.requisicoes.get(i);
                String cont = req[this.indexContador].toString();
                if (!this.textContador.getText().equalsIgnoreCase(cont)) continue;
                Funcoes.mensagem(this, "Contador j\u00e1 adicionado!", 5);
                return false;
            }
        }
        String reqNew = filial + requisicao;
        for (int i = 0; i < this.exames.size(); ++i) {
            Object[] linha = (Object[])this.exames.get(i);
            String req = linha[this.indexRequisicao].toString();
            String tb = Funcoes.preencheZero(linha[this.indexTubo].toString(), ParametrosGerais.getDigitosTuboTubo());
            if (!reqNew.equalsIgnoreCase(req) || tubo != null && !tubo.isEmpty() && !tubo.equalsIgnoreCase(tb)) continue;
            boolean jaAdicionada = false;
            for (int j = 0; j < this.requisicoes.size(); ++j) {
                Object[] reqAdicionada = (Object[])this.requisicoes.get(j);
                String reqAdic = reqAdicionada[this.indexRequisicao].toString();
                String tbAdic = Funcoes.preencheZero(reqAdicionada[this.indexTubo].toString(), ParametrosGerais.getDigitosTuboTubo());
                if (!req.equals(reqAdic) || !tb.equals(tbAdic)) continue;
                jaAdicionada = true;
                achou = true;
            }
            if (jaAdicionada) continue;
            this.textNomePaciente.setText(linha[this.indexNomePaciente].toString());
            if (adicionaLista) {
                this.requisicoes.add(linha.clone());
            }
            achou = true;
        }
        if (!achou) {
            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o encontrada!", 5);
            this.textRequisicao.setText("");
            this.textNomePaciente.setText("");
            ScreenUtil.requisitarFoco(this.textRequisicao);
        }
        return achou;
    }

    private void populateTable() {
        while (this.tableRequisicao.getRowCount() > 0) {
            this.tableModel.removeLine(0);
        }
        for (int i = 0; i < this.requisicoes.size(); ++i) {
            Object[] o = (Object[])this.requisicoes.get(i);
            if (!this.checkMostrarIndividual.isSelected()) {
                Object[] line = new String[]{o[this.indexRequisicao].toString(), o[this.indexNomePaciente].toString(), o[this.indexExame].toString()};
                this.tableModel.addLine(line);
            } else {
                String[] exames;
                for (String e : exames = o[this.indexExame].toString().split(" ")) {
                    Object[] line = new String[]{o[this.indexRequisicao].toString(), o[this.indexNomePaciente].toString(), e};
                    this.tableModel.addLine(line);
                }
            }
            this.tableRequisicao.scrollRectToVisible(this.tableRequisicao.getCellRect(this.tableModel.getRowCount() - 1, 0, false));
            this.tableRequisicao.setRowSelectionInterval(this.tableModel.getRowCount() - 1, this.tableModel.getRowCount() - 1);
        }
        this.tableRequisicao.setModel(this.tableModel);
    }

    public ArrayList getRequisicoes() {
        return this.requisicoes;
    }

    private boolean validarLote() {
        ((AbaDefaultPendentes)this.equipamento.examesPendentes).reloadExames();
        ArrayList pendentes = ((AbaDefaultPendentes)this.equipamento.examesPendentes).getExames();
        for (int i = 0; i < this.requisicoes.size(); ++i) {
            int contador;
            int tubo;
            Object[] req = (Object[])this.requisicoes.get(i);
            int requisicao = Integer.parseInt(req[this.indexRequisicao].toString());
            int row = this.validaExisteExame(requisicao, tubo = Integer.parseInt(req[this.indexTubo].toString()));
            if (row < 0 || req[this.indexContador] == null || !this.validaExisteExamePendente(contador = Integer.parseInt(req[this.indexContador].toString()), pendentes)) continue;
            Funcoes.mensagem(this, "O contador " + contador + " j\u00e1 esta cadastrado\npara exame que espera retorno!", 5);
            return false;
        }
        return true;
    }

    private int validaExisteExame(int requisicao, int tubo) {
        for (int i = 0; i < this.exames.size(); ++i) {
            Object[] exame = (Object[])this.exames.get(i);
            int requisicaoExame = Integer.parseInt(exame[this.indexRequisicao].toString());
            int tuboExame = Integer.parseInt(exame[this.indexTubo].toString());
            if (requisicao != requisicaoExame || tubo != tuboExame) continue;
            return i;
        }
        return -1;
    }

    private boolean validaExisteExamePendente(int contador, ArrayList pendentes) {
        for (int i = 0; i < pendentes.size(); ++i) {
            Object[] pendente = (Object[])pendentes.get(i);
            int contadorExame = Integer.parseInt(pendente[this.indexContador].toString());
            if (contador != contadorExame) continue;
            return true;
        }
        return false;
    }

    private void editaRequisicao() {
        if (this.equipamento.isContadorEnvio() && !this.checkMostrarIndividual.isSelected()) {
            int row = this.tableRequisicao.getSelectedRow();
            Object[] req = (Object[])this.requisicoes.get(row);
            this.textRequisicao.setText(req[this.indexRequisicao].toString());
            this.textNomePaciente.setText(req[this.indexNomePaciente].toString());
            this.textContador.setText(req[this.indexContador].toString());
            this.textContador.grabFocus();
        }
    }

    private void removerRequisicao(int row) {
        if (!this.checkMostrarIndividual.isSelected()) {
            this.requisicoes.remove(row);
        } else {
            String requisicao = this.tableRequisicao.getValueAt(row, 0).toString();
            for (int i = 0; i < this.requisicoes.size(); ++i) {
                Object[] req = (Object[])this.requisicoes.get(i);
                String reqCodigo = req[this.indexRequisicao].toString();
                if (!requisicao.equals(reqCodigo)) continue;
                String[] exames = req[this.indexExame].toString().split(" ");
                if (exames.length == 1) {
                    this.requisicoes.remove(i);
                    continue;
                }
                String exameRemover = this.tableRequisicao.getValueAt(row, 2).toString();
                StringBuilder exas = new StringBuilder();
                for (String e : exames) {
                    if (e.equals(exameRemover)) continue;
                    exas.append(e).append(" ");
                }
                if (exas.toString().trim().length() == 0) {
                    this.requisicoes.remove(i);
                    continue;
                }
                req[this.indexExame] = exas.toString().trim();
            }
        }
    }
}

