/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.targa3000;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.targa3000.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.targa3000.Mensagem;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Timer;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final int EQUIP_TIMEOUT = 5000;
    public static final int MAX_TENTATIVAS = 2;
    public static final int TIPO_REQ_NOVO = 0;
    public static final int TIPO_REQ_REPETICAO = 1;
    private String ultimaRequisicao = "";
    private String ultimoByteRecebido = "";
    private Map<Integer, String> msgErros = new HashMap<Integer, String>();
    private Timer porta = new Timer(30000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (InterfaceListener.this.getPortaCOM() != null && !InterfaceListener.this.isTX() && !InterfaceListener.this.isRX() || InterfaceListener.this.getPortaCOM() != null && InterfaceListener.this.isRX() && InterfaceListener.this.ultimoByteRecebido.equals(String.valueOf('\u0004'))) {
                try {
                    if (InterfaceListener.this.frames.isEmpty()) {
                        InterfaceListener.this.tratarStx();
                    } else {
                        InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0002'));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    });
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    String int_codigo;
    String fil_codigo;
    String req_codigo;
    String mco_codigo;
    String rec_codigo;
    String pac_nome;
    String pac_exames;
    String pac_sexo;
    String req_idade;
    String req_data;
    String req_hora;
    String acao;
    int tx_counter = 0;
    Mensagem ultimoFrame;
    List<Mensagem> frames = new ArrayList<Mensagem>();
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.msgErros.put(1, "Comando desconhecido");
        this.msgErros.put(2, "Erro de Sintaxe");
        this.msgErros.put(3, "Teste n\u00e3o presente (verifique a lista de alternativos no equipamento/jalis)");
        this.msgErros.put(4, "Todos os testes n\u00e3o est\u00e3o dispon\u00edveis no protocolo (verifique a lista de alternativos no equipamento/jalis)");
        this.msgErros.put(5, "Par\u00e2metros incorretos");
        this.msgErros.put(6, "Lista de trabalho de pacientes completa");
        this.msgErros.put(7, "Paciente desconhecido");
        this.msgErros.put(8, "Padroniza\u00e7\u00e3o em progresso");
        this.msgErros.put(9, "Paciente em progresso");
        this.msgErros.put(12, "Posi\u00e7\u00e3o n\u00e3o encontrada");
        this.msgErros.put(56, "Clone n\u00e3o poss\u00edvel");
        this.porta.start();
    }

    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0004');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    void limpaDadosRequisicao() {
        this.ultimoFrame = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        this.fil_codigo = fil_codigo;
        this.int_codigo = int_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = exames;
        this.acao = acao;
        try {
            if (acao.equalsIgnoreCase("C")) {
                return "";
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            req_codigo = StringUtil.preencheString(Integer.toString(Integer.parseInt(req_codigo)), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo).append(rec_codigo);
            String[] temp = exames.split(" ", 0);
            ArrayList<ExameMaterial> exa_lista = new ArrayList<ExameMaterial>();
            int i = -1;
            for (String t : temp) {
                ExameMaterial exa = new ExameMaterial(t, new Integer(mco_codigo));
                ExameMaterial[] exas = null;
                exas = BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa.getString(), mco_codigo) ? BDUtil.getExamesFilhos(fil_codigo, int_codigo, exa.getString(), mco_codigo) : new ExameMaterial[]{new ExameMaterial(exa.getString(), Integer.parseInt(mco_codigo))};
                for (ExameMaterial e : exas) {
                    if (exa_lista.contains(e)) continue;
                    exa_lista.add(e);
                }
            }
            String clone = "N";
            StringBuilder worklist = new StringBuilder("PS").append(codigo.toString()).append(clone).append("00");
            worklist.append(StringUtil.preencheString(Integer.toString(exa_lista.size()), 2, '0', 1));
            for (ExameMaterial exa : exa_lista) {
                String exa_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exa.getNomeExame(), mco_codigo, int_codigo);
                worklist.append(exa_alternativo);
            }
            worklist = new StringBuilder(worklist).append(this.getMsgEnd());
            Mensagem m = new Mensagem(worklist.toString(), fil_codigo, int_codigo, req_codigo, rec_codigo, mco_codigo, exames);
            this.frames.add(m);
            this.setTX(5000);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0002'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public void addRequisicaoLote(String requisicao, String tubo, String exames, String int_codigo, String mco_codigo) {
        try {
            String codigo = requisicao + StringUtil.preencheString(tubo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            String fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = tubo;
            String[] temp = exames.split(" ", 0);
            ArrayList<ExameMaterial> exa_lista = new ArrayList<ExameMaterial>();
            int i = -1;
            for (String t : temp) {
                ExameMaterial exa = new ExameMaterial(t, new Integer(mco_codigo));
                ExameMaterial[] exas = null;
                exas = BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa.getString(), mco_codigo) ? BDUtil.getExamesFilhos(fil_codigo, int_codigo, exa.getString(), mco_codigo) : new ExameMaterial[]{new ExameMaterial(exa.getString(), Integer.parseInt(mco_codigo))};
                for (ExameMaterial e : exas) {
                    if (exa_lista.contains(e)) continue;
                    exa_lista.add(e);
                }
            }
            String clone = "N";
            StringBuilder worklist = new StringBuilder("PS").append(codigo.toString()).append(clone).append("00");
            worklist.append(StringUtil.preencheString(Integer.toString(exa_lista.size()), 2, '0', 1));
            for (ExameMaterial exa : exa_lista) {
                String exa_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exa.getNomeExame(), mco_codigo, int_codigo);
                worklist.append(exa_alternativo);
            }
            worklist = new StringBuilder(worklist).append(this.getMsgEnd());
            this.frames.add(new Mensagem(String.valueOf('\u0002')));
            this.frames.add(new Mensagem(worklist.toString(), fil_codigo, int_codigo, req_codigo, rec_codigo, mco_codigo, exames));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    public void enviarLote() throws IOException {
        this.setTX(5000);
        this.tx_counter = 0;
        Mensagem m = this.frames.remove(0);
        if (!m.isHandShake().booleanValue()) {
            this.fil_codigo = m.getFil_codigo();
            this.int_codigo = m.getInt_codigo();
            this.req_codigo = m.getReq_codigo();
            this.rec_codigo = m.getRec_codigo();
            this.mco_codigo = m.getMco_codigo();
            this.pac_exames = m.getPac_exames();
            this.acao = "N";
        }
        this.getPortaCOM().write(m.getMensagem());
    }

    @Override
    public String parse(String message) {
        try {
            if (message.toLowerCase().startsWith("y")) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
                this.encerrarTransmissao();
                if (this.frames.size() > 0) {
                    this.enviarProximoFrame();
                }
                return "";
            }
            Statement st = Conexao.getStatement();
            boolean resultadoParcial = this.buscaInicioResultado(message) < 0;
            ArrayList<String> resultados = this.split(message);
            for (String s : resultados) {
                if (s.trim().length() < 11 && !resultadoParcial) continue;
                String req_codigo = this.ultimaRequisicao;
                if (!resultadoParcial) {
                    req_codigo = s.substring(1, 11);
                    s = s.substring(11);
                    this.ultimaRequisicao = req_codigo;
                }
                try {
                    Long.parseLong(req_codigo);
                }
                catch (Exception ex) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                    msg.append(req_codigo);
                    this.fireExcecaoEncontrada(msg.toString());
                    continue;
                }
                if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                    msg.append(req_codigo);
                    this.fireExcecaoEncontrada(msg.toString());
                    continue;
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                while (s.length() >= 21) {
                    String emi_alternativo = s.substring(0, 3);
                    String resultado = s.substring(15, 21);
                    String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (Funcoes.textoVazio(int_codigo)) {
                        this.fireExcecaoEncontrada("Interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    } else {
                        ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                        if (exame == null) {
                            this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                        } else {
                            HashMap<String, Object> dados = new HashMap<String, Object>();
                            int sit = -1;
                            if (BDUtil.existeDesmembramento(fil_codigo, int_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial())) {
                                ExameMaterial[] examesPais;
                                for (ExameMaterial examePai : examesPais = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial())) {
                                    sit = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, examePai.getNomeExame(), examePai.getCodigoMaterial(), rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial());
                                }
                            } else {
                                sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
                            }
                            if (sit != 2 && sit != 7) {
                                String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                                dados.put(campo, resultado.replaceAll("\\.", ","));
                                this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
                            }
                        }
                    }
                    if (s.length() < 21) continue;
                    s = s.substring(21);
                }
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            return "";
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, String.format("Erro ao inserir resultados recebidos ao banco de dados %s\n", this.ultimaRequisicao) + ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
                return String.format("Erro ao inserir resultados recebidos ao banco de dados %s", this.ultimaRequisicao);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                return String.format("Erro ao inserir resultados recebidos ao banco de dados %s", this.ultimaRequisicao);
            }
        }
    }

    public void encerrarTransmissao() throws Exception {
        if (this.tx_counter < 2 && this.pac_exames != null) {
            Statement st = Conexao.getStatement();
            for (String exame : this.pac_exames.split(" ")) {
                int sitAtual;
                int novaSit;
                String int_codigo = this.int_codigo;
                if (int_codigo == null) {
                    int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, exame, this.mco_codigo);
                }
                int n = novaSit = (sitAtual = this.getExameSituacao(st, this.fil_codigo, int_codigo, this.req_codigo, exame, this.mco_codigo, this.rec_codigo)) < 2 ? 1 : 3;
                if (Funcoes.textoVazio(this.fil_codigo) || Funcoes.textoVazio(this.req_codigo) || Funcoes.textoVazio(this.rec_codigo) || Funcoes.textoVazio(this.mco_codigo)) continue;
                this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exame, this.mco_codigo, int_codigo, null, novaSit);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
            if (this.acao.equals("N")) {
                this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
        }
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.setIdle();
        this.fireAtualizarTabela(0);
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    public void caracterNaoEsperado() throws Exception {
        String mensagem = "comando desconhecido";
        if (this.ultimoFrame != null && this.ultimoFrame.getMensagem().startsWith("N")) {
            String errorCode = this.ultimoFrame.getMensagem().substring(1);
            if (Funcoes.isNumeric(errorCode)) {
                int erro = Integer.parseInt(errorCode);
                switch (erro) {
                    case 2: {
                        mensagem = "erro de sintaxe";
                        break;
                    }
                    case 3: {
                        mensagem = "teste n\u00e3o localizado no equipamento";
                        break;
                    }
                    case 4: {
                        mensagem = "nenhum teste localizado no protocolo";
                        break;
                    }
                    case 5: {
                        mensagem = "par\u00e2metros incorretos";
                        break;
                    }
                    case 6: {
                        mensagem = "worklist cheia";
                        break;
                    }
                    case 7: {
                        mensagem = "paciente desconhecido";
                        break;
                    }
                    case 8: {
                        mensagem = "'standardization' em progresso";
                        break;
                    }
                    case 9: {
                        mensagem = "processando paciente";
                        break;
                    }
                    case 12: {
                        mensagem = "posi\u00e7\u00e3o n\u00e3o localizada";
                        break;
                    }
                    default: {
                        mensagem = "repeti\u00e7\u00e3o n\u00e3o permitida";
                    }
                }
            }
            this.fireMensagemEnviada("Erro ao enviar (" + mensagem + ")...", 0, 10000);
            this.encerrarTransmissao();
        }
    }

    private void tratarAcknowledge() throws Exception {
        System.out.println("ack recebido!");
        System.out.println(this.frames.size());
        System.out.println(this.isTX());
        if (this.isTX() || this.frames.size() > 0) {
            this.enviarProximoFrame();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarStx() throws Exception {
        this.getPortaCOM().write(String.valueOf('\u0006'));
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0002': {
                    this.tratarStx();
                    break;
                }
                case '\u0004': {
                    this.tratarEndOfTransmission();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
            this.setIdle();
        }
    }

    private void tratarEndOfTransmission() {
        String msg = this.getPortaCOM().getInputString();
        if (!Funcoes.textoVazio(msg) && msg.startsWith("T")) {
            this.addListaRecebimento(msg);
            this.getPortaCOM().clearInputString();
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (!message.equals("")) {
                if (message.startsWith("T") && message.endsWith(String.valueOf('\u0002'))) {
                    this.tratarStx();
                }
                if (this.isTX() && message.length() == 2 && message.charAt(0) == 'N') {
                    this.envioRecusado(message);
                    this.getPortaCOM().clearInputString();
                    this.setIdle();
                }
                if (message.length() == 2 && message.charAt(0) == 'Y') {
                    this.encerrarTransmissao();
                    this.setIdle();
                }
                if (message.length() == 1 && message.equals(String.valueOf('\u0002'))) {
                    this.getPortaCOM().clearInputString();
                    this.tratarStx();
                    this.ultimoByteRecebido = "";
                    return;
                }
                if (message.length() == 1 && message.equalsIgnoreCase(String.valueOf('\u0006'))) {
                    this.getPortaCOM().clearInputString();
                    this.ultimoByteRecebido = "";
                    this.tratarAcknowledge();
                    return;
                }
                if (message.length() == 3 && message.startsWith("y") && message.endsWith(String.valueOf('\u0002'))) {
                    message = message.substring(0, 2);
                    this.ultimoByteRecebido = message.substring(2);
                    this.getPortaCOM().clearInputString();
                }
                if (message.startsWith("T") && message.length() > 33 && (message.endsWith(this.getMsgEnd()) || message.endsWith(this.getMsgStart())) && message.endsWith(this.getMsgStart())) {
                    this.getPortaCOM().clearInputString();
                    this.tratarStx();
                }
                if (!Funcoes.textoVazio(message)) {
                    if (message.length() == 2 && message.toLowerCase().startsWith("y")) {
                        System.out.println(String.format("Recebeu confirma\u00e7\u00e3o de envio %s %s %s", this.fil_codigo, this.req_codigo, this.rec_codigo));
                        this.parse(message);
                    } else {
                        String resultado = message;
                        this.addListaRecebimento(resultado);
                        this.restartThreadRecebimento();
                    }
                }
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            System.out.println("Q:" + ex.getMessage());
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void envioRecusado(String message) {
        Integer errorCode = message.charAt(1);
        if (this.msgErros.containsKey(errorCode)) {
            this.fireExcecaoEncontrada(String.format("Aparelho recusou o envio (%s - %s)", String.valueOf(errorCode), this.msgErros.get(errorCode)));
        } else {
            this.fireExcecaoEncontrada(String.format("Aparelho recusou o envio (Erro desconhecido)", String.valueOf(errorCode), this.msgErros.get(errorCode)));
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        this.setIdle();
    }

    private void enviarProximoFrame() throws IOException {
        if (this.frames.size() > 0) {
            this.ultimoFrame = this.frames.remove(0);
            if (!this.ultimoFrame.isHandShake().booleanValue()) {
                this.fil_codigo = this.ultimoFrame.getFil_codigo();
                this.int_codigo = this.ultimoFrame.getInt_codigo();
                this.req_codigo = this.ultimoFrame.getReq_codigo();
                this.rec_codigo = this.ultimoFrame.getRec_codigo();
                this.mco_codigo = this.ultimoFrame.getMco_codigo();
                this.pac_exames = this.ultimoFrame.getPac_exames();
                this.acao = "N";
            }
            this.getPortaCOM().write(this.ultimoFrame.getMensagem());
        }
    }

    private String removeCarcteresControle(String mensagem) {
        char[] cSerie;
        StringBuilder retorno = new StringBuilder();
        for (char c : cSerie = mensagem.toCharArray()) {
            if (String.valueOf(c).matches("[a-zA-Z0-9. ]")) {
                retorno.append(c);
                continue;
            }
            retorno.append("");
        }
        return retorno.toString();
    }

    private ArrayList<String> split(String mensagem) {
        ArrayList<String> split = new ArrayList<String>();
        mensagem = this.removeCarcteresControle(mensagem);
        StringBuilder tmp = new StringBuilder();
        char[] cMensagem = mensagem.toCharArray();
        try {
            for (int i = 0; i < cMensagem.length; ++i) {
                if (cMensagem[i] == 'T' && (cMensagem[i + 1] == '0' || cMensagem[i + 1] == '1' || cMensagem[i + 1] == '2' || cMensagem[i + 1] == '3' || cMensagem[i + 1] == '4' || cMensagem[i + 1] == '5' || cMensagem[i + 1] == '6' || cMensagem[i + 1] == '7' || cMensagem[i + 1] == '8' || cMensagem[i + 1] == '9' || cMensagem[i + 1] == ' ' || cMensagem[i + 1] == '-')) {
                    if (i != 0 && (cMensagem[i - 1] == '0' || cMensagem[i - 1] == '1' || cMensagem[i - 1] == '2' || cMensagem[i - 1] == '3' || cMensagem[i - 1] == '4' || cMensagem[i - 1] == '5' || cMensagem[i - 1] == '6' || cMensagem[i - 1] == '7' || cMensagem[i - 1] == '8' || cMensagem[i - 1] == '9' || cMensagem[i - 1] == ' ' || cMensagem[i - 1] == '-')) {
                        split.add(tmp.toString());
                        tmp.setLength(0);
                    } else if (i == 0) {
                        split.add(tmp.toString());
                        tmp.setLength(0);
                    }
                }
                tmp.append(cMensagem[i]);
            }
            split.add(tmp.toString());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.fireMensagemEnviada("N\u00e3o foi poss\u00edvel processar o resultado", 0, 10000);
        }
        return split;
    }

    @Override
    public void teste() {
        String msg = "T0102629304|GLU00.00000.314195.68[EOT]";
    }

    private int buscaInicioResultado(String mensagem) {
        mensagem = this.removeCarcteresControle(mensagem);
        char[] cMensagem = mensagem.toCharArray();
        try {
            for (int i = 0; i < cMensagem.length; ++i) {
                if (cMensagem[i] != 'T' || cMensagem[i + 1] != '0' && cMensagem[i + 1] != '1' && cMensagem[i + 1] != '2' && cMensagem[i + 1] != '3' && cMensagem[i + 1] != '4' && cMensagem[i + 1] != '5' && cMensagem[i + 1] != '6' && cMensagem[i + 1] != '7' && cMensagem[i + 1] != '8' && cMensagem[i + 1] != '9' && cMensagem[i + 1] != ' ' && cMensagem[i + 1] != '-') continue;
                if (i > 1 && (cMensagem[i - 1] == '0' || cMensagem[i - 1] == '1' || cMensagem[i - 1] == '2' || cMensagem[i - 1] == '3' || cMensagem[i - 1] == '4' || cMensagem[i - 1] == '5' || cMensagem[i - 1] == '6' || cMensagem[i - 1] == '7' || cMensagem[i - 1] == '8' || cMensagem[i - 1] == '9' || cMensagem[i - 1] == ' ' || cMensagem[i - 1] == '-')) {
                    return i;
                }
                if (i != 0) continue;
                return i;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.fireMensagemEnviada("N\u00e3o foi poss\u00edvel interpretar o resultado", 0, 10000);
        }
        return -1;
    }

    @Override
    protected void encerrar() {
        super.encerrar();
        if (this.porta != null) {
            this.porta.stop();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(200L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

