/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.t890optimize;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final String CODIGO_ALTERNATIVO = "HEMOG";

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void dataChanged() {
        try {
            String retorno;
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.isEmpty() && (retorno = this.parse(message)) != null && !retorno.equals("")) {
                if (retorno.startsWith("Erro")) {
                    this.fireExcecaoEncontrada(retorno);
                } else {
                    this.fireMensagemEnviada(retorno, 0, 10000);
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String message) {
        if (!message.startsWith(this.getMsgStart()) || !message.endsWith(this.getMsgEnd())) {
            return "Erro ao receber o bloco de resultados, caracter inicial ou final n\u00e3o localizado";
        }
        message = message.substring(this.getMsgStart().length());
        message = message.substring(0, message.length() - this.getMsgEnd().length());
        String[] msgSplit = message.split(";");
        ArrayList<String> campos = new ArrayList<String>();
        for (String s : msgSplit) {
            campos.add(s);
        }
        if (campos != null && campos.size() > 0) {
            try {
                String retorno = this.parseResults(campos);
                if (retorno == null) {
                    return "";
                }
                if (retorno.startsWith("Erro")) {
                    return retorno;
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, 2000);
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao anular os dados recebidos";
                }
            }
        }
        return "Erro ao realizar parse dos dados recebidos";
    }

    private String parseResults(ArrayList<String> campos) throws SQLException {
        try {
            String id = campos.remove(0);
            campos.remove(0);
            campos.remove(0);
            if (Funcoes.textoVazio(id) || id.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada("Erro: Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: " + id);
                return "";
            }
            String fil_codigo = id.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = id.substring(id.length() - ParametrosGerais.getDigitosTuboTubo());
            String req_codigo = id.substring(ParametrosGerais.getDigitosTuboFilial(), id.length() - ParametrosGerais.getDigitosTuboTubo());
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, CODIGO_ALTERNATIVO);
            if (int_codigo == null) {
                this.fireExcecaoEncontrada("Interfaceamento do exame HEMOG n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                return "";
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, CODIGO_ALTERNATIVO);
            if (exame == null) {
                this.fireExcecaoEncontrada("C\u00f3digo LIS do exame HEMOG n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            } else {
                Statement st = Conexao.getStatement();
                HashMap<String, Object> hemograma = new HashMap<String, Object>();
                ArrayList<String> flags = new ArrayList<String>();
                hemograma.put("leucocitos", campos.remove(0));
                campos.remove(0);
                hemograma.put("linfocitos_tipicos_percentual", campos.remove(0));
                campos.remove(0);
                hemograma.put("linfocitos_tipicos_contagem", campos.remove(0));
                campos.remove(0);
                hemograma.put("monocitos_percentual", campos.remove(0));
                campos.remove(0);
                hemograma.put("monocitos_contagem", campos.remove(0));
                campos.remove(0);
                hemograma.put("granulocitos_percentual", campos.remove(0));
                campos.remove(0);
                hemograma.put("granulocitos_contagem", campos.remove(0));
                campos.remove(0);
                hemograma.put("eosinofilos_contagem", campos.remove(0));
                hemograma.put("basofilos_contagem", campos.remove(0));
                hemograma.put("hemacias", campos.remove(0));
                campos.remove(0);
                hemograma.put("rdw", campos.remove(0));
                campos.remove(0);
                hemograma.put("rdw_sd", campos.remove(0));
                campos.remove(0);
                hemograma.put("plaquetas", campos.remove(0));
                campos.remove(0);
                hemograma.put("vpm", campos.remove(0));
                campos.remove(0);
                hemograma.put("pct", campos.remove(0));
                campos.remove(0);
                hemograma.put("pdw", campos.remove(0));
                campos.remove(0);
                hemograma.put("hgb", campos.remove(0));
                campos.remove(0);
                hemograma.put("hct", campos.remove(0));
                campos.remove(0);
                hemograma.put("vcm", campos.remove(0));
                campos.remove(0);
                hemograma.put("hcm", campos.remove(0));
                campos.remove(0);
                hemograma.put("chcm", campos.remove(0));
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
                for (BDExame e : exames) {
                    this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, e.getExame(), e.getMaterial(), int_codigo, hemograma, flags);
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            Statement st = Conexao.getStatement();
            this.atualizarSituacaoRackTubo(st, fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, 1, rackposition);
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            if (acao.equals("N")) {
                this.firePacienteEnviado(req_codigo, pac_nome, pac_sexo, pac_idade, data, hora, exames);
            }
            this.interromperTimer();
            this.fireAtualizarTabela();
            this.setIdle();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }
}

