/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.t890;

import jalis.comum.Conexao;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final int EQUIP_TIMEOUT = 5000;
    public static final String CODIGO_ALTERNATIVO = "t890";
    private String int_codigo = "";
    private String fil_codigo;
    private String req_codigo;
    private String mco_codigo;
    private String rec_codigo;
    private String pac_nome;
    private String pac_exames;
    private String pac_sexo;
    private String req_idade;
    private String req_data;
    private String req_hora;
    private String acao;
    private String frame;
    private String rackposition;
    private static Map<String, String> camposExameByTestId = new HashMap<String, String>();

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        rackposition = Funcoes.preencheZero(rackposition.trim(), 3);
        this.fil_codigo = fil_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.rackposition = rackposition;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = exames;
        this.int_codigo = int_codigo;
        this.acao = acao;
        try {
            Statement st = Conexao.getStatement();
            int situacaoAtual = 0;
            String primeiroExame = exames.split(" ")[0];
            if (primeiroExame != null && !primeiroExame.isEmpty()) {
                situacaoAtual = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, primeiroExame, mco_codigo, rec_codigo);
            }
            int novaSituacao = acao.equals("N") ? 1 : (situacaoAtual == 1 ? 1 : 3);
            this.atualizarSituacaoRackTubo(st, fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, novaSituacao, rackposition);
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            if (acao.equals("N")) {
                this.firePacienteEnviado(req_codigo, pac_nome, pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
            this.interromperTimer();
            this.limpaDadosRequisicao();
            this.fireAtualizarTabela();
            this.setIdle();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public synchronized String parse(String message) {
        String[] linhas;
        String retorno = null;
        Object checksum = null;
        if (!message.startsWith(this.getMsgStart()) || !message.endsWith(this.getMsgEnd())) {
            return "Erro ao receber o bloco de resultados, caracter inicial ou final n\u00e3o localizado";
        }
        if (message.startsWith(this.getMsgStart())) {
            message = message.replaceFirst(this.getMsgStart(), "");
        }
        if (message.endsWith(this.getMsgEnd())) {
            message = message.replaceFirst(this.getMsgEnd(), "");
        }
        if ((linhas = message.split(LINE)) != null && linhas.length > 0) {
            for (int i = 0; i < linhas.length; ++i) {
                linhas[i] = linhas[i].replace("\n", "");
            }
            try {
                retorno = this.parseResults(linhas);
                if (retorno == null) {
                    return "";
                }
                if (retorno.startsWith("Erro")) {
                    return retorno;
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, 2000);
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao anular os dados recebidos";
                }
            }
        }
        return "Erro ao realizar parse dos dados recebidos";
    }

    private String parseResults(String[] linhas) throws SQLException {
        try {
            Statement st = Conexao.getStatement();
            String contador = "";
            int indexCampos = 0;
            for (int i = 0; i < linhas.length; ++i) {
                if (!linhas[i].startsWith("TEST")) continue;
                indexCampos = i + 1;
                contador = linhas[i].substring(7, 10).trim();
                break;
            }
            if (Funcoes.textoVazio(contador) || !Funcoes.isNumeric(contador)) {
                this.fireExcecaoEncontrada("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o localizado nos dados recebidos");
                return null;
            }
            ArrayList<String> requisicaoTuboRack = BDUtil.getRequisicaoTuboRack(this.fil_codigo, this.int_codigo, String.valueOf(1), contador);
            if (requisicaoTuboRack == null || requisicaoTuboRack.size() != 2) {
                requisicaoTuboRack = BDUtil.getRequisicaoTuboRack(this.fil_codigo, this.int_codigo, String.valueOf(3), contador);
            }
            if (requisicaoTuboRack == null || requisicaoTuboRack.size() != 2) {
                this.fireExcecaoEncontrada("Tubo n\u00e3o localizado para os dados recebidos");
                return null;
            }
            this.req_codigo = requisicaoTuboRack.get(0);
            this.rec_codigo = requisicaoTuboRack.get(1);
            HashMap<String, Object> dados = new HashMap<String, Object>();
            dados.put("rack_position", contador);
            for (int i = indexCampos; i < indexCampos + 10; ++i) {
                String linha = linhas[i];
                String campo = camposExameByTestId.get(linha.substring(0, 5).trim());
                String valor = linha.substring(7, 14).trim().replace('.', ',');
                dados.put(campo, valor);
            }
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo);
            for (BDExame e : exames) {
                this.atualizarDadosExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, e.getExame(), e.getMaterial(), this.int_codigo, dados);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    @Override
    public void dataChanged() {
        try {
            String retorno;
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.isEmpty() && (retorno = this.parse(message)) != null && !retorno.equals("")) {
                if (retorno.startsWith("Erro")) {
                    this.fireExcecaoEncontrada(retorno);
                }
                this.fireMensagemEnviada(retorno, 0, 10000);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    void limpaDadosRequisicao() {
        this.frame = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
        this.rackposition = null;
    }

    static {
        camposExameByTestId.put("WBC", "leucocitos");
        camposExameByTestId.put("RBC", "hemacias");
        camposExameByTestId.put("HGB", "hgb");
        camposExameByTestId.put("HCT", "hct");
        camposExameByTestId.put("MCV", "vcm");
        camposExameByTestId.put("MCH", "hcm");
        camposExameByTestId.put("MCHC", "chcm");
        camposExameByTestId.put("PLT", "plaquetas");
        camposExameByTestId.put("LY %", "linfocitos_tipicos_percentual");
        camposExameByTestId.put("LY #", "linfocitos_tipicos_contagem");
    }
}

