/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sysmexxt2000ibi;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.sysmexxt2000ibi.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    public String NOME_EXAME = "HEMOG";
    public final String ALTERNATIVO_VERMELHA = "VERMELHA";
    public final String ALTERNATIVO_BRANCA = "BRANCA";
    public final String ALTERNATIVO_PLAQUETAS = "PLAQUETAS";
    protected String INSTRUMENT_NAME = "";
    protected String INSTRUMENT_SYSTEM_VERSION = "";
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected String host_rack = null;
    protected String host_sampleAttribute = null;
    protected boolean hostQuery = false;
    private int qtdeDigitosTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
    private Map<String, String[]> map = new HashMap<String, String[]>();

    public InterfaceListener() {
        RecordParser record = new RecordParser(this);
        record.setInterfaceASTMListener(this);
        this.map.put(this.NOME_EXAME, new String[]{"WBC", "RBC", "HGB", "HCT", "MCV", "MCH", "MCHC", "PLT", "NEUT%", "LYMPH%", "MONO%", "EO%", "BASO%", "NEUT#", "LYMPH#", "MONO#", "EO#", "BASO#", "RDW-SD", "RDW-CV", "PDW", "MPV", "P-LCR", "PCT"});
        this.map.put("VERMELHA", new String[]{"RBC", "HGB", "HCT", "MCV", "MCH", "MCHC", "RDW-SD", "RDW-CV"});
        this.map.put("BRANCA", new String[]{"WBC", "NEUT%", "LYMPH%", "MONO%", "EO%", "BASO%", "NEUT#", "LYMPH#", "MONO#", "EO#", "BASO#"});
        this.map.put("PLAQUETAS", new String[]{"PLT", "PDW", "MPV", "P-LCR", "PCT"});
        super.setASTMRecordParser(record);
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            String[] fields = starting_range.split("\\^");
            starting_range = fields[2].trim();
            if (starting_range.length() != this.qtdeDigitosTubo) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo da amostra fora do padr\u00e3o %s (%s <> %s)", starting_range, starting_range.length(), this.qtdeDigitosTubo));
                return;
            }
            this.host_fil_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboFilial());
            starting_range = starting_range.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = starting_range.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rack = fields[0] + "^" + fields[1] + "^";
            if (fields.length > 3) {
                this.host_sampleAttribute = fields[3];
            }
            this.hostQuery = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Sysmexxt2000iBi: Host Query Response");
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    private void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String rack = this.host_rack;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames) && req != null && aba != null) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (Funcoes.textoVazio(pac_exames)) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            this.hostQuery = false;
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            this.host_rack = null;
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
            } else {
                this.tx_list.add(this.getHeaderRecord());
                this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
                this.tx_list = this.makeFrames(this.tx_list);
                this.tx_list.resetUltimoLido();
                this.setTX(this.TIME_TX);
                this.tx_counter = 0;
                this.getPortaCOM().write(String.valueOf('\u0005'));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "SysmexXt2000iBi: Host Query Response");
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            String sampleId;
            String short_name;
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            ExameMaterial[] alternativos = null;
            for (int i = 0; i < this.exames.length; ++i) {
                int contador = -1;
                String alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, this.exames[i], mco_codigo, int_codigo);
                int totalAlternativos = this.map.get(alternativo).length;
                alternativos = new ExameMaterial[totalAlternativos];
                String[] parametros = this.map.get(alternativo);
                if (i == this.exames.length - 1 && parametros == null) {
                    parametros = this.map.get(this.NOME_EXAME);
                }
                if (parametros == null) continue;
                for (String param : parametros) {
                    alternativos[++contador] = new ExameMaterial(param, null);
                }
                if (alternativo.equalsIgnoreCase(this.NOME_EXAME)) break;
            }
            if (Funcoes.textoVazio(this.host_sampleAttribute)) {
                this.host_sampleAttribute = "C";
            }
            if ((short_name = StringUtil.removerAcentos(pac_nome)).length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            if (Funcoes.textoVazio(rackposition)) {
                rackposition = "^^";
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(rackposition);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            String patient_id = sampleId = String.format("%s%s%s", fil_codigo, req_codigo, rec_codigo);
            sampleId = Funcoes.preencheVazio(sampleId, 15, 1);
            codigo.append(sampleId).append("^").append(this.host_sampleAttribute);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            String nome = short_name.trim();
            String sobreNome = null;
            if (short_name.indexOf(" ") > 0) {
                nome = short_name.substring(0, short_name.indexOf(" ")).trim();
                sobreNome = short_name.substring(short_name.indexOf(" ")).trim() + StringUtil.repeteCaractere(' ', 20);
                if (nome.length() > 20) {
                    nome = nome.substring(0, 19);
                }
                if (sobreNome.length() > 20) {
                    sobreNome = sobreNome.substring(0, 19).trim();
                }
            }
            this.tx_list.add(this.getHeaderRecord());
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            Date dateNascPac = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String dtNascPac = "";
            if (dateNascPac != null) {
                dtNascPac = Funcoes.formataData("yyyyMMdd", dateNascPac);
            }
            this.tx_list.add(this.getPatientRecord(1, patient_id, nome, sobreNome, dtNascPac, pac_sexo));
            this.addCommentRecord();
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(this.getDefaultOrderRecord(1, codigo.toString(), alternativos, null, null, "R", Funcoes.formataData("yyyyMMddHHmmss", Calendar.getInstance().getTime()), acao, "Q"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.host_sampleAttribute = null;
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    protected void addCommentRecord() {
        this.tx_list.add(this.getCommentRecord());
    }

    protected String getHeaderRecord() {
        return ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION);
    }

    public String getDefaultOrderRecord(int order_sequence, String sample_id, ExameMaterial[] test_item_numbers, ExameMaterial[] test_item_names, String dilution, String priority, String request_order, String action_code, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("||");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            record.append("^^^^");
            record.append(test_item_numbers[0].getNomeExame());
            record.append(test_item_names == null || test_item_names[0] == null ? "" : "^" + test_item_names[0].getNomeExame());
            record.append(dilution == null ? "" : "^" + dilution);
            for (int i = 1; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null) continue;
                record.append("\\^^^^");
                record.append(test_item_numbers[i].getNomeExame());
                record.append(test_item_names == null || test_item_names[i] == null ? "" : "^" + test_item_names[i].getNomeExame());
                record.append(dilution == null ? "" : "^" + dilution);
            }
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("|");
        record.append(request_order);
        record.append("|||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append("|");
        record.append('\r');
        return record.toString();
    }

    private ExameMaterial[] getAlternativos(int material) {
        String[] parametros = new String[]{"WBC", "RBC", "HGB", "HCT", "MCV", "MCH", "MCHC", "PLT", "NEUT%", "LYMPH%", "MONO%", "EO%", "BASO%", "NEUT#", "LYMPH#", "MONO#", "EO#", "BASO#", "RDW-SD", "RDW-CV", "PDW", "MPV", "P-LCR", "5PCT"};
        ExameMaterial[] alternativos = new ExameMaterial[parametros.length];
        for (int i = 0; i < parametros.length; ++i) {
            alternativos[i] = new ExameMaterial(parametros[i], material);
        }
        return alternativos;
    }

    protected String getPatientRecord(int patient_sequence, String patient_id, String pac_nome, String pac_sobrenome, String pac_dataNasc, String pac_sexo) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|||");
        record.append(patient_id == null ? "" : patient_id);
        record.append("|^");
        record.append(pac_nome == null ? "" : pac_nome);
        record.append("^").append(pac_sobrenome == null ? "^" : pac_sobrenome);
        record.append("||");
        record.append(pac_dataNasc).append("|");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append('\r');
        return record.toString();
    }

    private String getCommentRecord() {
        StringBuilder record = new StringBuilder("C|1||");
        record.append('\r');
        return record.toString();
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            for (int i = 0; i < 12; ++i) {
                this.handShakeCharReceived('\u0006');
            }
        } else if (op == 2) {
            this.resultado();
        }
    }

    private void query() {
        String idAmosta = JOptionPane.showInputDialog("Informe o Id da amostra");
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||XT-1800i^00-23^13302^^^^02305316||||||||E1394-97[CR][ETX]AA[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2Q|1|4^1^" + idAmosta + "^B||||20160503131116[CR][ETX]7B[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3L|1|N[CR][ETX]06[LINE]"));
        this.handShakeCharReceived('\u0004');
    }

    private void resultado() {
        String req = "010005939101";
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||XT-1800i^00-21^13505^^^^02305316||||||||E1394-97[CR][ETX]AD[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2P|1|||TESTE||||U[CR][ETX]7D[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3C|1[CR][ETX]33[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4O|1||10^8^[SP][SP][SP]" + req + "^W|^^^^WBC\\^^^^RBC\\^^^^HGB\\^^^^HCT\\^^^^MCV\\^^^^MCH\\^^^^MCHC\\^^^^PLT\\^^^^NEUT%\\^^^^LYM51:328>>PH%\\^^^^51:343>>MONO%\\^^^^EO%\\^^51:359>>^^BASO%\\^^^^NEUT51:390>>#\\^^^^LYMPH#\\^^^^MONO#\\^^^^EO#\\^51:406>>^^^BASO#\\^^^^RDW51:421>>-SD\\^^^^RDW-CV\\^51:437>>^^^MPV|||||||N||51:453>>||||||||51:468>>||[ETB]34[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5||F[CR][ETX]83[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6C|1[CR][ETX]36[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7R|1|^^^^WBC^1|9.62|10*3/uL||N||||||20130516142832[CR][ETX]0E[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0R|2|^^^^RBC^1|5.26|10*6/uL||N||||||20130516142832[CR][ETX]02[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1R|3|^^^^HGB^1|14.8|g/dL||N||||||20130516142832[CR][ETX]93[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2R|4|^^^^HCT^1|45.2|%||N||||||20130516142832[CR][ETX]80[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3R|5|^^^^MCV^1|85.9|fL||N||||||20130516142832[CR][ETX]21[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|6|^^^^MCH^1|28.1|pg||N||||||20130516142832[CR][ETX]2F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5R|7|^^^^MCHC^1|32.7|g/dL||N||||||20130516142832[CR][ETX]E4[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|8|^^^^PLT^1|327|10*3/uL||N||||||20130516142832[CR][ETX]F5[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7R|9|^^^^NEUT%^1|53.5|%||N||||||20130516142832[CR][ETX]0E[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0R|10|^^^^LYMPH%^1|33.2|%||H||||||20130516142832[CR][ETX]72[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1R|11|^^^^MONO%^1|7.9|%||N||||||20130516142832[CR][ETX]01[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2R|12|^^^^EO%^1|4.5|%||N||||||20130516142832[CR][ETX]57[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3R|13|^^^^BASO%^1|0.9|%||N||||||20130516142832[CR][ETX]EA[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|14|^^^^NEUT#^1|5.15|10*3/uL||N||||||20130516142832[CR][ETX]BC[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5R|15|^^^^LYMPH#^1|3.19|10*3/uL||N||||||20130516142832[CR][ETX]0E[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|16|^^^^MONO#^1|0.76|10*3/uL||N||||||20130516142832[CR][ETX]BF[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7R|17|^^^^EO#^1|0.43|10*3/uL||N||||||20130516142832[CR][ETX]16[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0R|18|^^^^BASO#^1|0.09|10*3/uL||N||||||20130516142832[CR][ETX]A3[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1R|19|^^^^RDW-SD^1|44.0|fL||N||||||20130516142832[CR][ETX]11[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2R|20|^^^^RDW-CV^1|14.3|%||N||||||20130516142832[CR][ETX]7F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3R|21|^^^^MPV^1|10.2|fL||N||||||20130516142832[CR][ETX]49[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|22|^^^^Blasts?|0|||A||||||20130516142832[CR][ETX]E0[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5R|23|^^^^Immature_Gran?|20|||A||||||20130516142832[CR][ETX]D6[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|24|^^^^Left_Shift?|0|||||||||20130516142832[CR][ETX]63[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7R|25|^^^^NRBC?|10|||||||||20130516142832[CR][ETX]D3[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0R|26|^^^^Atypical_Lympho?|0|||||||||20130516142832[CR][ETX]86[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1R|27|^^^^RBC_Lyse_Resistance?|50|||||||||20130516142832[CR][ETX]F1[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2R|28|^^^^Abn_Lympho/Blasts?|0|||||||||20130516142832[CR][ETX]FC[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3R|29|^^^^RBC_Agglutination?|60|||||||||20130516142832[CR][ETX]3F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|30|^^^^Turbidity/HGB_Interference?|80|||||||||20130516142832[CR][ETX]A7[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5R|31|^^^^Iron_Deficiency?|80|||||||||20130516142832[CR][ETX]9A[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|32|^^^^HGB_Defect?|80|||||||||20130516142832[CR][ETX]2D[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7R|33|^^^^Fragments?|0|||||||||20130516142832[CR][ETX]23[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0R|34|^^^^PLT_Clumps?|30|||||||||20130516142832[CR][ETX]6C[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2R|36|^^^^SCAT_WBC/BASO|histograma.png|||N||||||20130516142832[CR][ETX]BE[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3R|37|^^^^DIST_RBC|histograma1.png|||N||||||20130516142832[CR][ETX]E7[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|38|^^^^DIST_PLT|histograma2.png|||N||||||20130516142832[CR][ETX]1B[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1R|35|^^^^SCAT_DIFF|histograma3.png|||N||||||20130516142832[CR][ETX]5E[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5L|1|N[CR][ETX]08[LINE]"));
    }
}

