/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sysmexxt2000i;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.sysmexxt2000i.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.sysmexxt2000i.InterfaceListener;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class RecordParser
extends ASTMRecordParser {
    private Map<String, String> flags = new HashMap<String, String>();
    private Map<String, String> flagsExame = new HashMap<String, String>();
    private InterfaceConfiguracao configuracao;

    public RecordParser(InterfaceASTMListener equip) {
        super(equip);
        this.flags.put("L", "Lower than patient limit");
        this.flags.put("H", "Higher than patient limit");
        this.flags.put(">", "Out of linearity range");
        this.flags.put("N", "Normal");
        this.flags.put("A", "Analysis error or hardware problem");
        this.flags.put("W", "Low reliability");
        this.configuracao = new InterfaceConfiguracao();
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        this.flagsExame = new HashMap<String, String>();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        if (!Funcoes.textoVazio(req_codigo)) {
            req_codigo = req_codigo.trim();
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        String emi_alternativo = ((InterfaceListener)this.equip).NOME_EXAME;
        Statement st = Conexao.getStatement();
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        String resultado;
        String campoFlag;
        String campoHemog;
        Hashtable result_fields;
        block15: {
            if (this.exame_atual == null) {
                return;
            }
            String action_code = (String)this.exame_atual.get(ACTION_CODE);
            String report_type = (String)this.exame_atual.get(REPORT_TYPE);
            if (action_code != null) {
                this.equip.getClass();
                if (action_code.equals("Q")) {
                    this.exame_atual = null;
                    return;
                }
            }
            if (report_type != null) {
                this.equip.getClass();
                if (report_type.equals("X")) {
                    this.exame_atual = null;
                    return;
                }
            }
            result_fields = ASTMStandard.parseDefaultResultRecord(record);
            String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
            String int_codigo = (String)this.exame_atual.get(INT_CODIGO);
            String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
            String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
            String mco_codigo = (String)this.exame_atual.get(MCO_CODIGO);
            String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
            campoHemog = (String)result_fields.get(3);
            campoFlag = (String)result_fields.get(3);
            resultado = (String)result_fields.get(4);
            if (this.verificaCampoHemograma(campoHemog = this.parseCampoHemograma(campoHemog))) {
                try {
                    if (Funcoes.textoVazio(this.configuracao.getCaminhoHistogramaImportacao())) break block15;
                    int tamanhoCaminho = this.configuracao.getCaminhoHistogramaImportacao().length();
                    String data = Funcoes.formataData("yyyyMMdd", new Date());
                    if (this.configuracao.getCaminhoHistogramaImportacao().substring(tamanhoCaminho - 1, tamanhoCaminho).equals("\\")) {
                        String caminho = this.configuracao.getCaminhoHistogramaImportacao() + data + System.getProperty("file.separator") + resultado;
                        resultado = this.convertImg(caminho);
                        break block15;
                    }
                    String caminho = this.configuracao.getCaminhoHistogramaImportacao() + System.getProperty("file.separator") + data + System.getProperty("file.separator") + resultado;
                    resultado = this.convertImg(caminho);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                if ((resultado = resultado.replaceAll("\\.", ",")).startsWith(",")) {
                    resultado = "0" + resultado;
                }
                if (resultado.length() >= 1 && resultado.charAt(resultado.length() - 1) == ',') {
                    resultado = resultado + "0";
                }
            }
        }
        Statement st = Conexao.getStatement();
        this.exame_atual.put(campoHemog, resultado);
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !flags.equals("") && !Funcoes.textoVazio(campoHemog)) {
            this.exame_atual.put("flag_alerta", flags);
            campoFlag = campoFlag.replaceAll("\\^1", "");
            campoFlag = campoFlag.replaceAll("\\^", "");
            if (this.flags.containsKey(flags)) {
                this.flagsExame.put(campoFlag, this.flags.get(flags));
            } else {
                this.flagsExame.put(campoFlag, flags);
            }
        }
    }

    private boolean verificaCampoHemograma(String campo) {
        if (campo.equals("sysmex_histograma_rbc")) {
            return true;
        }
        if (campo.equals("sysmex_histograma_plt")) {
            return true;
        }
        if (campo.equals("sysmex_histograma_scat_dif")) {
            return true;
        }
        return campo.equals("sysmex_histograma_scat_wbc");
    }

    private String parseCampoHemograma(String campo) {
        campo = campo.replaceAll("\\^1", "");
        if ((campo = campo.replaceAll("\\^", "")).equalsIgnoreCase("WBC")) {
            return "leucocitos";
        }
        if (campo.equalsIgnoreCase("RBC")) {
            return "hemacias";
        }
        if (campo.equalsIgnoreCase("HGB")) {
            return "hgb";
        }
        if (campo.equalsIgnoreCase("HCT")) {
            return "hct";
        }
        if (campo.equalsIgnoreCase("MCV")) {
            return "vcm";
        }
        if (campo.equalsIgnoreCase("MCH")) {
            return "hcm";
        }
        if (campo.equalsIgnoreCase("MCHC")) {
            return "chcm";
        }
        if (campo.equalsIgnoreCase("PLT")) {
            return "plaquetas";
        }
        if (campo.equalsIgnoreCase("NEUT%")) {
            return "neutrofilo_percentual";
        }
        if (campo.equalsIgnoreCase("LYMPH%")) {
            return "linfocitos_tipicos_percentual";
        }
        if (campo.equalsIgnoreCase("MONO%")) {
            return "monocitos_percentual";
        }
        if (campo.equalsIgnoreCase("EO%")) {
            return "eosinofilos_percentual";
        }
        if (campo.equalsIgnoreCase("BASO%")) {
            return "basofilos_percentual";
        }
        if (campo.equalsIgnoreCase("NEUT#")) {
            return "neutrofilo_contagem";
        }
        if (campo.equalsIgnoreCase("LYMPH#")) {
            return "linfocitos_tipicos_contagem";
        }
        if (campo.equalsIgnoreCase("EO#")) {
            return "eosinofilos_contagem";
        }
        if (campo.equalsIgnoreCase("BASO#")) {
            return "basofilos_contagem";
        }
        if (campo.equalsIgnoreCase("RDW-SD")) {
            return "rdw_sd";
        }
        if (campo.equalsIgnoreCase("RDW-CV")) {
            return "rdw_cv";
        }
        if (campo.equalsIgnoreCase("MPV")) {
            return "vpm";
        }
        if (campo.equalsIgnoreCase("PDW")) {
            return "pdw";
        }
        if (campo.equalsIgnoreCase("DIST_RBC")) {
            return "sysmex_histograma_rbc";
        }
        if (campo.equalsIgnoreCase("DIST_PLT")) {
            return "sysmex_histograma_plt";
        }
        if (campo.equalsIgnoreCase("SCAT_DIFF")) {
            return "sysmex_histograma_scat_dif";
        }
        if (campo.equalsIgnoreCase("SCAT_WBC/BASO")) {
            return "sysmex_histograma_scat_wbc";
        }
        return "";
    }

    private String convertImg(String caminho) throws IOException {
        if (Funcoes.arquivoExiste(caminho)) {
            Base64 b64 = new Base64();
            File img = new File(caminho);
            BufferedImage imgNew = ImageIO.read(img);
            String resultado = b64.encodeAsString(ImagemUtils.imageToByte(imgNew));
            return resultado;
        }
        this.equip.fireExcecaoEncontrada("Arquivo n\u00e3o existente ou n\u00e3o h\u00e1 conex\u00e3o. " + caminho);
        return "";
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        ArrayList<String> flags = null;
        if (!this.flagsExame.isEmpty()) {
            flags = new ArrayList<String>();
            for (String key : this.flagsExame.keySet()) {
                flags.add(String.format("%s = %s", key, this.flagsExame.get(key)));
            }
        }
        Statement st = Conexao.getStatement();
        List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
        for (BDExame exame : exames) {
            this.equip.atualizarDadosExame(st, fil_codigo, exame.getRequisicao(), exame.getRecipiente(), exame.getExame(), exame.getMaterial(), int_codigo, dados, flags);
        }
    }
}

