/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sysmexxt2000i;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.sysmexxt2000i.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;

public class InterfaceListener
extends InterfaceASTMListener {
    public String NOME_EXAME = "HEMOG";
    protected String INSTRUMENT_NAME = "";
    protected String INSTRUMENT_SYSTEM_VERSION = "";

    public InterfaceListener() {
        RecordParser record = new RecordParser(this);
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            String[] exms;
            Statement st = Conexao.getStatement();
            for (String s : exms = pac_exames.split(" ", 0)) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, acao.equals("N") ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            try {
                if (this.tx_list == null) {
                    this.tx_list = new MemoryList();
                }
                if (this.rx_list == null) {
                    this.rx_list = new MemoryList();
                }
                this.tx_list.clear();
                this.rx_list.clear();
                this.fil_codigo = fil_codigo;
                this.int_codigo = int_codigo;
                this.req_codigo = req_codigo;
                this.pac_nome = pac_nome;
                this.pac_sexo = pac_sexo;
                this.req_idade = pac_idade;
                this.req_data = data;
                this.req_hora = hora;
                this.mco_codigo = mco_codigo;
                this.rec_codigo = rec_codigo;
                this.pac_exames = pac_exames;
                this.exames = pac_exames.split(" ", 0);
                this.ultima_acao = acao;
                Statement st = Conexao.getStatement();
                ExameMaterial[] alternativos = new ExameMaterial[30];
                String[] parametros = new String[]{"WBC", "RBC", "HGB", "HCT", "MCV", "MCH", "MCHC", "PLT", "NEUT%", "LYMPH%", "MONO%", "EO%", "BASO%", "NEUT#", "LYMPH#", "MONO#", "EO#", "BASO#", "RDW-SD", "RDW-CV", "PDW", "MPV", "P-LCR", "PCT", "RET%", "RET#", "IRF", "LFR", "MFR", "HFR"};
                for (int i = 0; i < parametros.length; ++i) {
                    alternativos[i] = new ExameMaterial(parametros[i], null);
                }
                String short_name = StringUtil.removerAcentos(pac_nome);
                if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                    short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
                }
                fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
                req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
                StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
                rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
                codigo.append(rec_codigo).append("^C");
                ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
                String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
                String nome = short_name;
                String sobrenome = null;
                this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
                if (this.tx_list.size() < 0) {
                    throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
                }
                String patient_id = req_codigo;
                String laboratory_pid = null;
                this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo));
                if (this.tx_list.size() < 0) {
                    throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
                }
                this.tx_list.add(InterfaceListener.getDefaultOrderRecord(1, codigo.toString(), alternativos, null, null, "R", Funcoes.formataData("YYYYMMddHHmm", Calendar.getInstance().getTime()), acao, "Q"));
                if (this.tx_list.size() < 0) {
                    throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
                }
                this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
                if (this.tx_list.size() < 0) {
                    throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
                }
                this.tx_list = this.makeFrames(this.tx_list);
                this.tx_list.resetUltimoLido();
                this.setTX(this.TIME_TX);
                this.tx_counter = 0;
                this.getPortaCOM().write(String.valueOf('\u0005'));
                return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException ex2) {
                    ErrorLogger.mostraMensagem(null, ex2.getMessage(), ex2.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
                }
                return "Erro ao enviar exames: " + e.toString();
            }
        }
    }

    public static String getDefaultOrderRecord(int order_sequence, String sample_id, ExameMaterial[] test_item_numbers, ExameMaterial[] test_item_names, String dilution, String priority, String request_order, String action_code, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("||");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            record.append("^^^");
            record.append(test_item_numbers[0].getNomeExame());
            record.append(test_item_names == null || test_item_names[0] == null ? "" : "^" + test_item_names[0].getNomeExame());
            record.append(dilution == null ? "" : "^" + dilution);
            for (int i = 1; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null) continue;
                record.append("\\^^^");
                record.append(test_item_numbers[i].getNomeExame());
                record.append(test_item_names == null || test_item_names[i] == null ? "" : "^" + test_item_names[i].getNomeExame());
                record.append(dilution == null ? "" : "^" + dilution);
            }
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("|");
        record.append(request_order);
        record.append("|||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append("|");
        record.append('\r');
        return record.toString();
    }

    private ExameMaterial[] getAlternativos(int material) {
        String[] parametros = new String[]{"WBC", "RBC", "HGB", "HCT", "MCV", "MCH", "MCHC", "PLT", "NEUT%", "LYMPH%", "MONO%", "EO%", "BASO%", "NEUT#", "LYMPH#", "MONO#", "EO#", "BASO#", "RDW-SD", "RDW-CV", "PDW", "MPV", "P-LCR", "5PCT"};
        ExameMaterial[] alternativos = new ExameMaterial[parametros.length];
        for (int i = 0; i < parametros.length; ++i) {
            alternativos[i] = new ExameMaterial(parametros[i], material);
        }
        return alternativos;
    }

    @Override
    public void teste() {
        String req = "010001084101";
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||XT-1800i^00-21^13505^^^^02305316||||||||E1394-97[CR][ETX]AD[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2P|1|||TESTE||||U[CR][ETX]7D[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3C|1[CR][ETX]33[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4O|1||10^8^[SP][SP][SP]" + req + "^W|^^^^WBC\\^^^^RBC\\^^^^HGB\\^^^^HCT\\^^^^MCV\\^^^^MCH\\^^^^MCHC\\^^^^PLT\\^^^^NEUT%\\^^^^LYM51:328>>PH%\\^^^^51:343>>MONO%\\^^^^EO%\\^^51:359>>^^BASO%\\^^^^NEUT51:390>>#\\^^^^LYMPH#\\^^^^MONO#\\^^^^EO#\\^51:406>>^^^BASO#\\^^^^RDW51:421>>-SD\\^^^^RDW-CV\\^51:437>>^^^MPV|||||||N||51:453>>||||||||51:468>>||[ETB]34[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5||F[CR][ETX]83[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6C|1[CR][ETX]36[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7R|1|^^^^WBC^1|9.62|10*3/uL||N||||||20130516142832[CR][ETX]0E[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0R|2|^^^^RBC^1|5.26|10*6/uL||N||||||20130516142832[CR][ETX]02[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1R|3|^^^^HGB^1|14.8|g/dL||N||||||20130516142832[CR][ETX]93[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2R|4|^^^^HCT^1|45.2|%||N||||||20130516142832[CR][ETX]80[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3R|5|^^^^MCV^1|85.9|fL||N||||||20130516142832[CR][ETX]21[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|6|^^^^MCH^1|28.1|pg||N||||||20130516142832[CR][ETX]2F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5R|7|^^^^MCHC^1|32.7|g/dL||N||||||20130516142832[CR][ETX]E4[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|8|^^^^PLT^1|327|10*3/uL||N||||||20130516142832[CR][ETX]F5[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7R|9|^^^^NEUT%^1|53.5|%||N||||||20130516142832[CR][ETX]0E[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0R|10|^^^^LYMPH%^1|33.2|%||H||||||20130516142832[CR][ETX]72[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1R|11|^^^^MONO%^1|7.9|%||N||||||20130516142832[CR][ETX]01[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2R|12|^^^^EO%^1|4.5|%||N||||||20130516142832[CR][ETX]57[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3R|13|^^^^BASO%^1|0.9|%||N||||||20130516142832[CR][ETX]EA[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|14|^^^^NEUT#^1|5.15|10*3/uL||N||||||20130516142832[CR][ETX]BC[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5R|15|^^^^LYMPH#^1|3.19|10*3/uL||N||||||20130516142832[CR][ETX]0E[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|16|^^^^MONO#^1|0.76|10*3/uL||N||||||20130516142832[CR][ETX]BF[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7R|17|^^^^EO#^1|0.43|10*3/uL||N||||||20130516142832[CR][ETX]16[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0R|18|^^^^BASO#^1|0.09|10*3/uL||N||||||20130516142832[CR][ETX]A3[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1R|19|^^^^RDW-SD^1|44.0|fL||N||||||20130516142832[CR][ETX]11[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2R|20|^^^^RDW-CV^1|14.3|%||N||||||20130516142832[CR][ETX]7F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3R|21|^^^^MPV^1|10.2|fL||N||||||20130516142832[CR][ETX]49[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|22|^^^^Blasts?|0|||A||||||20130516142832[CR][ETX]E0[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5R|23|^^^^Immature_Gran?|20|||A||||||20130516142832[CR][ETX]D6[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|24|^^^^Left_Shift?|0|||||||||20130516142832[CR][ETX]63[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7R|25|^^^^NRBC?|10|||||||||20130516142832[CR][ETX]D3[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0R|26|^^^^Atypical_Lympho?|0|||||||||20130516142832[CR][ETX]86[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1R|27|^^^^RBC_Lyse_Resistance?|50|||||||||20130516142832[CR][ETX]F1[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2R|28|^^^^Abn_Lympho/Blasts?|0|||||||||20130516142832[CR][ETX]FC[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3R|29|^^^^RBC_Agglutination?|60|||||||||20130516142832[CR][ETX]3F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|30|^^^^Turbidity/HGB_Interference?|80|||||||||20130516142832[CR][ETX]A7[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5R|31|^^^^Iron_Deficiency?|80|||||||||20130516142832[CR][ETX]9A[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|32|^^^^HGB_Defect?|80|||||||||20130516142832[CR][ETX]2D[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7R|33|^^^^Fragments?|0|||||||||20130516142832[CR][ETX]23[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0R|34|^^^^PLT_Clumps?|30|||||||||20130516142832[CR][ETX]6C[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2R|36|^^^^SCAT_WBC/BASO|histograma.png|||N||||||20130516142832[CR][ETX]BE[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3R|37|^^^^DIST_RBC|histograma1.png|||N||||||20130516142832[CR][ETX]E7[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|38|^^^^DIST_PLT|histograma2.png|||N||||||20130516142832[CR][ETX]1B[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1R|35|^^^^SCAT_DIFF|histograma3.png|||N||||||20130516142832[CR][ETX]5E[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5L|1|N[CR][ETX]08[LINE]"));
    }
}

