/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sysmexxs1000iSocket;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.sysmexxs1000ibi.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final char YES_FLAG = '1';
    private final String NOME_EXAME_HEMOG = "HEMOG";
    private final String NOME_EXAME_CBC = "CBC";
    private int MAX_PATIENT_NAME_CHARS = 40;
    private final int MAX_TENTATIVAS = 2;
    private final int EQUIP_TIMEOUT = 30000;
    private String int_codigo;
    private String fil_codigo;
    private String req_codigo;
    private String mco_codigo;
    private String rec_codigo;
    private String pac_nome;
    private String pac_exames;
    private String pac_sexo;
    private String req_idade;
    private String req_data;
    private String req_hora;
    private String acao;
    private List<String> frames = new ArrayList<String>();
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
    private int tx_counter = 0;
    private List<String> listaMsg = null;
    private Map<Integer, String> flags = null;

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.listaMsg = new ArrayList<String>();
        this.flags = new HashMap<Integer, String>();
        this.flags.put(0, "WBC Abnormal");
        this.flags.put(1, "WBC Suspect");
        this.flags.put(2, "RBC Abnormal");
        this.flags.put(3, "RBC Suspect");
        this.flags.put(4, "PLT Abnormal");
        this.flags.put(5, "PLT Suspect");
        this.flags.put(6, "Unit Information");
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        this.fil_codigo = fil_codigo;
        this.int_codigo = int_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = pac_exames;
        this.acao = acao;
        try {
            ExameMaterial[] exames;
            Statement st;
            ExameMaterial[] alternativos;
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            pac_nome = StringUtil.removerAcentos(pac_nome);
            pac_nome = StringUtil.limpaString(pac_nome, new String[]{"'", "`", "\"", "~", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "[", "{", "}", "]", "|", "\\", ";", ":", ",", "<", ".", ">", "?", "/"});
            if (pac_nome.length() > this.MAX_PATIENT_NAME_CHARS) {
                pac_nome = pac_nome.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            if (pac_nome.length() < this.MAX_PATIENT_NAME_CHARS) {
                pac_nome = Funcoes.preencheVazio(pac_nome, this.MAX_PATIENT_NAME_CHARS, 2);
            }
            String medico = BDUtil.buscaMedicoRequisicao(fil_codigo, req_codigo);
            medico = StringUtil.removerAcentos(medico);
            if (Funcoes.textoVazio(medico = StringUtil.limpaString(medico, new String[]{"'", "`", "\"", "~", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "[", "{", "}", "]", "|", "\\", ";", ":", ",", "<", ".", ">", "?", "/"})) || medico.length() < 20) {
                medico = StringUtil.preencheString(medico, 20, ' ', 0);
            }
            if (medico.length() > 20) {
                medico = medico.substring(0, 20);
            }
            data = !Funcoes.textoVazio(data) ? Funcoes.formataData("yyyyMMdd", Funcoes.stringToDate("dd/MM/yyyy", data)) : Funcoes.formataData("yyyyMMdd", new Date());
            String[] idade = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
            String dataNasc = data;
            if (idade != null && idade.length == 3) {
                dataNasc = idade[2];
                dataNasc = !Funcoes.textoVazio(dataNasc) && dataNasc.trim().length() == 10 ? Funcoes.formataData("yyyyMMdd", Funcoes.stringToDate("dd/MM/yyyy", dataNasc)) : data;
            }
            String alternativo = (alternativos = ExamesUtil.getAlternativos(st = Conexao.getStatement(), fil_codigo, int_codigo, exames = ExamesUtil.anexarCodigoMaterial(pac_exames.split(" "), mco_codigo))) != null && alternativos.length == 1 ? alternativos[0].getNomeExame() : "HEMOG";
            String pac_codigo = BDUtil.getCodigoPaciente(fil_codigo, req_codigo);
            pac_codigo = fil_codigo + StringUtil.preencheString(pac_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            if (Funcoes.textoVazio(pac_sexo)) {
                this.pac_sexo = pac_sexo = "F";
                this.fireExcecaoEncontrada(String.format("Sexo do paciente %s obrigat\u00f3rio verifique: %s %s %s", pac_nome, fil_codigo, req_codigo, rec_codigo));
            }
            StringBuilder worklist = new StringBuilder();
            worklist.append(String.valueOf('\u0002'));
            worklist.append("S");
            worklist.append("1");
            worklist.append("1");
            worklist.append(data);
            worklist.append("000");
            worklist.append(Funcoes.preencheVazio(codigo.toString(), 15, 1));
            worklist.append("00");
            worklist.append("00000000");
            worklist.append("1");
            worklist.append(Funcoes.preencheVazio(pac_codigo.toString(), 16, 2));
            worklist.append(pac_nome);
            worklist.append(pac_sexo == null ? "1" : (pac_sexo.equalsIgnoreCase("M") ? "1" : "2"));
            worklist.append(dataNasc);
            worklist.append(medico);
            worklist.append("                    ");
            worklist.append("                                        ");
            worklist.append("000000000000000000");
            if (alternativo.trim().equalsIgnoreCase("HEMOG")) {
                worklist.append("1111111111111111111111");
            } else if (alternativo.trim().equalsIgnoreCase("CBC")) {
                worklist.append("0111111100000000001111");
            }
            worklist.append("0000000000100000000000000000");
            worklist.append(String.valueOf('\u0003'));
            StringBuilder worklist2 = new StringBuilder();
            worklist2.append(String.valueOf('\u0002'));
            worklist2.append("S");
            worklist2.append("2");
            worklist2.append("1");
            worklist2.append(data);
            worklist2.append("000");
            worklist2.append(Funcoes.preencheVazio(codigo.toString(), 15, 1));
            worklist2.append("00");
            worklist2.append("00000000");
            worklist2.append("1");
            worklist2.append(Funcoes.preencheVazio(pac_codigo.toString(), 16, 2));
            worklist2.append(Funcoes.preencheVazio(" ", 100, 2));
            worklist2.append(Funcoes.preencheZero("0", 97));
            worklist2.append(String.valueOf('\u0003'));
            this.frames.clear();
            this.frames.add(worklist.toString());
            this.frames.add(worklist2.toString());
            this.setTX(30000);
            this.tx_counter = 0;
            this.getPortaCOM().write(this.frames.get(0));
            this.encerrarTransmissao();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public String enviarRequisicaoNaoExistente(String sampleID, String rackposition, String tuboPosition) {
        try {
            StringBuilder worklist = new StringBuilder();
            worklist.append(String.valueOf('\u0002'));
            worklist.append("S");
            worklist.append("1");
            worklist.append("0");
            worklist.append(Funcoes.formataData("yyyyMMdd", Calendar.getInstance().getTime()));
            worklist.append("000");
            worklist.append(Funcoes.preencheVazio(sampleID, 15, 1));
            worklist.append("00");
            worklist.append("00000000");
            worklist.append("1");
            worklist.append(Funcoes.preencheVazio(sampleID, 16, 2));
            worklist.append(StringUtil.repeteCaractere(' ', 40));
            worklist.append("3");
            worklist.append(Funcoes.formataData("yyyyMMdd", Calendar.getInstance().getTime()));
            worklist.append(StringUtil.repeteCaractere(' ', 20));
            worklist.append(StringUtil.repeteCaractere(' ', 20));
            worklist.append(StringUtil.repeteCaractere(' ', 40));
            worklist.append(StringUtil.repeteCaractere('0', 18));
            worklist.append(StringUtil.repeteCaractere('0', 22));
            worklist.append(StringUtil.repeteCaractere('0', 28));
            worklist.append(String.valueOf('\u0003'));
            StringBuilder worklist2 = new StringBuilder();
            worklist2.append(String.valueOf('\u0002'));
            worklist2.append("S");
            worklist2.append("2");
            worklist2.append("0");
            worklist2.append(Funcoes.formataData("yyyyMMdd", Calendar.getInstance().getTime()));
            worklist2.append("000");
            worklist2.append(Funcoes.preencheVazio(sampleID, 15, 1));
            worklist2.append("00");
            worklist2.append("00000000");
            worklist2.append("1");
            worklist2.append(Funcoes.preencheVazio(sampleID, 16, 2));
            worklist2.append(Funcoes.preencheVazio(" ", 100, 2));
            worklist2.append(Funcoes.preencheZero("0", 97));
            worklist2.append(String.valueOf('\u0003'));
            this.frames.clear();
            this.frames.add(worklist.toString());
            this.frames.add(worklist2.toString());
            this.setTX(30000);
            this.tx_counter = 0;
            this.getPortaCOM().write(this.frames.get(0));
            return "Enviando requisi\u00e7\u00e3o de " + this.pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String message) {
        String msgType;
        String retorno = null;
        if (!message.startsWith(this.getMsgStart()) && !message.endsWith(this.getMsgEnd())) {
            return "Erro ao validar mensagem recebida do equipamento";
        }
        if (message.startsWith(this.getMsgStart())) {
            message = message.replaceFirst(this.getMsgStart(), "");
        }
        if (message.endsWith(this.getMsgEnd())) {
            message = message.replaceFirst(this.getMsgEnd(), "");
        }
        if ((msgType = message.substring(0, 1)).equalsIgnoreCase("R")) {
            retorno = this.parseHostQuery(message);
        } else if (msgType.equalsIgnoreCase("D")) {
            retorno = this.parseResults(message);
        }
        return retorno;
    }

    private String parseHostQuery(String message) {
        try {
            String id = message.substring(5, 20).trim();
            if (id.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                return this.enviarRequisicaoNaoExistente(id, null, null);
            }
            String fil_codigo = id.substring(0, ParametrosGerais.getDigitosTuboFilial());
            id = id.substring(ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = id.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            String rec_codigo = id.substring(ParametrosGerais.getDigitosTuboRequisicao());
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String rack = message.substring(22, 30);
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "N";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                List<Object[]> reqs;
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                } else {
                    req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    if (req != null) {
                        aba = this.equipamento.getTab(2);
                        if (req != null) {
                            pac_exames = pac_exames + " ";
                            reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                            for (Object[] r : reqs) {
                                pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                            }
                            pac_exames = pac_exames.trim();
                        }
                    }
                }
            }
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
            }
            String sampleId = message.substring(5, 20).trim();
            return this.enviarRequisicaoNaoExistente(sampleId, null, null);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Sysmex XS1000i-BI Socket: Host Query Response");
            return "Erro ao processar a solicita\u00e7\u00e3o do equipamento";
        }
    }

    private String parseResults(String message) {
        try {
            int digitos = 0;
            if (Funcoes.isNumeric(this.configuracao.getQtdeDigitosDesconsiderar())) {
                digitos = Integer.parseInt(this.configuracao.getQtdeDigitosDesconsiderar());
            }
            String id = message.substring(32 + digitos, 47).trim();
            Statement st = Conexao.getStatement();
            if (id.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo() || !Funcoes.isNumeric(id.trim())) {
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
                return null;
            }
            String subType = message.substring(1, 2);
            if (subType.equalsIgnoreCase("1")) {
                this.listaMsg.clear();
                this.listaMsg.add(message);
                return "";
            }
            if (!subType.equalsIgnoreCase("2")) {
                return "";
            }
            String filialRecebimento = id.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String recipienteRecebimento = id.substring(id.length() - ParametrosGerais.getDigitosTuboTubo());
            String requisicaoRecebimento = id.substring(ParametrosGerais.getDigitosTuboFilial(), id.length() - ParametrosGerais.getDigitosTuboTubo());
            String materialRecebido = "";
            String int_codigo = this.getIntCodigo(filialRecebimento, requisicaoRecebimento, recipienteRecebimento, "HEMOG");
            if (int_codigo == null) {
                int_codigo = this.getIntCodigo(filialRecebimento, requisicaoRecebimento, recipienteRecebimento, "CBC");
            }
            if (int_codigo == null) {
                String alternativo = "";
                ExameMaterial exm = this.getReqExameLIS(filialRecebimento, int_codigo, requisicaoRecebimento, recipienteRecebimento, "HEMOG");
                if (exm == null) {
                    exm = this.getReqExameLIS(filialRecebimento, int_codigo, requisicaoRecebimento, recipienteRecebimento, "CBC");
                }
                StringBuilder s = new StringBuilder();
                if (exm == null) {
                    s.append("O exame n\u00e3o foi localizado para a requisi\u00e7\u00e3o ").append(id);
                    return s.toString();
                }
                int situacao = this.getExameSituacao(st, filialRecebimento, int_codigo, requisicaoRecebimento, "HEMOG", materialRecebido, recipienteRecebimento);
                s.append("N\u00e3o foi poss\u00edvel encontrar o exame! O exame encontra-se ");
                if (situacao == 8) {
                    s.append("exportado!");
                } else {
                    s.append("sem situa\u00e7\u00e3o!");
                }
                s.append("(").append(id).append(")");
                this.fireExcecaoEncontrada(s.toString());
                return null;
            }
            ArrayList<String> listFlags = new ArrayList<String>();
            if (!this.listaMsg.isEmpty()) {
                String flagsAux = this.listaMsg.get(0).substring(this.listaMsg.get(0).length() - 94, this.listaMsg.get(0).length());
                flagsAux = flagsAux.substring(0, 7);
                for (int i = 0; i < flagsAux.length(); ++i) {
                    if (flagsAux.toCharArray()[i] != '1') continue;
                    listFlags.add(this.flags.get(i));
                }
            }
            HashMap<String, Object> hemograma = new HashMap<String, Object>();
            hemograma.put("leucocitos", message.substring(47, 50) + "," + message.substring(50, 53));
            hemograma.put("hemacias", message.substring(53, 55) + "," + message.substring(55, 58));
            hemograma.put("hgb", message.substring(58, 61) + "," + message.substring(61, 63));
            hemograma.put("hct", message.substring(63, 66) + "," + message.substring(66, 68));
            hemograma.put("vcm", message.substring(68, 71) + "," + message.substring(71, 73));
            hemograma.put("hcm", message.substring(73, 76) + "," + message.substring(76, 78));
            hemograma.put("chcm", message.substring(78, 81) + "," + message.substring(81, 83));
            hemograma.put("plaquetas", message.substring(83, 87));
            hemograma.put("linfocitos_tipicos_percentual", message.substring(88, 91) + "," + message.substring(91, 93));
            hemograma.put("monocitos_percentual", message.substring(93, 96) + "," + message.substring(96, 98));
            hemograma.put("neutrofilo_percentual", message.substring(98, 101) + "," + message.substring(101, 103));
            hemograma.put("eosinofilos_percentual", message.substring(103, 106) + "," + message.substring(106, 108));
            hemograma.put("basofilos_percentual", message.substring(108, 111) + "," + message.substring(111, 113));
            hemograma.put("linfocitos_tipicos_contagem", message.substring(113, 116) + "," + message.substring(116, 119));
            hemograma.put("monocitos_contagem", message.substring(119, 122) + "," + message.substring(122, 125));
            hemograma.put("neutrofilo_contagem", message.substring(125, 128) + "," + message.substring(128, 131));
            hemograma.put("eosinofilos_contagem", message.substring(131, 134) + "," + message.substring(134, 137));
            hemograma.put("basofilos_contagem", message.substring(137, 140) + "," + message.substring(140, 143));
            hemograma.put("rdw_cv", message.substring(143, 146) + "," + message.substring(146, 148));
            hemograma.put("rdw_sd", message.substring(148, 151) + "," + message.substring(151, 153));
            hemograma.put("pdw", message.substring(153, 156) + "," + message.substring(156, 158));
            hemograma.put("vpm", message.substring(158, 161) + "," + message.substring(161, 163));
            hemograma.put("pct", message.substring(197, 200) + "," + message.substring(200, 202));
            hemograma.put("granulocitos_contagem", message.substring(215, 221));
            hemograma.put("granulocitos_percentual", message.substring(221, 226));
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(filialRecebimento, int_codigo, requisicaoRecebimento, recipienteRecebimento);
            if (exames == null || exames.isEmpty()) {
                this.fireExcecaoEncontrada(String.format("Nenhum exame localizado para a amostra %s %s %s  interface %s ", filialRecebimento, requisicaoRecebimento, recipienteRecebimento, int_codigo));
                return "";
            }
            this.listaMsg.clear();
            for (BDExame exame : exames) {
                this.atualizarDadosExame(st, filialRecebimento, requisicaoRecebimento, recipienteRecebimento, exame.getExame(), exame.getMaterial(), int_codigo, hemograma, listFlags);
                Conexao.arquivaSQL();
            }
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
                return "Erro ao inserir resultados recebidos ao banco de dados";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                return "Erro ao inserir resultados recebidos ao banco de dados";
            }
        }
        return "";
    }

    private void encerrarTransmissao() throws Exception {
        if (this.tx_counter < 2) {
            Statement st = Conexao.getStatement();
            this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
            if (this.acao.equals("N")) {
                this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
        }
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    private void retransmitirRecusado() throws Exception {
        if (this.tx_counter >= 2) {
            this.encerrarTransmissao();
            return;
        }
        this.setTX(30000);
        this.getPortaCOM().write(this.frames.get(0));
        ++this.tx_counter;
    }

    private void requisicaoExistente() throws Exception {
        Statement st = Conexao.getStatement();
        int sit = 1;
        System.out.println("Situa\u00e7\u00e3o: " + sit);
        if (!Funcoes.textoVazio(this.acao) && !this.acao.equalsIgnoreCase("N")) {
            sit = 3;
        }
        System.out.println("Nova Situa\u00e7\u00e3o: " + sit);
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, sit);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) re-enviado(s) com sucesso para " + this.pac_nome + ".", 0, 10000);
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    protected void aguardarProximoFrame() throws Exception {
        this.setRX(30000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(5000);
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    private void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(3000);
    }

    public void caracterNaoEsperado() throws Exception {
    }

    private void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            this.frames.remove(0);
            if (this.frames.size() > 0) {
                this.getPortaCOM().write(this.frames.get(0));
            } else {
                this.encerrarTransmissao();
            }
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarNegativeAck() throws Exception {
        if (this.isTX()) {
            this.retransmitirRecusado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
            this.setIdle();
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
            } else if (this.isRX()) {
                if (this.frames.size() > 0) {
                    this.abortarRecepcao();
                } else {
                    this.setIdle();
                }
            } else {
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    protected void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    protected void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    private void limpaDadosRequisicao() {
        this.frames.clear();
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    @Override
    public void teste() {
        String req = "010002734101";
        String flags = "1010101";
        boolean enviaFlags = false;
        StringBuilder tmp = new StringBuilder();
        tmp.setLength(0);
        if (enviaFlags) {
            tmp.append("[STX]D1U[SP][SP]XS-1000i^120670000000023000[SP][SP][SP]");
            tmp.append(req + "20130423124600[SP][SP][SP][SP][SP][SP]0001[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]");
            tmp.append("01100000" + flags + "00000000000000000000000000000000000000000000000000000000000000000XS-1000i^05347211^12067[ETX]");
        } else {
            tmp.append("[STX]D2U[SP][SP]XS-1000i^120670000000023000[SP][SP][SP]").append(req);
            tmp.append("0086300440001320038500875003000034300252002340008800624000530000100020200007610053800004610000");
            tmp.append("10012900403000000010200000000000000000000000000000000000000000000000000000[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]00000XS-1000i^05342311^12067[ETX]");
        }
        this.parse(TestesInterface.arruma(tmp.toString()));
    }

    private boolean isRecebimento(String linha) {
        return linha.contains("RECEBIMENTO");
    }

    private String removerComentario(String linha) {
        if (this.temComentario(linha)) {
            int inicioComentario = linha.indexOf("/*");
            int fimComentario = linha.indexOf("*/");
            String inicio = linha.substring(0, inicioComentario);
            String fim = linha.substring(fimComentario + 2, linha.length());
            linha = inicio + fim;
        }
        return linha;
    }

    private boolean temComentario(String linha) {
        return linha.contains("/*") && linha.contains("*/");
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

