/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sysmexxn550;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.sysmexxt2000ibi.InterfaceListener;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class RecordParser
extends jalis.laboratorio.interfaceamento.interfaces.sysmexxt2000ibi.RecordParser {
    public RecordParser(InterfaceASTMListener equip) {
        super(equip);
    }

    @Override
    public void recordFound(String record) throws Exception {
        String record_type = ASTMStandard.getRecordTypeIdentifier(record = record.substring(1));
        if (record_type != null) {
            if (record_type.equals(ASTMStandard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_RESULT)) {
                this.trataResultRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return;
            }
        }
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        ExameMaterial exame;
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        this.flagsExame = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        if (!Funcoes.textoVazio(req_codigo)) {
            req_codigo = req_codigo.trim();
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        String emi_alternativo = ((InterfaceListener)this.equip).NOME_EXAME;
        Statement st = Conexao.getStatement();
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (int_codigo == null) {
            emi_alternativo = ((InterfaceListener)this.equip).ALTERNATIVO_BRANCA;
            int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
            if (int_codigo == null) {
                emi_alternativo = ((InterfaceListener)this.equip).ALTERNATIVO_VERMELHA;
                int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
            }
            if (int_codigo == null) {
                emi_alternativo = ((InterfaceListener)this.equip).ALTERNATIVO_PLAQUETAS;
                int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
            }
        }
        if ((exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo)) == null) {
            emi_alternativo = ((InterfaceListener)this.equip).ALTERNATIVO_BRANCA;
            exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
            if (exame == null) {
                emi_alternativo = ((InterfaceListener)this.equip).ALTERNATIVO_VERMELHA;
                exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
            }
            if (exame == null) {
                emi_alternativo = ((InterfaceListener)this.equip).ALTERNATIVO_PLAQUETAS;
                exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
            }
        }
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
    }

    @Override
    protected String parseCampoHemograma(String campo) {
        if ((campo = this.trataCampos(campo)).equalsIgnoreCase("NEUT%W")) {
            return "neutrofilo_percentual";
        }
        if (campo.equalsIgnoreCase("IG%")) {
            return "ig_percentual";
        }
        if (campo.equalsIgnoreCase("IG#")) {
            return "ig_contagem";
        }
        if (campo.equalsIgnoreCase("DIST_RBC")) {
            return "dist_rbc";
        }
        if (campo.equalsIgnoreCase("DIST_PLT")) {
            return "dist_plt";
        }
        if (campo.equalsIgnoreCase("SCAT_WDF")) {
            return "scat_wdfa";
        }
        if (campo.equalsIgnoreCase("SCAT_WDF-CBC")) {
            return "scat_wdf_cbc";
        }
        return super.parseCampoHemograma(campo);
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        String resultado;
        String campoFlag;
        String campoHemog;
        Hashtable result_fields;
        block14: {
            if (this.exame_atual == null) {
                return;
            }
            String action_code = (String)this.exame_atual.get(ACTION_CODE);
            String report_type = (String)this.exame_atual.get(REPORT_TYPE);
            if (action_code != null) {
                this.equip.getClass();
                if (action_code.equals("Q")) {
                    this.exame_atual = null;
                    return;
                }
            }
            if (report_type != null) {
                this.equip.getClass();
                if (report_type.equals("X")) {
                    this.exame_atual = null;
                    return;
                }
            }
            result_fields = ASTMStandard.parseDefaultResultRecord(record);
            String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
            String int_codigo = (String)this.exame_atual.get(INT_CODIGO);
            String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
            String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
            String mco_codigo = (String)this.exame_atual.get(MCO_CODIGO);
            String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
            campoHemog = (String)result_fields.get(3);
            campoFlag = (String)result_fields.get(3);
            resultado = (String)result_fields.get(4);
            campoHemog = this.parseCampoHemograma(campoHemog);
            campoFlag = this.trataCampos(campoFlag);
            if (this.verificaCampoHemograma(campoHemog)) {
                try {
                    if (Funcoes.textoVazio(this.configuracao.getCaminhoHistogramaImportacao())) break block14;
                    int tamanhoCaminho = this.configuracao.getCaminhoHistogramaImportacao().length();
                    String data = Funcoes.formataData("yyyyMMdd", new Date());
                    if (this.configuracao.getCaminhoHistogramaImportacao().substring(tamanhoCaminho - 1, tamanhoCaminho).equals("\\")) {
                        String caminho = this.configuracao.getCaminhoHistogramaImportacao() + data + System.getProperty("file.separator") + resultado;
                        resultado = this.convertImg(caminho);
                        break block14;
                    }
                    String caminho = this.configuracao.getCaminhoHistogramaImportacao() + System.getProperty("file.separator") + data + System.getProperty("file.separator") + resultado;
                    resultado = this.convertImg(caminho);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                if ((resultado = resultado.replaceAll("\\.", ",")).startsWith(",")) {
                    resultado = "0" + resultado;
                }
                if (resultado.length() >= 1 && resultado.charAt(resultado.length() - 1) == ',') {
                    resultado = resultado + "0";
                }
            }
        }
        Statement st = Conexao.getStatement();
        this.exame_atual.put(campoHemog, resultado);
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (!(flags == null || flags.equals("") || Funcoes.textoVazio(campoHemog) && Funcoes.textoVazio(campoFlag))) {
            this.exame_atual.put("flag_alerta", flags);
            if (!this.configuracao.getExibirSomenteFlagsDeAnormalidade() && (!flags.equals("N") || !Funcoes.textoVazio(flags)) || this.configuracao.getExibirSomenteFlagsDeAnormalidade() && flags.equals("A")) {
                this.flagsExame.put(campoFlag, flags);
            }
        }
    }

    private boolean verificaCampoHemograma(String campo) {
        if (campo.equals("scat_wdfa")) {
            return true;
        }
        if (campo.equals("scat_wdf_cbc")) {
            return true;
        }
        if (campo.equals("dist_rbc")) {
            return true;
        }
        return campo.equals("dist_plt");
    }

    private String convertImg(String caminho) throws IOException {
        if (Funcoes.arquivoExiste(caminho)) {
            Base64 b64 = new Base64();
            File img = new File(caminho);
            BufferedImage imgNew = ImageIO.read(img);
            String resultado = b64.encodeAsString(ImagemUtils.imageToByte(imgNew));
            return resultado;
        }
        this.equip.fireExcecaoEncontrada("Arquivo n\u00e3o existente ou n\u00e3o h\u00e1 conex\u00e3o. " + caminho);
        return "";
    }
}

