/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sysmexxn1000;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.sysmexxn1000.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.sysmexxn1000.InterfaceListener;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    public Map<String, String> flags = new HashMap<String, String>();
    public Map<String, String> flagsExame = new HashMap<String, String>();
    public InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
    public List<String> strFlags = new ArrayList<String>();

    public RecordParser(InterfaceASTMListener equip) {
        super(equip);
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        if (!this.configuracao.getExibirSomenteFlagsDeAnormalidade()) {
            this.flags.put("L", "Lower than patient limit");
            this.flags.put("H", "Higher than patient limit");
            this.flags.put(">", "Out of linearity range");
            this.flags.put("N", "Normal");
            this.flags.put("W", "Low reliability");
        }
        this.flags.put("A", "Analysis error or hardware problem");
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> orderFields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, orderFields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, orderFields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)orderFields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sysSampleId = this.equip.parseOrderSystemSID(instSID);
        String reqCodigo = sysSampleId.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        if (!Funcoes.textoVazio(reqCodigo)) {
            reqCodigo = reqCodigo.trim();
        }
        try {
            Long.parseLong(reqCodigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(reqCodigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        reqCodigo = Funcoes.preencheZero(reqCodigo, qtde);
        String rackId = sysSampleId.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rackPos = sysSampleId.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rackId != null ? rackId + (rackPos != null ? "-" + rackPos : "") : rackPos);
        String filCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String recCodigo = reqCodigo.substring(reqCodigo.length() - ParametrosGerais.getDigitosTuboTubo());
        reqCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboFilial(), reqCodigo.length() - ParametrosGerais.getDigitosTuboTubo());
        InterfaceListener cfr_ignored_0 = (InterfaceListener)this.equip;
        String emiAlternativo = "HEMOG";
        String intCodigo = this.equip.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo);
        ExameMaterial exame = this.equip.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
        this.exame_atual.put(INT_CODIGO, intCodigo);
        this.exame_atual.put(FIL_CODIGO, filCodigo);
        this.exame_atual.put(REC_CODIGO, recCodigo);
        this.exame_atual.put(REQ_CODIGO, reqCodigo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emiAlternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + filCodigo + " " + reqCodigo + " " + recCodigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
    }

    @Override
    protected void trataResultRecord(String resultRecord) throws SQLException {
        if (this.exame_atual == null) {
            return;
        }
        String actionCode = (String)this.exame_atual.get(ACTION_CODE);
        String reportType = (String)this.exame_atual.get(REPORT_TYPE);
        if (actionCode != null) {
            this.equip.getClass();
            if (actionCode.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (reportType != null) {
            this.equip.getClass();
            if (reportType.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable resultFields = ASTMStandard.parseDefaultResultRecord(resultRecord);
        String campoHemog = (String)resultFields.get(3);
        String resultado = (String)resultFields.get(4);
        campoHemog = this.parseCampoHemograma(campoHemog);
        if ((resultado = resultado.replaceAll("\\.", ",")).startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.length() >= 1 && resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        this.exame_atual.put(campoHemog, resultado);
        String abnormalFlags = (String)resultFields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (!abnormalFlags.isEmpty() && !this.strFlags.toString().contains(abnormalFlags) && this.flags.get(abnormalFlags) != null) {
            this.strFlags.add(this.flags.get(abnormalFlags));
        }
    }

    private String parseCampoHemograma(String campo) {
        campo = campo.replaceAll("\\^1", "");
        if ((campo = campo.replaceAll("\\^", "")).equalsIgnoreCase("WBC")) {
            return "leucocitos";
        }
        if (campo.equalsIgnoreCase("RBC")) {
            return "hemacias";
        }
        if (campo.equalsIgnoreCase("HGB")) {
            return "hgb";
        }
        if (campo.equalsIgnoreCase("HCT")) {
            return "hct";
        }
        if (campo.equalsIgnoreCase("MCV")) {
            return "vcm";
        }
        if (campo.equalsIgnoreCase("MCH")) {
            return "hcm";
        }
        if (campo.equalsIgnoreCase("MCHC")) {
            return "chcm";
        }
        if (campo.equalsIgnoreCase("PLT")) {
            return "plaquetas";
        }
        if (campo.equalsIgnoreCase("NEUT%")) {
            return "neutrofilo_percentual";
        }
        if (campo.equalsIgnoreCase("LYMPH%")) {
            return "linfocitos_tipicos_percentual";
        }
        if (campo.equalsIgnoreCase("MONO%")) {
            return "monocitos_percentual";
        }
        if (campo.equalsIgnoreCase("MONO#")) {
            return "monocitos_contagem";
        }
        if (campo.equalsIgnoreCase("EO%")) {
            return "eosinofilos_percentual";
        }
        if (campo.equalsIgnoreCase("BASO%")) {
            return "basofilos_percentual";
        }
        if (campo.equalsIgnoreCase("NEUT#")) {
            return "neutrofilo_contagem";
        }
        if (campo.equalsIgnoreCase("LYMPH#")) {
            return "linfocitos_tipicos_contagem";
        }
        if (campo.equalsIgnoreCase("EO#")) {
            return "eosinofilos_contagem";
        }
        if (campo.equalsIgnoreCase("BASO#")) {
            return "basofilos_contagem";
        }
        if (campo.equalsIgnoreCase("BASO%")) {
            return "basofilos_percentual";
        }
        if (campo.equalsIgnoreCase("RDW-SD")) {
            return "rdw_sd";
        }
        if (campo.equalsIgnoreCase("RDW-CV")) {
            return "rdw_cv";
        }
        if (campo.equalsIgnoreCase("MPV")) {
            return "vpm";
        }
        return "";
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String filCodigo = (String)dados.remove(FIL_CODIGO);
        String intCodigo = (String)dados.remove(INT_CODIGO);
        String reqCodigo = (String)dados.remove(REQ_CODIGO);
        String recCodigo = (String)dados.remove(REC_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
        for (BDExame exame : exames) {
            this.equip.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getExame(), exame.getMaterial(), intCodigo, dados, this.strFlags);
        }
        this.strFlags = new ArrayList<String>();
    }
}

