/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sysmexxn1000;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.sysmexxn1000.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    public static final String NOME_EXAME = "HEMOG";
    public static final String ALTERNATIVO_VERMELHA = "VERMELHA";
    public static final String ALTERNATIVO_BRANCA = "BRANCA";
    public static final String ALTERNATIVO_PLAQUETAS = "PLAQUETAS";
    protected String hostFilCodigo = null;
    protected String hostReqCodigo = null;
    protected String hostRecCodigo = null;
    protected String hostRack = null;
    protected String hostSampleAttribute = null;
    protected boolean hostQuery = false;
    private int qtdeDigitosTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
    private Map<String, String[]> map = new HashMap<String, String[]>();

    public InterfaceListener() {
        RecordParser recordParser = new RecordParser(this);
        recordParser.setInterfaceASTMListener(this);
        this.map.put(NOME_EXAME, new String[]{"WBC", "RBC", "HGB", "HCT", "MCV", "MCH", "MCHC", "PLT", "RDW-SD", "RDW-CV", "MPV", "NEUT#", "LYMPH#", "EO#", "BASO#", "MONO#", "NEUT%", "LYMPH%", "MONO%", "EO%", "BASO%", "NRBC#", "NRBC%", "IG#", "IG%", "PDW", "P-LCR", "5PCT"});
        this.map.put(ALTERNATIVO_VERMELHA, new String[]{"RBC", "HGB", "HCT", "MCV", "MCH", "MCHC", "RDW-SD", "RDW-CV"});
        this.map.put(ALTERNATIVO_BRANCA, new String[]{"WBC", "NEUT%", "LYMPH%", "MONO%", "EO%", "BASO%", "NEUT#", "LYMPH#", "MONO#", "EO#", "BASO#"});
        this.map.put(ALTERNATIVO_PLAQUETAS, new String[]{"PLT", "PDW", "MPV", "P-LCR", "5PCT"});
        super.setASTMRecordParser(recordParser);
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public void responderRequest(String startingRange, String endingRange, String testId) {
        try {
            String[] fields = startingRange.split("\\^");
            startingRange = fields[2].trim();
            if (startingRange.length() != this.qtdeDigitosTubo) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo da amostra fora do padr\u00e3o %s (%s <> %s)", startingRange, startingRange.length(), this.qtdeDigitosTubo));
                return;
            }
            this.hostFilCodigo = startingRange.substring(0, ParametrosGerais.getDigitosTuboFilial());
            startingRange = startingRange.substring(ParametrosGerais.getDigitosTuboFilial());
            this.hostReqCodigo = startingRange.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.hostRecCodigo = startingRange.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostRack = fields[0] + "^" + fields[1] + "^";
            if (fields.length > 3) {
                this.hostSampleAttribute = fields[3];
            }
            this.hostQuery = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "SysmexXN1000: Host Query Response");
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    private void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String filCodigo = this.hostFilCodigo;
            String reqCodigo = this.hostReqCodigo;
            String recCodigo = this.hostRecCodigo;
            String pacNome = null;
            String pacSexo = null;
            String pacIdade = null;
            String data = null;
            String hora = null;
            String rack = this.hostRack;
            String prioridade = null;
            String intCodigo = null;
            String mcoCodigo = null;
            String pacExames = null;
            String acao = "A";
            Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pacExames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pacExames) && req != null && aba != null) {
                    pacExames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pacExames = pacExames + " ";
                    reqs = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                    for (Object[] r : reqs) {
                        pacExames = pacExames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pacExames = pacExames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (Funcoes.textoVazio(pacExames)) {
                    pacExames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pacExames = pacExames + " ";
                    reqs = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                    for (Object[] r : reqs) {
                        pacExames = pacExames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pacExames = pacExames.trim();
                }
            }
            this.hostQuery = false;
            this.hostFilCodigo = null;
            this.hostReqCodigo = null;
            this.hostRecCodigo = null;
            this.hostRack = null;
            if (req != null) {
                pacNome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pacSexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                intCodigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mcoCodigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.enviarRequisicao(pacNome, pacSexo, pacIdade, data, hora, rack, prioridade, filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo, pacExames, acao);
            } else {
                this.tx_list.add(this.getHeaderRecord());
                this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
                this.tx_list = this.makeFrames(this.tx_list);
                this.tx_list.resetUltimoLido();
                this.setTX(this.TIME_TX);
                this.tx_counter = 0;
                this.getPortaCOM().write(String.valueOf('\u0005'));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "SysmexXN1000: Host Query Response");
        }
    }

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String pacExames, String acao) {
        return this.enviarRequisicao(pacNome, pacSexo, pacIdade, data, hora, rackposition, prioridade, filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo, pacExames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String pacExames, String acao, HashMap<String, String> mapaParametros) {
        try {
            String sampleId;
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = filCodigo;
            this.int_codigo = intCodigo;
            this.req_codigo = reqCodigo;
            this.pac_nome = pacNome;
            this.pac_sexo = pacSexo;
            this.req_idade = pacIdade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mcoCodigo;
            this.rec_codigo = recCodigo;
            this.pac_exames = pacExames;
            this.exames = pacExames.split(" ", 0);
            this.ultima_acao = acao;
            ExameMaterial[] alternativos = null;
            for (int i = 0; i < this.exames.length; ++i) {
                int contador = -1;
                String alternativo = BDUtil.getExmCodigoAlternativo(filCodigo, this.exames[i], mcoCodigo, intCodigo);
                int totalAlternativos = this.map.get(alternativo).length;
                alternativos = new ExameMaterial[totalAlternativos];
                String[] parametros = this.map.get(alternativo);
                if (i == this.exames.length - 1 && parametros == null) {
                    parametros = this.map.get(NOME_EXAME);
                }
                if (parametros == null) continue;
                for (String param : parametros) {
                    alternativos[++contador] = new ExameMaterial(param, null);
                }
                if (alternativo.equalsIgnoreCase(NOME_EXAME)) break;
            }
            if (Funcoes.textoVazio(this.hostSampleAttribute)) {
                this.hostSampleAttribute = "C";
            }
            if (Funcoes.textoVazio(rackposition)) {
                rackposition = "^^";
            }
            filCodigo = Funcoes.preencheZero(filCodigo, ParametrosGerais.getDigitosTuboFilial());
            reqCodigo = Funcoes.preencheZero(reqCodigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(rackposition);
            recCodigo = Funcoes.preencheZero(recCodigo, ParametrosGerais.getDigitosTuboTubo());
            String patientId = sampleId = String.format("%s%s%s", filCodigo, reqCodigo, recCodigo);
            sampleId = Funcoes.preencheVazio(sampleId, 15, 1);
            codigo.append(sampleId).append("^").append(this.hostSampleAttribute);
            String shortName = this.corrigeTamanhoNome(pacNome);
            String nome = this.getNome(shortName.trim(), 1);
            String sobreNome = this.getNome(shortName.trim(), 2);
            this.tx_list.add(this.getHeaderRecord());
            if (this.tx_list.isEmpty()) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            this.tx_list.add(this.getPatientRecord(1, patientId, nome, sobreNome, this.getDataNascimento(filCodigo, reqCodigo), pacSexo));
            this.addCommentRecord();
            if (this.tx_list.isEmpty()) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(this.getDefaultOrderRecord(1, codigo.toString(), alternativos, null, null, "R", Funcoes.formataData("yyyyMMddHHmmss", Calendar.getInstance().getTime()), acao, "Q"));
            if (this.tx_list.isEmpty()) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            if (this.tx_list.isEmpty()) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.hostSampleAttribute = null;
            return "Enviando requisi\u00e7\u00e3o de " + pacNome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private String getDataNascimento(String filCodigo, String reqCodigo) {
        Date dateNascPac = BDUtil.getDataNacimentoPaciente(filCodigo, reqCodigo);
        String dtNascPac = "";
        if (dateNascPac != null) {
            dtNascPac = Funcoes.formataData("yyyyMMdd", dateNascPac);
        }
        return dtNascPac;
    }

    private String corrigeTamanhoNome(String pacNome) {
        String shortName = StringUtil.removerAcentos(pacNome);
        if (shortName.length() > this.MAX_PATIENT_NAME_CHARS) {
            shortName = shortName.substring(0, this.MAX_PATIENT_NAME_CHARS);
        }
        return shortName;
    }

    private String getNome(String shortName, int tipo) {
        String nome = "";
        if (shortName.indexOf(" ") > 0) {
            if (tipo == 1) {
                nome = shortName.substring(0, shortName.indexOf(" ")).trim();
            } else if (tipo == 2) {
                nome = shortName.substring(shortName.indexOf(" ")).trim() + StringUtil.repeteCaractere(' ', 20);
            }
            if (nome.length() > 20) {
                nome = nome.substring(0, 19);
            }
        }
        return nome;
    }

    protected void addCommentRecord() {
        this.tx_list.add(this.getCommentRecord());
    }

    protected String getHeaderRecord() {
        return ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, "", "");
    }

    public String getDefaultOrderRecord(int orderSequence, String sampleId, ExameMaterial[] testItemNumbers, ExameMaterial[] testItemNames, String dilution, String priority, String requestOrder, String actionCode, String reporType) {
        StringBuilder orderRecord = new StringBuilder("O|");
        orderRecord.append(orderSequence);
        orderRecord.append("|");
        orderRecord.append(sampleId == null ? "" : sampleId);
        orderRecord.append("||");
        if (testItemNumbers != null && testItemNumbers[0] != null) {
            orderRecord.append("^^^^");
            orderRecord.append(testItemNumbers[0].getNomeExame());
            orderRecord.append(testItemNames == null || testItemNames[0] == null ? "" : "^" + testItemNames[0].getNomeExame());
            orderRecord.append(dilution == null ? "" : "^" + dilution);
            for (int i = 1; i < testItemNumbers.length; ++i) {
                if (testItemNumbers[i] == null) continue;
                orderRecord.append("\\^^^^");
                orderRecord.append(testItemNumbers[i].getNomeExame());
                orderRecord.append(testItemNames == null || testItemNames[i] == null ? "" : "^" + testItemNames[i].getNomeExame());
                orderRecord.append(dilution == null ? "" : "^" + dilution);
            }
        }
        orderRecord.append("|");
        orderRecord.append(priority == null ? "" : priority);
        orderRecord.append("|");
        orderRecord.append(requestOrder);
        orderRecord.append("|||||");
        orderRecord.append(actionCode == null ? "" : actionCode);
        orderRecord.append("||||||||||||||");
        orderRecord.append(reporType == null ? "" : reporType);
        orderRecord.append("|");
        orderRecord.append('\r');
        return orderRecord.toString();
    }

    protected String getPatientRecord(int patientSequence, String patientId, String pacNome, String pacSobrenome, String pacDataNasc, String pacSexo) {
        StringBuilder patientRecord = new StringBuilder("P|");
        patientRecord.append(patientSequence);
        patientRecord.append("|||");
        patientRecord.append(patientId == null ? "" : patientId);
        patientRecord.append("|^");
        patientRecord.append(pacNome == null ? "" : pacNome);
        patientRecord.append("^").append(pacSobrenome == null ? "^" : pacSobrenome);
        patientRecord.append("||");
        patientRecord.append(pacDataNasc).append("|");
        patientRecord.append(pacSexo == null ? "" : pacSexo);
        patientRecord.append('\r');
        return patientRecord.toString();
    }

    private String getCommentRecord() {
        StringBuilder commentRecord = new StringBuilder("C|1||");
        commentRecord.append('\r');
        return commentRecord.toString();
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            for (int i = 0; i < 12; ++i) {
                this.handShakeCharReceived('\u0006');
            }
        } else if (op == 2) {
            this.resultado();
        }
    }

    private void query() {
        String idAmostra = JOptionPane.showInputDialog("Informe o Id da amostra");
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||XT-1800i^00-23^13302^^^^02305316||||||||E1394-97[CR][ETX]AA[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2Q|1|4^1^" + idAmostra + "^B||||20160503131116[CR][ETX]7B[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3L|1|N[CR][ETX]06[LINE]"));
        this.handShakeCharReceived('\u0004');
    }

    private void resultado() {
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||[SP][SP][SP][SP][SP]XN-10^00-22^41823^^^^AP795756||||||||E1394-97[CR]"));
        this.parse(this.equipamento.arruma("[STX]2P|1||||^^|||U|||||^||||||||||||^^^[CR]"));
        this.parse(this.equipamento.arruma("[STX]3C|1||[CR]"));
        this.parse(this.equipamento.arruma("[STX]4O|1||12^5^[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]010070291101^B|^^^^WBC\\^^^^RBC\\^^^^HGB\\^^^^HCT\\^^^^MCV\\^^^^MCH\\^^^^MCHC\\^^^^PLT\\^^^^RDW-SD\\^^^^RDW-CV\\^^^^PDW\\^^^^MPV\\^^^^P-LCR\\^^^^PCT\\^^^^NEUT#\\^^^^LYMPH#\\^^^^MONO#\\^^^^EO#\\^^^^BASO#\\^^^^NEUT%\\^^^^LYMPH%\\^^^^MONO%\\^^^^EO%\\^^^^BASO%\\^^^^NRBC#\\^^^^NRBC%\\^^^^IG#\\^^^^IG%\\^^^^MICROR\\^^^^MACROR|||||||N||||||||||||||F[CR]"));
        this.parse(this.equipamento.arruma("[STX]6R|1|^^^^WBC^1|3.61|10*3/uL||L||F||||20231121113227[CR]"));
        this.parse(this.equipamento.arruma("[STX]7R|2|^^^^RBC^1|4.32|10*6/uL||H||F||||20231121113227[CR]"));
        this.parse(this.equipamento.arruma("[STX]0R|3|^^^^HGB^1|12.2|g/dL||>||F||||20231121113227[CR]"));
        this.parse(this.equipamento.arruma("[STX]1R|4|^^^^HCT^1|35.8|%||L||F||||20231121113227[CR]"));
        this.parse(this.equipamento.arruma("[STX]2R|5|^^^^MCV^1|82.9|fL||L||F||||20231121113227[CR]"));
        this.parse(this.equipamento.arruma("[STX]3R|6|^^^^MCH^1|28.2|pg||L||F||||20231121113227[CR]"));
        this.parse(this.equipamento.arruma("[STX]4R|7|^^^^MCHC^1|34.1|g/dL||L||F||||20231121113227[CR]"));
        this.parse(this.equipamento.arruma("[STX]5R|8|^^^^PLT^1|223|10*3/uL||L||F||||20231121113227[CR]"));
        this.parse(this.equipamento.arruma("[STX]6R|9|^^^^NEUT%^1|11.9|%||L||F||||20231121113227[CR]"));
        this.parse(this.equipamento.arruma("[STX]6L|1|N[CR]"));
    }
}

