/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sysmexxe2100;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.sysmexxs1000ibi.InterfaceListener {
    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("")) {
                if (message.substring(1, 2).equalsIgnoreCase(TipoMensagem.DADOS_ANALISE.toString())) {
                    this.addListaRecebimento(message);
                    this.restartThreadRecebimento();
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                } else if (message.substring(1, 2).equalsIgnoreCase(TipoMensagem.DADOS_PESQUISA.toString())) {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    this.parseHostQuery(message);
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0015'));
                }
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private String parseHostQuery(String message) {
        String numeroRack = message.substring(20, 24);
        String posicaoTubo = message.substring(24, 26);
        String identificacaoAmostra = message.substring(26, 41).trim();
        String infoIdentificacao = message.substring(41, 42);
        if (Funcoes.textoVazio(identificacaoAmostra) || identificacaoAmostra.length() > ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            return this.enviarRequisicaoNaoExistente(identificacaoAmostra, numeroRack, posicaoTubo);
        }
        String fil_codigo = identificacaoAmostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = identificacaoAmostra.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        String rec_codigo = identificacaoAmostra.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        String acao = "N";
        ArrayList<String> listaExames = null;
        Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
        PanelAbaAbstrata aba = this.equipamento.getTab(0);
        if (req == null) {
            req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
            aba = this.equipamento.getTab(1);
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    listaExames = this.getExamesRequisicoesAba(fil_codigo, req_codigo, rec_codigo, aba);
                }
            } else {
                listaExames = this.getExamesRequisicoesAba(fil_codigo, req_codigo, rec_codigo, aba);
            }
        } else {
            String aux = (String)req[aba.getColIndice("Exame")];
            if (!Funcoes.textoVazio(aux)) {
                listaExames = new ArrayList<String>();
                listaExames.addAll(StringUtil.explode(aux, " "));
            }
        }
        if (req != null && listaExames != null && listaExames.size() > 0) {
            String nomePaciente = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
            String sexoPaciente = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
            String data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
            String hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
            String codigoInterfaceamento = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
            String codigoMaterial = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
            return this.enviarRequisicao(nomePaciente, sexoPaciente, null, data, hora, numeroRack, null, fil_codigo, codigoInterfaceamento, req_codigo, codigoMaterial, rec_codigo, StringUtil.implode(listaExames, " "), acao);
        }
        return this.enviarRequisicaoNaoExistente(identificacaoAmostra, numeroRack, posicaoTubo);
    }

    private ArrayList<String> getExamesRequisicoesAba(String codigoFilial, String codigoRequisicao, String codigoRecipiente, PanelAbaAbstrata componenteAba) {
        List<Object[]> reqs = this.getTodasRequisicaoAba(codigoFilial, codigoRequisicao, codigoRecipiente, componenteAba.getTipoAba());
        ArrayList<String> listaExames = new ArrayList<String>();
        for (Object[] r : reqs) {
            listaExames.add((String)r[componenteAba.getColIndice("Exame")]);
        }
        return listaExames.size() > 0 ? listaExames : null;
    }

    private static enum TipoMensagem {
        DADOS_ANALISE("D"),
        DADOS_PESQUISA("R"),
        DADOS_INFORMACOES_PEDIDO("S");

        String codigo = "";

        private TipoMensagem(String codigo) {
            this.codigo = codigo;
        }

        public String toString() {
            return this.codigo;
        }
    }
}

