/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sysmexca600;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    private String starting_range = null;
    private String ending_range = null;
    private String test_id = null;
    private boolean modoHostQuery = false;

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String result_status = (String)result_fields.get(ASTMStandard.RESULT_FIELD_RESULT_STATUS);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID));
        String emi_alternativo = components.get(this.equip.TEST_ITEM_NUMBER);
        String alternativo = emi_alternativo.substring(0, 2);
        String idResultado = emi_alternativo.substring(2);
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, alternativo);
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, alternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return;
        }
        String exa_codigo = exame.getNomeExame();
        String mco_codigo = exame.getCodigoMaterial();
        this.exame_atual.put(EXA_CODIGO, exa_codigo);
        this.exame_atual.put(MCO_CODIGO, mco_codigo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        String resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        if (!Funcoes.textoVazio(resultado)) {
            resultado = resultado.trim();
        }
        if (!Funcoes.textoVazio(resultado)) {
            resultado = resultado.replaceAll("\\.", ",");
        }
        if (!Funcoes.textoVazio(resultado) && resultado.startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (!Funcoes.textoVazio(resultado) && resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        Statement st = Conexao.getStatement();
        int sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
        String campo = "";
        if (idResultado.equals("1")) {
            campo = "time";
        } else if (idResultado.equals("2")) {
            campo = "acl_activity";
        } else if (idResultado.equals("4")) {
            campo = "inr";
        } else if (idResultado.equals("5")) {
            campo = "dFbg";
        }
        this.exame_atual.put(campo, resultado);
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !flags.equals("")) {
            this.exame_atual.put("flag_alerta", flags);
        }
        if (this.exame_atual != null) {
            try {
                this.salvaExame(this.exame_atual);
            }
            catch (Exception e) {
                this.equip.fireExcecaoEncontrada(String.format("Erro ao salvar exame %s|%s erro: %s", exa_codigo, mco_codigo, e.getMessage()));
            }
        }
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = sys_sample_id.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        if (!Funcoes.textoVazio(req_codigo)) {
            req_codigo = req_codigo.trim();
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Statement st = Conexao.getStatement();
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.get(FIL_CODIGO);
        String req_codigo = (String)dados.get(REQ_CODIGO);
        String rec_codigo = (String)dados.get(REC_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados);
    }

    @Override
    protected void trataRequestRecord(String record) throws Exception {
        Hashtable comps = ASTMStandard.parseDefaultRequestRecord(record);
        this.starting_range = (String)comps.get(ASTMStandard.REQUEST_FIELD_STARTING_RANGE_ID);
        this.ending_range = (String)comps.get(ASTMStandard.REQUEST_FIELD_ENDING_RANGE_ID);
        this.test_id = (String)comps.get(ASTMStandard.REQUEST_FIELD_TEST_ID);
        this.modoHostQuery = true;
    }

    @Override
    protected void trataTerminationRecord() throws Exception {
        if (this.modoHostQuery) {
            this.equip.responderRequest(this.starting_range, this.ending_range, this.test_id);
            this.modoHostQuery = false;
            return;
        }
        if (this.exame_atual == null) {
            return;
        }
        this.exame_atual = null;
    }
}

