/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sysmexca600;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.sysmexca600.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected String rack = "";
    protected String rackPos = "";
    protected String idTestAtribute = "";
    protected boolean hostQuery = false;
    protected boolean hostQueryVazio = false;
    boolean exr_codigoapoiado = false;
    public static final String ACAO_CANCELAR = "C";

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
    }

    @Override
    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            if (Funcoes.textoVazio(starting_range)) {
                return;
            }
            String[] infAgrupada = starting_range.split("\\^");
            if (infAgrupada.length < 4) {
                return;
            }
            this.rack = infAgrupada[0].trim();
            this.rackPos = infAgrupada[1].trim();
            this.idTestAtribute = infAgrupada[3].trim();
            String idTest = infAgrupada[2].trim();
            this.host_fil_codigo = idTest.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = idTest.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            this.host_rec_codigo = idTest.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
            this.hostQueryVazio = false;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "CA-600: Host Query Response");
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            int processo;
            Integer[] multiguias;
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.tx_list = new MemoryList();
            }
            this.tx_list.clear();
            if (this.rx_list != null) {
                this.rx_list.clear();
            }
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.trim().split(" ", 0);
            this.ultima_acao = acao;
            ExameMaterial[] exa_lista = null;
            ExameMaterial[] alternativos = null;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            for (Integer multiguia : multiguias = this.verificaAgrupaMultiguias(fil_codigo, req_codigo)) {
                if (this.exames == null || (exa_lista = InterfaceListener.getDesmExamesPai(fil_codigo, int_codigo, multiguia.toString(), this.exames[0], mco_codigo)).length > 0) continue;
                exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            }
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            this.rec_tuboPai = rec_codigo;
            String tipo_amostra = null;
            if (this.existeExames()) {
                exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
                tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
                ArrayList<ExameMaterial> temporario = new ArrayList<ExameMaterial>();
                for (ExameMaterial e : alternativos) {
                    if (temporario.contains(e)) continue;
                    temporario.add(e);
                }
                alternativos = new ExameMaterial[temporario.size()];
                for (int i = 0; i < temporario.size(); ++i) {
                    ExameMaterial em = (ExameMaterial)temporario.get(i);
                    em.setString(em.getString() + "0");
                    alternativos[i] = em;
                }
            }
            String nome = short_name;
            this.tx_list.add(this.getDefaultHeaderRecord(this.DELIMITERS, this.HOST_NAME));
            String t = this.getDefaultPatientRecord();
            this.tx_list.add(t);
            if (!Funcoes.textoVazio(rackposition) && !rackposition.startsWith("\\^")) {
                rackposition = "^" + rackposition;
            }
            String situacaoProcesso = this.isRepeticao(processo = this.getSitucaoProcesso(fil_codigo, int_codigo, req_codigo, rec_codigo, exa_lista, st)) ? "S" : "R";
            int seq = 1;
            if (this.validaListaExames(alternativos)) {
                t = this.getDefaultOrderRecord(seq++, codigo.toString(), alternativos, situacaoProcesso);
                this.tx_list.add(t);
            }
            t = "L|1|N\r";
            this.tx_list.add(t);
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            if (this.validaListaExames(exa_lista)) {
                for (ExameMaterial e : exa_lista) {
                    int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, e.getNomeExame(), e.getCodigoMaterial(), int_codigo, rackposition, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                this.fireMensagemEnviada("Exame(s) " + (acao.equals(ACAO_CANCELAR) ? "excluido(s)" : "enviado(s)") + " com sucesso para " + pac_nome, 0, 10000);
            }
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private String getDefaultHeaderRecord(String delimiters, String sender_id_name) {
        StringBuilder record = new StringBuilder("H|");
        record.append(delimiters == null ? "" : delimiters);
        record.append("|||");
        record.append(sender_id_name == null ? "" : sender_id_name);
        record.append("^^^^");
        record.append("|||||CA-600");
        record.append('\r');
        return record.toString();
    }

    private String getDefaultPatientRecord() {
        StringBuilder record = new StringBuilder("P|");
        record.append(1);
        record.append('\r');
        return record.toString();
    }

    private String getDefaultOrderRecord(int order_sequence, String sample_id, ExameMaterial[] test_item_numbers, String priority) {
        String codReq;
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        String specimenID = this.rack + "^" + this.rackPos + "^";
        String string = codReq = sample_id == null ? "" : sample_id;
        if (codReq.length() < 15) {
            while (codReq.length() < 15) {
                codReq = " " + codReq;
            }
        }
        specimenID = specimenID + codReq;
        specimenID = specimenID + "^" + this.idTestAtribute;
        record.append(specimenID);
        record.append("||");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            record.append("^^^");
            record.append(test_item_numbers[0].getNomeExame());
            record.append("^^100");
            for (int i = 1; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null) continue;
                record.append("\\^^^");
                record.append(test_item_numbers[i].getNomeExame());
                record.append("^^100");
            }
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("|");
        record.append(ASTMStandard.getCurrentMoment());
        record.append("|||||N");
        record.append('\r');
        return record.toString();
    }

    private boolean validaListaExames(ExameMaterial[] exa_lista) {
        return exa_lista != null;
    }

    private boolean existeExames() {
        return this.exames != null && this.exames.length > 0;
    }

    private boolean isRepeticao(int processo) {
        return processo == 3;
    }

    private int getSitucaoProcesso(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo, ExameMaterial[] exa_lista, Statement st) throws SQLException {
        int situacaoRotina = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), rec_codigo);
        int processo = situacaoRotina < 2 ? 1 : 3;
        return processo;
    }

    public static synchronized ExameMaterial[] getDesmExamesPai(String fil_codigo, String int_codigo, String req_codigo, String exa_kodigo, String mco_kodigo) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("select exa_codigo, mco_codigo from ");
        query.append("interfaceexamerequisicaodesm where fil_codigo = ");
        query.append(fil_codigo);
        query.append(" and int_codigo = ").append(int_codigo);
        query.append(" and req_codigo = ").append(req_codigo);
        query.append(" and exa_kodigo = ").append(DBUtil.bdText(exa_kodigo));
        query.append(" and mco_codigo = ").append(mco_kodigo);
        query.append(" order by exa_codigo desc");
        PreparedStatement ps = Conexao.getPreparedStatement(query.toString());
        ResultSet rs = ps.executeQuery();
        int i = DBUtil.qtdeRegistros(rs);
        ExameMaterial[] pais = new ExameMaterial[i];
        while (rs != null && rs.next()) {
            pais[--i] = new ExameMaterial(rs.getString("exa_codigo"), rs.getInt("mco_codigo"));
        }
        ps.close();
        return pais;
    }

    private Integer[] verificaAgrupaMultiguias(String fil_codigo, String req_codigo) throws SQLException {
        Integer[] multiguias = null;
        multiguias = RecepcaoUtil.verificaMultiGuias(fil_codigo, req_codigo, true);
        boolean agruparMultiguias = this.isAgruparMultiguias(fil_codigo, multiguias);
        if (!agruparMultiguias) {
            multiguias = new Integer[]{Integer.parseInt(req_codigo)};
        }
        return multiguias;
    }

    private boolean isAgruparMultiguias(String fil_codigo, Integer[] multiguias) throws SQLException {
        return ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), fil_codigo, multiguias);
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String rack = this.rack;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = "";
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req != null) {
                if (this.exr_codigoapoiado) {
                    if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                        if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
                            if (ParametrosGerais.isAgruparGuiasInterface()) {
                                requisicao = (String)req[aba.getColIndice("Multiguia")];
                            }
                            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
                            String tubo = (String)req[aba.getColIndice("Tubo")];
                            tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
                            fil_codigo = filial;
                            req_codigo = requisicao;
                            rec_codigo = tubo;
                        }
                    }
                }
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
            } else {
                this.hostQueryVazio = true;
                this.enviarRequisicaoSemExame(fil_codigo, req_codigo);
                return;
            }
            mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
            this.hostQuery = false;
            this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            this.rack = "";
            this.rackPos = "";
            this.idTestAtribute = "";
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "CA-600: Host Query Response");
        }
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String nome = BDUtil.getNomePaciente(fil_codigo, req_codigo);
            this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, req_codigo, null, nome, null, this.pac_sexo));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT"}, null);
        switch (op) {
            case 0: {
                this.query();
                break;
            }
            case 1: {
                this.confirmacaoACK();
                break;
            }
            case 2: {
                this.resultado();
                break;
            }
            case 3: {
                this.finalizaTransmissao();
            }
        }
    }

    private void query() {
        String idAmostra = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "");
        if (Funcoes.textoVazio(idAmostra)) {
            return;
        }
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||CA-600^[SP]00-28||||||||1[CR][ETX]26[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2Q|1|000004^01^[SP][SP][SP][SP][SP]" + idAmostra + "^B||^^^040^TP[SP][SP][SP][SP][SP][SP]\\^^^050^TTPA[SP][SP][SP][SP]\\^^^060^Fbg[SP][SP][SP][SP][SP]\\^^^610^DDi[SP][SP][SP][SP][SP]|O|20230106051700[CR][ETX]EC[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3L|1|N[CR][ETX]06[LINE]"));
        this.handShakeCharReceived('\u0004');
        for (int i = 0; i < 10; ++i) {
            this.handShakeCharReceived('\u0006');
        }
    }

    private void resultado() {
        String idAmostra = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "");
        if (Funcoes.textoVazio(idAmostra)) {
            return;
        }
        if (idAmostra.length() < 15) {
            idAmostra = "[SP]" + idAmostra;
        }
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||CA-600^ 00-22||||||||1[CR][ETX]C5[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2P|1[CR][ETX]0B[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3O|1||000001^01^" + idAmostra + "^B^||R||||||N[CR][ETX]37[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|1|^^^041^PT[SP]T[SP][SP][SP][SP]^100^1|[SP]10.2|sec[SP][SP]||N||||||20100328135000"));
        this.parse(this.equipamento.arruma("[STX]5R|2|^^^042^PT%[SP][SP][SP][SP][SP]^100^1|[SP]99.4|%[SP][SP][SP][SP]||N||||||20100328135000"));
        this.parse(this.equipamento.arruma("[STX]6R|3|^^^044^PT[SP]INR[SP][SP]^100^1|[SP]0.81|-[SP][SP][SP][SP]||N||||||20100328135000[CR][ETX]37[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7R|4|^^^051^FSL[SP][SP][SP][SP][SP]^100^1|[SP]27.4|sec[SP][SP]||N||||||20100328135000[CR][ETX]37[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0R|5|^^^061^Fbg[SP][SP][SP][SP][SP]^100^5|[SP][SP]8.5|sec[SP][SP]||N||||||20100328135000[CR][ETX]37[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1R|6|^^^062^Fbg[SP]C.[SP][SP]^100^5|[SP][SP]301|mg/dL||N||||||20100328135000[CR][ETX]37[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2L|1|N[CR][ETX]37[LINE]"));
        this.finalizaTransmissao();
    }

    private void finalizaTransmissao() {
        this.handShakeCharReceived('\u0004');
    }

    private void confirmacaoACK() {
        this.handShakeCharReceived('\u0006');
    }
}

