/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sysmexca500;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.sysmexca500.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final int MAX_TENTATIVAS = 2;
    private static final int TIMEOUT = 15000;
    private static final int MAX_PATIENT_NAME_CHARS = 11;
    protected static HashMap<String, String> deparaParametrosAnalise = null;
    private static final int QTDE_MAX_PARAMETROS_BLOCO = 22;
    private static final String PARAMETRO_INFO_IDENTIFICACAO = "infoIdentificacao";
    private static final String PARAMETRO_NUMERO_SUPORTE = "numeroSuporte";
    private static final String PARAMETRO_POSICAO_TUBO = "posicaoTubo";
    private ThreadRecebimento threadRecebimento = null;
    private List<String> framesEnvio = new ArrayList<String>();
    private int txCounter = 0;
    private LinkedList<InfoExameRequisicao> listaDadosExameRequisicao = null;
    private InterfaceConfiguracao configuracaoInterface = null;

    public InterfaceListener() {
        this.threadRecebimento = new ThreadRecebimento(this);
        this.threadRecebimento.start();
        this.listaDadosExameRequisicao = new LinkedList();
        this.configuracaoInterface = new InterfaceConfiguracao();
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracaoInterface.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.montaDeparaParametrosAnalise();
    }

    private void montaDeparaParametrosAnalise() {
        deparaParametrosAnalise = new HashMap();
        deparaParametrosAnalise.put("1", "time");
        deparaParametrosAnalise.put("2", "ativiade_concentracao");
        deparaParametrosAnalise.put("3", "ratio");
        deparaParametrosAnalise.put("4", "inr");
        deparaParametrosAnalise.put("5", "dFbg");
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        this.fireMensagemEnviada("Tempo esgotado ao tentar transmitir dados ao aparelho.", 1, 5000);
        this.setIdle();
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("")) {
                if (message.substring(1, 2).equalsIgnoreCase(TipoMensagem.DADOS_ANALISE.toString())) {
                    this.addListaRecebimento(message);
                    this.restartThreadRecebimento();
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                } else if (message.substring(1, 2).equalsIgnoreCase(TipoMensagem.DADOS_PESQUISA.toString())) {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    this.parseHostQuery(message);
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0015'));
                }
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                }
            });
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private String parseHostQuery(String message) {
        String numeroRack = message.substring(20, 24);
        String posicaoTubo = message.substring(24, 26);
        String identificacaoAmostra = message.substring(26, 41).trim();
        String infoIdentificacao = message.substring(41, 42);
        if (Funcoes.textoVazio(identificacaoAmostra) || identificacaoAmostra.length() > ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            return this.enviarRequisicaoNaoExistente(identificacaoAmostra, numeroRack, posicaoTubo, InfoIdentificacao.getInfoIdentificacao(infoIdentificacao));
        }
        String fil_codigo = "";
        String req_codigo = "";
        String rec_codigo = "";
        DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(identificacaoAmostra);
        if (dce == null) {
            return this.enviarRequisicaoNaoExistente(identificacaoAmostra, numeroRack, posicaoTubo, InfoIdentificacao.getInfoIdentificacao(infoIdentificacao));
        }
        fil_codigo = Funcoes.preencheZero(dce.getFilial(), ParametrosGerais.getDigitosTuboFilial());
        req_codigo = Funcoes.preencheZero(dce.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
        rec_codigo = Funcoes.preencheZero(dce.getTubo(), ParametrosGerais.getDigitosTuboTubo());
        String acao = "N";
        ArrayList<String> listaExames = null;
        Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
        PanelAbaAbstrata aba = this.equipamento.getTab(0);
        if (req == null) {
            req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
            aba = this.equipamento.getTab(1);
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    listaExames = this.getExamesRequisicoesAba(fil_codigo, req_codigo, rec_codigo, aba);
                }
            } else {
                listaExames = this.getExamesRequisicoesAba(fil_codigo, req_codigo, rec_codigo, aba);
            }
        } else {
            String aux = (String)req[aba.getColIndice("Exame")];
            if (!Funcoes.textoVazio(aux)) {
                listaExames = new ArrayList<String>();
                listaExames.addAll(StringUtil.explode(aux, " "));
            }
        }
        if (req != null && listaExames != null && listaExames.size() > 0) {
            String nomePaciente = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
            String sexoPaciente = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
            String data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
            String hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
            String codigoInterfaceamento = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
            String codigoMaterial = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
            HashMap<String, String> parametros = new HashMap<String, String>();
            parametros.put(PARAMETRO_INFO_IDENTIFICACAO, infoIdentificacao);
            parametros.put(PARAMETRO_NUMERO_SUPORTE, numeroRack);
            parametros.put(PARAMETRO_POSICAO_TUBO, posicaoTubo);
            return this.enviarRequisicao(nomePaciente, sexoPaciente, null, data, hora, numeroRack, null, fil_codigo, codigoInterfaceamento, req_codigo, codigoMaterial, rec_codigo, StringUtil.implode(listaExames, " "), acao, parametros);
        }
        return this.enviarRequisicaoNaoExistente(identificacaoAmostra, numeroRack, posicaoTubo, InfoIdentificacao.getInfoIdentificacao(infoIdentificacao));
    }

    private ArrayList<String> getExamesRequisicoesAba(String codigoFilial, String codigoRequisicao, String codigoRecipiente, PanelAbaAbstrata componenteAba) {
        List<Object[]> reqs = this.getTodasRequisicaoAba(codigoFilial, codigoRequisicao, codigoRecipiente, componenteAba.getTipoAba());
        ArrayList<String> listaExames = new ArrayList<String>();
        for (Object[] r : reqs) {
            listaExames.add((String)r[componenteAba.getColIndice("Exame")]);
        }
        return !listaExames.isEmpty() ? listaExames : null;
    }

    public String enviarRequisicaoNaoExistente(String identificacaoAmostra, String numeroRack, String posicaoTubo, InfoIdentificacao infoIdentificacao) {
        try {
            String data = Funcoes.formataData("yyMMdd", new Date());
            String hora = Funcoes.formataData("HHmm", new Date());
            LinkedList<String> worklist = this.montaMensagemWorklist(data, hora, identificacaoAmostra, StringUtil.repeteCaractere(' ', 11), numeroRack, posicaoTubo, infoIdentificacao, new ExameMaterial[]{new ExameMaterial(this.configuracaoInterface.getParametroAnalise(), null)});
            this.framesEnvio.clear();
            this.framesEnvio.addAll(worklist);
            this.setTX(15000);
            this.txCounter = 0;
            this.getPortaCOM().write(this.framesEnvio.get(0));
            this.fireExcecaoEncontrada(String.format("A solicita\u00e7\u00e3o da amostra n\u00e3o foi encontrada para o interfaceamento: AMOSTRA \"%s\".", identificacaoAmostra));
            return "Enviando requisi\u00e7\u00e3o da amostra \"" + identificacaoAmostra + "\".";
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    protected void aguardarProximoFrame() throws Exception {
        this.setRX(15000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                default: {
                    this.caracterNaoEsperado(c);
                    break;
                }
            }
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                }
            });
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
            this.setIdle();
        }
    }

    @Override
    public void teste() {
        String msg = "[STX]R2210101U3011231438000301[SP][SP][SP][SP][SP]900050115901B[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]040[SP][SP][SP][SP][SP][SP]050[SP][SP][SP][SP][SP][SP]090[SP][SP][SP][SP][SP][SP]610[SP][SP][SP][SP][SP][SP]700[SP][SP][SP][SP][SP][SP][ETX]";
        this.parseHostQuery(this.equipamento.arruma(msg));
    }

    private void tratarNegativeAck() throws Exception {
        if (this.isTX()) {
            this.retransmitirRecusado();
        }
    }

    private void retransmitirRecusado() throws Exception {
        if (this.txCounter >= 2) {
            this.encerrarTransmissao();
            return;
        }
        this.setTX(15000);
        this.getPortaCOM().write(this.framesEnvio.get(0));
        ++this.txCounter;
    }

    private void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            this.framesEnvio.remove(0);
            if (!this.framesEnvio.isEmpty()) {
                this.getPortaCOM().write(this.framesEnvio.get(0));
            } else {
                this.encerrarTransmissao();
            }
        }
    }

    public void caracterNaoEsperado(char c) throws Exception {
        this.fireExcecaoEncontrada("O caractere n\u00e3o esperado \"" + c + "\" foi recebido do equipamento.");
    }

    private void encerrarTransmissao() throws Exception {
        if (this.txCounter < 2 && !this.listaDadosExameRequisicao.isEmpty()) {
            Statement st = Conexao.getStatement();
            InfoExameRequisicao dadosExameRequisicao = this.listaDadosExameRequisicao.removeFirst();
            String acaoEnvioAparelho = dadosExameRequisicao.getAcao();
            if (Funcoes.textoVazio(acaoEnvioAparelho)) {
                this.fireExcecaoEncontrada(String.format("Erro ao tentar mudar a situa\u00e7\u00e3o do exame fil_codigo = %s, req_codigo = %s, rec_codigo = %s, mco_codigo = %s, int_codigo = %s", dadosExameRequisicao.getFilial(), dadosExameRequisicao.getCodigo(), dadosExameRequisicao.getRecipiente(), dadosExameRequisicao.getMaterial(), dadosExameRequisicao.getInterface()));
            } else {
                this.atualizarSituacaoTubo(st, dadosExameRequisicao.getFilial(), dadosExameRequisicao.getCodigo(), dadosExameRequisicao.getRecipiente(), dadosExameRequisicao.getMaterial(), dadosExameRequisicao.getInterface(), acaoEnvioAparelho.equals("N") ? 1 : 3);
                Conexao.arquivaSQL();
                this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + dadosExameRequisicao.getNome() + ".", 0, 10000);
                if (Funcoes.textoVazio(acaoEnvioAparelho) || acaoEnvioAparelho.equals("N")) {
                    this.firePacienteEnviado(dadosExameRequisicao.getCodigo(), dadosExameRequisicao.getNome(), dadosExameRequisicao.getSexo(), dadosExameRequisicao.getIdade(), dadosExameRequisicao.getData(), dadosExameRequisicao.getHora(), dadosExameRequisicao.getExames());
                }
            }
        } else if (this.listaDadosExameRequisicao.isEmpty()) {
            this.fireExcecaoEncontrada("N\u00e3o h\u00e1 dados na lista dos examerequisicao.");
        } else {
            this.listaDadosExameRequisicao.removeFirst();
        }
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String message) {
        try {
            message = message.replaceAll(this.getMsgStart(), "");
            message = message.replaceAll(this.getMsgEnd(), "");
            String id = message.substring(25, 40).trim();
            Statement st = Conexao.getStatement();
            if (id.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: \"" + id + "\".");
                return null;
            }
            if (!Funcoes.isNumeric(id)) {
                this.fireExcecaoEncontrada("Resultados recebidos para uma requisi\u00e7\u00e3o sem id v\u00e1lido: \"" + id + "\".");
                return null;
            }
            String fil_codigo = "";
            String req_codigo = "";
            String rec_codigo = "";
            DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(id);
            if (dce == null) {
                this.fireExcecaoEncontrada("Amostra n\u00e3o identificada. Id: \"" + id + "\".");
                return null;
            }
            fil_codigo = Funcoes.preencheZero(dce.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(dce.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
            rec_codigo = Funcoes.preencheZero(dce.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            String exames = message.substring(52);
            MapaResultados mapaResultados = new MapaResultados();
            if (exames.length() % 9 != 0) {
                this.fireExcecaoEncontrada("O resultado da filial \"" + fil_codigo + "\", requisi\u00e7\u00e3o \"" + req_codigo + "\" recebido do aparelho \u00e9 inv\u00e1lido. Tente retransmitir o resultado.");
                return null;
            }
            while (!Funcoes.textoVazio(exames)) {
                String resultadoAux = exames.substring(0, 9);
                String parametro = resultadoAux.substring(0, 3);
                String dados = resultadoAux.substring(3, 8);
                String indicador = resultadoAux.substring(8, 9);
                HashMap<String, DadosResultado> listaResultados = new HashMap<String, DadosResultado>();
                listaResultados.put(parametro, new DadosResultado(parametro, dados, indicador));
                mapaResultados.put(parametro, listaResultados);
                exames = exames.substring(9);
            }
            if (mapaResultados != null && !mapaResultados.isEmpty()) {
                for (String parametroPai : mapaResultados.keySet()) {
                    String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, parametroPai);
                    if (int_codigo == null) {
                        this.fireExcecaoEncontrada("Interface n\u00e3o localizada. Filial = \"" + fil_codigo + "\", requisi\u00e7\u00e3o = \"" + req_codigo + "\", recipiente = \"" + rec_codigo + "\".");
                        continue;
                    }
                    ExameMaterial exameMaterial = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, parametroPai);
                    if (exameMaterial == null) {
                        this.fireExcecaoEncontrada("Exame n\u00e3o localizado na interface ou amostra n\u00e3o interfaceada. Filial = \"" + fil_codigo + "\", requisi\u00e7\u00e3o = \"" + req_codigo + "\", recipiente = \"" + rec_codigo + "\".");
                        continue;
                    }
                    int sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), rec_codigo);
                    HashMap<String, Object> coagulacao = new HashMap<String, Object>();
                    HashMap mapaFilhos = (HashMap)mapaResultados.get(parametroPai);
                    ArrayList<String> indicadores = new ArrayList<String>();
                    for (String parametroFilho : mapaFilhos.keySet()) {
                        if (!deparaParametrosAnalise.containsKey(((DadosResultado)mapaFilhos.get(parametroFilho)).getParametroX())) continue;
                        DadosResultado dadosResultado = (DadosResultado)mapaFilhos.get(parametroFilho);
                        if (sit == 3) {
                            coagulacao.put(deparaParametrosAnalise.get(parametroFilho.substring(2)) + "_" + "repeticao", dadosResultado.dados);
                        } else {
                            coagulacao.put(deparaParametrosAnalise.get(parametroFilho.substring(2)), dadosResultado.dados);
                        }
                        if (Funcoes.textoVazio(dadosResultado.indicador)) continue;
                        indicadores.add(parametroFilho + " " + dadosResultado.indicador);
                    }
                    this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), int_codigo, coagulacao, indicadores);
                }
            } else {
                this.fireExcecaoEncontrada("Nenhum resultado retornado pelo aparelho. Filial = \"" + fil_codigo + "\", requisi\u00e7\u00e3o = \"" + req_codigo + "\".");
                return null;
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(2);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
                return "Erro ao inserir resultados recebidos ao banco de dados.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                return "Erro ao inserir resultados recebidos ao banco de dados.";
            }
        }
        return "";
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        if (acao.equals("A")) {
            Statement st = Conexao.getStatement();
            try {
                this.atualizarSituacaoTubo(st, fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, 3);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, "Erro ao mudar situacao do exame para repetir.\n" + e.getMessage(), e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao mudar situacao do exame para repetir.";
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    return "Erro ao mudar situacao do exame para repetir.";
                }
            }
        }
        return "";
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> parametros) {
        InfoExameRequisicao dadosExameRequisicao = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames);
        dadosExameRequisicao.setInterface(int_codigo);
        dadosExameRequisicao.setAcao(acao);
        StringBuilder codigo = new StringBuilder();
        try {
            String filialDigitos = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            String requisicaoDigitos = StringUtil.preencheString(req_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            String recipienteDigitos = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(filialDigitos).append(requisicaoDigitos).append(recipienteDigitos);
            String nomePaciente = StringUtil.tratarUnicode(StringUtil.removerAcentos(pac_nome));
            nomePaciente = StringUtil.limpaString(pac_nome, new String[]{"'", "`", "\"", "~", "!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "[", "{", "}", "]", "|", "\\", ";", ":", ",", "<", ".", ">", "?", "/"});
            if (nomePaciente.length() > 11) {
                nomePaciente = nomePaciente.substring(0, 11);
            }
            if (pac_nome.length() < 11) {
                nomePaciente = Funcoes.preencheVazio(pac_nome, 11, 2);
            }
            data = !Funcoes.textoVazio(data) ? Funcoes.formataData("yyMMdd", Funcoes.stringToDate("dd/MM/yyyy", data)) : Funcoes.formataData("yyMMdd", new Date());
            hora = !Funcoes.textoVazio(hora) ? hora.replaceAll(":", "") : Funcoes.formataData("HHmm", new Date());
            Statement st = Conexao.getStatement();
            ExameMaterial[] exames = ExamesUtil.anexarCodigoMaterial(pac_exames.split(" "), mco_codigo);
            exames = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exames);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exames);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            String pac_codigo = BDUtil.getCodigoPaciente(fil_codigo, req_codigo);
            pac_codigo = fil_codigo + StringUtil.preencheString(pac_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            if (Funcoes.textoVazio(pac_sexo)) {
                pac_sexo = "F";
                dadosExameRequisicao.setSexo(pac_sexo);
                this.fireExcecaoEncontrada(String.format("Sexo do paciente %s obrigat\u00f3rio verifique: %s %s %s", pac_nome, fil_codigo, req_codigo, rec_codigo));
            }
            LinkedList<String> worklist = this.montaMensagemWorklist(data, hora, codigo.toString(), nomePaciente, parametros.get(PARAMETRO_NUMERO_SUPORTE), parametros.get(PARAMETRO_POSICAO_TUBO), InfoIdentificacao.getInfoIdentificacao(parametros.get(PARAMETRO_INFO_IDENTIFICACAO)), alternativos);
            this.framesEnvio.clear();
            this.framesEnvio.addAll(worklist);
            this.listaDadosExameRequisicao.add(dadosExameRequisicao);
            this.setTX(15000);
            this.txCounter = 0;
            this.getPortaCOM().write(this.framesEnvio.get(0));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            this.fireExcecaoEncontrada("Erro ao tentar enviar paciente. C\u00f3digo da amostra = \"" + codigo + "\". " + e.getMessage());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private LinkedList<String> montaMensagemWorklist(String data, String hora, String codigoIdentificacao, String nomePaciente, String numeroSuporte, String posicaoTubo, InfoIdentificacao infoIdentificacao, ExameMaterial[] parametrosAnalise) {
        LinkedList<String> listaMensagens = new LinkedList<String>();
        int blocoAtual = 1;
        for (int j = 0; j < parametrosAnalise.length / 22 + 1; ++j) {
            StringBuilder worklist = new StringBuilder();
            worklist.append(this.montaCabecalhoBloco(data, hora, codigoIdentificacao, nomePaciente, numeroSuporte, posicaoTubo, infoIdentificacao, blocoAtual, parametrosAnalise.length / 22 + 1));
            for (int i = 0; i < 22 && (blocoAtual - 1) * 22 + i < parametrosAnalise.length; ++i) {
                ExameMaterial parametro = parametrosAnalise[(blocoAtual - 1) * 22 + i];
                worklist.append(parametro.getNomeExame() + StringUtil.repeteCaractere(' ', 6));
            }
            worklist.append(this.getMsgEnd());
            listaMensagens.add(worklist.toString());
            ++blocoAtual;
        }
        return listaMensagens;
    }

    private String montaCabecalhoBloco(String data, String hora, String codigoIdentificacao, String nomePaciente, String numeroSuporte, String posicaoTubo, InfoIdentificacao infoIdentificacao, int bloco, int qtdeBlocos) {
        StringBuilder worklist = new StringBuilder();
        worklist.append(this.getMsgStart());
        worklist.append("S");
        worklist.append("2");
        worklist.append("21");
        worklist.append(Funcoes.preencheZero(bloco, 2));
        worklist.append(Funcoes.preencheZero(qtdeBlocos, 2));
        worklist.append("U");
        worklist.append(data);
        worklist.append(hora);
        worklist.append(numeroSuporte);
        worklist.append(posicaoTubo);
        worklist.append(StringUtil.preencheString(codigoIdentificacao, 15, ' ', 1));
        worklist.append((Object)infoIdentificacao);
        worklist.append(nomePaciente);
        return worklist.toString();
    }

    class DadosResultado {
        String parametro = null;
        String parametroX = null;
        String dados = null;
        String indicador = null;

        public DadosResultado(String parametro, String dados, String indicador) {
            this.parametro = parametro;
            this.parametroX = parametro.substring(2);
            this.dados = dados;
            this.indicador = indicador;
            this.trataValorResultado();
        }

        private void trataValorResultado() {
            if (Funcoes.textoVazio(this.dados)) {
                return;
            }
            this.dados = this.dados.trim();
        }

        public String getParametro() {
            return this.parametro;
        }

        public String getDados() {
            return this.dados;
        }

        public String getIndicador() {
            return this.indicador;
        }

        public String getParametroX() {
            return this.parametroX;
        }
    }

    class MapaResultados
    extends HashMap<String, HashMap<String, DadosResultado>> {
        MapaResultados() {
        }

        @Override
        public HashMap<String, DadosResultado> put(String parametro, HashMap<String, DadosResultado> listaResultados) {
            if (this.containsKey(parametro = parametro.substring(0, 2) + "0")) {
                HashMap listaAux = (HashMap)this.get(parametro);
                listaAux.putAll(listaResultados);
                return listaAux;
            }
            return super.put(parametro, listaResultados);
        }
    }

    private static enum InfoIdentificacao {
        MANUAL("M"),
        SEQUENCIAL("A"),
        LEITOR("B"),
        DEFINIDO_HOST("C"),
        PESQUISADO_HOST(" ");

        String codigo = "";

        private InfoIdentificacao(String codigo) {
            this.codigo = codigo;
        }

        public String toString() {
            return this.codigo;
        }

        public static InfoIdentificacao getInfoIdentificacao(String codigo) {
            for (InfoIdentificacao aux : InfoIdentificacao.values()) {
                if (!aux.codigo.equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }
    }

    private static enum TipoMensagem {
        DADOS_ANALISE("D"),
        DADOS_PESQUISA("R"),
        DADOS_INFORMACOES_PEDIDO("S");

        String codigo = "";

        private TipoMensagem(String codigo) {
            this.codigo = codigo;
        }

        public String toString() {
            return this.codigo;
        }
    }
}

