/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sysmex_uf1000i;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServer;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.sysmex_uf1000i.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.sysmex_uf1000i.messages.AnalysisInformationFormat2;
import jalis.laboratorio.interfaceamento.interfaces.sysmex_uf1000i.messages.CommentBlock1;
import jalis.laboratorio.interfaceamento.interfaces.sysmex_uf1000i.messages.CommentBlock2;
import jalis.laboratorio.interfaceamento.interfaces.sysmex_uf1000i.messages.ParticleNumberBlock;
import jalis.laboratorio.interfaceamento.interfaces.sysmex_uf1000i.messages.Resultado;
import jalis.laboratorio.interfaceamento.interfaces.sysmex_uf1000i.messages.SampleInformationBlock;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final String FLAG_UTI = "0C02";
    private static final String FLAG_COND = "0C01";
    private static final String FLAG_RBC = "0C00";
    private final int TIME_OUT = 15000;
    private final int RETRY = 3;
    private int txCounter = 0;
    private final String INQUIRY_MODE = "inquiryMode";
    private final String INFORMATION_STATUS = "informationStatus";
    private final String TUBE_POSITION = "tubePosition";
    private final String GET_FLAG = "getFlag";
    private final String NOME_EXAME = "URI";
    private Map<TipoMensagem, String> messagesResultado = new HashMap<TipoMensagem, String>();
    private Map<String, String> source = new HashMap<String, String>();
    private Map<String, String> color = new HashMap<String, String>();
    private Map<String, String> clarity = new HashMap<String, String>();
    private Map<String, String> flags = new HashMap<String, String>();
    private Map<String, String> flagsRbc = new HashMap<String, String>();
    private Map<String, String> flagsCond = new HashMap<String, String>();
    private Map<String, String> othresFlags = new HashMap<String, String>();
    private Map<String, String> deparaParametros = new HashMap<String, String>();
    private ThreadRecebimento threadRecebimento = null;
    private int tamanhoEtiqueta = 0;
    private InterfaceConfiguracao configuracao;
    private Map<AnalysisInformationFormat2, InfoExameRequisicao> txList = new HashMap<AnalysisInformationFormat2, InfoExameRequisicao>();

    public InterfaceListener() {
        this.tamanhoEtiqueta = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        this.threadRecebimento = new ThreadRecebimento(this, 25);
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        if (!Funcoes.isNumeric(this.configuracao.getNumeroDoEquipamento()) || this.configuracao.getNumeroDoEquipamento().length() > 2) {
            Funcoes.mensagem(null, "Configura\u00e7\u00e3o do n\u00famero do equipamento n\u00e3o definida, verifique as configura\u00e7\u00f5es do equipamento no Jalis", 5);
        }
        this.source.put("0", "OP.CLCT");
        this.source.put("1", "Morning");
        this.source.put("2", "Timed (pooled urine)");
        this.source.put("3", "AF.Meal");
        this.source.put("4", "Cath");
        this.source.put("*", "Unknown");
        this.color.put("0", "None");
        this.color.put("1", "LyBrown");
        this.color.put("2", "Yellow");
        this.color.put("3", "Ybrown");
        this.color.put("4", "Orange");
        this.color.put("5", "Red");
        this.color.put("6", "Dbrown");
        this.color.put("7", "Green");
        this.color.put("8", "Blue");
        this.color.put("9", "White");
        this.color.put("*", "Unknown");
        this.clarity.put("0", "Clear");
        this.clarity.put("1", "SlHazy");
        this.clarity.put("2", "Hazy");
        this.clarity.put("3", "SlCldy");
        this.clarity.put("4", "Cloudy");
        this.clarity.put("*", "Unknown");
        this.flags.put("*", "Low reliability");
        this.flags.put("+", "Review");
        this.flags.put(" ", "Normal");
        this.flagsRbc.put("00000001", "Isomorphic?");
        this.flagsRbc.put("00000002", "Dysmorphic?");
        this.flagsRbc.put("00000003", "Mixed?");
        this.flagsCond.put("00000001", "RANK1");
        this.flagsCond.put("00000002", "RANK2");
        this.flagsCond.put("00000003", "RANK3");
        this.flagsCond.put("00000004", "RANK4");
        this.flagsCond.put("00000005", "RANK5");
        this.othresFlags.put(FLAG_RBC, "RBC-Info. Indicates RBC morphilogical information.");
        this.othresFlags.put(FLAG_COND, "Cond.-Info. Indicates urine concentration flag.");
        this.othresFlags.put(FLAG_UTI, "UTI-Info. Indicates UTI information. UTI?");
        this.deparaParametros.put("00D9", "pathological_casts");
        this.deparaParametros.put("0107", "small_round_cells");
        this.deparaParametros.put("0501", "spermatozoa");
        this.deparaParametros.put("0300", "crystals");
        this.deparaParametros.put("0402", "yeast_like_cells");
        this.deparaParametros.put("00DA", "muco");
        this.deparaParametros.put("0502", "cond");
        this.deparaParametros.put("0201", "rbc");
        this.deparaParametros.put("0202", "wbc");
        this.deparaParametros.put("0100", "celulas_epiteliais");
        this.deparaParametros.put("0000", "cilindro_hialino");
        this.deparaParametros.put("0401", "bacteriuria");
        this.deparaParametros.put("Source", "fonte");
        this.deparaParametros.put("Color", "COL");
        this.deparaParametros.put("Clarity", "ASP");
        this.deparaParametros.put("sEDchAnalysisUrineVolume", "sEDchAnalysisUrineVolume");
        this.deparaParametros.put("sEDchRawDataCount", "sEDchRawDataCount");
        this.deparaParametros.put("bACchRawDataCount", "bACchRawDataCount");
        this.deparaParametros.put("TotalNumberofSEDchParticle", "TotalNumberofSEDchParticle");
        this.deparaParametros.put("TotalNumberofBACchParticle", "TotalNumberofBACchParticle");
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        if (this.isTX()) {
            this.abortarTransmissao();
        } else if (this.isRX()) {
            // empty if block
        }
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setIdle();
    }

    private void limpaDadosRequisicao() {
        if (this.txList.keySet().iterator().hasNext()) {
            AnalysisInformationFormat2 analysisInformationFormat2 = this.txList.keySet().iterator().next();
            InfoExameRequisicao infoExameRequisicao = this.txList.remove(analysisInformationFormat2);
            this.fireMensagemEnviada("Tempo esgotado ao transmitir " + infoExameRequisicao.getNome(), 1, 5000);
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("")) {
                this.addListaRecebimento(message);
                ((PortaSocketServer)this.getPortaCOM()).write(String.valueOf('\u0006'));
                this.dataChanged();
                this.setIdle();
            } else {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void aguardarProximoFrame() throws Exception {
        this.setRX(15000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this, 25);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
            this.setIdle();
        }
    }

    private void tratarAcknowledge() throws SQLException {
        if (this.isTX()) {
            if (this.txList.keySet().iterator().hasNext()) {
                AnalysisInformationFormat2 analysisInformationFormat2 = this.txList.keySet().iterator().next();
                this.encerrarTransmissao(this.txList.remove(analysisInformationFormat2));
            }
        } else if (this.isRX()) {
            // empty if block
        }
    }

    private void encerrarTransmissao(InfoExameRequisicao infoExame) throws SQLException {
        Statement st = Conexao.getStatement();
        if (infoExame != null) {
            this.txCounter = 0;
            String[] exames = infoExame.getExames().split(" ");
            String fil_codigo = infoExame.getFilial();
            String int_codigo = infoExame.getInterface();
            String req_codigo = infoExame.getCodigo();
            String mco_codigo = infoExame.getMaterial();
            String rec_tuboPai = infoExame.getTuboPai();
            String rec_codigo = infoExame.getRecipiente();
            String ultima_acao = infoExame.getAcao();
            for (int i = 0; i < exames.length; ++i) {
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            String acao = ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
            this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + infoExame.getNome(), 0, 10000);
        } else if (infoExame != null) {
            this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + infoExame.getNome(), 0, 10000);
        }
        if (infoExame != null && infoExame.getAcao().equals("N")) {
            this.firePacienteEnviado(infoExame.getCodigo(), infoExame.getNome(), infoExame.getSexo(), infoExame.getIdade(), infoExame.getData(), infoExame.getHora(), infoExame.getExames());
        }
        this.setIdle();
        if (this.getAbaSelecionada() == 0) {
            this.fireAtualizarTabela(0);
        }
        if (this.getAbaSelecionada() == 1) {
            this.fireAtualizarTabela(1);
        }
    }

    private void tratarNegativeAck() throws Exception {
        if (this.isTX()) {
            if (this.txCounter == 3) {
                this.txCounter = 0;
                this.abortarTransmissao();
            }
            if (this.txList.keySet().iterator().hasNext()) {
                AnalysisInformationFormat2 analysisInformationFormat2 = this.txList.keySet().iterator().next();
                this.setTX(15000);
                ++this.txCounter;
                this.getPortaCOM().write(this.encapsularMsg(analysisInformationFormat2.getMsgEnvio()));
            }
        }
    }

    private void caracterNaoEsperado() {
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String messageReceive) {
        try {
            TipoMensagem tipoMensagem = this.getTipoMensagem(messageReceive);
            if (tipoMensagem == null) {
                this.fireExcecaoEncontrada("Mensagem desconhecida ou erro de comunica\u00e7\u00e3o na transmiss\u00e3o");
                this.fireExcecaoEncontrada(messageReceive);
            } else if (tipoMensagem.equals((Object)TipoMensagem.DATA_INQUIRY_ON_ANALYSIS_INFORMATION)) {
                this.responderHostQuery(messageReceive, tipoMensagem);
            } else {
                this.messagesResultado.put(tipoMensagem, messageReceive);
                if (this.messagesResultado.size() == 5) {
                    HashMap<TipoMensagem, String> messages = new HashMap<TipoMensagem, String>(this.messagesResultado);
                    this.messagesResultado.clear();
                    this.parseMensagensDeResultado(messages);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    private void responderHostQuery(String message, TipoMensagem tipoMensagem) {
        try {
            List<Object[]> reqs;
            int pos = 1;
            String textDistinctionCode1 = message.substring(1, ++pos);
            String textDistinctionCode2 = message.substring(pos++, pos);
            String textDistinctionCode3 = message.substring(pos, pos += 2);
            String inquiryMode = message.substring(pos, pos += 2);
            String inquirySampleId = message.substring(pos, pos += 14);
            String rackNo = message.substring(pos, pos += 6);
            String tubePosition = message.substring(pos, pos += 2);
            String reserved = message.substring(pos, pos += 18);
            HashMap<String, String> mapaParametros = new HashMap<String, String>();
            mapaParametros.put("codigoEtiqueta", inquirySampleId.trim());
            mapaParametros.put("tubePosition", tubePosition.trim());
            mapaParametros.put("inquiryMode", inquiryMode.trim());
            if (Funcoes.textoVazio(inquirySampleId) || !Funcoes.isNumeric(inquirySampleId.trim()) || inquirySampleId.trim().length() != this.tamanhoEtiqueta) {
                this.fireExcecaoEncontrada(String.format("Id da amostra solicitada inv\u00e1lida ou com tamanho fora do padr\u00e3o da configura\u00e7\u00e3o do Jalis [%s]", inquirySampleId));
                String pac_nome = "";
                String pac_sexo = "";
                String pac_idade = "";
                String data = "";
                String hora = "";
                String prioridade = "";
                String int_codigo = "";
                String mco_codigo = "";
                String pac_exames = "";
                mapaParametros.put("informationStatus", InformationStatus.NOT_REGISTERED.toString().trim());
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackNo, prioridade, "", int_codigo, "", mco_codigo, "", pac_exames, "A", mapaParametros);
            }
            inquirySampleId = inquirySampleId.trim();
            String fil_codigo = inquirySampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = inquirySampleId.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            String rec_codigo = inquirySampleId.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo());
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "A";
            if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(rec_codigo)) {
                return;
            }
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames) && req != null && aba != null) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                pac_exames = "";
                if (req != null) {
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) >= 7) continue;
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
                if (Funcoes.textoVazio(pac_exames)) {
                    req = null;
                }
            }
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                mapaParametros.put("informationStatus", InformationStatus.REGISTERED.toString());
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackNo, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao, mapaParametros);
            } else {
                mapaParametros.put("informationStatus", InformationStatus.REGISTERED.toString());
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackNo, prioridade, "", int_codigo, "", mco_codigo, "", "", acao, mapaParametros);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    private synchronized void parseMensagensDeResultado(Map<TipoMensagem, String> messages) throws Exception {
        Resultado resultado = new Resultado();
        for (TipoMensagem tipoMensagem : messages.keySet()) {
            ParticleNumberBlock particleNumberBlock;
            if (tipoMensagem.equals((Object)TipoMensagem.SAMPLE_INFORMATION_BLOCK)) {
                SampleInformationBlock sampleInformationBlock = new SampleInformationBlock(messages.get((Object)tipoMensagem));
                resultado.addSampleInformationBlock(sampleInformationBlock);
                continue;
            }
            if (tipoMensagem.equals((Object)TipoMensagem.PARTICLE_NUMBER_BLOCK_1)) {
                particleNumberBlock = new ParticleNumberBlock(messages.get((Object)tipoMensagem));
                resultado.addParticleNumberBlock1(particleNumberBlock);
                continue;
            }
            if (tipoMensagem.equals((Object)TipoMensagem.PARTICLE_NUMBER_BLOCK_2)) {
                particleNumberBlock = new ParticleNumberBlock(messages.get((Object)tipoMensagem));
                resultado.addParticleNumberBlock2(particleNumberBlock);
                continue;
            }
            if (tipoMensagem.equals((Object)TipoMensagem.COMMENT_BLOCK_1)) {
                CommentBlock1 commentBlock1 = new CommentBlock1(messages.get((Object)tipoMensagem));
                resultado.addCommentBlock1(commentBlock1);
                continue;
            }
            if (!tipoMensagem.equals((Object)TipoMensagem.COMMENT_BLOCK_2)) continue;
            CommentBlock2 commentBlock2 = new CommentBlock2(messages.get((Object)tipoMensagem));
            resultado.addCommentBlock2(commentBlock2);
        }
        this.parseResultado(resultado);
    }

    private synchronized void parseResultado(Resultado resultado) throws Exception {
        ParticleNumberBlock pnb;
        HashMap<String, Object> dadosResultado = new HashMap<String, Object>();
        ArrayList<String> flags = new ArrayList<String>();
        String fil_codigo = "";
        String req_codigo = "";
        String rec_codigo = "";
        String int_codigo = "";
        ExameMaterial exame = null;
        for (Integer bloco : resultado.getSampleInformationBlocks().keySet()) {
            SampleInformationBlock sampleInformationBlock = resultado.getSampleInformationBlocks().get(bloco);
            String idAmostra = sampleInformationBlock.getSampleNo().trim();
            if (!this.valida(idAmostra)) continue;
            fil_codigo = idAmostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
            int_codigo = this.getIntCodigo(fil_codigo, req_codigo = idAmostra.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo = idAmostra.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()), "URI");
            if (int_codigo == null) {
                this.fireExcecaoEncontrada(String.format("N\u00e3o localizado o c\u00f3digo da interface para a amostra %s %s %s", fil_codigo, req_codigo, rec_codigo));
                return;
            }
            exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, "URI");
            if (exame == null) {
                this.fireExcecaoEncontrada(String.format("N\u00e3o localizado o exame para a amostra %s %s %s", fil_codigo, req_codigo, rec_codigo));
                return;
            }
            dadosResultado.put("fonte", this.getMapValue(this.source, sampleInformationBlock.getSource()));
            dadosResultado.put("COL", this.getMapValue(this.color, sampleInformationBlock.getColor()));
            dadosResultado.put("ASP", this.getMapValue(this.clarity, sampleInformationBlock.getClarity()));
            dadosResultado.put("sEDchAnalysisUrineVolume", sampleInformationBlock.getsEDchAnalysisUrineVolume());
            dadosResultado.put("sEDchRawDataCount", sampleInformationBlock.getsEDchRawDataCount());
            dadosResultado.put("bACchRawDataCount", sampleInformationBlock.getbACchRawDataCount());
            dadosResultado.put("TotalNumberofSEDchParticle", sampleInformationBlock.getTotalNumberofSEDchParticle());
            dadosResultado.put("TotalNumberofBACchParticle", sampleInformationBlock.getTotalNumberofBACchParticle());
            this.pegarFlags(sampleInformationBlock, flags);
        }
        for (Integer bloco : resultado.getListaParticleNumberBlock1().keySet()) {
            pnb = resultado.getListaParticleNumberBlock1().get(bloco);
            for (String key : pnb.getPairs().keySet()) {
                if (!this.deparaParametros.containsKey(key)) continue;
                dadosResultado.put(this.deparaParametros.get(key), pnb.getPairs().get(key).getNumber().replace(".", ","));
            }
        }
        for (Integer bloco : resultado.getListaCommentBlock1().keySet()) {
            CommentBlock1 commentBloco1 = resultado.getListaCommentBlock1().get(bloco);
            for (String key : commentBloco1.getComments().keySet()) {
                if (!this.deparaParametros.containsKey(commentBloco1.getComments().get(key).getCode())) continue;
                dadosResultado.put(this.deparaParametros.get(commentBloco1.getComments().get(key).getCode()), commentBloco1.getComments().get(key).getNumber() != null ? commentBloco1.getComments().get(key).getNumber().replace(".", ",") : "");
            }
        }
        for (Integer bloco : resultado.getListaParticleNumberBlock2().keySet()) {
            pnb = resultado.getListaParticleNumberBlock2().get(bloco);
            for (String key : pnb.getPairs().keySet()) {
                dadosResultado.put(this.deparaParametros.get(key), pnb.getPairs().get(key).getNumber().replace(".", ","));
            }
        }
        for (Integer bloco : resultado.getListaCommentBlock2().keySet()) {
            CommentBlock2 commentBloco2 = resultado.getListaCommentBlock2().get(bloco);
            for (String key : commentBloco2.getPairs().keySet()) {
                if (!this.othresFlags.containsKey(commentBloco2.getPairs().get(key).getCode()) || commentBloco2.getPairs().get(key).getNumber().equals("00000000")) continue;
                if (commentBloco2.getPairs().get(key).getCode().equalsIgnoreCase(FLAG_UTI)) {
                    flags.add(this.othresFlags.get(commentBloco2.getPairs().get(key).getCode()));
                    continue;
                }
                if (commentBloco2.getPairs().get(key).getCode().equalsIgnoreCase(FLAG_COND)) {
                    flags.add(this.othresFlags.get(commentBloco2.getPairs().get(key).getCode()) + " " + this.flagsCond.get(commentBloco2.getPairs().get(key).getNumber()));
                    continue;
                }
                if (!commentBloco2.getPairs().get(key).getCode().equalsIgnoreCase(FLAG_RBC)) continue;
                flags.add(this.othresFlags.get(commentBloco2.getPairs().get(key).getCode()) + " " + this.flagsRbc.get(commentBloco2.getPairs().get(key).getNumber()));
            }
        }
        if (exame != null) {
            Statement st = Conexao.getStatement();
            this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dadosResultado, flags);
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
        } else {
            this.fireExcecaoEncontrada("Exame n\u00e3o encontrado. Tubo: " + fil_codigo + "-" + req_codigo + "-" + rec_codigo);
        }
    }

    private void pegarFlags(SampleInformationBlock sampleInformationBlock, ArrayList<String> flags) throws IllegalAccessException, InvocationTargetException {
        for (Method method : sampleInformationBlock.getClass().getDeclaredMethods()) {
            Object ret;
            if (!method.getName().startsWith("getFlag") || (ret = method.invoke((Object)sampleInformationBlock, new Object[0])) == null || Funcoes.textoVazio(ret.toString())) continue;
            String nomeFlag = method.getName().substring(method.getName().indexOf("getFlag") + 7).toUpperCase();
            flags.add(this.getFlag(nomeFlag, ret.toString()));
        }
    }

    private String getFlag(String nomeFlag, String flag) {
        if (!Funcoes.textoVazio(flag)) {
            return String.format("%s=%s", nomeFlag, this.flags.get(flag));
        }
        return null;
    }

    private String getMapValue(Map<String, String> map, String key) {
        return map.get(key);
    }

    private boolean valida(String idAmostra) {
        if (idAmostra.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: \"" + idAmostra + "\".");
            return false;
        }
        if (!Funcoes.isNumeric(idAmostra)) {
            this.fireExcecaoEncontrada("Resultados recebidos para uma requisi\u00e7\u00e3o sem id v\u00e1lido: \"" + idAmostra + "\".");
            return false;
        }
        return true;
    }

    private TipoMensagem getTipoMensagem(String message) {
        String tipo = message.substring(2, 3);
        return TipoMensagem.getTipoMensagem(tipo);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            String medico;
            this.txList.clear();
            Date dateOrdered = Funcoes.stringToDate(data);
            String tubePosition = mapaParametros.get("tubePosition");
            Integer sex = 0;
            Integer informationStatus = 1;
            Integer inquiryMode = mapaParametros.get("inquiryMode") != null && Funcoes.isNumeric(mapaParametros.get("inquiryMode")) ? Integer.parseInt(mapaParametros.get("inquiryMode")) : 2;
            String sampleNo = fil_codigo + req_codigo + rec_codigo;
            String short_name = StringUtil.removerAcentos(pac_nome);
            String firstName = "";
            String lastName = short_name;
            if (short_name.indexOf(" ") > 0) {
                String[] names = short_name.split(" ");
                firstName = names[0];
                if (firstName.length() > 20) {
                    firstName = firstName.substring(0, 20);
                }
                if ((lastName = names.length <= 2 ? names[1] : names[names.length - 1]).length() > 20) {
                    lastName = lastName.substring(0, 20);
                }
            } else if (lastName.length() > 20) {
                firstName = lastName.substring(0, 20);
                lastName = "";
            }
            if (pac_sexo.equalsIgnoreCase("F")) {
                sex = 2;
            } else if (pac_sexo.equalsIgnoreCase("M")) {
                sex = 1;
            }
            if (mapaParametros != null) {
                if (mapaParametros.containsKey("tubePosition")) {
                    tubePosition = mapaParametros.get("tubePosition");
                }
                if (mapaParametros.containsKey("informationStatus")) {
                    informationStatus = Integer.parseInt(mapaParametros.get("informationStatus"));
                }
                if (mapaParametros.containsKey("inquiryMode")) {
                    inquiryMode = Integer.parseInt(mapaParametros.get("inquiryMode"));
                }
                if (mapaParametros.containsKey("codigoEtiqueta")) {
                    sampleNo = mapaParametros.get("codigoEtiqueta");
                }
            }
            String[] age = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
            Date birthday = null;
            if (age != null) {
                birthday = StringUtil.getDataDeString(age[2]);
            }
            if (!Funcoes.textoVazio(medico = BDUtil.buscaMedicoRequisicao(fil_codigo, req_codigo))) {
                medico = StringUtil.removerAcentos(medico);
            }
            AnalysisInformationFormat2 analysisInformationFormat2 = new AnalysisInformationFormat2();
            analysisInformationFormat2.setTextDistinctionCode3(this.configuracao.getNumeroDoEquipamento());
            analysisInformationFormat2.setDateOrdered(dateOrdered);
            analysisInformationFormat2.setBirthday(birthday);
            analysisInformationFormat2.setInformationStatus(informationStatus);
            analysisInformationFormat2.setInquiryMode(inquiryMode);
            analysisInformationFormat2.setPatientID(fil_codigo + req_codigo);
            analysisInformationFormat2.setFirstName(firstName);
            analysisInformationFormat2.setLastName(lastName);
            analysisInformationFormat2.setSampleNo(sampleNo);
            analysisInformationFormat2.setrackNo(rackposition.trim());
            analysisInformationFormat2.setTubePosition(tubePosition);
            analysisInformationFormat2.setSex(sex);
            analysisInformationFormat2.setDoctor(medico);
            analysisInformationFormat2.setPatientComments("");
            analysisInformationFormat2.setWard("");
            InfoExameRequisicao infoExame = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, exames);
            infoExame.setAcao(acao);
            infoExame.setInterface(int_codigo);
            infoExame.setRack(rackposition + "^" + tubePosition);
            this.txList.put(analysisInformationFormat2, infoExame);
            this.setTX(15000);
            this.txCounter = 1;
            this.getPortaCOM().write(this.encapsularMsg(analysisInformationFormat2.getMsgEnvio()));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
        return "Enviado paciente " + pac_nome;
    }

    private String encapsularMsg(String msgEnvio) {
        StringBuilder msg = new StringBuilder(this.getMsgStart());
        msg.append(msgEnvio);
        msg.append(this.getMsgEnd());
        return msg.toString();
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao, null);
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        if (portaCOM instanceof PortaSocketServer) {
            ((PortaSocketServer)portaCOM).setEscreverEmBytes(true);
        }
        super.setPortaCOM(portaCOM);
    }

    public static enum TipoMensagem {
        DATA_INQUIRY_ON_ANALYSIS_INFORMATION("1"),
        SAMPLE_INFORMATION_BLOCK("S"),
        PARTICLE_NUMBER_BLOCK_1("P"),
        PARTICLE_NUMBER_BLOCK_2("Q"),
        COMMENT_BLOCK_1("C"),
        COMMENT_BLOCK_2("D");

        String codigo = "";

        private TipoMensagem(String codigo) {
            this.codigo = codigo;
        }

        public String toString() {
            return this.codigo;
        }

        public static TipoMensagem getTipoMensagem(String codigo) {
            for (TipoMensagem aux : TipoMensagem.values()) {
                if (!aux.codigo.equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }
    }

    public static enum InformationStatus {
        NOT_REGISTERED("0"),
        REGISTERED("1"),
        QUALITY_CONTROL("2");

        String codigo = "";

        private InformationStatus(String codigo) {
            this.codigo = codigo;
        }

        public String toString() {
            return this.codigo;
        }

        public static InformationStatus getInformationStatus(String codigo) {
            for (InformationStatus aux : InformationStatus.values()) {
                if (!aux.codigo.equalsIgnoreCase(codigo)) continue;
                return aux;
            }
            return null;
        }
    }
}

