/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sysmexUwan;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    private static final String FLAGS_NAO_LIBERADAS = "flagsNaoLiberadas";
    protected Map<String, String> campos = new HashMap<String, String>();
    private Map<String, String> flags = new HashMap<String, String>();
    protected boolean envioMontandoRack = false;
    private List<String> flagsSalva = null;
    protected String lastField = "";
    private static final String RAW = "Raw";
    private ArrayList<String> flagsCampoNaoLiberados = new ArrayList();

    public RecordParser(InterfaceASTMListener equip, boolean enviarMontandoRack) {
        super(equip);
        this.flagsCampoNaoLiberados.add("crystals");
        this.flagsCampoNaoLiberados.add("spermatozoa");
        this.flagsCampoNaoLiberados.add("yeast_like_cells");
        this.flagsCampoNaoLiberados.add("cilindro_hialino");
        this.flagsCampoNaoLiberados.add("pathological_casts");
        this.flagsCampoNaoLiberados.add("rTec");
        this.flagsCampoNaoLiberados.add("hyCast");
        this.flagsCampoNaoLiberados.add("muco");
        this.flagsCampoNaoLiberados.add("tranEc");
        this.flagsCampoNaoLiberados.add("bacteriuria");
        this.flagsCampoNaoLiberados.add("celulas_epiteliais");
        this.flagsCampoNaoLiberados.add("LEU");
        this.flags.put("*", "Anormal");
        this.flags.put("S", "Sieve");
        this.flags.put("!", "Resultado editado");
        this.flags.put("#", "Modificado refer\u00eancia");
        this.flags.put("T", "Erro na tira de teste. Nenhum resultado gerado. Campo de resultado vazio");
        this.flags.put("C", "Calibra\u00e7\u00e3o expirada");
        this.campos.put("C-BLD-RAW", "BLD2");
        this.campos.put("C-URO-RAW", "URO2");
        this.campos.put("C-BIL-RAW", "BIL2");
        this.campos.put("C-KET-RAW", "KET2");
        this.campos.put("C-PRO-RAW", "PRO2");
        this.campos.put("C-NIT-RAW", "NIT2");
        this.campos.put("C-GLU-RAW", "GLU2");
        this.campos.put("C-PH-RAW", "PH2");
        this.campos.put("C-S.G.(Ref)-RAW", "SG2");
        this.campos.put("C-LEU-RAW", "LEU2");
        this.campos.put("", "VTC2");
        this.campos.put("", "VC2");
        this.campos.put("", "CRE2");
        this.campos.put("", "ALB2");
        this.campos.put("", "RT");
        this.campos.put("", "PC2");
        this.campos.put("", "AC2");
        this.campos.put("C-ColorRANK-RAW", "COLRANK2");
        this.campos.put("C-CLOUD-RAW", "CLOUD2");
        this.campos.put("RBC-RAW", "RBC2");
        this.campos.put("RBC-RAW", "RBC2");
        this.campos.put("C-Error Code", "errorCode");
        this.campos.put("C-Error Code", "errorCode2");
        this.campos.put("NL RBC", "nlRbc");
        this.campos.put("NL RBC2", "nlRbc2");
        this.campos.put("WBC2", "WBC2");
        this.campos.put("WBC CLUMPS", "wbcClumps");
        this.campos.put("WBC CLUMPS2", "wbcClumps2");
        this.campos.put("EC2", "EC2");
        this.campos.put("Squa.EC", "squareEc");
        this.campos.put("Squa.EC2", "squareEc");
        this.campos.put("Non SEC", "nonSec");
        this.campos.put("NON_SEC2", "nonSec2");
        this.campos.put("Tran.EC", "tranEc");
        this.campos.put("Tran.EC2", "tranEc2");
        this.campos.put("RTEC", "rTec");
        this.campos.put("RTEC2", "rTec2");
        this.campos.put("CAST2", "cast2");
        this.campos.put("Hy.CAST", "hyCast");
        this.campos.put("HY_CAST2", "hyCast2");
        this.campos.put("PATH_CAST2", "pathCast2");
        this.campos.put("X_TAL2", "xTal2");
        this.campos.put("YLC2", "ylc2");
        this.campos.put("SPERM2", "sperm2");
        this.campos.put("MUCUS2", "mucus2");
        this.campos.put("RBC-Info", "rbcInfo");
        this.campos.put("RBC_INFO2", "rbcInfo2");
        this.campos.put("UTI_INFO", "utiInfo");
        this.campos.put("UTI_INFO2", "utiInfor2");
        this.campos.put("BACT2", "bact2");
        this.campos.put("SOURCE", "fonte");
        this.campos.put("EC", "celulas_epiteliais");
        this.campos.put("CAST", "cilindro_hialino");
        this.campos.put("BACT", "bacteriuria");
        this.campos.put("Path.CAST", "pathological_casts");
        this.campos.put("SRC", "small_round_cells");
        this.campos.put("SPERM", "spermatozoa");
        this.campos.put("X'TAL", "crystals");
        this.campos.put("YLC", "yeast_like_cells");
        this.campos.put("MUCUS", "muco");
        this.campos.put("COND", "cond");
        this.campos.put("RBC", "rbc");
        this.campos.put("WBC", "wbc");
        this.campos.put("C-BLD", "SAN");
        this.campos.put("C-BIL", "BIL");
        this.campos.put("C-URO", "URO");
        this.campos.put("C-KET", "CET");
        this.campos.put("C-PRO", "PRO");
        this.campos.put("C-NIT", "NIT");
        this.campos.put("C-GLU", "GLI");
        this.campos.put("C-PH", "p.H");
        this.campos.put("C-S.G.(Ref)", "DEN");
        this.campos.put("C-LEU", "LEU");
        this.campos.put("C-VTC", "VTC");
        this.campos.put("C-COLOR", "COL");
        this.campos.put("C-CLA", "ASP");
        this.campos.put("C-UBG", "UBG");
        this.campos.put("C-ERY", "ERY");
        this.campos.put("C-ColorRANK", "COLRANK");
        this.campos.put("C-CLOUD", "CLOUD");
        this.campos.put("C-CRE", "CRE");
        this.campos.put("C-CRE-RAW", "CRE2");
        this.campos.put("C-ALB", "ALB");
        this.campos.put("C-ALB-RAW", "ALB2");
        this.campos.put("C-P/C", "PC");
        this.campos.put("C-A/C", "AC");
        this.envioMontandoRack = enviarMontandoRack;
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual != null) {
            this.salvaExame(this.exame_atual);
        }
        this.exame_atual = new HashMap();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            this.exame_atual = null;
            return;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
        String emi_alternativo = "URI";
        Statement st = Conexao.getStatement();
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo + " amostra n\u00e3o interfaciada ou j\u00e1 exportada");
            this.exame_atual = null;
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
        Exame ex = new Exame(fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo, rec_codigo);
        this.flagsSalva = ex.getFlags();
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String int_codigo = (String)this.exame_atual.get(INT_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
        String mco_codigo = (String)this.exame_atual.get(MCO_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String campoUrina = (String)result_fields.get(3);
        String resultado = (String)result_fields.get(4);
        if (!Funcoes.textoVazio(campoUrina)) {
            campoUrina = campoUrina.substring(campoUrina.indexOf("^^^") + 3);
            campoUrina = campoUrina.substring(0, campoUrina.indexOf("^"));
            campoUrina = this.campos.get(campoUrina);
        }
        resultado = resultado.replaceAll("\\.", ",");
        if ((resultado = resultado.substring(0, resultado.indexOf("^"))).startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.length() >= 1 && resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        if (this.flagsCampoNaoLiberados.contains(campoUrina)) {
            if (!this.exame_atual.containsKey(FLAGS_NAO_LIBERADAS)) {
                this.exame_atual.put(FLAGS_NAO_LIBERADAS, new ArrayList());
            }
            if (!((ArrayList)this.exame_atual.get(FLAGS_NAO_LIBERADAS)).toString().contains(campoUrina)) {
                ((ArrayList)this.exame_atual.get(FLAGS_NAO_LIBERADAS)).add(campoUrina + " = " + resultado);
            }
        }
        Statement st = Conexao.getStatement();
        this.exame_atual.put(campoUrina, resultado);
        this.lastField = campoUrina;
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        String flags = (String)dados.remove("flag_alerta");
        ArrayList<String> flag = new ArrayList<String>();
        if (flags != null) {
            for (String s : flags.split("\n")) {
                flag.add(s);
            }
        }
        this.lastField = "";
        Statement st = Conexao.getStatement();
        List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
        for (BDExame exame : exames) {
            ArrayList flagsAux = new ArrayList();
            if (this.exame_atual.containsKey(FLAGS_NAO_LIBERADAS)) {
                flagsAux = (ArrayList)this.exame_atual.get(FLAGS_NAO_LIBERADAS);
            }
            this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getExame(), exame.getMaterial(), int_codigo, dados, flagsAux);
        }
    }
}

