/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sysmexUwan;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServerDouble;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.sysmexUwan.RecordParser;
import jalis.laboratorio.interfaceamento.interfaces.urisys1800.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.socket.InterfaceSocketServerListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class InterfaceListener
extends InterfaceSocketServerListener {
    private boolean hostQuery = true;
    protected int MAX_PATIENT_NAME_CHARS = 40;
    private static final String EXAME = "URI";
    private InterfaceConfiguracao configuracao;
    private List<InfoExameRequisicao> examesEnviados = new ArrayList<InfoExameRequisicao>();
    private String host_fil_codigo = null;
    private String host_req_codigo = null;
    private String host_rec_codigo = null;
    private Timer timer;
    private boolean heartbit = false;
    private String msg = "";

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        RecordParser record = new RecordParser(this, this.configuracao.getEnviarMontandoRack());
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        if (this.configuracao.getModoHostQuery()) {
            this.timer = new Timer(300000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (InterfaceListener.this.getPortaCOM() != null && !InterfaceListener.this.isTX() && !InterfaceListener.this.isRX() || InterfaceListener.this.getPortaCOM() != null && InterfaceListener.this.isRX()) {
                        try {
                            if (!InterfaceListener.this.heartbit) {
                                InterfaceListener.this.heartbit = true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            this.timer.start();
        }
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        super.setPortaCOM(portaCOM);
        ((PortaSocketServerDouble)this.getPortaCOM()).setIgnoraSTX(true);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            this.tx_list.clear();
            this.rx_list.clear();
            this.tx_list.add(this.getHeaderRecord(this.DELIMITERS, this.HOST_NAME, this.HOST_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro do paciente");
            }
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            String nome = null;
            String sobrenome = short_name;
            if (short_name.indexOf(" ") > 0) {
                String[] names = short_name.split(" ");
                nome = names[0];
                if (nome.length() > 15) {
                    nome = nome.substring(0, 15);
                }
                if ((sobrenome = names.length <= 2 ? names[1] : names[names.length - 1]).length() > 20) {
                    sobrenome = sobrenome.substring(0, 20);
                }
            } else if (sobrenome.length() > 36) {
                nome = sobrenome.substring(0, 36);
                sobrenome = "";
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            String patient_id = req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            String laboratory_pid = null;
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            Date dateNascPac = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String dtNascPac = "";
            if (dateNascPac != null) {
                dtNascPac = Funcoes.formataData("yyyyMMdd", dateNascPac);
            }
            this.tx_list.add(this.getPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo, dtNascPac));
            this.tx_list.add(this.getOrderRecord(codigo.toString(), rackposition, "R", acao));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.tx_list.add(String.valueOf('\u0004'));
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            InfoExameRequisicao infoexame = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames);
            infoexame.setInterface(int_codigo);
            infoexame.setCurva(false);
            infoexame.setTuboPai(rec_codigo);
            this.examesEnviados.add(infoexame);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    protected void prepararParaReceber() throws Exception {
        this.getPortaCOM().clearInputString();
        this.setRX(this.TIME_ENQUIRY);
        this.fireMensagemEnviada("Aguardando envio de dados pelo equipamento", 0, 10000);
        ((PortaSocketServerDouble)this.getPortaCOM()).writeOut(String.valueOf('\u0006'));
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        while (!this.examesEnviados.isEmpty()) {
            this.encerrarTransmissao(this.examesEnviados.remove(0));
        }
        this.interromperTimer();
        ((PortaSocketServerDouble)this.getPortaCOM()).writeIn(String.valueOf('\u0004'));
        ((PortaSocketServerDouble)this.getPortaCOM()).writeOut(String.valueOf('\u0004'));
        ((PortaSocketServerDouble)this.getPortaCOM()).clearInputString();
        ((PortaSocketServerDouble)this.getPortaCOM()).clearStringOutput();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
        if (this.hostQuery) {
            this.hostQuery = true;
        }
    }

    private void encerrarTransmissao(InfoExameRequisicao infoExame) throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            Statement st = Conexao.getStatement();
            if (infoExame != null) {
                String[] exames = infoExame.getExames().split(" ");
                String fil_codigo = infoExame.getFilial();
                String int_codigo = infoExame.getInterface();
                String req_codigo = infoExame.getCodigo();
                String mco_codigo = infoExame.getMaterial();
                String rec_tuboPai = infoExame.getTuboPai();
                String rec_codigo = infoExame.getRecipiente();
                for (int i = 0; i < exames.length; ++i) {
                    int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
            } else {
                this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
            }
        }
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(infoExame.getCodigo(), infoExame.getNome(), infoExame.getSexo(), infoExame.getIdade(), infoExame.getData(), infoExame.getHora(), infoExame.getExames());
        }
    }

    protected void tratarAcknowledge(boolean in) throws Exception {
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                if (in) {
                    this.enviarProximoFrame();
                } else {
                    this.enviarProximoFrameOut();
                }
            } else if (in) {
                this.enviarProximoFrame();
            } else {
                this.enviarProximoFrameOut();
            }
        } else if (!this.isRX()) {
            if (in) {
                this.enviarProximoFrame();
            } else {
                this.enviarProximoFrameOut();
            }
        } else if (in) {
            this.enviarProximoFrame();
        } else {
            this.enviarProximoFrameOut();
        }
        if (this.heartbit) {
            this.heartbit = false;
        }
    }

    @Override
    public void fcTimedOut(EventObject e) {
        super.fcTimedOut(e);
        this.heartbit = false;
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "N";
            if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(rec_codigo)) {
                return;
            }
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames) && req != null && aba != null) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (Funcoes.textoVazio(pac_exames)) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
                this.hostQuery = false;
                ((PortaSocketServerDouble)this.getPortaCOM()).writeOut(String.valueOf('\u0005'));
            } else {
                this.hostQuery = false;
                this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o n\u00e3o encontrada %s ", this.host_req_codigo));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Labmax 560: Host Query Response");
            this.hostQuery = false;
        }
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            if (!message.contains(String.valueOf('\u0002'))) {
                message = String.valueOf('\u0002') + message;
            }
            message = message.substring(1, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            if (this.checkCRC(message = message.substring(0, message.length() - 2), checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    message = (String)this.rx_list.get(this.rx_list.getUltimoInserido()) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                this.rx_list.add(message);
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    String s = (String)this.rx_list.remove(0);
                    this.recordParser.recordFound(s);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = ((PortaSocketServerDouble)this.getPortaCOM()).getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                ((PortaSocketServerDouble)this.getPortaCOM()).writeIn(String.valueOf('\u0006'));
            }
            if (!(message = ((PortaSocketServerDouble)this.getPortaCOM()).removeInputString(this.getMsgEnd())).equals("")) {
                String retorno = this.parse(message);
                ((PortaSocketServerDouble)this.getPortaCOM()).writeIn(String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            String sampleId = starting_range.trim();
            this.hostQuery = true;
            if (Funcoes.textoVazio(sampleId)) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                return;
            }
            if (sampleId.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                return;
            }
            this.host_fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            sampleId = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Labmax 560: Host Query Response");
        }
    }

    private String getHeaderRecord(String delimiters, String sender_id_name, String sender_id_system) {
        StringBuilder record = new StringBuilder("H|");
        record.append(delimiters == null ? "" : delimiters);
        record.append("||");
        record.append("|");
        record.append(sender_id_name == null ? "" : sender_id_name);
        record.append(sender_id_system == null ? "" : "^" + sender_id_system);
        record.append("||||||||LIS2-A2");
        record.append('\r');
        return record.toString();
    }

    private String getCommentRecord(String crc) {
        StringBuilder record = new StringBuilder("C|1||");
        record.append(crc);
        record.append('\r');
        return record.toString();
    }

    private String getOrderRecord(String sample_id, String InstrumentSpecimenID, String priority, String action_code) {
        StringBuilder record = new StringBuilder("O|");
        record.append("1|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("||");
        record.append("^^^URO\\^^^BLD\\^^^BIL\\^^^KET\\^^^RBC\\^^^WBC\\^^^WBC Clumps\\^^^EC\\^^^Squa.EC\\^^^Non SEC\\^^^CAST\\^^^Hy.CAST\\^^^Path.CAST\\^^^BACT\\^^^X'TAL\\^^^YLC\\^^^SP");
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("||").append(ASTMStandard.getCurrentMoment());
        record.append("||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||||||");
        record.append("||||||");
        record.append("O");
        record.append("|||||");
        record.append('\r');
        return record.toString();
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String laboratory_pid, String pac_nome, String pac_sobrenome, String pac_sexo, String dataNasc) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|");
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append(laboratory_pid == null ? "" : laboratory_pid);
        record.append("||");
        record.append(pac_sobrenome == null ? "" : pac_sobrenome);
        record.append(pac_nome == null ? "" : "^" + pac_nome);
        record.append("||");
        record.append(dataNasc).append("|");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append("|||||||||||||||||||");
        record.append('\r');
        return record.toString();
    }

    @Override
    protected void enviarProximoFrame() throws Exception {
        int next;
        this.rx_list.clear();
        int n = next = this.tx_list.getUltimoLido() < 0 ? 0 : this.tx_list.getUltimoLido() + 1;
        if (this.tx_list.size() > 0 && next <= this.tx_list.size() - 1) {
            String frame = (String)this.tx_list.get(next);
            this.setTX(this.TIME_TX);
            ++this.tx_counter;
            ((PortaSocketServerDouble)this.getPortaCOM()).writeIn(frame);
        } else {
            this.encerrarTransmissao();
        }
    }

    protected void enviarProximoFrameOut() throws Exception {
        int next;
        this.rx_list.clear();
        int n = next = this.tx_list.getUltimoLido() < 0 ? 0 : this.tx_list.getUltimoLido() + 1;
        if (this.tx_list.size() > 0 && next <= this.tx_list.size() - 1) {
            String frame = (String)this.tx_list.get(next);
            this.setTX(this.TIME_TX);
            ++this.tx_counter;
            ((PortaSocketServerDouble)this.getPortaCOM()).writeOut(frame);
        }
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT"}, null);
        if (op == 0) {
            this.testeQuery();
        } else if (op == 1) {
            ((PortaSocketServerDouble)this.getPortaCOM()).readOutput(String.valueOf('\u0006'));
        } else if (op == 2) {
            this.testeResultado();
        } else if (op == 3) {
            this.handShakeCharReceived('\u0004');
        }
    }

    private void testeQuery() {
        ArrayList<String> linhas = new ArrayList<String>();
        linhas.add(this.equipamento.arruma("[ENQ]"));
        linhas.add(this.equipamento.arruma("[STX]1H|\\^&|||U-WAM^00-15_Build007^A2624^^^^AU501736||||||||LIS2-A2|20191128171211[CR][ETX]83[CR][LF]"));
        linhas.add(this.equipamento.arruma("[STX]2Q|1|010005899611||||010005894811||||||C[CR][ETX][CHK1][CHK2][CR][LF] "));
        linhas.add(this.equipamento.arruma("[STX]3L|1|N[CR][ETX][CHK1][CHK2][CR][LF] "));
        linhas.add(this.equipamento.arruma("[EOT]"));
        for (String linha : linhas) {
            ((PortaSocketServerDouble)this.getPortaCOM()).readOutput(linha);
        }
    }

    private void testeResultado() {
        ArrayList<String> linhas = new ArrayList<String>();
        linhas.add(this.equipamento.arruma("[STX]"));
        linhas.add(this.equipamento.arruma("1H|\\^&|||U-WAM^00-15_Build007^A2624^^^^AU501736||||||||LIS2-A2|20190808163017[CR][ETX]8C[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]"));
        linhas.add(this.equipamento.arruma("2P|1|||||||U[CR][ETX]F8[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]"));
        linhas.add(this.equipamento.arruma("3O|1|010005889611||^^^C-URO\\^^^C-BLD\\^^^C-BIL\\^^^C-KET\\^^^C-GLU\\^^^C-PRO\\^^^C-PH\\^^^C-NIT\\^^^C-LEU\\^^^C-CRE\\^^^C-ALB\\^^^C-P/C\\^^^C-A/C\\^^^C-S.G.(Ref)\\^^^C-COLOR\\^^^C-CLOUD\\^^^RBC\\^^^NL[SP]RBC\\^^^WBC\\^^^WBC[SP]Clumps\\^^^EC\\^^^Squa.EC\\^^^Non[SP]SEC\\^^^[ETB]C9[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]"));
        linhas.add(this.equipamento.arruma("4Tran.EC\\^^^RTEC\\^^^CAST\\^^^Hy.CAST\\^^^Path.CAST\\^^^BACT\\^^^X'TAL\\^^^YLC\\^^^SPERM\\^^^MUCUS\\^^^RBC-Info.\\^^^UTI-Info.\\^^^BACT-Info.\\^^^RC_UNIVERSAL\\^^^SF_DSS_PxSF_FSC_P\\^^^HIST_SF_FSC_P\\^^^CW_SSH_AxCW_FSC_W\\^^^CW_FLL_AxCW_FSC_W\\^^^CB_FLH_PxCB[ETB]0A[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]"));
        linhas.add(this.equipamento.arruma("5_FSC_P\\^^^SF_FLL_WxSF_FLL_A\\^^^CW_FLH_PxCW_FSC_P\\|R||20190808162920||||N|||20190808162922|*||||||||||F[CR][ETX]4D[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]"));
        linhas.add(this.equipamento.arruma("6R|1|^^^C-URO^A^1^S^[SP][SP]0001^01|^RAW|mg/dL||N||||^^user^user||20190808154430|UC-3500[CR][ETX]CD[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]7R|2|^^^C-URO^A^1^S^[SP][SP]0001^01|^MAINFORMAT|mg/dL||N||||^^user^user||20190808154430|UC-3500[CR][ETX]D3[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]0R|3|^^^C-BLD^A^1^S^[SP][SP]0001^01|^RAW|mg/dL||N||||^^user^user||20190808154430|UC-3500[CR][ETX]A5[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]1R|4|^^^C-BLD^A^1^S^[SP][SP]0001^01|^MAINFORMAT|mg/dL||N||||^^user^user||20190808154430|UC-3500[CR][ETX]AB[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]2R|5|^^^C-BIL^A^1^S^[SP][SP]0001^01|^RAW|mg/dL||N||||^^user^user||20190808154430|UC-3500[CR][ETX]AE[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]3R|6|^^^C-BIL^A^1^S^[SP][SP]0001^01|^MAINFORMAT|mg/dL||N||||^^user^user||20190808154430|UC-3500[CR][ETX]B4[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]4R|7|^^^C-KET^A^1^S^[SP][SP]0001^01|^RAW|mg/dL||N||||^^user^user||20190808154430|UC-3500[CR][ETX]BF[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]5R|8|^^^C-KET^A^1^S^[SP][SP]0001^01|^MAINFORMAT|mg/dL||N||||^^user^user||20190808154430|UC-3500[CR][ETX]C5[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]6R|9|^^^C-GLU^A^1^S^[SP][SP]0001^01|^RAW|mg/dL||N||||^^user^user||20190808154430|UC-3500[CR][ETX]C7[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]7R|10|^^^C-GLU^A^1^S^[SP][SP]0001^01|^MAINFORMAT|mg/dL||N||||^^user^user||20190808154430|UC-3500[CR][ETX]F4[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]0R|11|^^^C-PRO^A^1^S^[SP][SP]0001^01|^RAW|mg/dL||N||||^^user^user||20190808154430|UC-3500[CR][ETX]F3[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]1R|12|^^^C-PRO^A^1^S^[SP][SP]0001^01|^MAINFORMAT|mg/dL||N||||^^user^user||20190808154430|UC-3500[CR][ETX]F9[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]2R|13|^^^C-PH^A^1^S^[SP][SP]0001^01|5.5^RAW|||N||||^^user^user||20190808154430|UC-3500[CR][ETX]83[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]3R|14|^^^C-PH^A^1^S^[SP][SP]0001^01|5.5^MAINFORMAT|||N||||^^user^user||20190808154430|UC-3500[CR][ETX]89[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]4R|15|^^^C-NIT^A^1^S^[SP][SP]0001^01|-^RAW|||N||||^^user^user||20190808154430|UC-3500[CR][ETX]6F[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]5R|16|^^^C-NIT^A^1^S^[SP][SP]0001^01|-^MAINFORMAT|||N||||^^user^user||20190808154430|UC-3500[CR][ETX]75[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]6R|17|^^^C-LEU^A^1^S^[SP][SP]0001^01|75^RAW|c/\u00b5L||H||||^^user^user||20190808154430|UC-3500[CR][ETX]3A[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]7R|18|^^^C-LEU^A^1^S^[SP][SP]0001^01|75^MAINFORMAT|c/\u00b5L||H||||^^user^user||20190808154430|UC-3500[CR][ETX]40[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]0R|19|^^^C-CRE^A^1^S^[SP][SP]0001^01|10^RAW|mg/dL||N||||^^user^user||20190808154430|UC-3500[CR][ETX]45[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]1R|20|^^^C-CRE^A^1^S^[SP][SP]0001^01|0.1^MAINFORMAT|g/L||N||||^^user^user||20190808154430|UC-3500[CR][ETX]9F[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]2R|21|^^^C-ALB^A^1^S^[SP][SP]0001^01|10^RAW|mg/L||N||||^^user^user||20190808154430|UC-3500[CR][ETX]D1[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]3R|22|^^^C-ALB^A^1^S^[SP][SP]0001^01|0.01^MAINFORMAT|g/L||N||||^^user^user||20190808154430|UC-3500[CR][ETX]C8[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]4R|23|^^^C-P/C^A^1^S^[SP][SP]0001^01|^RAW|g/gCr||N||||^^user^user||20190808154430|UC-3500[CR][ETX]CA[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]5R|24|^^^C-P/C^A^1^S^[SP][SP]0001^01|^MAINFORMAT|g/gCr||N||||^^user^user||20190808154430|UC-3500[CR][ETX]D0[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]6R|25|^^^C-A/C^A^1^S^[SP][SP]0001^01|^RAW|mg/gCr||N||||^^user^user||20190808154430|UC-3500[CR][ETX]2C[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]7R|26|^^^C-A/C^A^1^S^[SP][SP]0001^01|^MAINFORMAT|mg/gCr||N||||^^user^user||20190808154430|UC-3500[CR][ETX]32[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]0R|27|^^^C-S.G.(Ref)^A^1^S^[SP][SP]0001^01|1.017^RAW|||N||||^^user^user||20190808154430|UC-3500[CR][ETX]B1[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]1R|28|^^^C-S.G.(Ref)^A^1^S^[SP][SP]0001^01|1.017^MAINFORMAT|||N||||^^user^user||20190808154430|UC-3500[CR][ETX]B7[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]2R|29|^^^C-COLOR^A^1^S^[SP][SP]0001^01|STRAW[SP][SP][SP][SP][SP]02^RAW|||N||||^^user^user||20190808154430|UC-3500[CR][ETX]6C[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]3R|30|^^^C-COLOR^A^1^S^[SP][SP]0001^01|STRAW[SP][SP][SP][SP][SP]02^MAINFORMAT|||N||||^^user^user||20190808154430|UC-3500[CR][ETX]69[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]4R|31|^^^C-CLOUD^A^1^S^[SP][SP]0001^01|-^RAW|||N||||^^user^user||20190808154430|UC-3500[CR][ETX]F9[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]5R|32|^^^C-CLOUD^A^1^S^[SP][SP]0001^01|-^MAINFORMAT|||N||||^^user^user||20190808154430|UC-3500[CR][ETX]FF[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]6R|33|^^^RBC^A^1^S^[SP][SP]0001^01|2.5^RAW|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]AF[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]7R|34|^^^RBC^A^1^S^[SP][SP]0001^01|2.5^MAINFORMAT|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]B5[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]0R|35|^^^NL[SP]RBC^A^1^S^[SP][SP]0001^01|1.8^RAW|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]67[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]1R|36|^^^NL[SP]RBC^A^1^S^[SP][SP]0001^01|1.8^MAINFORMAT|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]6D[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]2R|37|^^^WBC^A^1^S^[SP][SP]0001^01|253.0^RAW|/\u00b5l||H||||^^user^user||20190808154836|UF-5000[CR][ETX]11[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]3R|38|^^^WBC^A^1^S^[SP][SP]0001^01|253.0^MAINFORMAT|/\u00b5l||H||||^^user^user||20190808154836|UF-5000[CR][ETX]17[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]4R|39|^^^WBC[SP]Clumps^A^1^S^[SP][SP]0001^01|3.2^RAW|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]4A[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]5R|40|^^^WBC[SP]Clumps^A^1^S^[SP][SP]0001^01|3.2^MAINFORMAT|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]47[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]6R|41|^^^EC^A^1^S^[SP][SP]0001^01|6.8^RAW|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]66[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]7R|42|^^^EC^A^1^S^[SP][SP]0001^01|6.8^MAINFORMAT|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]6C[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]0R|43|^^^Squa.EC^A^1^S^[SP][SP]0001^01|1.9^RAW|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]26[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]1R|44|^^^Squa.EC^A^1^S^[SP][SP]0001^01|1.9^MAINFORMAT|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]2C[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]2R|45|^^^Non[SP]SEC^A^1^S^[SP][SP]0001^01|4.9^RAW|/\u00b5l||H||||^^user^user||20190808154836|UF-5000[CR][ETX]FD[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]3R|46|^^^Non[SP]SEC^A^1^S^[SP][SP]0001^01|4.9^MAINFORMAT|/\u00b5l||H||||^^user^user||20190808154836|UF-5000[CR][ETX]03[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]4R|47|^^^Tran.EC^A^1^S^[SP][SP]0001^01|0.4^RAW|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]23[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]5R|48|^^^Tran.EC^A^1^S^[SP][SP]0001^01|0.4^MAINFORMAT|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]29[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]6R|49|^^^RTEC^A^1^S^[SP][SP]0001^01|4.4^RAW|/\u00b5l||H||||^^user^user||20190808154836|UF-5000[CR][ETX]08[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]7R|50|^^^RTEC^A^1^S^[SP][SP]0001^01|4.4^MAINFORMAT|/\u00b5l||H||||^^user^user||20190808154836|UF-5000[CR][ETX]05[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]0R|51|^^^CAST^A^1^S^[SP][SP]0001^01|0.27^RAW|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]2F[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]1R|52|^^^CAST^A^1^S^[SP][SP]0001^01|0.27^MAINFORMAT|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]35[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]2R|53|^^^Hy.CAST^A^1^S^[SP][SP]0001^01|0.27^RAW|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]22[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]3R|54|^^^Hy.CAST^A^1^S^[SP][SP]0001^01|0.27^MAINFORMAT|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]28[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]4R|55|^^^Path.CAST^A^1^S^[SP][SP]0001^01|0.00^RAW|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]E9[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]5R|56|^^^Path.CAST^A^1^S^[SP][SP]0001^01|0.00^MAINFORMAT|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]EF[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]6R|57|^^^BACT^A^1^S^[SP][SP]0001^01|++++^RAW|/\u00b5l||>||||^^user^user||20190808154836|UF-5000[CR][ETX]FF[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]7R|58|^^^BACT^A^1^S^[SP][SP]0001^01|++++^MAINFORMAT|/\u00b5l||>||||^^user^user||20190808154836|UF-5000[CR][ETX]05[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]0R|59|^^^X'TAL^A^1^S^[SP][SP]0001^01|0.0^RAW|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]33[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]1R|60|^^^X'TAL^A^1^S^[SP][SP]0001^01|0.0^MAINFORMAT|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]30[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]2R|61|^^^YLC^A^1^S^[SP][SP]0001^01|0.2^RAW|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]B8[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]3R|62|^^^YLC^A^1^S^[SP][SP]0001^01|0.2^MAINFORMAT|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]BE[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]4R|63|^^^SPERM^A^1^S^[SP][SP]0001^01|0.0^RAW|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]59[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]5R|64|^^^SPERM^A^1^S^[SP][SP]0001^01|0.0^MAINFORMAT|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]5F[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]6R|65|^^^MUCUS^A^1^S^[SP][SP]0001^01|0.27^RAW|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]9C[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]7R|66|^^^MUCUS^A^1^S^[SP][SP]0001^01|0.27^MAINFORMAT|/\u00b5l||N||||^^user^user||20190808154836|UF-5000[CR][ETX]A2[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]0R|67|^^^RBC-Info.^A^1^S^[SP][SP]0001^01|0^RAW|||||||^^user^user||20190808154836|UF-5000[CR][ETX]94[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]1R|68|^^^RBC-Info.^A^1^S^[SP][SP]0001^01|0^MAINFORMAT|||||||^^user^user||20190808154836|UF-5000[CR][ETX]9A[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]2R|69|^^^UTI-Info.^A^1^S^[SP][SP]0001^01|1^RAW|||||||^^user^user||20190808154836|UF-5000[CR][ETX]B4[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]3R|70|^^^UTI-Info.^A^1^S^[SP][SP]0001^01|1^MAINFORMAT|||||||^^user^user||20190808154836|UF-5000[CR][ETX]B1[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]4R|71|^^^BACT-Info.^A^1^S^[SP][SP]0001^01|1^RAW|||||||^^user^user||20190808154836|UF-5000[CR][ETX]D7[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]5R|72|^^^BACT-Info.^A^1^S^[SP][SP]0001^01|1^MAINFORMAT|||||||^^user^user||20190808154836|UF-5000[CR][ETX]DD[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]6R|73|^^^RC_UNIVERSAL^A^1^RC^[SP][SP]0001^01|^RAW|||>||||^^user^user||20190808154836|UF-5000[CR][ETX]D6[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]7R|74|^^^SF_DSS_PxSF_FSC_P^A^1^IF^[SP][SP]0001^01|20190808&R&PNG&E&R&E&[UF-5000&S&12821]&E&[20190808_154836]&E&R&E&[[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]010367836037]_[SF_DSS_PxSF_FSC_P].png^RAW|||||||^^user^user||20190808154836|UF-5000[CR][ETX]55[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]0R|75|^^^HIST_SF_FSC_P^A^1^IF^[SP][SP]0001^01|20190808&R&PNG&E&R&E&[UF-5000&S&12821]&E&[20190808_154836]&E&R&E&[[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]010367836037]_[HIST_SF_FSC_P].png^RAW|||||||^^user^user||20190808154836|UF-5000[CR][ETX]6B[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]1R|76|^^^CW_SSH_AxCW_FSC_W^A^1^IF^[SP][SP]0001^01|20190808&R&PNG&E&R&E&[UF-5000&S&12821]&E&[20190808_154836]&E&R&E&[[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]010367836037]_[CW_SSH_AxCW_FSC_W].png^RAW|||||||^^user^user||20190808154836|UF-5000[CR][ETX]4D[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]2R|77|^^^CW_FLL_AxCW_FSC_W^A^1^IF^[SP][SP]0001^01|20190808&R&PNG&E&R&E&[UF-5000&S&12821]&E&[20190808_154836]&E&R&E&[[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]010367836037]_[CW_FLL_AxCW_FSC_W].png^RAW|||||||^^user^user||20190808154836|UF-5000[CR][ETX]2F[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]3R|78|^^^CB_FLH_PxCB_FSC_P^A^1^IF^[SP][SP]0001^01|20190808&R&PNG&E&R&E&[UF-5000&S&12821]&E&[20190808_154836]&E&R&E&[[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]010367836037]_[CB_FLH_PxCB_FSC_P].png^RAW|||||||^^user^user||20190808154836|UF-5000[CR][ETX]E5[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]4R|79|^^^SF_FLL_WxSF_FLL_A^A^1^IF^[SP][SP]0001^01|20190808&R&PNG&E&R&E&[UF-5000&S&12821]&E&[20190808_154836]&E&R&E&[[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]010367836037]_[SF_FLL_WxSF_FLL_A].png^RAW|||||||^^user^user||20190808154836|UF-5000[CR][ETX]33[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]5R|80|^^^CW_FLH_PxCW_FSC_P^A^1^IF^[SP][SP]0001^01|20190808&R&PNG&E&R&E&[UF-5000&S&12821]&E&[20190808_154836]&E&R&E&[[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]010367836037]_[CW_FLH_PxCW_FSC_P].png^RAW|||||||^^user^user||20190808154836|UF-5000[CR][ETX]34[LINE]"));
        linhas.add(this.equipamento.arruma("[STX]6L|1|N[CR][ETX]09[LINE]"));
        linhas.add(this.equipamento.arruma("[EOT]"));
        for (String linha : linhas) {
            this.getPortaCOM().read(linha, linha.length());
        }
    }

    @Override
    public void dataChangedInput() {
        try {
            String message = ((PortaSocketServerDouble)this.getPortaCOM()).getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                ((PortaSocketServerDouble)this.getPortaCOM()).writeIn(String.valueOf('\u0006'));
            }
            if (!(message = ((PortaSocketServerDouble)this.getPortaCOM()).removeInputString(this.getMsgEnd())).equals("")) {
                String retorno = this.parse(message);
                ((PortaSocketServerDouble)this.getPortaCOM()).writeIn(String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void dataChangedOutput() {
        try {
            String message = ((PortaSocketServerDouble)this.getPortaCOM()).getOutputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                ((PortaSocketServerDouble)this.getPortaCOM()).writeOut(String.valueOf('\u0006'));
            }
            if (!(message = ((PortaSocketServerDouble)this.getPortaCOM()).removeOutputString(this.getMsgEnd())).equals("")) {
                String retorno = this.parse(message);
                ((PortaSocketServerDouble)this.getPortaCOM()).writeOut(String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                    this.enviarProximoFrameOut();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
                this.enviarProximoFrameOut();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handShakeCharReceivedInput(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    if (this.isTX() || this.tx_list.size() > 0 && this.rx_counter < this.MAX_TENTATIVAS_RX) {
                        ((PortaSocketServerDouble)this.getPortaCOM()).writeIn(String.valueOf('\u0015'));
                        ++this.rx_counter;
                        break;
                    }
                    this.rx_counter = 0;
                    this.tratarEnquiryIn();
                    break;
                }
                case '\u0006': {
                    this.tratarAcknowledge(true);
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0004': {
                    this.tratarEndOfTX();
                    this.enviarProximoFrame();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de caracter de handshake recebido");
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
            if (this.tx_list.size() > 0) {
                this.limpaDadosRequisicao();
            }
            this.setIdle();
        }
    }

    @Override
    public void handShakeCharReceivedOutput(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    if (this.isTX() || this.tx_list.size() > 0 && this.rx_counter < this.MAX_TENTATIVAS_RX) {
                        ((PortaSocketServerDouble)this.getPortaCOM()).writeOut(String.valueOf('\u0015'));
                        ++this.rx_counter;
                        break;
                    }
                    this.rx_counter = 0;
                    this.tratarEnquiryOut();
                    break;
                }
                case '\u0006': {
                    this.tratarAcknowledge(false);
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0004': {
                    this.tratarEndOfTX();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de caracter de handshake recebido");
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
            if (this.tx_list.size() > 0) {
                this.limpaDadosRequisicao();
            }
            this.setIdle();
        }
    }

    protected void tratarEnquiryOut() throws Exception {
        if (this.isTX()) {
            this.abortarParaReceber();
        } else if (!this.isRX()) {
            this.prepararParaReceberOut();
        } else {
            this.prepararParaReceberOut();
        }
    }

    protected void tratarEnquiryIn() throws Exception {
        if (this.isTX()) {
            this.abortarParaReceber();
        } else if (!this.isRX()) {
            this.prepararParaReceberIn();
        } else {
            this.prepararParaReceberIn();
        }
    }

    protected void prepararParaReceberIn() throws Exception {
        ((PortaSocketServerDouble)this.getPortaCOM()).clearInputString();
        this.setRX(this.TIME_ENQUIRY);
        this.fireMensagemEnviada("Aguardando envio de dados pelo equipamento", 0, 10000);
        ((PortaSocketServerDouble)this.getPortaCOM()).writeIn(String.valueOf('\u0006'));
    }

    protected void prepararParaReceberOut() throws Exception {
        ((PortaSocketServerDouble)this.getPortaCOM()).clearStringOutput();
        this.setRX(this.TIME_ENQUIRY);
        this.fireMensagemEnviada("Aguardando envio de dados pelo equipamento", 0, 10000);
        ((PortaSocketServerDouble)this.getPortaCOM()).writeOut(String.valueOf('\u0006'));
    }

    @Override
    public void dataChangedInputTriplex() {
    }
}

