/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sx260;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.interfaces.sx260.AbaExamesNaoEnviadosRack;
import jalis.laboratorio.interfaceamento.interfaces.sx260.InterfaceListener;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RequisicaoOdbc
extends JDialog
implements ActionListener {
    private AbstractInterfaceamento equip;
    private InterfaceListener listener;
    private JPanel panelRoot = new JPanel(new GridBagLayout());
    private PanelAbaAbstrata aba;
    private TTextField textIdLocalizacaoOdbc = ComponenteFactory.novoTTextField(12, 1);
    private JPanel panelButton = new JPanel(new FlowLayout(2));
    private JButton buttonEnviar = ComponenteFactory.novoJButton("Enviar", 'e', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'c', this);

    public RequisicaoOdbc(JFrame parent, AbstractInterfaceamento equip, InterfaceListener listener, PanelAbaAbstrata aba) {
        super(parent);
        this.equip = equip;
        this.listener = listener;
        this.aba = aba;
        this.setDefaultCloseOperation(0);
        this.configTela();
    }

    private void configTela() {
        this.setPreferredSize(new Dimension(170, 100));
        this.setTitle("Lote");
        this.setModal(true);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this.panelRoot.add((Component)new JLabel("ID da Amostra inicial"), c);
        this.textIdLocalizacaoOdbc.setPreferredSize(new Dimension(155, 20));
        this.textIdLocalizacaoOdbc.setMinimumSize(new Dimension(155, 20));
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        this.panelRoot.add((Component)this.textIdLocalizacaoOdbc, c);
        this.buttonEnviar.setPreferredSize(new Dimension(65, 25));
        this.buttonEnviar.setMinimumSize(new Dimension(65, 25));
        this.panelButton.add(this.buttonEnviar);
        this.panelButton.add(this.buttonCancelar);
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 0.0;
        this.panelRoot.add((Component)this.panelButton, c);
        this.add((Component)this.panelRoot, "Center");
        Funcoes.montaEnter((JComponent)this.panelRoot);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonEnviar && this.enviar()) {
            this.setVisible(false);
        }
    }

    private boolean enviar() {
        if (Funcoes.textoVazio(this.textIdLocalizacaoOdbc)) {
            Funcoes.mensagem(this, "Id inicial n\u00e3o preenchido", 5);
            return false;
        }
        Map<String, String[]> pacientes = this.listener.localizaAmostras(this.textIdLocalizacaoOdbc.getText());
        for (String key : pacientes.keySet()) {
            String[] paciente = pacientes.get(key);
            String req_codigo = paciente[0];
            int digitosTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            if (req_codigo.trim().length() < digitosTubo) {
                this.listener.fireExcecaoEncontrada(String.format("Tamanho do id da amostra menor que o da configura\u00e7\u00e3o %s ", req_codigo));
                continue;
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            String rackPos = String.format("%s^%s", key, paciente[1]);
            try {
                ((AbaExamesNaoEnviadosRack)this.aba).transmiteRequisicao(fil_codigo, req_codigo, rec_codigo, rackPos);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "RequisicaoOdbc (121)");
            }
        }
        return true;
    }
}

