/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sx260;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.exames.ResolvedorResultado;
import jalis.laboratorio.interfaceamento.interfaces.sx260.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final int QTDE_EXAMES_TOTAL_RACK = 59;
    public static final int QTDE_EXAMES_ENVIO_RACK = 35;
    private static final String FEMININO = "F";
    private static Connection connectionAccess;
    private static InterfaceConfiguracao configuracao;

    public InterfaceListener() {
        try {
            ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
            String fonteWorklist = c.getFonteOdbcWorklist();
            if (!Funcoes.isLinux()) {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                connectionAccess = DriverManager.getConnection("jdbc:odbc:" + fonteWorklist, "", "");
                connectionAccess.setAutoCommit(false);
                connectionAccess.setTransactionIsolation(2);
            } else {
                Funcoes.mensagem(null, "Para equipamento com conex\u00e3o ODBC \u00e9 necess\u00e1rio Windows para funcionamento verifique", 2);
            }
            configuracao = new InterfaceConfiguracao();
            configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        }
        catch (ClassNotFoundException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "SX260:Interfacelistener:57");
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "SX260:Interfacelistener:59");
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        StringBuilder sql = new StringBuilder();
        boolean curva = false;
        String rec_tuboPai = "";
        LinkedList<String> examesFilho = new LinkedList<String>();
        ExameMaterial[] alternativos = null;
        Object listaCurva = null;
        Map<String, List<ExameMaterial>> alternativosCurva = null;
        try {
            ExameMaterial[] exameMaterialArray;
            Statement st = Conexao.getStatement();
            String[] listaExames = exames.split(" ", 0);
            if (acao.equalsIgnoreCase("A")) {
                String[] stringArray = listaExames;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String exame;
                    int atual = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame = stringArray[i], mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, rackposition, atual < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
            }
            this.fireAtualizarTabela(0);
            if (Funcoes.textoVazio(rackposition)) {
                return "Rack n\u00e3o informada";
            }
            if (Funcoes.textoVazio(data)) {
                return "Data informada inv\u00e1lida";
            }
            String[] rackPos = rackposition.split("[/^]");
            if (rackPos != null && rackPos.length < 2) {
                return "Rack n\u00e3o informada";
            }
            long sample_id = Long.parseLong(rackPos[0]);
            int cupPos = Integer.parseInt(rackPos[1]);
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            req_codigo = StringUtil.preencheString(req_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo).append(rec_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(listaExames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            if (!Funcoes.textoVazio(tipo_amostra)) {
                tipo_amostra = "serum";
            }
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            ExameMaterial[] outros = null;
            if (exa_lista != null) {
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
                outros = BDUtil.getExameDesmembradosTubo(fil_codigo, req_codigo, rec_codigo, int_codigo, mco_codigo);
                exa_lista = ArraysUtil.concatenarVarios(outros, exa_lista);
            } else {
                exa_lista = ExamesUtil.anexarCodigoMaterial(listaExames, mco_codigo);
                rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_lista[0].getNomeExame(), mco_codigo);
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
            }
            alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            if (!exa_listaCurva.isEmpty()) {
                if (alternativos != null && alternativos.length == 1) {
                    alternativos = null;
                }
                if ((alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, st, exa_listaCurva, rec_tuboPai, true, examesFilho)) != null && alternativosCurva.size() > 0) {
                    curva = true;
                }
            }
            if (outros != null) {
                for (ExameMaterial exameMaterial : outros) {
                    if (examesFilho.contains(exameMaterial.getNomeExame())) continue;
                    examesFilho.add(exameMaterial.getNomeExame());
                }
            }
            String material = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getNomeExame(), exa_lista[0].getCodigoMaterial(), int_codigo);
            Date dtRequisicao = Funcoes.stringToDate(data);
            String string = codigo.toString();
            if (curva) {
                ExameMaterial[] exameMaterialArray2 = new ExameMaterial[1];
                exameMaterialArray = exameMaterialArray2;
                exameMaterialArray2[0] = exa_lista[0];
            } else {
                exameMaterialArray = exa_lista;
            }
            this.enviaPaciente(fil_codigo, mco_codigo, int_codigo, string, pac_nome, pac_sexo, pac_idade, material, rackposition, exameMaterialArray, data, sql, sample_id, req_codigo, cupPos);
            if (alternativos != null && alternativos.length > 0) {
                for (int i = 0; i < alternativos.length; ++i) {
                    if (alternativos[i] == null || alternativos[0] == null) continue;
                    this.insereExames(fil_codigo, int_codigo, mco_codigo, sql, alternativos[i].getNomeExame(), sample_id, cupPos);
                }
            }
            if (curva) {
                for (String key : alternativosCurva.keySet()) {
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    List<ExameMaterial> examesCurva = alternativosCurva.get(key);
                    for (ExameMaterial exameMaterial : examesCurva) {
                        this.insereExames(fil_codigo, int_codigo, mco_codigo, sql, exameMaterial.getNomeExame(), sample_id, cupPos);
                    }
                }
            }
            this.commit();
            InfoExameRequisicao ultimo_enviado = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, exames.toString());
            ultimo_enviado.setTuboPai(rec_tuboPai);
            ultimo_enviado.setExamesFilho(StringUtil.implode(examesFilho, " "));
            ultimo_enviado.setInterface(int_codigo);
            ultimo_enviado.setCurva(curva);
            this.confirmaTransmissao(ultimo_enviado);
            this.fireAtualizarTabela(0);
            this.firePacienteEnviado(req_codigo, pac_nome, pac_sexo, pac_idade, data, hora, exames);
            return "Exame enviado com sucesso para " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage() + "\n" + sql.toString(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage() + "\n" + sql.toString(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private void confirmaTransmissao(InfoExameRequisicao ultimo_enviado) {
        try {
            String[] exames;
            if (ultimo_enviado == null || ultimo_enviado.getExames() == null) {
                return;
            }
            Statement st = Conexao.getStatement();
            for (String exame : exames = ultimo_enviado.getExames().split(" ", 0)) {
                int situacao;
                String fil_codigo = ultimo_enviado.getFilial();
                String req_codigo = ultimo_enviado.getCodigo();
                String mco_codigo = ultimo_enviado.getMaterial();
                String rec_codigo = ultimo_enviado.getRecipiente();
                String recTuboPai = ultimo_enviado.getTuboPai();
                String int_codigo = ultimo_enviado.getInterface();
                if (!Funcoes.textoVazio(recTuboPai) && ultimo_enviado.isCurva().booleanValue()) {
                    recTuboPai = Funcoes.preencheZero(recTuboPai, ParametrosGerais.getDigitosTuboTubo());
                    int_codigo = this.getIntCodigo(fil_codigo, req_codigo, recTuboPai, exame, mco_codigo);
                    situacao = -1;
                    String[] stringArray = ultimo_enviado.getExamesFilho().split(" ");
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String exameFilho;
                        situacao = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, recTuboPai, exameFilho = stringArray[i], mco_codigo);
                        BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, exameFilho, mco_codigo, recTuboPai, situacao < 2 ? 1 : 3);
                    }
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, recTuboPai);
                    if (BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, recTuboPai)) {
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, recTuboPai, exame, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                    }
                } else {
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                    if (!Funcoes.textoVazio(ultimo_enviado.getExamesFilho())) {
                        for (String exameFilho : ultimo_enviado.getExamesFilho().split(" ")) {
                            ExameMaterial[] exaPai = BDUtil.getDesmExamesPai(fil_codigo, int_codigo, req_codigo, rec_codigo, exameFilho, mco_codigo);
                            String exPai = null;
                            String exMcoPai = null;
                            for (ExameMaterial e : exaPai) {
                                exPai = e.getNomeExame();
                                exMcoPai = e.getCodigoMaterial();
                                recTuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exPai, mco_codigo);
                                if (Funcoes.textoVazio(recTuboPai)) continue;
                                situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exameFilho, mco_codigo, rec_codigo);
                                BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, e.getNomeExame(), e.getCodigoMaterial(), exameFilho, mco_codigo, recTuboPai, situacao < 2 ? 1 : 3);
                            }
                        }
                    }
                }
                if (!req_codigo.equals(ultimo_enviado.getCodigo())) continue;
                this.firePacienteEnviado(ultimo_enviado.getCodigo(), ultimo_enviado.getNome(), ultimo_enviado.getSexo(), ultimo_enviado.getIdade(), ultimo_enviado.getData(), ultimo_enviado.getHora(), ultimo_enviado.getExames());
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
            this.equipamento.mensagemEnviada("Exame enviado com sucesso para " + ultimo_enviado.getNome(), 1, 5000);
            ultimo_enviado = null;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                this.rollback();
                Conexao.anulaSQL();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void enviaPaciente(String fil_codigo, String mco_codigo, String int_codigo, String codigo, String pac_nome, String pac_sexo, String pac_idade, String material, String rackposition, ExameMaterial[] exa_lista, String data, StringBuilder sql, long sample_id, String req_codigo, int cup_no) throws SQLException {
        sql.setLength(0);
        if (!this.buscaPaciente(sample_id)) {
            sql.append(this.montaInsert(fil_codigo, codigo, pac_sexo, pac_idade, sample_id, req_codigo, pac_nome));
        } else {
            sql.append(this.montaUpdate(material, exa_lista, sample_id));
        }
        PreparedStatement ps = this.getPreparedStatement(sql);
        this.execute(ps);
    }

    private String montaUpdate(String material, ExameMaterial[] exa_lista, Long sample_id) {
        StringBuilder sql = new StringBuilder();
        sql.append("update SAMPLE_MAIN set container = 1, dilution = 1, ");
        sql.append("sample_kind = '").append(material).append("', ");
        sql.append("test_item_count = '").append(exa_lista.length).append("'");
        sql.append(" where sample_id = '").append(sample_id).append("'");
        return sql.toString();
    }

    private String montaInsert(String fil_codigo, String codigo, String pac_sexo, String pac_idade, long sample_id, String req_codigo, String pac_nome) throws SQLException {
        StringBuilder sql = new StringBuilder();
        String first_name = pac_nome;
        String family_name = "";
        if (this.contemEspaco(pac_nome)) {
            first_name = pac_nome.substring(0, pac_nome.indexOf(" "));
            family_name = pac_nome.substring(pac_nome.indexOf(" "));
        }
        sql.append("insert into SAMPLE_PATIENT_INFO (sample_id, id, first_name, family_name, sex, age, birth)");
        sql.append(" values ('").append(sample_id).append("' ");
        sql.append(", '").append(codigo).append("' ");
        sql.append(", '").append(first_name).append("' ");
        sql.append(", '").append(family_name.trim()).append("' ");
        sql.append(this.getSexo(pac_sexo));
        sql.append(this.getIdade(pac_idade));
        sql.append(this.getDataNascimento(fil_codigo, req_codigo));
        sql.append(" ) ");
        return sql.toString();
    }

    private boolean contemEspaco(String pac_nome) {
        return pac_nome.contains(" ");
    }

    private boolean buscaPaciente(Long sampleID) throws SQLException {
        StringBuilder sql = new StringBuilder();
        boolean existePaciente = false;
        sql.append("select count(*) as existePaciente from SAMPLE_PATIENT_INFO where sample_id = '").append(sampleID).append("'");
        PreparedStatement ps = this.getPreparedStatement(sql);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            existePaciente = rs.getInt("existePaciente") > 0;
        }
        return existePaciente;
    }

    private String getDataNascimento(String fil_codigo, String req_codigo) throws SQLException {
        StringBuilder sql = new StringBuilder();
        String[] nascimento = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
        if (this.contemDataNascimento(nascimento)) {
            sql.append(", '").append(Funcoes.formataData(configuracao.getFormatoData(), Funcoes.stringToDate(nascimento[2]))).append("' ");
        } else {
            sql.append(", null");
        }
        return sql.toString();
    }

    private boolean contemDataNascimento(String[] nascimento) {
        return nascimento != null && !Funcoes.textoVazio(nascimento[2]);
    }

    private String getIdade(String pac_idade) {
        StringBuilder sql = new StringBuilder(", null");
        if (!Funcoes.textoVazio(pac_idade)) {
            sql.setLength(0);
            sql.append(", '").append(pac_idade).append("'");
        }
        return sql.toString();
    }

    private String getSexo(String pac_sexo) {
        String sql = ", null";
        if (!Funcoes.textoVazio(pac_sexo)) {
            sql = ", " + this.getValor(pac_sexo);
        }
        return sql;
    }

    private String getValor(String pac_sexo) {
        StringBuilder sql = new StringBuilder();
        if (this.isFeminino(pac_sexo)) {
            return sql.append("'Feminino'").toString();
        }
        sql.append("'Masculino'");
        return sql.toString();
    }

    private boolean isFeminino(String pac_sexo) {
        return pac_sexo.equalsIgnoreCase(FEMININO);
    }

    private String obtemCodigoRequisicao(String data) {
        StringBuilder id = new StringBuilder();
        String dtAt = Funcoes.formataData("yyyyMMdd", Calendar.getInstance().getTime());
        id.append(dtAt);
        int cont = 1;
        if (data.startsWith(dtAt)) {
            cont = Integer.parseInt(data.substring(dtAt.length()));
            ++cont;
        }
        id.append(Funcoes.preencheZero(cont, 4));
        return id.toString();
    }

    private void rollback() throws SQLException {
        if (connectionAccess != null) {
            connectionAccess.rollback();
        }
    }

    private void execute(PreparedStatement ps) throws SQLException {
        if (connectionAccess != null) {
            ps.execute();
        }
    }

    private PreparedStatement getPreparedStatement(StringBuilder sql) throws SQLException {
        if (connectionAccess != null) {
            return connectionAccess.prepareStatement(sql.toString());
        }
        return null;
    }

    private void commit() throws SQLException {
        if (connectionAccess != null) {
            connectionAccess.commit();
        }
    }

    private Statement createStatement() throws SQLException {
        if (connectionAccess != null) {
            return connectionAccess.createStatement(1004, 1007);
        }
        return null;
    }

    private ResultSet executeQuery(StringBuilder sql, Statement stResults) throws SQLException {
        if (connectionAccess != null) {
            return stResults.executeQuery(sql.toString().trim());
        }
        return null;
    }

    private void insereExames(String fil_codigo, String int_codigo, String mco_codigo, StringBuilder sql, String exame, long sample_id, int cupPos) throws SQLException {
        sql.setLength(0);
        sql.append("insert into sample_item_test_task (SAMPLE_ID, ITEM, CUP_POS, EMERGENCY,DILUTION, CONTAINER) values (?, ?, ?, ?, ?, ?)");
        if (!Funcoes.isLinux()) {
            String sqlExame = sql.toString();
            sqlExame = sqlExame.replaceFirst("[?]", String.valueOf(sample_id));
            sqlExame = sqlExame.replaceFirst("[?]", "'" + exame + "'");
            sqlExame = sqlExame.replaceFirst("[?]", String.valueOf(cupPos));
            sqlExame = sqlExame.replaceFirst("[?]", "false");
            sqlExame = sqlExame.replaceFirst("[?]", "1");
            sqlExame = sqlExame.replaceFirst("[?]", "1");
            PreparedStatement ps = this.getPreparedStatement(new StringBuilder(sqlExame));
            this.execute(ps);
        } else {
            String sqlExame = sql.toString();
            sqlExame = sqlExame.replaceFirst("[?]", String.valueOf(sample_id));
            sqlExame = sqlExame.replaceFirst("[?]", "'" + exame + "'");
            sqlExame = sqlExame.replaceFirst("[?]", String.valueOf(cupPos));
            sqlExame = sqlExame.replaceFirst("[?]", "false");
            sqlExame = sqlExame.replaceFirst("[?]", "1");
            sqlExame = sqlExame.replaceFirst("[?]", "1");
        }
    }

    public void buscarResultados() {
        try {
            ArrayList<String> lista = new ArrayList<String>();
            this.getRequisicoes(lista, 1);
            this.getRequisicoes(lista, 2);
            int qtdeBusca = 0;
            StringBuilder requisicoes = new StringBuilder();
            for (int i = 0; i < lista.size(); ++i) {
                requisicoes.append("'").append((String)lista.get(i)).append("'");
                if (++qtdeBusca > 50) {
                    qtdeBusca = 0;
                    this.buscaRequisicoes(requisicoes.toString());
                    requisicoes.setLength(0);
                    continue;
                }
                requisicoes.append(", ");
            }
            if (qtdeBusca > 0) {
                this.buscaRequisicoes(requisicoes.deleteCharAt(requisicoes.length() - 2).toString());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    private void getRequisicoes(List<String> lista, int abaSelecionada) {
        ArrayList examesPendentes = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        for (int i = 0; i < examesPendentes.size(); ++i) {
            Object[] req = (Object[])examesPendentes.get(i);
            if (abaSelecionada == 2) {
                if (!"3;4;5".contains((String)req[aba.getColIndice("Sit")])) continue;
            }
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            String tubo = Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboTubo());
            ArrayList tubosFilho = new ArrayList();
            if (this.tuboValido(req)) {
                tubosFilho = (ArrayList)req[20];
                if (!this.contemTubos(tubosFilho)) continue;
                for (Object tuboFilho : tubosFilho) {
                    String requisicaoFormatada = "";
                    tubo = Funcoes.preencheZero((String)tuboFilho, ParametrosGerais.getDigitosTuboTubo());
                    requisicaoFormatada = String.format("%s%s", requisicao, tubo);
                    if (lista.contains(requisicaoFormatada)) continue;
                    lista.add(requisicaoFormatada);
                }
                continue;
            }
            if (lista.contains(requisicao = String.format("%s%s", requisicao, tubo))) continue;
            lista.add(requisicao);
        }
    }

    private boolean tuboValido(Object[] req) {
        return null != req && req.length > 0 && null != req[20] && Funcoes.isNumeric(StringUtil.removeCaracteresNaoNumericos(req[20].toString()));
    }

    private boolean contemTubos(ArrayList tubos) {
        return tubos != null && !tubos.isEmpty();
    }

    private void buscaRequisicoes(String requisicoes) throws SQLException, Exception {
        if (Funcoes.textoVazio(requisicoes)) {
            return;
        }
        List<Resultado> resultados = this.pegaResultadosV2(requisicoes);
        Statement st = Conexao.getStatement();
        for (Resultado resultado : resultados) {
            String req_codigo = resultado.id;
            if (!Funcoes.isNumeric(req_codigo) || req_codigo.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o fora do padr\u00e3o do jalis (%s) ou n\u00e3o interfaceada", req_codigo));
                continue;
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo, resultado.alternativo);
            if (int_codigo == null) {
                this.fireExcecaoEncontrada("Interfaceamento do exame " + resultado.alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                continue;
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, resultado.alternativo);
            if (exame == null) {
                this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + resultado.alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                continue;
            }
            HashMap<String, Object> dados = new HashMap<String, Object>();
            int sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
            resultado.valor = this.arrendondaValor(resultado.valor, fil_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo);
            String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
            dados.put(campo, resultado.valor);
            this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, null, sit < 3 ? 2 : 4);
            this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
            if (!BDUtil.existeExame(fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo)) continue;
            ResolvedorResultado.salvaDados(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo, null, null, dados, null, false, (AbstractInterfaceamentoListener)this);
        }
    }

    private List<Resultado> pegaResultadosV2(String requisicoes) throws SQLException {
        ArrayList<Resultado> resultados = new ArrayList<Resultado>();
        StringBuilder sql = new StringBuilder();
        sql.append("select a.sample_id, b.patient_id, a.item, a.Result from SAMPLE_ITEM_TEST_RESULT a left join Sample_main b on a.sample_id = b.sample_id");
        sql.append(" where b.patient_id in(").append(requisicoes).append(") ");
        sql.append(" order by a.sample_id, item");
        Statement stResults = this.createStatement();
        ResultSet rs = this.executeQuery(sql, stResults);
        while (rs != null && rs.next()) {
            Resultado resultado = new Resultado();
            resultado.id = rs.getString("patient_id");
            resultado.alternativo = rs.getString("item");
            resultado.valor = null;
            try {
                resultado.valor = rs.getString("Result");
            }
            catch (Exception e) {
                this.fireExcecaoEncontrada(String.format("Erro ao receber resultado da requisicao %s alternativo %s verifique o resultado no equipamento", resultado.id, resultado.alternativo));
                e.printStackTrace();
                continue;
            }
            if (resultado.valor == null) {
                this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o %s com resultado valor de null alternativo %s", resultado.id, resultado.alternativo));
                continue;
            }
            StringBuilder r = new StringBuilder();
            for (char c : resultado.valor.toCharArray()) {
                if (!Character.isDigit(c) && c != '-' && c != '.') break;
                if (c == '.') {
                    r.append(",");
                    continue;
                }
                r.append(c);
            }
            resultado.valor = r.toString();
            resultados.add(resultado);
        }
        return resultados;
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void dataChanged() {
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return null;
    }

    @Override
    public String getMsgStart() {
        return null;
    }

    @Override
    public String parse(String message) {
        return null;
    }

    @Override
    public void teste() {
        String requisicao = "'201810150009'";
        try {
            this.buscaRequisicoes(requisicao);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, String[]> localizaAmostras(String sampleId) {
        HashMap<String, String[]> pacientes = new HashMap<String, String[]>();
        StringBuilder sql = new StringBuilder();
        sql.append("select sample_id, patient_id, cup_no from SAMPLE_MAIN ");
        sql.append(" where sample_id >= '").append(sampleId).append("'");
        sql.append(" order by sample_id");
        try {
            Statement stResults = this.createStatement();
            ResultSet rs = this.executeQuery(sql, stResults);
            while (rs != null && rs.next()) {
                String[] paciente = new String[]{rs.getString("patient_id"), rs.getString("cup_no")};
                pacientes.put(rs.getString("sample_id"), paciente);
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "SX260:Interfacelistener:522");
        }
        if (Funcoes.isLinux() && pacientes.isEmpty()) {
            String[] paciente = new String[]{"1002999704", "20"};
            pacientes.put("2014071100038", paciente);
            paciente = new String[]{"1002999715", "40"};
            pacientes.put("2014071100039", paciente);
            paciente = new String[]{"1002999714", "42"};
            pacientes.put("2014071100040", paciente);
        }
        return pacientes;
    }

    class Resultado {
        String id;
        String alternativo;
        String valor;

        Resultado() {
        }
    }
}

