/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.sx140;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.sx140.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    public static final int QTDE_EXAMES_TOTAL_RACK = 59;
    public static final int QTDE_EXAMES_ENVIO_RACK = 35;
    private static Connection connectionAccess;
    private static InterfaceConfiguracao configuracao;

    public InterfaceListener() {
        try {
            ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
            String fonteWorklist = c.getFonteOdbcWorklist();
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            connectionAccess = DriverManager.getConnection("jdbc:odbc:" + fonteWorklist, "", "");
            connectionAccess.setAutoCommit(false);
            connectionAccess.setTransactionIsolation(2);
            configuracao = new InterfaceConfiguracao();
            configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        }
        catch (ClassNotFoundException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "SX140:Interfacelistener:23");
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "SX140:Interfacelistener:37");
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void dataChanged() {
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return null;
    }

    @Override
    public String getMsgStart() {
        return null;
    }

    @Override
    public String parse(String message) {
        return null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        StringBuilder sql = new StringBuilder();
        try {
            if (Funcoes.textoVazio(rackposition)) {
                return "Rack n\u00e3o informada";
            }
            if (Funcoes.textoVazio(data)) {
                return "Data informada inv\u00e1lida";
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            req_codigo = StringUtil.preencheString(req_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo).append(rec_codigo);
            String[] temp = exames.split(" ", 0);
            ExameMaterial[] exa_lista = new ExameMaterial[temp.length];
            int i = -1;
            for (String t : temp) {
                exa_lista[++i] = new ExameMaterial(t, new Integer(mco_codigo));
            }
            exa_lista = ExamesUtil.anexarCodigoMaterial(temp, mco_codigo);
            String material = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getNomeExame(), exa_lista[0].getCodigoMaterial(), int_codigo);
            java.util.Date dtRequisicao = Funcoes.stringToDate(data);
            StringBuilder values = new StringBuilder();
            sql.append("insert into Patient (ClinicID, Name, Sex, Age)");
            values.append(" values (");
            values.append("'").append(codigo.toString()).append("'");
            values.append(",'").append(pac_nome).append("'");
            if (!Funcoes.textoVazio(pac_sexo)) {
                if (pac_sexo.equalsIgnoreCase("F")) {
                    values.append(",'Feminino'");
                } else {
                    values.append(",'Masculino'");
                }
            } else {
                values.append(", null");
            }
            if (!Funcoes.textoVazio(pac_idade)) {
                String[] idade = pac_idade.split(" ");
                if (idade[1].equalsIgnoreCase("a")) {
                    values.append(", ").append(idade[0]);
                } else {
                    values.append(", 0");
                }
            } else {
                values.append(", 0");
            }
            sql.append(values.toString()).append(")");
            System.out.println(sql.toString());
            PreparedStatement ps = connectionAccess.prepareStatement(sql.toString());
            ps.execute();
            sql.setLength(0);
            sql.append("SELECT @@IDENTITY");
            ps = connectionAccess.prepareStatement(sql.toString());
            System.out.println(sql.toString());
            ResultSet rs = ps.executeQuery();
            int codigoPaciente = -1;
            if (rs.next()) {
                codigoPaciente = rs.getInt(1);
            }
            if (codigoPaciente <= 0) {
                connectionAccess.rollback();
                return "Erro ao inserir paciente da requisi\u00e7\u00e3o: " + codigo;
            }
            sql.setLength(0);
            sql.append("insert into Sample (PatientID, SampleIdentity, SendDate, IsEmergent, SampleType, SampleCupIndex, DilutionProportion, Checker) values (");
            sql.append(codigoPaciente).append(", ");
            sql.append("'").append((CharSequence)codigo).append("', ");
            sql.append(Funcoes.formataData(configuracao.getFormatoData(), dtRequisicao)).append(", ");
            sql.append("0, ");
            sql.append("'").append(material).append("', ");
            sql.append(rackposition).append(", ");
            sql.append("1, ");
            sql.append("'admin'").append(")");
            System.out.println(sql.toString());
            ps = connectionAccess.prepareStatement(sql.toString());
            ps.execute();
            sql.setLength(0);
            sql.append("SELECT @@IDENTITY");
            ps = connectionAccess.prepareStatement(sql.toString());
            System.out.println(sql.toString());
            rs = ps.executeQuery();
            int codigoRequisicao = -1;
            if (rs.next()) {
                codigoRequisicao = rs.getInt(1);
            }
            if (codigoRequisicao <= 0) {
                connectionAccess.rollback();
                return "Erro ao inserir requisi\u00e7\u00e3o: " + codigo;
            }
            sql.setLength(0);
            sql.append("insert into Task (SampleID, ItemID, ReactionCupIndex, TestDate, Status) values (?, ?, ?, ?, ?)");
            System.out.println(sql.toString());
            ps = connectionAccess.prepareStatement(sql.toString());
            for (int j = 0; j < exa_lista.length; ++j) {
                ExameMaterial exa = exa_lista[j];
                String exa_alternativo = BDUtil.getExmCodigoAlternativo(fil_codigo, exa.getNomeExame(), mco_codigo, int_codigo);
                ps.setInt(1, codigoRequisicao);
                ps.setInt(2, Integer.parseInt(exa_alternativo));
                ps.setInt(3, 0);
                ps.setDate(4, new Date(dtRequisicao.getTime()));
                ps.setInt(5, 1);
                ps.execute();
                System.out.println(ps.toString());
            }
            connectionAccess.commit();
            Statement st = Conexao.getStatement();
            String[] stringArray = temp;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String exame;
                int atual = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame = stringArray[j], mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, rackposition, atual < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
            return "Exame enviado com sucesso para " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage() + "\n" + sql.toString(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage() + "\n" + sql.toString(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public void buscarResultados() {
        try {
            ArrayList<String> lista = new ArrayList<String>();
            this.getRequisicoes(lista, 1);
            this.getRequisicoes(lista, 2);
            int qtdeBusca = 0;
            StringBuilder requisicoes = new StringBuilder();
            for (int i = 0; i < lista.size(); ++i) {
                requisicoes.append("'").append((String)lista.get(i)).append("'");
                if (++qtdeBusca > 50) {
                    qtdeBusca = 0;
                    this.buscaRequisicoes(requisicoes.toString());
                    requisicoes.setLength(0);
                    continue;
                }
                requisicoes.append(", ");
            }
            if (qtdeBusca > 0) {
                this.buscaRequisicoes(requisicoes.deleteCharAt(requisicoes.length() - 2).toString());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    private void getRequisicoes(List<String> lista, int abaSelecionada) {
        ArrayList examesPendentes = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        for (int i = 0; i < examesPendentes.size(); ++i) {
            Object[] req = (Object[])examesPendentes.get(i);
            if (abaSelecionada == 2) {
                if (!"3;4;5".contains((String)req[aba.getColIndice("Sit")])) continue;
            }
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            String tubo = Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboTubo());
            if (lista.contains(requisicao = String.format("%s%s", requisicao, tubo))) continue;
            lista.add(requisicao);
        }
    }

    private void buscaRequisicoes(String requisicoes) throws SQLException, Exception {
        if (Funcoes.textoVazio(requisicoes)) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select b.SampleIdentity, a.ItemID, a.Result from Task a left join Sample b on a.SampleID = b.SampleID where a.Status = 0 and a.TestDate >( Date() -15) ");
        sql.append(" and b.SampleIdentity in (").append(requisicoes).append(" )");
        sql.append(" order by a.ItemID ");
        Statement stResults = connectionAccess.createStatement(1004, 1007);
        System.out.println(sql.toString());
        ResultSet rs = stResults.executeQuery(sql.toString());
        Statement st = Conexao.getStatement();
        while (rs.next()) {
            String req_codigo = rs.getString("SampleIdentity");
            String alternativo = rs.getString("ItemID");
            String resultado = null;
            try {
                resultado = rs.getString("Result");
            }
            catch (Exception e) {
                this.fireExcecaoEncontrada(String.format("Erro ao receber resultado da requisicao %s alternativo %s verifique o resultado no equipamento", req_codigo, alternativo));
                e.printStackTrace();
                continue;
            }
            if (resultado == null) {
                this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o %s com resultado valor de null ", req_codigo));
                continue;
            }
            StringBuilder r = new StringBuilder();
            for (char c : resultado.toCharArray()) {
                if (!Character.isDigit(c) && c != '-' && c != '.') break;
                if (c == '.') {
                    r.append(",");
                    continue;
                }
                r.append(c);
            }
            resultado = r.toString();
            if (!Funcoes.isNumeric(req_codigo) || req_codigo.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o fora do padr\u00e3o do jalis (%s) ou n\u00e3o interfaceada", req_codigo));
                continue;
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo, alternativo);
            if (int_codigo == null) {
                this.fireExcecaoEncontrada("Interfaceamento do exame " + alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                continue;
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, alternativo);
            if (exame == null) {
                this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                continue;
            }
            HashMap<String, Object> dados = new HashMap<String, Object>();
            int sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
            resultado = this.arrendondaValor(resultado, fil_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo);
            String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
            dados.put(campo, resultado);
            this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, null, sit < 3 ? 2 : 4);
            this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
        }
    }
}

